/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.components;

import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ThemeJFrame
extends JFrame
implements ActionListener {
    JPanel panelMain = null;
    int width = 900;
    int height = 700;
    int posX = 200;
    int posY = 200;
    boolean hasButtonNext = false;
    boolean hasButtonPrev = false;
    String versionId = "Versi\u00f3n: 1.18";
    private JButton jButtonSiguiente = null;
    private JButton jButtonAnterior = null;
    private ImageIcon imgLogo = null;
    private ImageIcon imgPlataforma = null;
    private static Font serifFont = new Font("Serif", 1, 15);

    public ThemeJFrame() throws ModelException {
        this.setSize(929, 777);
        this.setLocation(new Point(150, 150));
        this.setResizable(false);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.setBackground(Color.WHITE);
        this.getContentPane().add(this.getPanel());
    }

    public JPanel getPanel() {
        if (this.panelMain == null) {
            this.imgLogo = new ImageIcon("img/MinisterioLogo.jpg");
            this.imgPlataforma = new ImageIcon("img/PlataformaLogo.png");
            this.panelMain = new JPanel(null, true){

                @Override
                public void paintComponent(Graphics g) {
                    Image imagenLogo = ThemeJFrame.this.imgLogo.getImage();
                    Image imagenPlataforma = ThemeJFrame.this.imgPlataforma.getImage();
                    g.drawImage(imagenLogo, 0, 0, null);
                    int resto = this.getWidth() - imagenLogo.getWidth(null);
                    g.drawImage(imagenPlataforma, resto / 2, 20, null);
                    g.setFont(serifFont);
                    g.drawString(ThemeJFrame.this.versionId, this.getWidth() - 100, this.getHeight() - 10);
                    ThemeJFrame.this.panelMain.getGraphics().setColor(Color.WHITE);
                }
            };
            this.setBackground(Color.WHITE);
            this.repaint();
        }
        return this.panelMain;
    }

    public boolean isHasButtonNext() {
        return this.hasButtonNext;
    }

    public void setHasButtonNext(boolean hasButtonNext) {
        this.hasButtonNext = hasButtonNext;
    }

    public boolean isHasButtonPrev() {
        return this.hasButtonPrev;
    }

    public void setHasButtonPrev(boolean hasButtonPrev) {
        this.hasButtonPrev = hasButtonPrev;
    }

    public JButton getJButtonSiguiente() {
        if (this.jButtonSiguiente == null) {
            this.jButtonSiguiente = new JButton();
            this.jButtonSiguiente.setLocation(new Point(this.getWidth() - 200, this.getHeight() - 100));
            this.jButtonSiguiente.setText(Acciones.NEXT);
            this.jButtonSiguiente.setSize(new Dimension(150, 30));
        }
        return this.jButtonSiguiente;
    }

    public JButton getJButtonAnterior() {
        if (this.jButtonAnterior == null) {
            this.jButtonAnterior = new JButton();
            this.jButtonAnterior.setLocation(new Point(50, this.getHeight() - 100));
            this.jButtonAnterior.setText("Volver");
            this.jButtonAnterior.setActionCommand(Acciones.PREV);
            this.jButtonAnterior.setSize(new Dimension(150, 30));
        }
        return this.jButtonAnterior;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

