/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.utils;

import es.dgpe.place.client.utils.ConfigurationManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComboBoxUtils {
    private static ComboBoxUtils instance = null;
    private static File[] ficheros_gc = null;
    private static String mensajeGcOk = "mensajeGcOk";
    private static String mensajeGcFail = "mensajeGcFail";
    private static Map listComboBoxs = null;

    public static void loadComboBoxFromConstant(JComboBox combo, String constant) {
        String nombre = null;
        nombre = constant.lastIndexOf("/") == -1 ? String.valueOf(constant.substring(constant.lastIndexOf(":") + 1)) + ".gc" : constant.substring(constant.lastIndexOf("/") + 1);
        String[] values = ComboBoxUtils.getNamesFromComboBox(nombre);
        if (values == null) {
            System.out.println("El combo '" + nombre + "' viene nulo");
        } else {
            int i = 0;
            while (i < values.length) {
                combo.addItem(values[i]);
                ++i;
            }
        }
    }

    public static void loadComboBoxNoObligatorioFromConstant(JComboBox combo, String constant) {
        combo.addItem("");
        ComboBoxUtils.loadComboBoxFromConstant(combo, constant);
        combo.setSelectedItem("");
    }

    public static String[] getNamesFromGc() {
        String[] resultado = null;
        if (ficheros_gc != null) {
            resultado = new String[ficheros_gc.length];
            int i = 0;
            while (i < ficheros_gc.length) {
                resultado[i] = ficheros_gc[i].getName();
                ++i;
            }
        }
        return resultado;
    }

    public static Map getlistComboBox() {
        Map resultado = null;
        if (listComboBoxs != null) {
            resultado = listComboBoxs;
        }
        return resultado;
    }

    public static String[][] getComboBoxByConstant(String constant) {
        String[][] resultado = null;
        String nombre = constant.substring(constant.lastIndexOf("/") + 1);
        if (listComboBoxs != null && nombre != null) {
            resultado = (String[][])listComboBoxs.get(nombre);
        }
        return resultado;
    }

    public static String[][] getComboBox(String name) {
        String[][] resultado = null;
        String nombre = name.substring(name.lastIndexOf("/") + 1);
        if (listComboBoxs != null) {
            resultado = (String[][])listComboBoxs.get(nombre);
        }
        return resultado;
    }

    public static String[] getNamesFromComboBox(String constant) {
        String[][] combo;
        String[] resultado = null;
        String nombre = constant.substring(constant.lastIndexOf("/") + 1);
        if (listComboBoxs != null && (combo = (String[][])listComboBoxs.get(nombre)) != null) {
            resultado = new String[combo.length];
            int i = 0;
            while (i < combo.length) {
                resultado[i] = combo[i][0];
                ++i;
            }
        }
        return resultado;
    }

    public static String[] getValuesFromComboBox(String constant) {
        String[][] combo;
        String[] resultado = null;
        String nombre = constant.substring(constant.lastIndexOf("/") + 1);
        if (listComboBoxs != null && (combo = (String[][])listComboBoxs.get(nombre)) != null) {
            resultado = new String[combo.length];
            int i = 0;
            while (i < combo.length) {
                resultado[i] = combo[i][1];
                ++i;
            }
        }
        return resultado;
    }

    public static ComboBoxUtils getInstance() {
        if (instance == null) {
            instance = new ComboBoxUtils();
        }
        return instance;
    }

    private ComboBoxUtils() {
        try {
            ficheros_gc = new File("data/gc").listFiles();
            listComboBoxs = new HashMap();
            System.out.println(String.valueOf(ConfigurationManager.leerPropiedad(mensajeGcOk)) + " desde la ruta " + "data/gc");
            int i = 0;
            while (i < ficheros_gc.length) {
                String[][] resultado = ComboBoxUtils.loadComboBoxFromFile(ficheros_gc[i]);
                listComboBoxs.put(ficheros_gc[i].getName(), resultado);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(ConfigurationManager.leerPropiedad(mensajeGcFail)) + " desde la ruta " + "data/gc");
            e.printStackTrace();
        }
        catch (Throwable t) {
            System.out.println(String.valueOf(ConfigurationManager.leerPropiedad(mensajeGcFail)) + " desde la ruta " + "data/gc");
            t.printStackTrace();
        }
    }

    public static String[][] loadComboBoxFromFile(File f) {
        String[][] resultado = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(f);
            NodeList listOfElements = doc.getElementsByTagName("Row");
            int numElementos = listOfElements.getLength();
            System.out.println("Cargando los datos del fichero " + f.getName() + "(" + numElementos + " elementos)");
            resultado = new String[numElementos][2];
            int s = 0;
            while (s < listOfElements.getLength()) {
                Node nodo = listOfElements.item(s);
                Element elemento = (Element)nodo;
                NodeList contenido = elemento.getElementsByTagName("Value");
                Node valorCodigo = null;
                Node valorNombre = null;
                Element valorName = null;
                int i = 0;
                while (i < contenido.getLength()) {
                    NodeList nnl;
                    Element elementoActual = (Element)contenido.item(i);
                    if (elementoActual.getAttribute("ColumnRef").equalsIgnoreCase("code")) {
                        NodeList cnl = elementoActual.getElementsByTagName("SimpleValue");
                        valorCodigo = (Element)cnl.item(0);
                    } else if (elementoActual.getAttribute("ColumnRef").equalsIgnoreCase("nombre")) {
                        nnl = elementoActual.getElementsByTagName("SimpleValue");
                        valorNombre = (Element)nnl.item(0);
                    } else if (elementoActual.getAttribute("ColumnRef").equalsIgnoreCase("name")) {
                        nnl = elementoActual.getElementsByTagName("SimpleValue");
                        valorName = (Element)nnl.item(0);
                    }
                    ++i;
                }
                resultado[s][0] = valorNombre.getFirstChild().getNodeValue();
                resultado[s][1] = valorCodigo.getFirstChild().getNodeValue();
                ++s;
            }
        }
        catch (Exception e) {
            System.out.println("Error cargando los datos del fichero " + f.getName());
        }
        return resultado;
    }

    public static void loadComboBoxFromConstantDiscrimacion(JComboBox<String> combo, String constant, String clave) {
        String nombre = null;
        nombre = constant.lastIndexOf("/") == -1 ? String.valueOf(constant.substring(constant.lastIndexOf(":") + 1)) + ".gc" : constant.substring(constant.lastIndexOf("/") + 1);
        String[] names = ComboBoxUtils.getNamesFromComboBox(nombre);
        String[] values = ComboBoxUtils.getValuesFromComboBox(nombre);
        if (values == null) {
            System.out.println("El combo '" + nombre + "' viene nulo");
        } else {
            int i = 0;
            while (i < values.length) {
                if (values[i].startsWith(clave)) {
                    combo.addItem(String.valueOf(names[i]) + " (" + values[i] + ")");
                }
                ++i;
            }
        }
    }
}

