/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;

public class ConfigurationManager {
    public static final String CONFIG_PATH = "config/configuracion.properties";
    public static final String BP_PATH = "config/contractingPartyDefault.properties";
    public static final String CONNECTION_PATH = "config/connection.properties";
    public static final String SECURITY_PATH = "config/client-security-env.properties";
    public static final String DATA_PATH = "data";
    public static final String GC_PATH = "data/gc";
    public static final String UBL_VERSION = "ubl.version";
    public static final String CODICE_VERSION = "codice.version";
    public static final String CODICE_PROFILE_VERSION = "codice.profile.version";
    private static final String mensajeConfigOk = "mensajeConfigOk";
    private static final String mensajeConfigFail = "mensajeConfigFail";
    private static Properties configuracion = new Properties();
    private static Properties infoBP = new Properties();
    private static Properties security = new Properties();
    private static Properties connection = new Properties();
    private static ConfigurationManager instance = null;

    public static String leerPropiedad(String propiedad) {
        String resultado = "Propiedad inexistente en el archivo de configuraci\u00f3n";
        try {
            resultado = (String)ConfigurationManager.getConfiguracion().get(propiedad);
        }
        catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad " + propiedad);
        }
        return resultado;
    }

    public static String leerPropiedadSecurity(String propiedad) {
        String resultado = "Propiedad inexistente en el archivo de configuraci\u00f3n de seguridad";
        try {
            resultado = (String)ConfigurationManager.getSecurity().get(propiedad);
        }
        catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad " + propiedad);
        }
        return resultado;
    }

    public static String leerPropiedadConnection(String propiedad) {
        String resultado = "Propiedad inexistente en el archivo de configuraci\u00f3n de conectividad";
        try {
            resultado = (String)ConfigurationManager.getConnection().get(propiedad);
        }
        catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad " + propiedad);
        }
        return resultado;
    }

    public static String leerPropiedadBP(String propiedad) {
        String resultado = "Propiedad inexistente en el archivo de configuraci\u00f3n del \u00d3rgano de Contrataci\u00f3n";
        try {
            resultado = (String)ConfigurationManager.getDefaultBP().get(propiedad);
            resultado = new String(resultado.getBytes("UTF-8"), "UTF-8");
        }
        catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad " + propiedad);
        }
        return resultado;
    }

    public static Properties getSecurity() {
        return security;
    }

    public static Properties getConnection() {
        return connection;
    }

    public static Properties getDefaultBP() {
        return infoBP;
    }

    public static Properties getConfiguracion() {
        return configuracion;
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    private ConfigurationManager() {
        try {
            BufferedInputStream is = null;
            configuracion = new Properties();
            is = new BufferedInputStream(new FileInputStream(CONFIG_PATH));
            configuracion.load(is);
            BufferedInputStream is2 = null;
            infoBP = new Properties();
            is2 = new BufferedInputStream(new FileInputStream(BP_PATH));
            infoBP.load(is2);
            BufferedInputStream is3 = null;
            connection = new Properties();
            is3 = new BufferedInputStream(new FileInputStream(CONNECTION_PATH));
            connection.load(is3);
            BufferedInputStream is4 = null;
            security = new Properties();
            is4 = new BufferedInputStream(new FileInputStream(SECURITY_PATH));
            security.load(is4);
            System.out.println(String.valueOf(ConfigurationManager.leerPropiedad(mensajeConfigOk)) + " desde la ruta " + CONFIG_PATH);
        }
        catch (Exception e) {
            System.out.println(ConfigurationManager.leerPropiedad(mensajeConfigFail));
            e.printStackTrace();
        }
        catch (Throwable t) {
            System.out.println(ConfigurationManager.leerPropiedad(mensajeConfigFail));
            t.printStackTrace();
        }
    }
}

