/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.utils;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSProcessorFactory;
import es.dgpe.place.client.utils.ClienteLlamadas;
import es.dgpe.place.client.utils.SecurityEnvironmentHandler;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class FirmarServicioPublicacionHandler
implements SOAPHandler<SOAPMessageContext> {
    public Set<QName> getHeaders() {
        QName securityHeader = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(securityHeader);
        return headers;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        try {
            Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outboundProperty.booleanValue()) {
                System.out.println("\nOutbound message:");
                context.setMessage(this.obtenerMensajeFirmado(context.getMessage()));
                ClienteLlamadas.setMensajeEnviado(context.getMessage());
            } else {
                System.out.println("\nInbound message:");
                context.getMessage().writeTo((OutputStream)System.out);
                ClienteLlamadas.setMensajeRecibido(context.getMessage());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext arg0) {
        return false;
    }

    public void close(MessageContext arg0) {
    }

    private SOAPMessage obtenerMensajeFirmado(SOAPMessage msg) {
        SOAPMessage secureMsg = null;
        FileInputStream clientConfig = null;
        try {
            clientConfig = new FileInputStream("./etc/client_security_config.xml");
            XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();
            XWSSProcessor cprocessor = factory.createProcessorForSecurityConfiguration((InputStream)clientConfig, (CallbackHandler)new SecurityEnvironmentHandler("client"));
            clientConfig.close();
            ProcessingContext context = new ProcessingContext();
            context.setSOAPMessage(msg);
            secureMsg = cprocessor.secureOutboundMessage(context);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return secureMsg;
    }
}

