/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.utils;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.KeyIdentifier;

public class SecurityEnvironmentHandler
implements CallbackHandler {
    private String keyStoreURL;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreURL;
    private String trustStorePassword;
    private String trustStoreType;
    private String symmKeyStoreURL;
    private String symmKeyStorePassword;
    private String symmKeyStoreType;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private KeyStore symmKeyStore;
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final UnsupportedCallbackException unsupported = new UnsupportedCallbackException(null, "Unsupported Callback Type Encountered");
    String clientPropsFile = null;

    public SecurityEnvironmentHandler(String role) throws Exception {
        Properties properties = new Properties();
        String home = System.getProperty("jwsdp.home");
        home = "./";
        this.clientPropsFile = role.equals("client") ? "./config" + fileSeparator + "client-security-env.properties" : String.valueOf(home) + fileSeparator + "xws-security" + fileSeparator + "etc" + fileSeparator + "server-security-env.properties";
        properties.load(new FileInputStream(this.clientPropsFile));
        this.keyStoreURL = String.valueOf(home) + properties.getProperty("keystore.url");
        this.keyStoreType = properties.getProperty("keystore.type");
        this.keyStorePassword = properties.getProperty("keystore.password");
        this.trustStoreURL = String.valueOf(home) + properties.getProperty("truststore.url");
        this.trustStoreType = properties.getProperty("truststore.type");
        this.trustStorePassword = properties.getProperty("truststore.password");
        this.symmKeyStoreURL = String.valueOf(home) + properties.getProperty("symmetrickeystore.url");
        this.symmKeyStoreType = properties.getProperty("symmetrickeystore.type");
        this.symmKeyStorePassword = properties.getProperty("symmetrickeystore.password");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            SecretKey symmKey;
            PrivateKey privKey;
            X509Certificate cert;
            String alias;
            X509Certificate cert2;
            PasswordValidationCallback.DigestPasswordRequest request;
            PasswordValidationCallback cb;
            if (callbacks[i] instanceof PasswordValidationCallback) {
                cb = (PasswordValidationCallback)callbacks[i];
                if (cb.getRequest() instanceof PasswordValidationCallback.PlainTextPasswordRequest) {
                    cb.setValidator((PasswordValidationCallback.PasswordValidator)new PlainTextPasswordValidator());
                } else {
                    if (!(cb.getRequest() instanceof PasswordValidationCallback.DigestPasswordRequest)) throw unsupported;
                    request = (PasswordValidationCallback.DigestPasswordRequest)cb.getRequest();
                    String username = request.getUsername();
                    if ("Ron".equals(username)) {
                        request.setPassword("noR");
                        cb.setValidator((PasswordValidationCallback.PasswordValidator)new PasswordValidationCallback.DigestPasswordValidator());
                    }
                }
            } else if (callbacks[i] instanceof TimestampValidationCallback) {
                cb = (TimestampValidationCallback)callbacks[i];
                cb.setValidator((TimestampValidationCallback.TimestampValidator)new DefaultTimestampValidator());
            } else if (callbacks[i] instanceof SignatureVerificationKeyCallback) {
                cb = (SignatureVerificationKeyCallback)callbacks[i];
                if (cb.getRequest() instanceof SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest) {
                    request = (SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest)cb.getRequest();
                    if (this.trustStore == null) {
                        this.initTrustStore();
                    }
                    cert2 = this.getCertificateFromTrustStore(request.getSubjectKeyIdentifier());
                    request.setX509Certificate(cert2);
                } else {
                    if (!(cb.getRequest() instanceof SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest)) throw unsupported;
                    request = (SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest)cb.getRequest();
                    if (this.trustStore == null) {
                        this.initTrustStore();
                    }
                    cert2 = this.getCertificateFromTrustStore(request.getIssuerName(), request.getSerialNumber());
                    request.setX509Certificate(cert2);
                }
            } else if (callbacks[i] instanceof SignatureKeyCallback) {
                cb = (SignatureKeyCallback)callbacks[i];
                if (cb.getRequest() instanceof SignatureKeyCallback.DefaultPrivKeyCertRequest) {
                    request = (SignatureKeyCallback.DefaultPrivKeyCertRequest)cb.getRequest();
                    if (this.keyStore == null) {
                        this.initKeyStore();
                    }
                    this.getDefaultPrivKeyCert((SignatureKeyCallback.DefaultPrivKeyCertRequest)request);
                } else {
                    if (!(cb.getRequest() instanceof SignatureKeyCallback.AliasPrivKeyCertRequest)) throw unsupported;
                    request = (SignatureKeyCallback.AliasPrivKeyCertRequest)cb.getRequest();
                    alias = request.getAlias();
                    if (this.keyStore == null) {
                        this.initKeyStore();
                    }
                    try {
                        cert = (X509Certificate)this.keyStore.getCertificate(alias);
                        request.setX509Certificate(cert);
                        privKey = (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword.toCharArray());
                        request.setPrivateKey(privKey);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
            } else if (callbacks[i] instanceof DecryptionKeyCallback) {
                PrivateKey privKey2;
                cb = (DecryptionKeyCallback)callbacks[i];
                if (cb.getRequest() instanceof DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest) {
                    request = (DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest)cb.getRequest();
                    byte[] ski = request.getSubjectKeyIdentifier();
                    if (this.keyStore == null) {
                        this.initKeyStore();
                    }
                    privKey2 = this.getPrivateKey(ski);
                    request.setPrivateKey(privKey2);
                } else if (cb.getRequest() instanceof DecryptionKeyCallback.X509IssuerSerialBasedRequest) {
                    request = (DecryptionKeyCallback.X509IssuerSerialBasedRequest)cb.getRequest();
                    String issuerName = request.getIssuerName();
                    BigInteger serialNumber = request.getSerialNumber();
                    if (this.keyStore == null) {
                        this.initKeyStore();
                    }
                    privKey = this.getPrivateKey(issuerName, serialNumber);
                    request.setPrivateKey(privKey);
                } else if (cb.getRequest() instanceof DecryptionKeyCallback.X509CertificateBasedRequest) {
                    request = (DecryptionKeyCallback.X509CertificateBasedRequest)cb.getRequest();
                    cert2 = request.getX509Certificate();
                    if (this.keyStore == null) {
                        this.initKeyStore();
                    }
                    privKey2 = this.getPrivateKey(cert2);
                    request.setPrivateKey(privKey2);
                } else {
                    if (!(cb.getRequest() instanceof DecryptionKeyCallback.AliasSymmetricKeyRequest)) throw unsupported;
                    request = (DecryptionKeyCallback.AliasSymmetricKeyRequest)cb.getRequest();
                    if (this.symmKeyStore == null) {
                        this.initSymmKeyStore();
                    }
                    alias = request.getAlias();
                    try {
                        symmKey = (SecretKey)this.symmKeyStore.getKey(alias, this.symmKeyStorePassword.toCharArray());
                        request.setSymmetricKey(symmKey);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
            } else if (callbacks[i] instanceof EncryptionKeyCallback) {
                cb = (EncryptionKeyCallback)callbacks[i];
                if (cb.getRequest() instanceof EncryptionKeyCallback.AliasX509CertificateRequest) {
                    request = (EncryptionKeyCallback.AliasX509CertificateRequest)cb.getRequest();
                    if (this.trustStore == null) {
                        this.initTrustStore();
                    }
                    alias = request.getAlias();
                    try {
                        cert = (X509Certificate)this.trustStore.getCertificate(alias);
                        request.setX509Certificate(cert);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                } else {
                    if (!(cb.getRequest() instanceof EncryptionKeyCallback.AliasSymmetricKeyRequest)) throw unsupported;
                    request = (EncryptionKeyCallback.AliasSymmetricKeyRequest)cb.getRequest();
                    if (this.symmKeyStore == null) {
                        this.initSymmKeyStore();
                    }
                    alias = request.getAlias();
                    try {
                        symmKey = (SecretKey)this.symmKeyStore.getKey(alias, this.symmKeyStorePassword.toCharArray());
                        request.setSymmetricKey(symmKey);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
            } else {
                if (!(callbacks[i] instanceof CertificateValidationCallback)) throw unsupported;
                cb = (CertificateValidationCallback)callbacks[i];
                cb.setValidator((CertificateValidationCallback.CertificateValidator)new X509CertificateValidatorImpl());
            }
            ++i;
        }
    }

    private void initTrustStore() throws IOException {
        try {
            this.trustStore = KeyStore.getInstance(this.trustStoreType);
            this.trustStore.load(new FileInputStream(this.trustStoreURL), this.trustStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void initKeyStore() throws IOException {
        try {
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            this.keyStore.load(new FileInputStream(this.keyStoreURL), this.keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void initSymmKeyStore() throws IOException {
        try {
            this.symmKeyStore = KeyStore.getInstance(this.symmKeyStoreType);
            this.symmKeyStore.load(new FileInputStream(this.symmKeyStoreURL), this.symmKeyStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private X509Certificate getCertificateFromTrustStore(byte[] ski) throws IOException {
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = aliases.nextElement();
                Certificate cert = this.trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || (keyId = SecurityEnvironmentHandler.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(ski, keyId)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    private X509Certificate getCertificateFromTrustStore(String issuerName, BigInteger serialNumber) throws IOException {
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = this.trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public PrivateKey getPrivateKey(byte[] ski) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType()) || (keyId = SecurityEnvironmentHandler.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(ski, keyId)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public PrivateKey getPrivateKey(String issuerName, BigInteger serialNumber) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !cert.equals(certificate)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return null;
    }

    private void getDefaultPrivKeyCert(SignatureKeyCallback.DefaultPrivKeyCertRequest request) throws IOException {
        String uniqueAlias = null;
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate thisCertificate;
                String currentAlias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(currentAlias) || (thisCertificate = this.keyStore.getCertificate(currentAlias)) == null || !(thisCertificate instanceof X509Certificate)) continue;
                if (uniqueAlias == null) {
                    uniqueAlias = currentAlias;
                    continue;
                }
                uniqueAlias = null;
                break;
            }
            if (uniqueAlias != null) {
                request.setX509Certificate((X509Certificate)this.keyStore.getCertificate(uniqueAlias));
                request.setPrivateKey((PrivateKey)this.keyStore.getKey(uniqueAlias, this.keyStorePassword.toCharArray()));
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private static byte[] getSubjectKeyIdentifier(X509Certificate cert) {
        String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
        byte[] subjectKeyIdentifier = cert.getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID);
        if (subjectKeyIdentifier == null) {
            return null;
        }
        try {
            KeyIdentifier keyId = null;
            DerValue derVal = new DerValue(new DerInputStream(subjectKeyIdentifier).getOctetString());
            keyId = new KeyIdentifier(derVal.getOctetString());
            return keyId.getIdentifier();
        }
        catch (NoClassDefFoundError ncde) {
            if (subjectKeyIdentifier == null) {
                return null;
            }
            byte[] dest = new byte[subjectKeyIdentifier.length - 4];
            System.arraycopy(subjectKeyIdentifier, 4, dest, 0, subjectKeyIdentifier.length - 4);
            return dest;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void validateExpirationTime(Date expires, long maxClockSkew, long timestampFreshnessLimit) throws TimestampValidationCallback.TimestampValidationException {
        Date currentTime = SecurityEnvironmentHandler.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
        if (expires.before(currentTime)) {
            throw new TimestampValidationCallback.TimestampValidationException("The current time is ahead of the expiration time in Timestamp");
        }
    }

    public void validateCreationTime(Date created, long maxClockSkew, long timestampFreshnessLimit) throws TimestampValidationCallback.TimestampValidationException {
        Date current = SecurityEnvironmentHandler.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            throw new TimestampValidationCallback.TimestampValidationException("The creation time is older than  currenttime - timestamp-freshness-limit - max-clock-skew");
        }
        Date currentTime = SecurityEnvironmentHandler.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            throw new TimestampValidationCallback.TimestampValidationException("The creation time is ahead of the current time.");
        }
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private class DefaultTimestampValidator
    implements TimestampValidationCallback.TimestampValidator {
        private DefaultTimestampValidator() {
        }

        public void validate(TimestampValidationCallback.Request request) throws TimestampValidationCallback.TimestampValidationException {
            TimestampValidationCallback.UTCTimestampRequest utcTimestampRequest = (TimestampValidationCallback.UTCTimestampRequest)request;
            SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'");
            Date created = null;
            Date expired = null;
            try {
                try {
                    created = calendarFormatter1.parse(utcTimestampRequest.getCreated());
                    if (utcTimestampRequest.getExpired() != null) {
                        expired = calendarFormatter1.parse(utcTimestampRequest.getExpired());
                    }
                }
                catch (ParseException pe) {
                    created = calendarFormatter2.parse(utcTimestampRequest.getCreated());
                    if (utcTimestampRequest.getExpired() != null) {
                        expired = calendarFormatter2.parse(utcTimestampRequest.getExpired());
                    }
                }
            }
            catch (ParseException pe) {
                throw new TimestampValidationCallback.TimestampValidationException(pe.getMessage());
            }
            long maxClockSkew = utcTimestampRequest.getMaxClockSkew();
            long timestampFreshnessLimit = utcTimestampRequest.getTimestampFreshnessLimit();
            SecurityEnvironmentHandler.this.validateCreationTime(created, maxClockSkew, timestampFreshnessLimit);
            if (expired != null) {
                SecurityEnvironmentHandler.this.validateExpirationTime(expired, maxClockSkew, timestampFreshnessLimit);
            }
        }
    }

    private class PlainTextPasswordValidator
    implements PasswordValidationCallback.PasswordValidator {
        private PlainTextPasswordValidator() {
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            PasswordValidationCallback.PlainTextPasswordRequest plainTextRequest = (PasswordValidationCallback.PlainTextPasswordRequest)request;
            return "Ron".equals(plainTextRequest.getUsername()) && "noR".equals(plainTextRequest.getPassword());
        }
    }

    private class X509CertificateValidatorImpl
    implements CertificateValidationCallback.CertificateValidator {
        private X509CertificateValidatorImpl() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            CertPathBuilder builder;
            PKIXBuilderParameters parameters;
            if (this.isSelfCert(certificate)) {
                return true;
            }
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                e.printStackTrace();
                throw new CertificateValidationCallback.CertificateValidationException("X509Certificate Expired", (Throwable)e);
            }
            catch (CertificateNotYetValidException e) {
                e.printStackTrace();
                throw new CertificateValidationCallback.CertificateValidationException("X509Certificate not yet valid", (Throwable)e);
            }
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(certificate);
            try {
                if (SecurityEnvironmentHandler.this.trustStore == null) {
                    SecurityEnvironmentHandler.this.initTrustStore();
                }
                parameters = new PKIXBuilderParameters(SecurityEnvironmentHandler.this.trustStore, (CertSelector)certSelector);
                parameters.setRevocationEnabled(false);
                builder = CertPathBuilder.getInstance("PKIX");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CertificateValidationCallback.CertificateValidationException(e.getMessage(), (Throwable)e);
            }
            try {
                PKIXCertPathBuilderResult e = (PKIXCertPathBuilderResult)builder.build(parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isSelfCert(X509Certificate cert) throws CertificateValidationCallback.CertificateValidationException {
            try {
                X509Certificate x509Cert;
                String alias;
                if (SecurityEnvironmentHandler.this.keyStore == null) {
                    SecurityEnvironmentHandler.this.initKeyStore();
                }
                Enumeration<String> aliases = SecurityEnvironmentHandler.this.keyStore.aliases();
                do {
                    if (!aliases.hasMoreElements()) {
                        return false;
                    }
                    alias = aliases.nextElement();
                } while (!SecurityEnvironmentHandler.this.keyStore.isKeyEntry(alias) || (x509Cert = (X509Certificate)SecurityEnvironmentHandler.this.keyStore.getCertificate(alias)) == null || !x509Cert.equals(cert));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CertificateValidationCallback.CertificateValidationException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

