/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.utils.documentsgenerator;

import com.sun.xml.internal.ws.api.message.Attachment;
import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.DatosModificacionBean;
import es.dgpe.place.client.beans.EventoAperturaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.OrganoContratacionBean;
import es.dgpe.place.client.beans.codice.Code;
import es.dgpe.place.client.beans.codice.Contractingauthorityparty;
import es.dgpe.place.client.beans.codice.Documentreference;
import es.dgpe.place.client.beans.codice.Event;
import es.dgpe.place.client.utils.CODICESerializing;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.ConfigurationManager;
import es.dgpe.place.client.utils.SessionDataManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dgpe.codice.common.caclib.AddressLineType;
import org.dgpe.codice.common.caclib.AddressType;
import org.dgpe.codice.common.caclib.AttachmentType;
import org.dgpe.codice.common.caclib.AttendanceConditionsType;
import org.dgpe.codice.common.caclib.AuctionTermsType;
import org.dgpe.codice.common.caclib.BudgetAmountType;
import org.dgpe.codice.common.caclib.ClassificationCategoryType;
import org.dgpe.codice.common.caclib.ClassificationSchemeType;
import org.dgpe.codice.common.caclib.CommodityClassificationType;
import org.dgpe.codice.common.caclib.ContactType;
import org.dgpe.codice.common.caclib.ContractExecutionRequirementType;
import org.dgpe.codice.common.caclib.ContractModificationType;
import org.dgpe.codice.common.caclib.ContractType;
import org.dgpe.codice.common.caclib.ContractingPartyType;
import org.dgpe.codice.common.caclib.CountryType;
import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.common.caclib.EventType;
import org.dgpe.codice.common.caclib.InvoicingTermsType;
import org.dgpe.codice.common.caclib.LegalMonetaryTotalType;
import org.dgpe.codice.common.caclib.LocationType;
import org.dgpe.codice.common.caclib.PartyIdentificationType;
import org.dgpe.codice.common.caclib.PartyNameType;
import org.dgpe.codice.common.caclib.PartyType;
import org.dgpe.codice.common.caclib.PeriodType;
import org.dgpe.codice.common.caclib.PersonType;
import org.dgpe.codice.common.caclib.ProcessJustificationType;
import org.dgpe.codice.common.caclib.ProcurementProjectType;
import org.dgpe.codice.common.caclib.TenderResultType;
import org.dgpe.codice.common.caclib.TenderedProjectType;
import org.dgpe.codice.common.caclib.TendererQualificationRequestType;
import org.dgpe.codice.common.caclib.TenderingProcessType;
import org.dgpe.codice.common.caclib.TenderingTermsType;
import org.dgpe.codice.common.cbclib.AbnormallyLowTendersIndicatorType;
import org.dgpe.codice.common.cbclib.AcceleratedProcedureJustificationType;
import org.dgpe.codice.common.cbclib.ActivityCodeType;
import org.dgpe.codice.common.cbclib.AddressFormatCodeType;
import org.dgpe.codice.common.cbclib.AgencyNameType;
import org.dgpe.codice.common.cbclib.AttendanceConditionsDescriptionType;
import org.dgpe.codice.common.cbclib.AttendanceRestrictionCodeType;
import org.dgpe.codice.common.cbclib.AuctionConstraintIndicatorType;
import org.dgpe.codice.common.cbclib.AwardDateType;
import org.dgpe.codice.common.cbclib.CandidateReductionConstraintIndicatorType;
import org.dgpe.codice.common.cbclib.CityNameType;
import org.dgpe.codice.common.cbclib.CodeValueType;
import org.dgpe.codice.common.cbclib.ContractIDType;
import org.dgpe.codice.common.cbclib.ContractModificationDurationMeasureType;
import org.dgpe.codice.common.cbclib.ContractModificationJustificationType;
import org.dgpe.codice.common.cbclib.ContractModificationReasonCodeType;
import org.dgpe.codice.common.cbclib.ContractingPartyTypeCodeType;
import org.dgpe.codice.common.cbclib.ContractingSystemCodeType;
import org.dgpe.codice.common.cbclib.CountrySubentityCodeType;
import org.dgpe.codice.common.cbclib.CountrySubentityType;
import org.dgpe.codice.common.cbclib.CustomizationIDType;
import org.dgpe.codice.common.cbclib.DescriptionType;
import org.dgpe.codice.common.cbclib.DocumentTypeCodeType;
import org.dgpe.codice.common.cbclib.DocumentTypeType;
import org.dgpe.codice.common.cbclib.DurationMeasureType;
import org.dgpe.codice.common.cbclib.EUNationalsReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.EcatalogIndicatorType;
import org.dgpe.codice.common.cbclib.ElectronicInvoicingIndicatorType;
import org.dgpe.codice.common.cbclib.ElectronicMailType;
import org.dgpe.codice.common.cbclib.EmbeddedDocumentBinaryObjectType;
import org.dgpe.codice.common.cbclib.EndDateType;
import org.dgpe.codice.common.cbclib.EndTimeType;
import org.dgpe.codice.common.cbclib.EorderingIndicatorType;
import org.dgpe.codice.common.cbclib.EpaymentMeansIndicatorType;
import org.dgpe.codice.common.cbclib.EstimatedOverallContractAmountType;
import org.dgpe.codice.common.cbclib.ExecutionRequirementCodeType;
import org.dgpe.codice.common.cbclib.ExpenseCodeType;
import org.dgpe.codice.common.cbclib.FinalDurationMeasureType;
import org.dgpe.codice.common.cbclib.GovernmentProcurementAgreementConstraintIndicatorType;
import org.dgpe.codice.common.cbclib.IDType;
import org.dgpe.codice.common.cbclib.IdentificationCodeType;
import org.dgpe.codice.common.cbclib.IdentificationIDType;
import org.dgpe.codice.common.cbclib.IssueDateType;
import org.dgpe.codice.common.cbclib.IssueTimeType;
import org.dgpe.codice.common.cbclib.ItemClassificationCodeType;
import org.dgpe.codice.common.cbclib.JobTitleType;
import org.dgpe.codice.common.cbclib.LanguageIDType;
import org.dgpe.codice.common.cbclib.LineType;
import org.dgpe.codice.common.cbclib.LotsCombinationContractingAuthorityRightsType;
import org.dgpe.codice.common.cbclib.MaximumLotPresentationQuantityType;
import org.dgpe.codice.common.cbclib.MaximumTendererAwardedLotsQuantityType;
import org.dgpe.codice.common.cbclib.NameType;
import org.dgpe.codice.common.cbclib.NonEUNationalsReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.NoteType;
import org.dgpe.codice.common.cbclib.OccurrenceDateType;
import org.dgpe.codice.common.cbclib.OccurrenceTimeType;
import org.dgpe.codice.common.cbclib.OriginCountryCodeType;
import org.dgpe.codice.common.cbclib.PartPresentationCodeType;
import org.dgpe.codice.common.cbclib.PayableAmountType;
import org.dgpe.codice.common.cbclib.PostalZoneType;
import org.dgpe.codice.common.cbclib.ProcedureCodeType;
import org.dgpe.codice.common.cbclib.ProfileIDType;
import org.dgpe.codice.common.cbclib.ReasonCodeType;
import org.dgpe.codice.common.cbclib.ReceivedElectronicTenderQuantityType;
import org.dgpe.codice.common.cbclib.ReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.RestrictedProcurementDocumentsJustificationType;
import org.dgpe.codice.common.cbclib.ResultCodeType;
import org.dgpe.codice.common.cbclib.SMEAwardedIndicatorType;
import org.dgpe.codice.common.cbclib.SMEsReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.SchemeURIType;
import org.dgpe.codice.common.cbclib.StartDateType;
import org.dgpe.codice.common.cbclib.SubTypeCodeType;
import org.dgpe.codice.common.cbclib.SubmissionMethodCodeType;
import org.dgpe.codice.common.cbclib.TaxExclusiveAmountType;
import org.dgpe.codice.common.cbclib.TelefaxType;
import org.dgpe.codice.common.cbclib.TelephoneType;
import org.dgpe.codice.common.cbclib.TotalAmountType;
import org.dgpe.codice.common.cbclib.TypeCodeType;
import org.dgpe.codice.common.cbclib.UBLVersionIDType;
import org.dgpe.codice.common.cbclib.URIType;
import org.dgpe.codice.common.cbclib.UUIDType;
import org.dgpe.codice.common.cbclib.UrgencyCodeType;
import org.dgpe.codice.common.cbclib.VersionIDType;
import org.oasis.ubl.codelist.currencycode.CurrencyCodeContentType;
import org.oasis.ubl.codelist.mimemediatypecode.BinaryObjectMimeCodeContentType;
import org.oasis.ubl.codelist.unitcode.UnitCodeContentType;
import org.oasis.ubl.common.udt.CodeType;

public class DocumentGeneratorCommon {
    protected static CODICESerializing mapper = null;
    protected static ConfigurationManager cm = null;
    protected static CODICESerializing cs = CODICESerializing.getInstance();

    protected static Object getObjectFromSet(Set conjunto) {
        if (conjunto != null && conjunto.size() > 0) {
            return conjunto.iterator().next();
        }
        return null;
    }

    protected static EmbeddedDocumentBinaryObjectType createEmbeddedDocument(Attachment att, String url) {
        EmbeddedDocumentBinaryObjectType emb = null;
        try {
            emb = CODICESerializing.getCbcFactory().createEmbeddedDocumentBinaryObjectType();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return emb;
    }

    protected static DocumentReferenceType createDocumentReference(Documentreference document, String url, String name) {
        DocumentReferenceType dr = null;
        try {
            dr = CODICESerializing.getCacFactory().createDocumentReferenceType();
            IDType id = CODICESerializing.getCbcFactory().createIDType();
            id.setValue(url.substring(url.lastIndexOf(File.separator) + 1));
            dr.setID(id);
            IssueDateType issueDate = CODICESerializing.getCbcFactory().createIssueDateType();
            issueDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(new Date()));
            IssueTimeType issueTime = CODICESerializing.getCbcFactory().createIssueTimeType();
            issueTime.setValue(DocumentGeneratorCommon.timetoXMLGregorianCalendar(new Date()));
            dr.setIssueDate(issueDate);
            dr.setIssueTime(issueTime);
            Code tipoDOC = new Code();
            DocumentTypeCodeType tct = CODICESerializing.getCbcFactory().createDocumentTypeCodeType();
            tipoDOC.setDescription(document.getDocumenttypecode().getDescription());
            tipoDOC.setListVersionId(document.getDocumenttypecode().getListVersionId());
            tipoDOC.setCodevalue(document.getDocumenttypecode().getCodevalue());
            DocumentGeneratorCommon.code2Codice(document.getDocumenttypecode(), (CodeType)tct);
            tct.setLanguageID("es");
            tct.setListURI(document.getDocumenttypecode().getListUri());
            tct.setName(document.getDocumenttypecode().getDescription());
            tct.setListName("Tipo de documento");
            tct.setListVersionID(document.getDocumenttypecode().getListVersionId());
            tct.setListSchemeURI(document.getDocumenttypecode().getListUri());
            tct.setValue(document.getDocumenttypecode().getCodevalue());
            dr.setDocumentTypeCode(tct);
            if (document.getDocumenttypecode() != null && document.getDocumenttypecode().getCodevalue() != null && document.getDocumenttypecode().getCodevalue().equalsIgnoreCase("ZZZ")) {
                DocumentTypeType docType = CODICESerializing.getCbcFactory().createDocumentTypeType();
                docType.setValue(name);
                dr.setDocumentType(docType);
            }
            AttachmentType att = CODICESerializing.getCacFactory().createAttachmentType();
            EmbeddedDocumentBinaryObjectType emb = CODICESerializing.getCbcFactory().createEmbeddedDocumentBinaryObjectType();
            emb.setMimeCode(BinaryObjectMimeCodeContentType.fromValue((String)"application/octet-stream"));
            emb.setFilename(url.substring(url.lastIndexOf(File.separator) + 1));
            if (url.length() > 0) {
                try {
                    File fichero = new File(url);
                    FileInputStream fin = null;
                    fin = new FileInputStream(fichero);
                    long length = fichero.length();
                    if (length > Integer.MAX_VALUE) {
                        throw new IOException("Tama\u00f1o del fichero excesivo: " + length);
                    }
                    byte[] bytes = new byte[(int)length];
                    int offset = 0;
                    int numRead = 0;
                    while (offset < bytes.length && (numRead = fin.read(bytes, offset, bytes.length - offset)) >= 0) {
                        offset += numRead;
                    }
                    if (offset < bytes.length) {
                        throw new IOException("No se ha podido leer completamente el fichero " + fichero.getName());
                    }
                    fin.close();
                    emb.setValue(bytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            att.setEmbeddedDocumentBinaryObject(emb);
            dr.setAttachment(att);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dr;
    }

    protected static Calendar datetoCalendar(Date fecha) {
        if (fecha == null) {
            return null;
        }
        Calendar res = Calendar.getInstance();
        res.setTime(fecha);
        return res;
    }

    protected static XMLGregorianCalendar datetoXMLGregorianCalendar(Date fecha) {
        XMLGregorianCalendar res = null;
        if (fecha == null) {
            return null;
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(fecha);
            int month = c.get(2) + 1;
            int day = c.get(5);
            int year = c.get(1);
            DatatypeFactory df = DatatypeFactory.newInstance();
            res = df.newXMLGregorianCalendarDate(year, month, day, ((Calendar)c).getTimeZone().getOffset(fecha.getTime()) / 60000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    protected static XMLGregorianCalendar timetoXMLGregorianCalendar(Date fecha) {
        XMLGregorianCalendar res = null;
        if (fecha == null) {
            return null;
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(fecha);
            int hour = c.get(10);
            int minute = c.get(12);
            int second = c.get(13);
            DatatypeFactory df = DatatypeFactory.newInstance();
            res = df.newXMLGregorianCalendarTime(hour, minute, second, ((Calendar)c).getTimeZone().getOffset(fecha.getTime()) / 60000);
            res.setHour(c.get(11));
            res.setMinute(c.get(12));
            res.setSecond(c.get(13));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    protected static Date XMLGregorianCalendartoDate(XMLGregorianCalendar objeto) {
        if (objeto == null) {
            return null;
        }
        Date fecha = new Date();
        fecha.setDate(objeto.getDay());
        fecha.setMonth(objeto.getMonth());
        fecha.setYear(objeto.getYear());
        return fecha;
    }

    protected static Date XMLGregorianCalendartoTime(XMLGregorianCalendar objeto) {
        if (objeto == null) {
            return null;
        }
        Date fecha = new Date();
        fecha.setHours(objeto.getHour());
        fecha.setMinutes(objeto.getMinute());
        fecha.setSeconds(objeto.getSecond());
        return fecha;
    }

    protected static ProcurementProjectType crearProcurementProject(Code tipoContrato, Code subtipoContrato, String nombreContrato, Code cpv, BigDecimal sinImpuestos, BigDecimal conImpuestos, Code pais, Code nuts) throws JAXBException {
        BigDecimal valorEstimado = null;
        return DocumentGeneratorCommon.crearProcurementProject(tipoContrato, subtipoContrato, nombreContrato, cpv, sinImpuestos, conImpuestos, valorEstimado, pais, nuts);
    }

    protected static ProcurementProjectType crearProcurementProject(Code tipoContrato, Code subtipoContrato, String nombreContrato, Code cpv, BigDecimal sinImpuestos, BigDecimal conImpuestos, BigDecimal valorEstimado, Code pais, Code nuts) throws JAXBException {
        CondicionesEjecucionBean duracionContrato = null;
        return DocumentGeneratorCommon.crearProcurementProject(tipoContrato, subtipoContrato, nombreContrato, cpv, sinImpuestos, conImpuestos, valorEstimado, duracionContrato, pais, nuts);
    }

    protected static ProcurementProjectType crearProcurementProject(Code tipoContrato, Code subtipoContrato, String nombreContrato, Code cpv, BigDecimal sinImpuestos, BigDecimal conImpuestos, BigDecimal valorEstimado, CondicionesEjecucionBean duracionContrato, Code pais, Code nuts) throws JAXBException {
        ProcurementProjectType res = CODICESerializing.getCacFactory().createProcurementProjectType();
        if (nombreContrato != null) {
            NameType nameType = CODICESerializing.getCbcFactory().createNameType();
            nameType.setValue(nombreContrato);
            res.getName().add(nameType);
        }
        if (tipoContrato != null) {
            TypeCodeType tct = CODICESerializing.getCbcFactory().createTypeCodeType();
            tipoContrato.setDescription(tipoContrato.getDescription());
            tipoContrato.setListVersionId(tipoContrato.getListVersionId());
            tipoContrato.setCodevalue(tipoContrato.getCodevalue());
            tct.setLanguageID("es");
            tct.setListURI(tipoContrato.getListUri());
            tct.setName(tipoContrato.getDescription());
            tct.setListName("Tipo de Contrato");
            tct.setListVersionID(tipoContrato.getListVersionId());
            tct.setListSchemeURI(tipoContrato.getListUri());
            tct.setValue(tipoContrato.getCodevalue());
            DocumentGeneratorCommon.code2Codice(tipoContrato, (CodeType)tct);
            res.setTypeCode(tct);
        }
        if (subtipoContrato != null) {
            SubTypeCodeType stct = CODICESerializing.getCbcFactory().createSubTypeCodeType();
            subtipoContrato.setDescription(subtipoContrato.getDescription());
            subtipoContrato.setListVersionId(subtipoContrato.getListVersionId());
            subtipoContrato.setCodevalue(subtipoContrato.getCodevalue());
            subtipoContrato.setListUri(subtipoContrato.getListUri());
            stct.setListName("Subtipo de Contrato");
            stct.setListVersionID(subtipoContrato.getListVersionId());
            stct.setListSchemeURI(subtipoContrato.getListUri());
            stct.setLanguageID("es");
            stct.setValue(subtipoContrato.getCodevalue());
            DocumentGeneratorCommon.code2Codice(subtipoContrato, (CodeType)stct);
            res.setSubTypeCode(stct);
        }
        if (sinImpuestos != null || conImpuestos != null || valorEstimado != null) {
            TaxExclusiveAmountType amountType;
            BudgetAmountType ba = CODICESerializing.getCacFactory().createBudgetAmountType();
            if (conImpuestos != null) {
                TotalAmountType totalAmountType = CODICESerializing.getCbcFactory().createTotalAmountType();
                totalAmountType.setValue(conImpuestos);
                totalAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
                ba.setTotalAmount(totalAmountType);
            }
            if (sinImpuestos != null) {
                amountType = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
                amountType.setValue(sinImpuestos);
                amountType.setCurrencyID(CurrencyCodeContentType.EUR);
                ba.setTaxExclusiveAmount(amountType);
            }
            if (valorEstimado != null) {
                amountType = CODICESerializing.getCbcFactory().createEstimatedOverallContractAmountType();
                amountType.setValue(valorEstimado);
                amountType.setCurrencyID(CurrencyCodeContentType.EUR);
                ba.setEstimatedOverallContractAmount((EstimatedOverallContractAmountType)amountType);
            }
            res.setBudgetAmount(ba);
        }
        if (cpv != null) {
            CommodityClassificationType comm = CODICESerializing.getCacFactory().createCommodityClassificationType();
            ItemClassificationCodeType itc = CODICESerializing.cbcFactory.createItemClassificationCodeType();
            itc.setLanguageID("es");
            itc.setListVersionID(cpv.getListVersionId());
            itc.setListName("CPV");
            itc.setListURI(cpv.getListUri());
            itc.setListSchemeURI(cpv.getListUri());
            itc.setName("CPV");
            itc.setValue(cpv.getCodevalue());
            cpv.setListUri(cpv.getListUri());
            cpv.setListVersionId(cpv.getListVersionId());
            DocumentGeneratorCommon.asignarCode((CodeType)itc, cpv);
            comm.setItemClassificationCode(itc);
            res.getRequiredCommodityClassification().add(comm);
        }
        LocationType location = CODICESerializing.getCacFactory().createLocationType();
        if (pais != null) {
            CountrySubentityType countrySubentity = CODICESerializing.getCbcFactory().createCountrySubentityType();
            countrySubentity.setValue(nuts.getDescription());
            location.setCountrySubentity(countrySubentity);
            AddressType addressType = CODICESerializing.getCacFactory().createAddressType();
            CountryType countryType = CODICESerializing.getCacFactory().createCountryType();
            IdentificationCodeType identificationCodeType = CODICESerializing.getCbcFactory().createIdentificationCodeType();
            identificationCodeType.setValue(pais.getCodevalue());
            identificationCodeType.setListURI(pais.getListUri());
            identificationCodeType.setName(pais.getDescription());
            identificationCodeType.setListVersionID(pais.getListVersionId());
            countryType.setIdentificationCode(identificationCodeType);
            NameType nameType = CODICESerializing.getCbcFactory().createNameType();
            nameType.setValue(pais.getDescription());
            countryType.setName(nameType);
            addressType.setCountry(countryType);
            location.setAddress(addressType);
        }
        if (nuts != null) {
            CountrySubentityCodeType countryCode = CODICESerializing.getCbcFactory().createCountrySubentityCodeType();
            countryCode.setListURI(nuts.getListUri());
            countryCode.setValue(nuts.getCodevalue());
            location.setCountrySubentityCode(countryCode);
        }
        res.setRealizedLocation(location);
        if (duracionContrato != null) {
            PeriodType plannedPeriod = DocumentGeneratorCommon.crearPlannedPeriod(duracionContrato);
            res.setPlannedPeriod(plannedPeriod);
        }
        return res;
    }

    protected static TenderingTermsType crearTenderingTerms(int clasificacion, String solvencia, Contractingauthorityparty datosOC, int idDirectiva, String justifNoPubPliegos, CondicionesEjecucionBean condicionesEjecucion, int indicadorCatalogoElectronico) {
        TenderingTermsType res = DocumentGeneratorCommon.crearTenderingTerms(clasificacion, solvencia, datosOC, idDirectiva);
        if (justifNoPubPliegos != null && justifNoPubPliegos.length() > 0) {
            RestrictedProcurementDocumentsJustificationType justifNoPubPliegoType = CODICESerializing.getCbcFactory().createRestrictedProcurementDocumentsJustificationType();
            justifNoPubPliegoType.setValue(justifNoPubPliegos);
            res.getRestrictedProcurementDocumentsJustification().add(justifNoPubPliegoType);
        }
        EcatalogIndicatorType catalogoElectronico = CODICESerializing.getCbcFactory().createEcatalogIndicatorType();
        switch (indicadorCatalogoElectronico) {
            case 0: {
                catalogoElectronico.setValue(true);
                res.setEcatalogIndicator(catalogoElectronico);
                break;
            }
            case 1: {
                catalogoElectronico.setValue(false);
                res.setEcatalogIndicator(catalogoElectronico);
            }
        }
        if (condicionesEjecucion != null) {
            DescriptionType descripcion;
            ExecutionRequirementCodeType codigoCondicionEjecucion;
            EorderingIndicatorType eOrdering = CODICESerializing.getCbcFactory().createEorderingIndicatorType();
            EpaymentMeansIndicatorType ePayment = CODICESerializing.getCbcFactory().createEpaymentMeansIndicatorType();
            InvoicingTermsType invoicingTerms = CODICESerializing.getCacFactory().createInvoicingTermsType();
            ElectronicInvoicingIndicatorType eInvoicing = CODICESerializing.getCbcFactory().createElectronicInvoicingIndicatorType();
            switch (condicionesEjecucion.getPedidoElectronico()) {
                case 0: {
                    eOrdering.setValue(true);
                    res.setEorderingIndicator(eOrdering);
                    break;
                }
                case 1: {
                    eOrdering.setValue(false);
                    res.setEorderingIndicator(eOrdering);
                }
            }
            switch (condicionesEjecucion.getFacturaElectronica()) {
                case 0: {
                    eInvoicing.setValue(true);
                    invoicingTerms.setElectronicInvoicingIndicator(eInvoicing);
                    res.setInvoicingTerms(invoicingTerms);
                    break;
                }
                case 1: {
                    eOrdering.setValue(false);
                    invoicingTerms.setElectronicInvoicingIndicator(eInvoicing);
                    res.setInvoicingTerms(invoicingTerms);
                }
            }
            switch (condicionesEjecucion.getPagoElectronico()) {
                case 0: {
                    ePayment.setValue(true);
                    res.setEpaymentMeansIndicator(ePayment);
                    break;
                }
                case 1: {
                    ePayment.setValue(false);
                    res.setEpaymentMeansIndicator(ePayment);
                }
            }
            if (condicionesEjecucion.getCombatirParo() != null && condicionesEjecucion.getCombatirParo().length() > 0) {
                ContractExecutionRequirementType combatirParo = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                String idTipoCondicionCombatirParo = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc")[5][1];
                Code tipoCondicionCombatirParo = DocumentGeneratorCommon.crearCode("5", "Combatir el paro", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionCombatirParo);
                descripcion.setValue(condicionesEjecucion.getCombatirParo());
                combatirParo.setExecutionRequirementCode(codigoCondicionEjecucion);
                combatirParo.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(combatirParo);
            }
            if (condicionesEjecucion.getConsideracionesAmbientales() != null && condicionesEjecucion.getConsideracionesAmbientales().length() > 0) {
                ContractExecutionRequirementType consideracionesAmbientales = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                Code tipoCondicionConsideracionesAmbientales = DocumentGeneratorCommon.crearCode("1", "Consideraciones de tipo ambiental", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionConsideracionesAmbientales);
                descripcion.setValue(condicionesEjecucion.getConsideracionesAmbientales());
                consideracionesAmbientales.setExecutionRequirementCode(codigoCondicionEjecucion);
                consideracionesAmbientales.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(consideracionesAmbientales);
            }
            if (condicionesEjecucion.getConsideracionesSocial() != null && condicionesEjecucion.getConsideracionesSocial().length() > 0) {
                ContractExecutionRequirementType consideracionesSocial = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                Code tipoCondicionConsideracionesSocial = DocumentGeneratorCommon.crearCode("2", "Consideraciones tipo social", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionConsideracionesSocial);
                descripcion.setValue(condicionesEjecucion.getConsideracionesSocial());
                consideracionesSocial.setExecutionRequirementCode(codigoCondicionEjecucion);
                consideracionesSocial.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(consideracionesSocial);
            }
            if (condicionesEjecucion.getConvencionesOMT() != null && condicionesEjecucion.getConvencionesOMT().length() > 0) {
                ContractExecutionRequirementType convencionesOMT = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                Code tipoCondicionConvencionesOMT = DocumentGeneratorCommon.crearCode("7", "Cumplimiento de las Convenciones fundamentales de la Organizaci\u00f3n Mundial del Trabajo", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionConvencionesOMT);
                descripcion.setValue(condicionesEjecucion.getConvencionesOMT());
                convencionesOMT.setExecutionRequirementCode(codigoCondicionEjecucion);
                convencionesOMT.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(convencionesOMT);
            }
            if (condicionesEjecucion.getEliminarDesigualdades() != null && condicionesEjecucion.getEliminarDesigualdades().length() > 0) {
                ContractExecutionRequirementType eliminarDesigualdades = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                Code tipoCondicionEliminarDesigualdades = DocumentGeneratorCommon.crearCode("4", "Eliminar desigualdades entre el hombre y la mujer", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionEliminarDesigualdades);
                descripcion.setValue(condicionesEjecucion.getEliminarDesigualdades());
                eliminarDesigualdades.setExecutionRequirementCode(codigoCondicionEjecucion);
                eliminarDesigualdades.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(eliminarDesigualdades);
            }
            if (condicionesEjecucion.getFavorecerFormacion() != null && condicionesEjecucion.getFavorecerFormacion().length() > 0) {
                ContractExecutionRequirementType favorecerFormacion = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                Code tipoCondicionFavorecerFormacion = DocumentGeneratorCommon.crearCode("6", "Favorecer la formaci\u00f3n en el lugar de trabajo", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionFavorecerFormacion);
                descripcion.setValue(condicionesEjecucion.getFavorecerFormacion());
                favorecerFormacion.setExecutionRequirementCode(codigoCondicionEjecucion);
                favorecerFormacion.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(favorecerFormacion);
            }
            if (condicionesEjecucion.getPromoverEmpleo() != null && condicionesEjecucion.getPromoverEmpleo().length() > 0) {
                ContractExecutionRequirementType promoverEmpleo = CODICESerializing.getCacFactory().createContractExecutionRequirementType();
                codigoCondicionEjecucion = CODICESerializing.getCbcFactory().createExecutionRequirementCodeType();
                descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
                Code tipoCondicionPromoverEmpleo = DocumentGeneratorCommon.crearCode("3", "Promover el empleo de presonas con dificultades particulares de inserci\u00f3n en el mercado laboral", "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc", "2.0");
                DocumentGeneratorCommon.asignarCode((CodeType)codigoCondicionEjecucion, tipoCondicionPromoverEmpleo);
                descripcion.setValue(condicionesEjecucion.getPromoverEmpleo());
                promoverEmpleo.setExecutionRequirementCode(codigoCondicionEjecucion);
                promoverEmpleo.getDescription().add(descripcion);
                res.getContractExecutionRequirement().add(promoverEmpleo);
            }
        }
        return res;
    }

    protected static TenderingTermsType crearTenderingTerms(int clasificacion, String solvencia, Contractingauthorityparty datosOC, int idDirectiva) {
        TenderingTermsType res = CODICESerializing.getCacFactory().createTenderingTermsType();
        if (idDirectiva > 0) {
            DocumentReferenceType pplegdocref = CODICESerializing.getCacFactory().createDocumentReferenceType();
            String directiva = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/ProcurementLegislationDocumentReferenceID-2.05.gc")[idDirectiva - 1][1];
            IDType idDocRefDirectiva = CODICESerializing.getCbcFactory().createIDType();
            idDocRefDirectiva.setValue(directiva);
            pplegdocref.setID(idDocRefDirectiva);
            res.setProcurementLegislationDocumentReference(pplegdocref);
        }
        if (clasificacion > -1 || solvencia != null) {
            TendererQualificationRequestType tqr = CODICESerializing.getCacFactory().createTendererQualificationRequestType();
            if (clasificacion > -1 & clasificacion < ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/RequiredBusinessProfileCode-2.05.gc").length) {
                String descClass = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/RequiredBusinessProfileCode-2.05.gc")[clasificacion][0];
                String codeClass = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/RequiredBusinessProfileCode-2.05.gc")[clasificacion][1];
                ClassificationSchemeType cst = CODICESerializing.getCacFactory().createClassificationSchemeType();
                ClassificationCategoryType cat = CODICESerializing.getCacFactory().createClassificationCategoryType();
                CodeValueType codev = CODICESerializing.getCbcFactory().createCodeValueType();
                codev.setValue(codeClass);
                codev.setLanguageID("es");
                cat.setCodeValue(codev);
                NameType catName = new NameType();
                catName.setValue("Elemento RequiredBusinessProfileCode");
                cat.setName(catName);
                DescriptionType descCat = new DescriptionType();
                descCat.setLanguageID("es");
                descCat.setValue(descClass);
                List catDescList = cat.getDescription();
                catDescList.add(descCat);
                NameType name = CODICESerializing.getCbcFactory().createNameType();
                name.setValue("RequiredBusinessProfileCode");
                cst.setName(name);
                IDType id = CODICESerializing.getCbcFactory().createIDType();
                id.setValue("RequiredBusinessProfileCode");
                cst.setID(id);
                LanguageIDType lang = CODICESerializing.getCbcFactory().createLanguageIDType();
                lang.setValue("Espa\u00f1ol");
                cst.setLanguageID(lang);
                AgencyNameType agencyName = CODICESerializing.getCbcFactory().createAgencyNameType();
                agencyName.setValue("Direcci\u00f3n General del Patrimonio del Estado");
                cst.setAgencyName(agencyName);
                VersionIDType version = CODICESerializing.getCbcFactory().createVersionIDType();
                version.setValue("2.05");
                cst.setVersionID(version);
                URIType uri = CODICESerializing.getCbcFactory().createURIType();
                uri.setValue("http://contrataciondelestado.es/codice/cl/2.05/RequiredBusinessProfileCode-2.05.gc");
                cst.setURI(uri);
                SchemeURIType schemeUri = CODICESerializing.getCbcFactory().createSchemeURIType();
                schemeUri.setValue("urn:dgpe:names:specification:codice:codelist:gc:RequiredBusinessProfileCode-2.05");
                cst.setSchemeURI(schemeUri);
                cst.getClassificationCategory().add(cat);
                tqr.getRequiredBusinessClassificationScheme().add(cst);
            }
            if (solvencia != null) {
                DescriptionType desc = CODICESerializing.getCbcFactory().createDescriptionType();
                desc.setValue(solvencia);
                tqr.getDescription().add(desc);
            }
            res.setTendererQualificationRequest(tqr);
        }
        return res;
    }

    protected static TenderingProcessType crearTenderingProcess(Code tipoProcedimiento, Code codeUrgency, Code codeExpense, Code codeSubmissionMethod, Date fechaFinOfertas, Date fechaFinSolicitudes, Event evento) {
        EndTimeType endTime;
        EndDateType endDate;
        PeriodType period;
        TenderingProcessType res = CODICESerializing.getCacFactory().createTenderingProcessType();
        if (tipoProcedimiento != null) {
            ProcedureCodeType pcode = CODICESerializing.getCbcFactory().createProcedureCodeType();
            DocumentGeneratorCommon.asignarCode((CodeType)pcode, tipoProcedimiento);
            res.setProcedureCode(pcode);
            if (tipoProcedimiento.getCodevalue().compareTo("7") == 0) {
                ContractingSystemCodeType contractingSystemCode = new ContractingSystemCodeType();
                contractingSystemCode.setValue("3");
                contractingSystemCode.setListURI("http://contrataciondelestado.es/codice/cl/2.0/ContractingSystemTypeCode-2.0.gc");
                contractingSystemCode.setListVersionID("2.0");
                contractingSystemCode.setName("Contrato basado en un Acuerdo Marco");
                res.setContractingSystemCode(contractingSystemCode);
            }
        }
        if (fechaFinOfertas != null) {
            period = CODICESerializing.getCacFactory().createPeriodType();
            endDate = CODICESerializing.getCbcFactory().createEndDateType();
            endDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(fechaFinOfertas));
            period.setEndDate(endDate);
            endTime = CODICESerializing.getCbcFactory().createEndTimeType();
            endTime.setValue(DocumentGeneratorCommon.timetoXMLGregorianCalendar(fechaFinOfertas));
            period.setEndTime(endTime);
            res.setTenderSubmissionDeadlinePeriod(period);
        }
        if (fechaFinSolicitudes != null) {
            period = CODICESerializing.getCacFactory().createPeriodType();
            endDate = CODICESerializing.getCbcFactory().createEndDateType();
            endDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(fechaFinSolicitudes));
            period.setEndDate(endDate);
            endTime = CODICESerializing.getCbcFactory().createEndTimeType();
            endTime.setValue(DocumentGeneratorCommon.timetoXMLGregorianCalendar(fechaFinSolicitudes));
            period.setEndTime(endTime);
            res.setParticipationRequestReceptionPeriod(period);
        }
        if (codeUrgency != null) {
            UrgencyCodeType urgency = CODICESerializing.getCbcFactory().createUrgencyCodeType();
            DocumentGeneratorCommon.asignarCode((CodeType)urgency, codeUrgency);
            res.setUrgencyCode(urgency);
        }
        if (codeExpense != null) {
            ExpenseCodeType expense = CODICESerializing.getCbcFactory().createExpenseCodeType();
            DocumentGeneratorCommon.asignarCode((CodeType)expense, codeExpense);
            res.setExpenseCode(expense);
        }
        if (codeSubmissionMethod != null) {
            SubmissionMethodCodeType submissionMethod = CODICESerializing.getCbcFactory().createSubmissionMethodCodeType();
            DocumentGeneratorCommon.asignarCode((CodeType)submissionMethod, codeSubmissionMethod);
            res.setSubmissionMethodCode(submissionMethod);
        }
        if (evento != null) {
            res.getOpenTenderEvent().add(DocumentGeneratorCommon.crearEvent(evento));
        }
        return res;
    }

    public static TenderingProcessType crearTenderingProcess(Code tipoProcedimiento, Code codeUrgency, Code codeExpense, Code codeSubmissionMethod, Date fechaFinOfertas, Date fechaFinSolicitudes, Event evento, Date fechaEnvioInvitaciones, String justifProcAcelerado, int indicadorFasesSucesivas, int indicadorSubastaElectronica, Boolean acuerdoCP, ExpedienteBean expediente, Code tipoJustificacionATPV, String textoJustificacionATPV) {
        TenderingProcessType res = DocumentGeneratorCommon.crearTenderingProcess(tipoProcedimiento, codeUrgency, codeExpense, codeSubmissionMethod, fechaFinOfertas, fechaFinSolicitudes, evento);
        if (fechaEnvioInvitaciones != null) {
            PeriodType period = CODICESerializing.getCacFactory().createPeriodType();
            EndDateType endDate = CODICESerializing.getCbcFactory().createEndDateType();
            endDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(fechaEnvioInvitaciones));
            period.setEndDate(endDate);
            EndTimeType endTime = CODICESerializing.getCbcFactory().createEndTimeType();
            endTime.setValue(DocumentGeneratorCommon.timetoXMLGregorianCalendar(fechaEnvioInvitaciones));
            period.setEndTime(endTime);
            res.setInvitationSubmissionPeriod(period);
        }
        if (justifProcAcelerado != null && justifProcAcelerado.length() > 0) {
            AcceleratedProcedureJustificationType procAcelerado = CODICESerializing.getCbcFactory().createAcceleratedProcedureJustificationType();
            procAcelerado.setValue(justifProcAcelerado);
            res.setAcceleratedProcedureJustification(procAcelerado);
        }
        if (indicadorSubastaElectronica >= 0) {
            AuctionTermsType subasta = CODICESerializing.getCacFactory().createAuctionTermsType();
            AuctionConstraintIndicatorType indicadorSubasta = CODICESerializing.getCbcFactory().createAuctionConstraintIndicatorType();
            switch (indicadorSubastaElectronica) {
                case 0: {
                    indicadorSubasta.setValue(true);
                    DescriptionType terminosSubasta = CODICESerializing.getCbcFactory().createDescriptionType();
                    terminosSubasta.setValue(expediente.getTerminosSubastaElectronica());
                    subasta.getDescription().add(terminosSubasta);
                    break;
                }
                case 1: {
                    indicadorSubasta.setValue(false);
                }
            }
            subasta.setAuctionConstraintIndicator(indicadorSubasta);
            res.setAuctionTerms(subasta);
        }
        CandidateReductionConstraintIndicatorType fasesSucesivas = CODICESerializing.getCbcFactory().createCandidateReductionConstraintIndicatorType();
        switch (indicadorFasesSucesivas) {
            case 0: {
                fasesSucesivas.setValue(true);
                res.setCandidateReductionConstraintIndicator(fasesSucesivas);
                break;
            }
            case 1: {
                fasesSucesivas.setValue(false);
                res.setCandidateReductionConstraintIndicator(fasesSucesivas);
            }
        }
        if (expediente.getLotes() != null && expediente.getLotes().isTieneLotes()) {
            String idPresentarLotes = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderPresentationCode-1.04.gc")[expediente.getLotes().getIdDebeOfertar()][1];
            Code presentarLotes = DocumentGeneratorCommon.crearCode(idPresentarLotes, expediente.getLotes().getDebeOfertar(), "http://contrataciondelestado.es/codice/cl/1.04/TenderPresentationCode-1.04.gc", "2006");
            PartPresentationCodeType partPresentationCodeType = new PartPresentationCodeType();
            partPresentationCodeType.setValue(idPresentarLotes);
            partPresentationCodeType.setListURI(presentarLotes.getListUri());
            partPresentationCodeType.setListVersionID(presentarLotes.getListVersionId());
            partPresentationCodeType.setName(presentarLotes.getDescription());
            res.setPartPresentationCode(partPresentationCodeType);
            MaximumLotPresentationQuantityType maximumLotPresentationQuantityType = new MaximumLotPresentationQuantityType();
            maximumLotPresentationQuantityType.setValue(new BigDecimal(expediente.getLotes().getNumeroMaximoPresentacion()));
            res.setMaximumLotPresentationQuantity(maximumLotPresentationQuantityType);
            MaximumTendererAwardedLotsQuantityType awardedLotsQuantityType = new MaximumTendererAwardedLotsQuantityType();
            awardedLotsQuantityType.setValue(new BigDecimal(expediente.getLotes().getNumeroMaximoAdjudicacion()));
            res.setMaximumTendererAwardedLotsQuantity(awardedLotsQuantityType);
            LotsCombinationContractingAuthorityRightsType lotsCombinationContractingAuthorityRightsType = new LotsCombinationContractingAuthorityRightsType();
            lotsCombinationContractingAuthorityRightsType.setValue(expediente.getLotes().getDetallePosibilidadAdjudicacion());
            res.getLotsCombinationContractingAuthorityRights().add(lotsCombinationContractingAuthorityRightsType);
        }
        if (acuerdoCP != null) {
            GovernmentProcurementAgreementConstraintIndicatorType acp = CODICESerializing.cbcFactory.createGovernmentProcurementAgreementConstraintIndicatorType();
            acp.setValue(acuerdoCP.booleanValue());
            res.setGovernmentProcurementAgreementConstraintIndicator(acp);
        }
        ProcessJustificationType tenderProcJustif = null;
        if (tipoJustificacionATPV != null) {
            tenderProcJustif = new ProcessJustificationType();
            ReasonCodeType reasonCode = CODICESerializing.getCbcFactory().createReasonCodeType();
            DocumentGeneratorCommon.asignarCode((CodeType)reasonCode, tipoJustificacionATPV);
            tenderProcJustif.setReasonCode(reasonCode);
            res.getProcessJustification().add(tenderProcJustif);
        }
        if (textoJustificacionATPV != null) {
            tenderProcJustif = new ProcessJustificationType();
            DescriptionType procJustifDesc = CODICESerializing.getCbcFactory().createDescriptionType();
            procJustifDesc.setLanguageID("es");
            procJustifDesc.setValue(textoJustificacionATPV);
            tenderProcJustif.getDescription().add(procJustifDesc);
            res.getProcessJustification().add(tenderProcJustif);
        }
        return res;
    }

    protected static EventType crearEvent(Event objeto) {
        if (objeto == null) {
            return null;
        }
        EventType res = CODICESerializing.getCacFactory().createEventType();
        if (objeto.getIdentifier().length() > 0) {
            IdentificationIDType id = CODICESerializing.getCbcFactory().createIdentificationIDType();
            id.setValue(objeto.getIdentifier());
            res.setIdentificationID(id);
        }
        if (objeto.getOccurrencedate() != null) {
            OccurrenceDateType fecha = CODICESerializing.getCbcFactory().createOccurrenceDateType();
            fecha.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getOccurrencedate()));
            res.setOccurrenceDate(fecha);
        }
        if (objeto.getOccurrencetime() != null) {
            OccurrenceTimeType hora = CODICESerializing.getCbcFactory().createOccurrenceTimeType();
            hora.setValue(DocumentGeneratorCommon.timetoXMLGregorianCalendar(objeto.getOccurrencetime()));
            res.setOccurrenceTime(hora);
        }
        if (objeto.getDescription().length() > 0) {
            DescriptionType descripcion = CODICESerializing.getCbcFactory().createDescriptionType();
            descripcion.setValue(objeto.getDescription());
            res.getDescription().add(descripcion);
        }
        if (objeto.getCode() != null) {
            TypeCodeType codet = CODICESerializing.getCbcFactory().createTypeCodeType();
            DocumentGeneratorCommon.asignarCode((CodeType)codet, objeto.getCode());
            res.setTypeCode(codet);
        }
        if (objeto.getAddress().length() > 0 || objeto.getCity().length() > 0 || objeto.getCountry() != null || objeto.getPostalZone().length() > 0) {
            LocationType loc = CODICESerializing.getCacFactory().createLocationType();
            AddressType add = CODICESerializing.getCacFactory().createAddressType();
            if (objeto.getAddress().length() > 0) {
                AddressLineType line = CODICESerializing.getCacFactory().createAddressLineType();
                LineType linet = CODICESerializing.getCbcFactory().createLineType();
                linet.setValue(objeto.getAddress());
                line.setLine(linet);
                add.getAddressLine().add(line);
            }
            if (objeto.getCity().length() > 0) {
                CityNameType city = CODICESerializing.getCbcFactory().createCityNameType();
                city.setValue(objeto.getCity());
                add.setCityName(city);
            }
            if (objeto.getPostalZone().length() > 0) {
                PostalZoneType cp = CODICESerializing.getCbcFactory().createPostalZoneType();
                cp.setValue(objeto.getPostalZone());
                add.setPostalZone(cp);
            }
            if (objeto.getCountry() != null) {
                CountryType pais = CODICESerializing.getCacFactory().createCountryType();
                IdentificationCodeType idcode = CODICESerializing.getCbcFactory().createIdentificationCodeType();
                idcode.setValue("es");
                idcode.setLanguageID("es");
                idcode.setListAgencyID("0.3");
                idcode.setListSchemeURI("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
                idcode.setListURI("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
                DocumentGeneratorCommon.asignarCode((CodeType)idcode, objeto.getCountry());
                pais.setIdentificationCode(idcode);
                idcode.setListVersionID("0.3");
                add.setCountry(pais);
            }
            loc.setAddress(add);
            if (objeto.getLocationDescription().length() > 0) {
                DescriptionType dt = CODICESerializing.getCbcFactory().createDescriptionType();
                dt.setLanguageID("es");
                dt.setValue(objeto.getLocationDescription());
                loc.setDescription(dt);
            }
            res.setOccurrenceLocation(loc);
            AttendanceConditionsType attendanceConditionsType = new AttendanceConditionsType();
            AttendanceRestrictionCodeType attendanceRestrictionCodeType = new AttendanceRestrictionCodeType();
            attendanceRestrictionCodeType.setValue(objeto.getTipoEvento().getCodevalue());
            attendanceRestrictionCodeType.setListURI(objeto.getTipoEvento().getListUri());
            attendanceRestrictionCodeType.setListVersionID(objeto.getTipoEvento().getListVersionId());
            attendanceRestrictionCodeType.setName(objeto.getTipoEvento().getDescription());
            attendanceConditionsType.setAttendanceRestrictionCode(attendanceRestrictionCodeType);
            AttendanceConditionsDescriptionType attendanceConditionsDescriptionType = new AttendanceConditionsDescriptionType();
            if (objeto.getCondicionesAcceso().length() > 0) {
                attendanceConditionsDescriptionType.setValue(objeto.getCondicionesAcceso());
            }
            attendanceConditionsType.getAttendanceConditionsDescription().add(attendanceConditionsDescriptionType);
            res.setAttendanceConditions(attendanceConditionsType);
        }
        return res;
    }

    protected static ContractModificationType crearContractModification(DatosModificacionBean datosModificacion, String numContrato) {
        ContractModificationType modification = CODICESerializing.getCacFactory().createContractModificationType();
        ContractIDType contractId = CODICESerializing.getCbcFactory().createContractIDType();
        contractId.setValue(numContrato);
        modification.setContractID(contractId);
        if (datosModificacion.getNumeroModificiacion() != null) {
            IDType idType = CODICESerializing.getCbcFactory().createIDType();
            idType.setValue(datosModificacion.getNumeroModificiacion());
            modification.setID(idType);
        }
        IssueDateType issueDate = CODICESerializing.getCbcFactory().createIssueDateType();
        if (datosModificacion.getFechaModificacion() != null) {
            issueDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(datosModificacion.getFechaModificacion()));
            modification.setIssueDate(issueDate);
        }
        if (datosModificacion.getIncrementoSinImpuestos() != null || datosModificacion.getIncrementoConImpuestos() != null) {
            LegalMonetaryTotalType incremento = CODICESerializing.getCacFactory().createLegalMonetaryTotalType();
            if (datosModificacion.getIncrementoSinImpuestos() != null) {
                TaxExclusiveAmountType taxExclusive = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
                taxExclusive.setValue(datosModificacion.getIncrementoSinImpuestos());
                taxExclusive.setCurrencyID(CurrencyCodeContentType.EUR);
                incremento.setTaxExclusiveAmount(taxExclusive);
            }
            if (datosModificacion.getIncrementoConImpuestos() != null) {
                PayableAmountType payableAmount = CODICESerializing.getCbcFactory().createPayableAmountType();
                payableAmount.setValue(datosModificacion.getIncrementoConImpuestos());
                payableAmount.setCurrencyID(CurrencyCodeContentType.EUR);
                incremento.setPayableAmount(payableAmount);
            }
            modification.setContractModificationLegalMonetaryTotal(incremento);
        }
        if (datosModificacion.getImporteTotalSinImpuestos() != null || datosModificacion.getImporteTotalConImpuestos() != null) {
            LegalMonetaryTotalType importeTotal = CODICESerializing.getCacFactory().createLegalMonetaryTotalType();
            if (datosModificacion.getImporteTotalSinImpuestos() != null) {
                TaxExclusiveAmountType taxExclusiveTotal = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
                taxExclusiveTotal.setValue(datosModificacion.getImporteTotalSinImpuestos());
                taxExclusiveTotal.setCurrencyID(CurrencyCodeContentType.EUR);
                importeTotal.setTaxExclusiveAmount(taxExclusiveTotal);
            }
            if (datosModificacion.getImporteTotalConImpuestos() != null) {
                PayableAmountType payableAmountTotal = CODICESerializing.getCbcFactory().createPayableAmountType();
                payableAmountTotal.setValue(datosModificacion.getImporteTotalConImpuestos());
                payableAmountTotal.setCurrencyID(CurrencyCodeContentType.EUR);
                importeTotal.setPayableAmount(payableAmountTotal);
            }
            modification.setFinalLegalMonetaryTotal(importeTotal);
        }
        ContractModificationDurationMeasureType incrementoDuracion = CODICESerializing.getCbcFactory().createContractModificationDurationMeasureType();
        if (datosModificacion.getIncrementoDuracion() != null) {
            incrementoDuracion.setValue(datosModificacion.getIncrementoDuracion());
            String unit = ComboBoxUtils.getComboBox("http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc")[datosModificacion.getUnidadDuracionIncremento()][1];
            incrementoDuracion.setUnitCode(UnitCodeContentType.fromValue((String)unit));
            modification.setContractModificationDurationMeasure(incrementoDuracion);
        }
        FinalDurationMeasureType finalDuracion = CODICESerializing.getCbcFactory().createFinalDurationMeasureType();
        if (datosModificacion.getDuracionTotal() != null) {
            finalDuracion.setValue(datosModificacion.getDuracionTotal());
            String unit = ComboBoxUtils.getComboBox("http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc")[datosModificacion.getUnidadDuracionTotal()][1];
            finalDuracion.setUnitCode(UnitCodeContentType.fromValue((String)unit));
            modification.setFinalDurationMeasure(finalDuracion);
        }
        if (datosModificacion.getDescripcion() != null) {
            NoteType note = CODICESerializing.getCbcFactory().createNoteType();
            note.setValue(datosModificacion.getDescripcion());
            modification.getNote().add(note);
        }
        ContractModificationJustificationType justification = CODICESerializing.getCbcFactory().createContractModificationJustificationType();
        justification.setValue(datosModificacion.getJustificacionModificacion());
        modification.setContractModificationJustification(justification);
        ContractModificationReasonCodeType reasonCode = CODICESerializing.getCbcFactory().createContractModificationReasonCodeType();
        reasonCode.setValue(ComboBoxUtils.getComboBox("http://contrataciondelestado.es/codice/cl/2.05/ContractModificationReasonCode-2.05.gc")[datosModificacion.getCodigoMotivoModificacion()][1]);
        reasonCode.setListURI("http://contrataciondelestado.es/codice/cl/2.05/ContractModificationReasonCode-2.05.gc");
        reasonCode.setName(ComboBoxUtils.getComboBox("http://contrataciondelestado.es/codice/cl/2.05/ContractModificationReasonCode-2.05.gc")[datosModificacion.getCodigoMotivoModificacion()][0]);
        modification.setContractModificationReasonCode(reasonCode);
        return modification;
    }

    protected static void asignarCode(CodeType codeT, Code code) {
        codeT.setListURI(code.getListUri());
        codeT.setName(code.getDescription());
        codeT.setListVersionID(code.getListVersionId());
        codeT.setValue(code.getCodevalue());
    }

    protected static ContractingPartyType crearContractingPartyType(Contractingauthorityparty datosOC) throws JAXBException {
        IDType id;
        if (datosOC == null) {
            return null;
        }
        ContractingPartyType res = CODICESerializing.getCacFactory().createContractingPartyType();
        if (datosOC.getContractingauthoritytypecode() != null) {
            ContractingPartyTypeCodeType codeType = CODICESerializing.getCbcFactory().createContractingPartyTypeCodeType();
            datosOC.getContractingauthoritytypecode().setListVersionId("2006");
            datosOC.getContractingauthoritytypecode().setListUri("http://contrataciondelestado.es/codice/cl/1.04/ContractingAuthorityCode-1.04.gc");
            DocumentGeneratorCommon.code2Codice(datosOC.getContractingauthoritytypecode(), (CodeType)codeType);
            res.setContractingPartyTypeCode(codeType);
        }
        if (datosOC.getCaactivitytypecode() != null) {
            ActivityCodeType atc = CODICESerializing.getCbcFactory().createActivityCodeType();
            datosOC.getCaactivitytypecode().setListVersionId("2006");
            datosOC.getCaactivitytypecode().setListUri("http://contrataciondelestado.es/codice/cl/1.04/ContractingAuthorityActivityCode-1.04.gc");
            DocumentGeneratorCommon.code2Codice(datosOC.getCaactivitytypecode(), (CodeType)atc);
            res.getActivityCode().add(atc);
        }
        PartyType party = CODICESerializing.getCacFactory().createPartyType();
        PartyNameType name = CODICESerializing.getCacFactory().createPartyNameType();
        NameType namet = CODICESerializing.getCbcFactory().createNameType();
        namet.setValue(datosOC.getPartyname());
        name.setName(namet);
        party.getPartyName().add(name);
        if (datosOC.getIdPlataforma() != null) {
            PartyIdentificationType idplat = CODICESerializing.getCacFactory().createPartyIdentificationType();
            id = CODICESerializing.getCbcFactory().createIDType();
            id.setValue(datosOC.getIdPlataforma());
            id.setSchemeName("ID_PLATAFORMA");
            idplat.setID(id);
            party.getPartyIdentification().add(idplat);
        }
        if (datosOC.getCif() != null) {
            PartyIdentificationType cif = CODICESerializing.getCacFactory().createPartyIdentificationType();
            id = CODICESerializing.getCbcFactory().createIDType();
            id.setValue(datosOC.getCif());
            id.setSchemeName("CIF");
            cif.setID(id);
            party.getPartyIdentification().add(cif);
        }
        if (datosOC.getJobRole() != null) {
            PersonType person = CODICESerializing.getCacFactory().createPersonType();
            JobTitleType job = CODICESerializing.getCbcFactory().createJobTitleType();
            job.setValue(datosOC.getJobRole());
            person.setJobTitle(job);
            party.setPerson(person);
        }
        res.setParty(party);
        return res;
    }

    private static ContactType crearContacto(String email, String telefono, String fax) {
        ContactType contact = CODICESerializing.getCacFactory().createContactType();
        if (email.length() > 0) {
            ElectronicMailType eMailCbc = CODICESerializing.getCbcFactory().createElectronicMailType();
            eMailCbc.setValue(email);
            contact.setElectronicMail(eMailCbc);
        }
        if (telefono.length() > 0) {
            TelephoneType telephoneCbc = CODICESerializing.getCbcFactory().createTelephoneType();
            telephoneCbc.setValue(telefono);
            contact.setTelephone(telephoneCbc);
        }
        if (fax.length() > 0) {
            TelefaxType faxCbc = CODICESerializing.getCbcFactory().createTelefaxType();
            faxCbc.setValue(fax);
            contact.setTelefax(faxCbc);
        }
        return contact;
    }

    protected static PartyType anyadeDireccionContactosPartyOC(PartyType party, Contractingauthorityparty datosOC) {
        if (datosOC.getAddressLine().length() > 0 || datosOC.getCityName().length() > 0 || datosOC.getPostalZone().length() > 0) {
            AddressType add = CODICESerializing.getCacFactory().createAddressType();
            if (datosOC.getAddressLine().length() > 0) {
                AddressFormatCodeType adfc = CODICESerializing.getCbcFactory().createAddressFormatCodeType();
                adfc.setValue("1");
                adfc.setListURI("http://contrataciondelestado.es/codice/cl/1.04/AddressFormatCode-1.0.gc");
                adfc.setLanguageID("es");
                adfc.setListVersionID("2007");
                adfc.setName("Spanish Format");
                add.setAddressFormatCode(adfc);
                AddressLineType line = CODICESerializing.getCacFactory().createAddressLineType();
                LineType linet = CODICESerializing.getCbcFactory().createLineType();
                linet.setValue(datosOC.getAddressLine());
                line.setLine(linet);
                add.getAddressLine().add(line);
            }
            if (datosOC.getCityName().length() > 0) {
                CityNameType city = CODICESerializing.getCbcFactory().createCityNameType();
                city.setValue(datosOC.getCityName());
                add.setCityName(city);
            }
            if (datosOC.getPostalZone() != null) {
                PostalZoneType cp = CODICESerializing.getCbcFactory().createPostalZoneType();
                cp.setValue(datosOC.getPostalZone());
                add.setPostalZone(cp);
            }
            if (datosOC.getCountry() != null) {
                CountryType pais = CODICESerializing.getCacFactory().createCountryType();
                IdentificationCodeType idcode = CODICESerializing.getCbcFactory().createIdentificationCodeType();
                DocumentGeneratorCommon.asignarCode((CodeType)idcode, datosOC.getCountry());
                pais.setIdentificationCode(idcode);
                NameType countryName = CODICESerializing.getCbcFactory().createNameType();
                countryName.setValue(idcode.getName());
                pais.setName(countryName);
                add.setCountry(pais);
            }
            party.setPostalAddress(add);
        }
        if (datosOC.getContactEmail().length() > 0 | datosOC.getTelephone().length() > 0 | datosOC.getFax().length() > 0) {
            party.setContact(DocumentGeneratorCommon.crearContacto(datosOC.getContactEmail(), datosOC.getTelephone(), datosOC.getFax()));
        }
        return party;
    }

    protected static void code2Codice(Code objeto, CodeType res) {
        if (objeto != null) {
            res.setListURI(objeto.getListUri());
            res.setListVersionID(objeto.getListVersionId());
            res.setName(objeto.getDescription());
            res.setValue(objeto.getCodevalue());
        }
    }

    protected static Calendar generatePublishDate() {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        date.setTime(System.currentTimeMillis());
        calendar.setTime(date);
        return calendar;
    }

    protected static XMLGregorianCalendar generatePublishDateXMLGregorianCalendar() {
        Date d = new Date();
        d.setTime(System.currentTimeMillis());
        XMLGregorianCalendar res = null;
        res = DocumentGeneratorCommon.datetoXMLGregorianCalendar(d);
        return res;
    }

    protected static XMLGregorianCalendar generatePublishTimeXMLGregorianCalendar() {
        Date d = new Date();
        d.setTime(System.currentTimeMillis());
        XMLGregorianCalendar res = null;
        res = DocumentGeneratorCommon.timetoXMLGregorianCalendar(d);
        return res;
    }

    protected static CustomizationIDType getCustomizationID() {
        CustomizationIDType version = null;
        version = CODICESerializing.getCbcFactory().createCustomizationIDType();
        ConfigurationManager.getInstance();
        version.setValue(ConfigurationManager.leerPropiedad("codice.version"));
        return version;
    }

    protected static ProfileIDType getProfileID() {
        ProfileIDType version = null;
        version = CODICESerializing.getCbcFactory().createProfileIDType();
        ConfigurationManager.getInstance();
        version.setValue(ConfigurationManager.leerPropiedad("codice.profile.version"));
        return version;
    }

    protected static UBLVersionIDType getUBLVersionID() {
        UBLVersionIDType version = null;
        version = CODICESerializing.getCbcFactory().createUBLVersionIDType();
        ConfigurationManager.getInstance();
        version.setValue(ConfigurationManager.leerPropiedad("ubl.version"));
        return version;
    }

    protected static UUIDType getUUID(String id) {
        UUIDType uuidtype = null;
        uuidtype = CODICESerializing.getCbcFactory().createUUIDType();
        if (id != null) {
            uuidtype.setValue(id);
        } else {
            uuidtype.setValue("PREVIEW");
        }
        return uuidtype;
    }

    protected static IDType getID(String id) {
        IDType idtype = null;
        idtype = CODICESerializing.getCbcFactory().createIDType();
        if (id != null) {
            idtype.setValue(String.valueOf(System.currentTimeMillis()));
        } else {
            idtype.setValue("PREVIEW");
        }
        return idtype;
    }

    protected static ContractType crearContract(String ID, Date contractDate, Date startDate) {
        ContractType contrato = null;
        if (ID.length() > 0 || contractDate != null || startDate != null) {
            contrato = new ContractType();
            if (ID.length() > 0) {
                IDType numContrato = new IDType();
                numContrato.setValue(ID);
                contrato.setID(numContrato);
            }
            if (contractDate != null) {
                IssueDateType fechaForm = new IssueDateType();
                fechaForm.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(contractDate));
                contrato.setIssueDate(fechaForm);
            }
            if (startDate != null) {
                PeriodType periodoContrato = new PeriodType();
                StartDateType fechaVigorContrato = new StartDateType();
                fechaVigorContrato.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(startDate));
                periodoContrato.setStartDate(fechaVigorContrato);
                contrato.setValidityPeriod(periodoContrato);
            }
        }
        return contrato;
    }

    protected static TenderResultType crearTenderResultAdjudicacion(ExpedienteBean objeto) {
        TenderResultType res = null;
        try {
            res = CODICESerializing.getCacFactory().createTenderResultType();
            AwardDateType awardDate = CODICESerializing.getCbcFactory().createAwardDateType();
            if (objeto.getLicitador() != null) {
                awardDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getLicitador().getFechaAdjudicacion()));
                res.setAwardDate(awardDate);
                DescriptionType description = CODICESerializing.getCbcFactory().createDescriptionType();
                description.setValue(objeto.getLicitador().getMotivacion());
                res.getDescription().add(description);
                PeriodType periodForm = CODICESerializing.getCacFactory().createPeriodType();
                if (objeto.getLicitador().getFechaFinFormalizacion() != null) {
                    EndDateType endDate = CODICESerializing.getCbcFactory().createEndDateType();
                    endDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getLicitador().getFechaFinFormalizacion()));
                    EndTimeType endTime = CODICESerializing.getCbcFactory().createEndTimeType();
                    endTime.setValue(DocumentGeneratorCommon.timetoXMLGregorianCalendar(objeto.getLicitador().getFechaFinFormalizacion()));
                    periodForm.setEndDate(endDate);
                    periodForm.setEndTime(endTime);
                }
                DescriptionType descricpionFinAdjudicacion = CODICESerializing.getCbcFactory().createDescriptionType();
                descricpionFinAdjudicacion.setValue(objeto.getLicitador().getDescripcionLimiteFormalizacion());
                periodForm.getDescription().add(descricpionFinAdjudicacion);
                res.setContractFormalizationPeriod(periodForm);
                TenderedProjectType tpt = CODICESerializing.getCacFactory().createTenderedProjectType();
                LegalMonetaryTotalType mtt = CODICESerializing.getCacFactory().createLegalMonetaryTotalType();
                if (objeto.getLicitador().getImporteSinImpuestos().length() > 0) {
                    TaxExclusiveAmountType amountType = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
                    amountType.setValue(new BigDecimal(objeto.getLicitador().getImporteSinImpuestos()));
                    amountType.setCurrencyID(CurrencyCodeContentType.EUR);
                    mtt.setTaxExclusiveAmount(amountType);
                }
                if (objeto.getLicitador().getImporteConImpuestos().length() > 0) {
                    PayableAmountType amountType2 = CODICESerializing.getCbcFactory().createPayableAmountType();
                    amountType2.setValue(new BigDecimal(objeto.getLicitador().getImporteConImpuestos()));
                    amountType2.setCurrencyID(CurrencyCodeContentType.EUR);
                    mtt.setPayableAmount(amountType2);
                }
                tpt.setLegalMonetaryTotal(mtt);
                res.setAwardedTenderedProject(tpt);
                if (objeto.getLicitador().getNumOfertasElectronicas() != null) {
                    ReceivedTenderQuantityType rtq = CODICESerializing.getCbcFactory().createReceivedTenderQuantityType();
                    rtq.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasRecibidas()));
                    res.setReceivedTenderQuantity(rtq);
                }
                if (objeto.getLicitador().getNumOfertasRecibidasPymes() != null) {
                    SMEsReceivedTenderQuantityType value = CODICESerializing.getCbcFactory().createSMEsReceivedTenderQuantityType();
                    value.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasRecibidasPymes()));
                    res.setSMEsReceivedTenderQuantity(value);
                }
                if (objeto.getLicitador().getNumOfertasExtranjerosUE() != null) {
                    EUNationalsReceivedTenderQuantityType euNationalsReceivedTenderQuantityType = CODICESerializing.getCbcFactory().createEUNationalsReceivedTenderQuantityType();
                    euNationalsReceivedTenderQuantityType.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasExtranjerosUE()));
                    res.setEUNationalsReceivedTenderQuantity(euNationalsReceivedTenderQuantityType);
                }
                if (objeto.getLicitador().getNumOfertasExtranjerosNoUE() != null) {
                    NonEUNationalsReceivedTenderQuantityType nonEuNationalsReceivedTenderQuantityType = CODICESerializing.getCbcFactory().createNonEUNationalsReceivedTenderQuantityType();
                    nonEuNationalsReceivedTenderQuantityType.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasExtranjerosNoUE()));
                    res.setNonEUNationalsReceivedTenderQuantity(nonEuNationalsReceivedTenderQuantityType);
                }
                if (objeto.getLicitador().getNumOfertasElectronicas() != null) {
                    ReceivedElectronicTenderQuantityType electronicTenderQuantityType = CODICESerializing.getCbcFactory().createReceivedElectronicTenderQuantityType();
                    electronicTenderQuantityType.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasElectronicas()));
                    res.setReceivedElectronicTenderQuantity(electronicTenderQuantityType);
                }
                if (objeto.getLicitador().getOfertasBajas() != null) {
                    AbnormallyLowTendersIndicatorType abnormallyLowTendersIndicatorType = CODICESerializing.getCbcFactory().createAbnormallyLowTendersIndicatorType();
                    abnormallyLowTendersIndicatorType.setValue(objeto.getLicitador().getOfertasBajas().booleanValue());
                    res.setAbnormallyLowTendersIndicator(abnormallyLowTendersIndicatorType);
                }
                if (objeto.getLicitador().getIdPaisOrigen() >= 0) {
                    OriginCountryCodeType originCountryCodeType = CODICESerializing.getCbcFactory().createOriginCountryCodeType();
                    String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getLicitador().getIdPaisOrigen()][1];
                    Code pais = DocumentGeneratorCommon.crearCode(idPais, ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getLicitador().getIdPaisOrigen()][0], "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
                    originCountryCodeType.setValue(idPais);
                    originCountryCodeType.setListURI(pais.getListUri());
                    originCountryCodeType.setListVersionID(pais.getListVersionId());
                    originCountryCodeType.setName(pais.getDescription());
                    res.getOriginCountryCode().add(originCountryCodeType);
                }
                if (objeto.getLicitador().getAdjudicatarioPyme() != null) {
                    SMEAwardedIndicatorType smeAwardedIndicatorType = CODICESerializing.getCbcFactory().createSMEAwardedIndicatorType();
                    smeAwardedIndicatorType.setValue(objeto.getLicitador().getAdjudicatarioPyme().booleanValue());
                    res.setSMEAwardedIndicator(smeAwardedIndicatorType);
                }
                PartyType party = CODICESerializing.getCacFactory().createPartyType();
                PartyNameType name = CODICESerializing.getCacFactory().createPartyNameType();
                NameType na = CODICESerializing.getCbcFactory().createNameType();
                na.setValue(objeto.getLicitador().getNombre());
                name.setName(na);
                party.getPartyName().add(name);
                PartyIdentificationType pit = CODICESerializing.getCacFactory().createPartyIdentificationType();
                IDType typeParty = CODICESerializing.getCbcFactory().createIDType();
                typeParty.setValue(objeto.getLicitador().getIdentificador());
                typeParty.setSchemeName(objeto.getLicitador().getTipoIdentificador());
                pit.setID(typeParty);
                party.getPartyIdentification().add(pit);
                LocationType location = CODICESerializing.getCacFactory().createLocationType();
                AddressType addressType = CODICESerializing.getCacFactory().createAddressType();
                if (objeto.getLicitador().getCiudad().length() > 0) {
                    CityNameType cityName = CODICESerializing.getCbcFactory().createCityNameType();
                    cityName.setValue(objeto.getLicitador().getCiudad());
                    addressType.setCityName(cityName);
                }
                if (objeto.getLicitador().getCodigoPostal().length() > 0) {
                    PostalZoneType postalZoneType = CODICESerializing.getCbcFactory().createPostalZoneType();
                    postalZoneType.setValue(objeto.getLicitador().getCodigoPostal());
                    addressType.setPostalZone(postalZoneType);
                }
                if (objeto.getLicitador().getDireccion().length() > 0) {
                    AddressLineType addressLine = CODICESerializing.getCacFactory().createAddressLineType();
                    LineType line = CODICESerializing.getCbcFactory().createLineType();
                    line.setValue(objeto.getLicitador().getDireccion());
                    addressLine.setLine(line);
                    addressType.getAddressLine().add(addressLine);
                }
                IdentificationCodeType identificationCode = new IdentificationCodeType();
                String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getLicitador().getIdPais()][1];
                Code paisCode = DocumentGeneratorCommon.crearCode(idPais, objeto.getLicitador().getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
                identificationCode.setValue(idPais);
                identificationCode.setListURI("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
                identificationCode.setListVersionID("0.3");
                identificationCode.setName(paisCode.getDescription());
                CountryType countryType = new CountryType();
                countryType.setIdentificationCode(identificationCode);
                NameType name2 = new NameType();
                name2.setValue(paisCode.getDescription());
                countryType.setName(name2);
                addressType.setCountry(countryType);
                location.setAddress(addressType);
                CountrySubentityType countrySubentityType = CODICESerializing.getCbcFactory().createCountrySubentityType();
                countrySubentityType.setValue(objeto.getLicitador().getNuts());
                location.setCountrySubentity(countrySubentityType);
                CountrySubentityCodeType codeType = CODICESerializing.getCbcFactory().createCountrySubentityCodeType();
                codeType.setValue(objeto.getLicitador().getIdNuts());
                codeType.setListURI("https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc");
                codeType.setListVersionID("2009");
                codeType.setName(objeto.getLicitador().getNuts());
                location.setCountrySubentityCode(codeType);
                party.setPhysicalLocation(location);
                res.setWinningParty(party);
            }
            ResultCodeType rct = CODICESerializing.getCbcFactory().createResultCodeType();
            rct.setValue("8");
            rct.setLanguageID("es");
            rct.setName("Adjudicado");
            rct.setListVersionID("2.02");
            rct.setListSchemeURI("http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc");
            rct.setListURI("http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc");
            res.setResultCode(rct);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    protected static TenderResultType crearTenderResultFormalizacion(ExpedienteBean objeto) {
        TenderResultType res = DocumentGeneratorCommon.crearTenderResultAdjudicacion(objeto);
        res.getResultCode().setValue("9");
        res.getResultCode().setName("Formalizado");
        ContractType contrato = DocumentGeneratorCommon.crearContract(objeto.getNumContrato(), objeto.getFechaFormalizacion(), objeto.getFechaVigorContrato());
        res.setContract(contrato);
        return res;
    }

    protected static TenderResultType crearTenderResultRenuncia(ExpedienteBean objeto) {
        TenderResultType res = null;
        try {
            res = CODICESerializing.getCacFactory().createTenderResultType();
            AwardDateType awardDate = CODICESerializing.getCbcFactory().createAwardDateType();
            awardDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getFechaAcuerdo()));
            res.setAwardDate(awardDate);
            ResultCodeType rct = CODICESerializing.getCbcFactory().createResultCodeType();
            if (objeto.getTipoResolucion().equals("DESIERTO")) {
                rct.setValue("3");
                rct.setName("Desierto");
            }
            if (objeto.getTipoResolucion().equals("DESISTIMIENTO")) {
                rct.setValue("4");
                rct.setName("Desistimiento");
            }
            if (objeto.getTipoResolucion().equals("RENUNCIA")) {
                rct.setValue("5");
                rct.setName("Renuncia");
            }
            rct.setLanguageID("es");
            rct.setListVersionID("2.02");
            rct.setListSchemeURI("http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc");
            rct.setListURI("http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc");
            res.setResultCode(rct);
            ReceivedTenderQuantityType rtq = CODICESerializing.getCbcFactory().createReceivedTenderQuantityType();
            if (objeto.getNumOfertasRecibidas() != null) {
                rtq.setValue(new BigDecimal(objeto.getNumOfertasRecibidas()));
            }
            res.setReceivedTenderQuantity(rtq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    protected static TenderResultType crearTenderResultMenor(ExpedienteBean objeto) {
        TenderResultType res = null;
        try {
            res = CODICESerializing.getCacFactory().createTenderResultType();
            AwardDateType awardDate = CODICESerializing.getCbcFactory().createAwardDateType();
            if (objeto.getLicitador() != null) {
                awardDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getLicitador().getFechaAdjudicacion()));
                res.setAwardDate(awardDate);
                TenderedProjectType tpt = CODICESerializing.getCacFactory().createTenderedProjectType();
                LegalMonetaryTotalType mtt = CODICESerializing.getCacFactory().createLegalMonetaryTotalType();
                TaxExclusiveAmountType amountType = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
                amountType.setValue(new BigDecimal(objeto.getLicitador().getImporteSinImpuestos()));
                amountType.setCurrencyID(CurrencyCodeContentType.EUR);
                mtt.setTaxExclusiveAmount(amountType);
                PayableAmountType amountType2 = CODICESerializing.getCbcFactory().createPayableAmountType();
                amountType2.setValue(new BigDecimal(objeto.getLicitador().getImporteConImpuestos()));
                amountType2.setCurrencyID(CurrencyCodeContentType.EUR);
                mtt.setPayableAmount(amountType2);
                tpt.setLegalMonetaryTotal(mtt);
                res.setAwardedTenderedProject(tpt);
                ReceivedTenderQuantityType rtq = CODICESerializing.getCbcFactory().createReceivedTenderQuantityType();
                rtq.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasRecibidas()));
                res.setReceivedTenderQuantity(rtq);
                PartyType party = CODICESerializing.getCacFactory().createPartyType();
                PartyNameType name = CODICESerializing.getCacFactory().createPartyNameType();
                NameType na = CODICESerializing.getCbcFactory().createNameType();
                na.setValue(objeto.getLicitador().getNombre());
                name.setName(na);
                party.getPartyName().add(name);
                PartyIdentificationType pit = CODICESerializing.getCacFactory().createPartyIdentificationType();
                IDType typeParty = CODICESerializing.getCbcFactory().createIDType();
                typeParty.setValue(objeto.getLicitador().getIdentificador());
                typeParty.setSchemeName(objeto.getLicitador().getTipoIdentificador());
                pit.setID(typeParty);
                party.getPartyIdentification().add(pit);
                CountryType pais = CODICESerializing.getCacFactory().createCountryType();
                IdentificationCodeType idcode = CODICESerializing.getCbcFactory().createIdentificationCodeType();
                idcode.setValue("ES");
                idcode.setLanguageID("es");
                idcode.setListVersionID("0.3");
                pais.setIdentificationCode(idcode);
                res.setWinningParty(party);
            }
            ResultCodeType rct = CODICESerializing.getCbcFactory().createResultCodeType();
            rct.setValue("8");
            rct.setLanguageID("es");
            rct.setName("Adjudicado");
            rct.setListVersionID("2.02");
            rct.setListSchemeURI("http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc");
            rct.setListURI("http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc");
            res.setResultCode(rct);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    protected static Event crearEvent(EventoAperturaBean objeto) {
        Event eventoApertura = null;
        if (objeto != null) {
            eventoApertura = new Event();
            eventoApertura.setIdentifier(objeto.getNombre());
            eventoApertura.setAddress(objeto.getCalle());
            eventoApertura.setCity(objeto.getPoblacion());
            eventoApertura.setDescription(objeto.getDescripcion());
            eventoApertura.setOccurrencedate(objeto.getFechaApertura());
            eventoApertura.setOccurrencetime(objeto.getFechaApertura());
            eventoApertura.setPostalZone(objeto.getCp());
            eventoApertura.setCode(DocumentGeneratorCommon.crearCode("4", "Apertura sobre oferta econ\u00f3mica", "http://contrataciondelestado.es/codice/cl/2.01/EventTypeCode-2.01.gc", "2.01"));
            eventoApertura.setLocationDescription(objeto.getLugar());
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            eventoApertura.setCountry(DocumentGeneratorCommon.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", null));
            String idTipoEvento = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.01/EventTypeCode-2.01.gc")[objeto.getIdTipoEventoApertura()][1];
            eventoApertura.setTipoEvento(DocumentGeneratorCommon.crearCode(idTipoEvento, objeto.getTipoEventoApertura(), "http://contrataciondelestado.es/codice/cl/2.05/AttendanceRestrictionCode-2.05.gc", "2.05"));
            eventoApertura.setCondicionesAcceso(objeto.getRequisitosAsistentes());
        }
        return eventoApertura;
    }

    protected static Code crearCode(String codevalue, String name, String nombreLista, String versionId) {
        Code res = new Code();
        res.setCodevalue(String.valueOf(codevalue));
        res.setListUri(nombreLista);
        res.setDescription(name);
        res.setListVersionId(versionId);
        return res;
    }

    protected static Contractingauthorityparty crearContractingParty() {
        SessionDataManager.getInstance();
        OrganoContratacionBean datosOC = SessionDataManager.getOrganoContratacion();
        Contractingauthorityparty cap = new Contractingauthorityparty();
        cap.setPartyname(datosOC.getNombreOC());
        cap.setCif(datosOC.getNumDocumento());
        cap.setIdPlataforma(datosOC.getIdPlataforma());
        String idAdmin = ComboBoxUtils.getComboBox("http://contrataciondelestado.es/codice/cl/1.04/ContractingAuthorityCode-1.04.gc")[datosOC.getIdOrgContratante()][1];
        cap.setContractingauthoritytypecode(DocumentGeneratorCommon.crearCode(idAdmin, datosOC.getNombreAdmin(), "http://contrataciondelestado.es/codice/cl/1.04/ContractingAuthorityCode-1.04.gc", null));
        cap.setIdPlataforma(datosOC.getIdPlataforma());
        cap.setAddressLine(datosOC.getVia());
        cap.setPostalZone(datosOC.getCP());
        cap.setCityName(datosOC.getPoblacion());
        if (datosOC.getIdPais() != -1) {
            CountryType pais = CODICESerializing.getCacFactory().createCountryType();
            IdentificationCodeType idcode = CODICESerializing.getCbcFactory().createIdentificationCodeType();
            String codeValuePais = ComboBoxUtils.getComboBox("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[datosOC.getIdPais()][1];
            cap.setCountry(DocumentGeneratorCommon.crearCode(codeValuePais, datosOC.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3"));
        }
        cap.setContactEmail(datosOC.getEmail());
        cap.setTelephone(datosOC.getTelefono());
        cap.setFax(datosOC.getFax());
        return cap;
    }

    protected static PeriodType crearPlannedPeriod(CondicionesEjecucionBean objeto) {
        PeriodType pp = null;
        try {
            pp = CODICESerializing.getCacFactory().createPeriodType();
            if (objeto.getFechaInicio() != null) {
                StartDateType startDate = CODICESerializing.getCbcFactory().createStartDateType();
                startDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getFechaInicio()));
                pp.setStartDate(startDate);
            }
            if (objeto.getFechaFinal() != null) {
                EndDateType endDate = CODICESerializing.getCbcFactory().createEndDateType();
                endDate.setValue(DocumentGeneratorCommon.datetoXMLGregorianCalendar(objeto.getFechaFinal()));
                pp.setEndDate(endDate);
            }
            if (objeto.getDuracion() != null) {
                DurationMeasureType duracion = CODICESerializing.getCbcFactory().createDurationMeasureType();
                duracion.setValue(new BigDecimal(objeto.getDuracion()));
                String unit = ComboBoxUtils.getComboBox("http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc")[objeto.getUnidadDuracion()][1];
                duracion.setUnitCode(UnitCodeContentType.fromValue((String)unit));
                pp.setDurationMeasure(duracion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pp;
    }
}

