/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.utils.documentsgenerator;

import es.dgpe.place.client.beans.AnularAnuncioBean;
import es.dgpe.place.client.beans.AnularDocumentoBean;
import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.CristeriosAdjudicacionBean;
import es.dgpe.place.client.beans.DatosModificacionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.ReceptorRecursosBean;
import es.dgpe.place.client.beans.RequisitosParticipacionBean;
import es.dgpe.place.client.beans.codice.Code;
import es.dgpe.place.client.beans.codice.Contractingauthorityparty;
import es.dgpe.place.client.beans.codice.Documentreference;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.utils.ClienteLlamadas;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.utils.documentsgenerator.DocumentGeneratorCommon;
import ext.place.codice.common.caclib.AdditionalPublicationRequestType;
import ext.place.codice.common.caclib.GeneralDocumentCancellationType;
import ext.place.codice.common.caclib.NoticeCancellationAttachmentDocumentReferenceType;
import ext.place.codice.common.caclib.NoticeCancellationType;
import ext.place.codice.common.cbclib.CancellationReasonCodeType;
import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.dgpe.codice.common.caclib.AddressLineType;
import org.dgpe.codice.common.caclib.AddressType;
import org.dgpe.codice.common.caclib.AppealTermsType;
import org.dgpe.codice.common.caclib.AwardingCriteriaType;
import org.dgpe.codice.common.caclib.AwardingTermsType;
import org.dgpe.codice.common.caclib.BudgetAmountType;
import org.dgpe.codice.common.caclib.CommodityClassificationType;
import org.dgpe.codice.common.caclib.CountryType;
import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.common.caclib.EvaluationCriteriaType;
import org.dgpe.codice.common.caclib.LocationType;
import org.dgpe.codice.common.caclib.PartyIdentificationType;
import org.dgpe.codice.common.caclib.PartyNameType;
import org.dgpe.codice.common.caclib.PartyType;
import org.dgpe.codice.common.caclib.ProcurementProjectLotType;
import org.dgpe.codice.common.caclib.ProcurementProjectType;
import org.dgpe.codice.common.caclib.TendererQualificationRequestType;
import org.dgpe.codice.common.caclib.TendererRequirementType;
import org.dgpe.codice.common.caclib.TenderingTermsType;
import org.dgpe.codice.common.cbclib.AgencyIDType;
import org.dgpe.codice.common.cbclib.AwardingCriteriaSubTypeCodeType;
import org.dgpe.codice.common.cbclib.AwardingCriteriaTypeCodeType;
import org.dgpe.codice.common.cbclib.CityNameType;
import org.dgpe.codice.common.cbclib.ContractFolderIDType;
import org.dgpe.codice.common.cbclib.CountrySubentityCodeType;
import org.dgpe.codice.common.cbclib.CountrySubentityType;
import org.dgpe.codice.common.cbclib.DescriptionType;
import org.dgpe.codice.common.cbclib.EvaluationCriteriaTypeCodeType;
import org.dgpe.codice.common.cbclib.IDType;
import org.dgpe.codice.common.cbclib.IdentificationCodeType;
import org.dgpe.codice.common.cbclib.IssueDateType;
import org.dgpe.codice.common.cbclib.IssueTimeType;
import org.dgpe.codice.common.cbclib.ItemClassificationCodeType;
import org.dgpe.codice.common.cbclib.LineType;
import org.dgpe.codice.common.cbclib.NameType;
import org.dgpe.codice.common.cbclib.NoteType;
import org.dgpe.codice.common.cbclib.PlannedDateType;
import org.dgpe.codice.common.cbclib.PostalZoneType;
import org.dgpe.codice.common.cbclib.RequirementTypeCodeType;
import org.dgpe.codice.common.cbclib.TaxExclusiveAmountType;
import org.dgpe.codice.common.cbclib.TotalAmountType;
import org.dgpe.codice.common.cbclib.UUIDType;
import org.dgpe.codice.common.cbclib.WebsiteURIType;
import org.dgpe.codice.common.cbclib.WeightNumericType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;
import org.oasis.ubl.codelist.currencycode.CurrencyCodeContentType;

public class DocumentsGenerator
extends DocumentGeneratorCommon {
    public static PriorInformationNoticeType generateDocumentPriorInformationNotice(ExpedienteBean objeto, String id, String noticeid) {
        PriorInformationNoticeType documento = null;
        try {
            documento = cs.getPinFactory().createPriorInformationNoticeType();
            IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();
            documento.setUBLVersionID(DocumentsGenerator.getUBLVersionID());
            documento.setCustomizationID(DocumentsGenerator.getCustomizationID());
            documento.setProfileID(DocumentsGenerator.getProfileID());
            documento.setID(DocumentsGenerator.getID(id));
            documento.setUUID(DocumentsGenerator.getUUID(id));
            if (objeto != null) {
                PlannedDateType plannedDate = cs.getCbcFactory().createPlannedDateType();
                plannedDate.setValue(DocumentsGenerator.datetoXMLGregorianCalendar(objeto.getFechaPrevIniProcAdj()));
                documento.setPlannedDate(plannedDate);
            }
            issuedate.setValue(DocumentsGenerator.generatePublishDateXMLGregorianCalendar());
            documento.setIssueDate(issuedate);
            IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
            issuetime.setValue(DocumentsGenerator.generatePublishTimeXMLGregorianCalendar());
            documento.setIssueTime(issuetime);
            ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
            contractfileid.setValue(objeto.getNumExpediente());
            documento.setContractFolderID(contractfileid);
            Contractingauthorityparty cap = DocumentsGenerator.crearContractingParty();
            documento.setContractingParty(DocumentsGenerator.crearContractingPartyType(cap));
            String idTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc")[objeto.getIdTipoContrato()][1];
            Code tipoContrato = DocumentsGenerator.crearCode(idTipoContrato, objeto.getTipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc", "2006");
            String idSubTipoContrato = null;
            Code subtipoContrato = null;
            if (idTipoContrato.equalsIgnoreCase("1")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("2")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("3")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("40")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc", "2.05");
            }
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            String idNuts = objeto.getIdNuts();
            Code nuts = DocumentsGenerator.crearCode(idNuts, objeto.getNuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            String idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[objeto.getIdCpv()][1];
            Code cpv = DocumentsGenerator.crearCode(idCPV, objeto.getCpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            BigDecimal importeSin = null;
            BigDecimal importeCon = null;
            BigDecimal valorEstimado = null;
            if (objeto.getImporteSinImpuestos().length() > 0) {
                try {
                    importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getImporteConImpuestos().length() > 0) {
                try {
                    importeCon = new BigDecimal(objeto.getImporteConImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getValorEstimado().length() > 0) {
                try {
                    valorEstimado = new BigDecimal(objeto.getValorEstimado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            documento.setProcurementProject(DocumentsGenerator.crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin, importeCon, valorEstimado, pais, nuts));
            String idTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][1];
            Code codeTipoProcedimiento = DocumentsGenerator.crearCode(idTipoProc, objeto.getProcContratacion(), "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc", "2.05");
            String idTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][1];
            Code codeTipoTram = DocumentsGenerator.crearCode(idTipoTram, objeto.getTipoTramitacion(), "http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc", "2006");
            String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][1];
            Code codeTipoTramGasto = DocumentsGenerator.crearCode(idTipoTramGasto, objeto.getTipoTramitacionGasto(), "http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc", "2006");
            documento.setTenderingProcess(DocumentsGenerator.crearTenderingProcess(codeTipoProcedimiento, null, null, null, null, null, null));
            documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(-1, objeto.getDescSolvencia(), DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion()));
            documento.getTenderingTerms().setAppealTerms(DocumentsGenerator.obtenerReceptorRecursos(objeto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return documento;
    }

    public static ContractNoticeType generateDocumentContractNotice(ExpedienteBean objeto, String id, String noticeid) {
        ContractNoticeType documento = null;
        try {
            documento = cs.getCnFactory().createContractNoticeType();
            IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();
            documento.setUBLVersionID(DocumentsGenerator.getUBLVersionID());
            documento.setCustomizationID(DocumentsGenerator.getCustomizationID());
            documento.setProfileID(DocumentsGenerator.getProfileID());
            documento.setID(DocumentsGenerator.getID(id));
            documento.setUUID(DocumentsGenerator.getUUID(id));
            issuedate.setValue(DocumentsGenerator.generatePublishDateXMLGregorianCalendar());
            documento.setIssueDate(issuedate);
            IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
            issuetime.setValue(DocumentsGenerator.generatePublishTimeXMLGregorianCalendar());
            documento.setIssueTime(issuetime);
            ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
            contractfileid.setValue(objeto.getNumExpediente());
            documento.setContractFolderID(contractfileid);
            Contractingauthorityparty cap = DocumentsGenerator.crearContractingParty();
            documento.setContractingParty(DocumentsGenerator.crearContractingPartyType(cap));
            String idTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc")[objeto.getIdTipoContrato()][1];
            Code tipoContrato = DocumentsGenerator.crearCode(idTipoContrato, objeto.getTipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc", "2006");
            String idSubTipoContrato = null;
            Code subtipoContrato = null;
            if (idTipoContrato.equalsIgnoreCase("1")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("2")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("3")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("40")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc", "2.05");
            }
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            String idNuts = objeto.getIdNuts();
            Code nuts = DocumentsGenerator.crearCode(idNuts, objeto.getNuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            String idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[objeto.getIdCpv()][1];
            Code cpv = DocumentsGenerator.crearCode(idCPV, objeto.getCpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            BigDecimal importeSin = null;
            BigDecimal importeCon = null;
            BigDecimal valorEstimado = null;
            if (objeto.getImporteSinImpuestos().length() > 0) {
                try {
                    importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getImporteConImpuestos().length() > 0) {
                try {
                    importeCon = new BigDecimal(objeto.getImporteConImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getValorEstimado().length() > 0) {
                try {
                    valorEstimado = new BigDecimal(objeto.getValorEstimado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            CondicionesEjecucionBean duracionContrato = null;
            if (objeto.getCondicionesEjecucion() != null) {
                duracionContrato = objeto.getCondicionesEjecucion();
            }
            documento.setProcurementProject(DocumentsGenerator.crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin, importeCon, valorEstimado, duracionContrato, pais, nuts));
            String idTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][1];
            String nombreTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][0];
            Code codeTipoProcedimiento = DocumentsGenerator.crearCode(idTipoProc, nombreTipoProc, "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc", "2.05");
            String idTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][1];
            String nombreTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][0];
            Code codeTipoTram = DocumentsGenerator.crearCode(idTipoTram, nombreTipoTram, "http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc", "2006");
            String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][1];
            String nombreTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][0];
            Code codeTipoTramGasto = DocumentsGenerator.crearCode(idTipoTramGasto, nombreTipoTramGasto, "http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc", "2006");
            String idFormaPresentacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc")[objeto.getIdFormaPresentacion()][1];
            String nombreFormaPresentacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc")[objeto.getIdFormaPresentacion()][0];
            Code codeFormaPresentacion = DocumentsGenerator.crearCode(idFormaPresentacion, nombreFormaPresentacion, "http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc", "2006");
            Boolean acuerdoCP = objeto.getAcuerdoCP() == 0 ? new Boolean(true) : new Boolean(false);
            documento.setTenderingProcess(DocumentsGenerator.crearTenderingProcess(codeTipoProcedimiento, codeTipoTram, codeTipoTramGasto, codeFormaPresentacion, objeto.getFechaFinOfertas(), objeto.getFechaFinSolicitudes(), DocumentsGenerator.crearEvent(objeto.getEventoApertura()), objeto.getFechaEnvioInvitaciones(), objeto.getJustifProcAcelerado(), objeto.getIndicadorFasesSucesivas(), objeto.getIndicadorSubastaElectronica(), acuerdoCP, objeto, null, null));
            if (objeto.getDescSolvencia() != null | objeto.getDirectivaAplicacion() != null | objeto.getJustifNoPubPliegos() != null | objeto.getCondicionesEjecucion() != null) {
                documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(objeto.getClasificacion(), objeto.getDescSolvencia(), DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(), objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
            } else {
                documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(objeto.getClasificacion(), null, DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(), objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
            ArrayList<ProcurementProjectLotType> listaLotes = DocumentsGenerator.obtenerDatosLotes(objeto);
            for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
                documento.getProcurementProjectLot().add(procurementProjectLotType);
            }
        }
        DocumentsGenerator.insertarInformacionContacto(documento.getTenderingTerms());
        documento.getTenderingTerms().setAppealTerms(DocumentsGenerator.obtenerReceptorRecursos(objeto));
        documento.getTenderingTerms().setTendererQualificationRequest(DocumentsGenerator.obtenerRequisitosSolvencia(objeto, documento.getTenderingTerms().getTendererQualificationRequest()));
        documento.getTenderingTerms().setAwardingTerms(DocumentsGenerator.obtenerCriteriosAdjudiacion(objeto));
        return documento;
    }

    public static CallForTendersType generateDocumentCallForTenders(ExpedienteBean objeto, String id, String noticeid) {
        CallForTendersType documento = null;
        try {
            documento = cs.getCftFactory().createCallForTendersType();
            IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();
            documento.setUBLVersionID(DocumentsGenerator.getUBLVersionID());
            documento.setCustomizationID(DocumentsGenerator.getCustomizationID());
            documento.setProfileID(DocumentsGenerator.getProfileID());
            documento.setID(DocumentsGenerator.getID(id));
            documento.setUUID(DocumentsGenerator.getUUID(id));
            issuedate.setValue(DocumentsGenerator.generatePublishDateXMLGregorianCalendar());
            documento.setIssueDate(issuedate);
            IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
            issuetime.setValue(DocumentsGenerator.generatePublishTimeXMLGregorianCalendar());
            documento.setIssueTime(issuetime);
            ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
            contractfileid.setValue(objeto.getNumExpediente());
            documento.setContractFolderID(contractfileid);
            Contractingauthorityparty cap = DocumentsGenerator.crearContractingParty();
            documento.setContractingParty(DocumentsGenerator.crearContractingPartyType(cap));
            String idTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc")[objeto.getIdTipoContrato()][1];
            Code tipoContrato = DocumentsGenerator.crearCode(idTipoContrato, objeto.getTipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc", "2006");
            String idSubTipoContrato = null;
            Code subtipoContrato = null;
            if (idTipoContrato.equalsIgnoreCase("1")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("2")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("3")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("40")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc", "2.05");
            }
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            String idNuts = objeto.getIdNuts();
            Code nuts = DocumentsGenerator.crearCode(idNuts, objeto.getNuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            String idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[objeto.getIdCpv()][1];
            Code cpv = DocumentsGenerator.crearCode(idCPV, objeto.getCpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            BigDecimal importeSin = null;
            BigDecimal importeCon = null;
            BigDecimal valorEstimado = null;
            if (objeto.getImporteSinImpuestos().length() > 0) {
                try {
                    importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getImporteConImpuestos().length() > 0) {
                try {
                    importeCon = new BigDecimal(objeto.getImporteConImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getValorEstimado().length() > 0) {
                try {
                    valorEstimado = new BigDecimal(objeto.getValorEstimado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            CondicionesEjecucionBean duracionContrato = null;
            if (objeto.getCondicionesEjecucion() != null) {
                duracionContrato = objeto.getCondicionesEjecucion();
            }
            documento.setProcurementProject(DocumentsGenerator.crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin, importeCon, valorEstimado, duracionContrato, pais, nuts));
            String idTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][1];
            String nombreTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][0];
            Code codeTipoProcedimiento = DocumentsGenerator.crearCode(idTipoProc, nombreTipoProc, "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc", "2.05");
            String idTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][1];
            String nombreTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][0];
            Code codeTipoTram = DocumentsGenerator.crearCode(idTipoTram, nombreTipoTram, "http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc", "2006");
            String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][1];
            String nombreTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][0];
            Code codeTipoTramGasto = DocumentsGenerator.crearCode(idTipoTramGasto, nombreTipoTramGasto, "http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc", "2006");
            String idFormaPresentacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc")[objeto.getIdFormaPresentacion()][1];
            String nombreFormaPresentacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc")[objeto.getIdFormaPresentacion()][0];
            Code codeFormaPresentacion = DocumentsGenerator.crearCode(idFormaPresentacion, nombreFormaPresentacion, "http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc", "2006");
            Boolean acuerdoCP = objeto.getAcuerdoCP() == 0 ? new Boolean(true) : new Boolean(false);
            documento.setTenderingProcess(DocumentsGenerator.crearTenderingProcess(codeTipoProcedimiento, codeTipoTram, codeTipoTramGasto, codeFormaPresentacion, objeto.getFechaFinOfertas(), objeto.getFechaFinSolicitudes(), DocumentsGenerator.crearEvent(objeto.getEventoApertura()), objeto.getFechaEnvioInvitaciones(), objeto.getJustifProcAcelerado(), objeto.getIndicadorFasesSucesivas(), objeto.getIndicadorSubastaElectronica(), acuerdoCP, objeto, null, null));
            if (objeto.getDescSolvencia() != null | objeto.getDirectivaAplicacion() != null | objeto.getJustifNoPubPliegos() != null | objeto.getCondicionesEjecucion() != null) {
                documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(objeto.getClasificacion(), objeto.getDescSolvencia(), DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(), objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
            } else {
                documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(objeto.getClasificacion(), null, DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(), objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
            }
            Documentreference tdr = new Documentreference();
            Documentreference ldr = new Documentreference();
            tdr.setDocumentidentifier("DOC_PPT");
            tdr.setDocumenttypecode(DocumentsGenerator.crearCode("DOC_PPT", "Documento de Pliego de Prescripciones T\u00e9cnicas", "http://contrataciondelestado.es/codice/cl/2.05/TenderingDocumentTypeCode-2.05.gc", "2.05"));
            ldr.setDocumentidentifier("DOC_PCAP");
            ldr.setDocumenttypecode(DocumentsGenerator.crearCode("DOC_PCAP", "Documento de Pliego de Cl\u00e1usulas Administrativas", "http://contrataciondelestado.es/codice/cl/2.05/TenderingDocumentTypeCode-2.05.gc", "2.05"));
            documento.setTechnicalDocumentReference(DocumentsGenerator.createDocumentReference(tdr, objeto.getUrlPCAP(), null));
            documento.setLegalDocumentReference(DocumentsGenerator.createDocumentReference(ldr, objeto.getUrlPPT(), null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
            ArrayList<ProcurementProjectLotType> listaLotes = DocumentsGenerator.obtenerDatosLotes(objeto);
            for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
                documento.getProcurementProjectLot().add(procurementProjectLotType);
            }
        }
        DocumentsGenerator.insertarInformacionContacto(documento.getTenderingTerms());
        documento.getTenderingTerms().setAppealTerms(DocumentsGenerator.obtenerReceptorRecursos(objeto));
        documento.getTenderingTerms().setTendererQualificationRequest(DocumentsGenerator.obtenerRequisitosSolvencia(objeto, documento.getTenderingTerms().getTendererQualificationRequest()));
        documento.getTenderingTerms().setAwardingTerms(DocumentsGenerator.obtenerCriteriosAdjudiacion(objeto));
        return documento;
    }

    public static ContractAwardNoticeType generateDocumentContractAwardNoticeAdjudicacion(ExpedienteBean objeto, String id, String noticeid) {
        ContractAwardNoticeType documento = null;
        try {
            documento = cs.getCanFactory().createContractAwardNoticeType();
            IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();
            documento.setUBLVersionID(DocumentsGenerator.getUBLVersionID());
            documento.setCustomizationID(DocumentsGenerator.getCustomizationID());
            documento.setProfileID(DocumentsGenerator.getProfileID());
            documento.setID(DocumentsGenerator.getID(id));
            documento.setUUID(DocumentsGenerator.getUUID(id));
            issuedate.setValue(DocumentsGenerator.generatePublishDateXMLGregorianCalendar());
            documento.setIssueDate(issuedate);
            IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
            issuetime.setValue(DocumentsGenerator.generatePublishTimeXMLGregorianCalendar());
            documento.setIssueTime(issuetime);
            ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
            contractfileid.setValue(objeto.getNumExpediente());
            documento.setContractFolderID(contractfileid);
            Contractingauthorityparty cap = DocumentsGenerator.crearContractingParty();
            documento.setContractingParty(DocumentsGenerator.crearContractingPartyType(cap));
            String idTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc")[objeto.getIdTipoContrato()][1];
            Code tipoContrato = DocumentsGenerator.crearCode(idTipoContrato, objeto.getTipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc", "2006");
            String idSubTipoContrato = null;
            Code subtipoContrato = null;
            if (idTipoContrato.equalsIgnoreCase("1")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("2")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("3")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("40")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc", "2.05");
            }
            String idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[objeto.getIdCpv()][1];
            Code cpv = DocumentsGenerator.crearCode(idCPV, objeto.getCpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            BigDecimal importeSin = null;
            BigDecimal importeCon = null;
            BigDecimal valorEstimado = null;
            if (objeto.getImporteSinImpuestos().length() > 0) {
                try {
                    importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getImporteConImpuestos().length() > 0) {
                try {
                    importeCon = new BigDecimal(objeto.getImporteConImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getValorEstimado().length() > 0) {
                try {
                    valorEstimado = new BigDecimal(objeto.getValorEstimado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            String idNuts = objeto.getIdNuts();
            Code nuts = DocumentsGenerator.crearCode(idNuts, objeto.getNuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            CondicionesEjecucionBean duracionContrato = null;
            if (objeto.getCondicionesEjecucion() != null) {
                duracionContrato = objeto.getCondicionesEjecucion();
            }
            documento.setProcurementProject(DocumentsGenerator.crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin, importeCon, valorEstimado, duracionContrato, pais, nuts));
            String idTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][1];
            String nombreTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[objeto.getIdProcContratacion()][0];
            Code codeTipoProcedimiento = DocumentsGenerator.crearCode(idTipoProc, nombreTipoProc, "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc", "2.05");
            String idTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][1];
            String nombreTipoTram = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc")[objeto.getIdTipoTramitacion()][0];
            Code codeTipoTram = DocumentsGenerator.crearCode(idTipoTram, nombreTipoTram, "http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc", "2006");
            String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][1];
            String nombreTipoTramGasto = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc")[objeto.getIdTipoTramitacionGasto()][0];
            Code codeTipoTramGasto = DocumentsGenerator.crearCode(idTipoTramGasto, nombreTipoTramGasto, "http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc", "2006");
            String idFormaPresentacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc")[objeto.getIdFormaPresentacion()][1];
            String nombreFormaPresentacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc")[objeto.getIdFormaPresentacion()][0];
            Code codeFormaPresentacion = DocumentsGenerator.crearCode(idFormaPresentacion, nombreFormaPresentacion, "http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc", "2006");
            Code codeJustificacionATPV = null;
            if (objeto.getIdCodigoJustificacionATPV() >= 0) {
                String idJustificacionATPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/ProcessJustificationReasonCode-2.0.gc")[objeto.getIdCodigoJustificacionATPV()][1];
                codeJustificacionATPV = DocumentsGenerator.crearCode(idJustificacionATPV, objeto.getCodigoJustificacionATPV(), "http://contrataciondelestado.es/codice/cl/2.0/ProcessJustificationReasonCode-2.0.gc", "2.0");
            }
            documento.setTenderingProcess(DocumentsGenerator.crearTenderingProcess(codeTipoProcedimiento, codeTipoTram, codeTipoTramGasto, codeFormaPresentacion, objeto.getFechaFinOfertas(), objeto.getFechaFinSolicitudes(), DocumentsGenerator.crearEvent(objeto.getEventoApertura()), objeto.getFechaEnvioInvitaciones(), objeto.getJustifProcAcelerado(), objeto.getIndicadorFasesSucesivas(), objeto.getIndicadorSubastaElectronica(), null, objeto, codeJustificacionATPV, objeto.getTextoJustificacionATPV()));
            if (objeto.getDescSolvencia() != null | objeto.getDirectivaAplicacion() != null | objeto.getJustifNoPubPliegos() != null | objeto.getCondicionesEjecucion() != null) {
                documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(objeto.getClasificacion(), objeto.getDescSolvencia(), DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(), objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
            } else {
                documento.setTenderingTerms(DocumentsGenerator.crearTenderingTerms(objeto.getClasificacion(), null, DocumentsGenerator.crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(), objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
            }
            documento.getTenderResult().add(DocumentsGenerator.crearTenderResultAdjudicacion(objeto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
            ArrayList<ProcurementProjectLotType> listaLotes = DocumentsGenerator.obtenerDatosLotes(objeto);
            for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
                documento.getProcurementProjectLot().add(procurementProjectLotType);
            }
        }
        documento.getTenderingTerms().setAppealTerms(DocumentsGenerator.obtenerReceptorRecursos(objeto));
        documento.getTenderingTerms().setAwardingTerms(DocumentsGenerator.obtenerCriteriosAdjudiacion(objeto));
        return documento;
    }

    public static ContractAwardNoticeType generateDocumentContractAwardNoticeFormalizacion(ExpedienteBean objeto, String id, String noticeid) {
        ContractAwardNoticeType documento = DocumentsGenerator.generateDocumentContractAwardNoticeAdjudicacion(objeto, id, noticeid);
        documento.getTenderResult().set(0, DocumentsGenerator.crearTenderResultFormalizacion(objeto));
        return documento;
    }

    public static ContractAwardNoticeType generateDocumentContractAwardNoticeRenuncia(ExpedienteBean objeto, String id, String noticeid) {
        ContractAwardNoticeType documento = DocumentsGenerator.generateDocumentContractAwardNoticeAdjudicacion(objeto, id, noticeid);
        NoteType textoAcuerdo = cs.getCbcFactory().createNoteType();
        textoAcuerdo.setValue(objeto.getTextoAcuerdo());
        documento.getNote().add(textoAcuerdo);
        documento.getTenderResult().set(0, DocumentsGenerator.crearTenderResultRenuncia(objeto));
        return documento;
    }

    public static ContractAwardNoticeType generateDocumentContractAwardNoticeMenor(ExpedienteBean objeto, String id, String noticeid) {
        ContractAwardNoticeType documento = null;
        try {
            documento = cs.getCanFactory().createContractAwardNoticeType();
            IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();
            documento.setUBLVersionID(DocumentsGenerator.getUBLVersionID());
            documento.setCustomizationID(DocumentsGenerator.getCustomizationID());
            documento.setProfileID(DocumentsGenerator.getProfileID());
            documento.setID(DocumentsGenerator.getID(id));
            issuedate.setValue(DocumentsGenerator.generatePublishDateXMLGregorianCalendar());
            documento.setIssueDate(issuedate);
            IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
            issuetime.setValue(DocumentsGenerator.generatePublishTimeXMLGregorianCalendar());
            documento.setIssueTime(issuetime);
            ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
            contractfileid.setValue(objeto.getNumExpediente());
            documento.setContractFolderID(contractfileid);
            Contractingauthorityparty cap = DocumentsGenerator.crearContractingParty();
            documento.setContractingParty(DocumentsGenerator.crearContractingPartyType(cap));
            String idTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc")[objeto.getIdTipoContrato()][1];
            Code tipoContrato = DocumentsGenerator.crearCode(idTipoContrato, objeto.getTipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc", "2006");
            String idSubTipoContrato = null;
            Code subtipoContrato = null;
            if (idTipoContrato.equalsIgnoreCase("1")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("2")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("3")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("40")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc", "2.05");
            }
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            String idNuts = objeto.getIdNuts();
            Code nuts = DocumentsGenerator.crearCode(idNuts, objeto.getNuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            BigDecimal importeSin = null;
            BigDecimal importeCon = null;
            Object valorEstimado = null;
            if (objeto.getImporteSinImpuestos().length() > 0) {
                try {
                    importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getImporteConImpuestos().length() > 0) {
                try {
                    importeCon = new BigDecimal(objeto.getImporteConImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            CondicionesEjecucionBean duracionContrato = null;
            if (objeto.getCondicionesEjecucion() != null) {
                duracionContrato = objeto.getCondicionesEjecucion();
            }
            documento.setProcurementProject(DocumentsGenerator.crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), null, importeSin, importeCon, null, duracionContrato, pais, nuts));
            String idTipoProc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[6][1];
            Code codeTipoProcedimiento = DocumentsGenerator.crearCode(idTipoProc, ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc")[6][0], "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc", "2.05");
            documento.setTenderingProcess(DocumentsGenerator.crearTenderingProcess(codeTipoProcedimiento, null, null, null, null, null, null));
            documento.getTenderResult().add(DocumentsGenerator.crearTenderResultMenor(objeto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return documento;
    }

    public static ContractModificationNoticeType generateContractModificaction(ExpedienteBean objeto, String id, String noticeid) {
        ContractModificationNoticeType documento = null;
        try {
            documento = cs.getContractModificationNoticeFactory().createContractModificationNoticeType();
            IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();
            documento.setUBLVersionID(DocumentsGenerator.getUBLVersionID());
            documento.setCustomizationID(DocumentsGenerator.getCustomizationID());
            documento.setProfileID(DocumentsGenerator.getProfileID());
            documento.setID(DocumentsGenerator.getID(id));
            documento.setUUID(DocumentsGenerator.getUUID(id));
            issuedate.setValue(DocumentsGenerator.generatePublishDateXMLGregorianCalendar());
            documento.setIssueDate(issuedate);
            IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
            issuetime.setValue(DocumentsGenerator.generatePublishTimeXMLGregorianCalendar());
            documento.setIssueTime(issuetime);
            ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
            contractfileid.setValue(objeto.getNumExpediente());
            documento.setContractFolderID(contractfileid);
            Contractingauthorityparty cap = DocumentsGenerator.crearContractingParty();
            documento.setContractingParty(DocumentsGenerator.crearContractingPartyType(cap));
            if (objeto.getIdDirectivaAplicacion() > 0) {
                DocumentReferenceType pplegdocref = cs.getCacFactory().createDocumentReferenceType();
                String directiva = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/ProcurementLegislationDocumentReferenceID-2.05.gc")[objeto.getIdDirectivaAplicacion() - 1][1];
                IDType idDocRefDirectiva = cs.getCbcFactory().createIDType();
                idDocRefDirectiva.setValue(directiva);
                pplegdocref.setID(idDocRefDirectiva);
                documento.setProcurementLegislationDocumentReference(pplegdocref);
            }
            String idTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc")[objeto.getIdTipoContrato()][1];
            Code tipoContrato = DocumentsGenerator.crearCode(idTipoContrato, objeto.getTipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc", "2006");
            String idSubTipoContrato = null;
            Code subtipoContrato = null;
            if (idTipoContrato.equalsIgnoreCase("1")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("2")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("3")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc", "2006");
            } else if (idTipoContrato.equalsIgnoreCase("40")) {
                idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc")[objeto.getIdSubtipoContrato()][1];
                subtipoContrato = DocumentsGenerator.crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc", "2.05");
            }
            String idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[objeto.getIdCpv()][1];
            Code cpv = DocumentsGenerator.crearCode(idCPV, objeto.getCpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            BigDecimal importeSin = null;
            BigDecimal importeCon = null;
            BigDecimal valorEstimado = null;
            if (objeto.getImporteSinImpuestos().length() > 0) {
                try {
                    importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getImporteConImpuestos().length() > 0) {
                try {
                    importeCon = new BigDecimal(objeto.getImporteConImpuestos());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (objeto.getValorEstimado().length() > 0) {
                try {
                    valorEstimado = new BigDecimal(objeto.getValorEstimado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[objeto.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, objeto.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            String idNuts = objeto.getIdNuts();
            Code nuts = DocumentsGenerator.crearCode(idNuts, objeto.getNuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            CondicionesEjecucionBean duracionContrato = null;
            if (objeto.getCondicionesEjecucion() != null) {
                duracionContrato = objeto.getCondicionesEjecucion();
            }
            documento.setProcurementProject(DocumentsGenerator.crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin, importeCon, valorEstimado, duracionContrato, pais, nuts));
            documento.getTenderResult().add(DocumentsGenerator.crearTenderResultFormalizacion(objeto));
            DatosModificacionBean datosModificacion = null;
            if (objeto.getDatosModificacion() != null) {
                datosModificacion = objeto.getDatosModificacion();
                documento.getContractModification().add(DocumentsGenerator.crearContractModification(datosModificacion, objeto.getNumContrato()));
            } else {
                documento.getContractModification().add(DocumentsGenerator.crearContractModification(new DatosModificacionBean(), objeto.getNumContrato()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
            ArrayList<ProcurementProjectLotType> listaLotes = DocumentsGenerator.obtenerDatosLotes(objeto);
            for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
                documento.getProcurementProjectLot().add(procurementProjectLotType);
            }
        }
        documento.setAppealTerms(DocumentsGenerator.obtenerReceptorRecursos(objeto));
        return documento;
    }

    public static CancelNoticeRequestType generateCancelNoticeRequest(AnularAnuncioBean objeto, String id, String noticeid) {
        CancelNoticeRequestType documento = null;
        try {
            AgencyIDType agencyID;
            documento = cs.getCancelNoticeFactory().createCancelNoticeRequestType();
            documento.setID(DocumentsGenerator.getID(id));
            PartyIdentificationType partyIdentification = new PartyIdentificationType();
            IDType partyId = new IDType();
            partyId.setValue(objeto.getBuyerProfileId());
            partyId.setSchemeName("ID_PLATAFORMA");
            partyIdentification.setID(partyId);
            documento.setContractingPartyIdentification(partyIdentification);
            NoticeCancellationType noticeCancellation = new NoticeCancellationType();
            if (objeto.getIDRef().length() > 0) {
                IDType idRef = new IDType();
                idRef.setValue(objeto.getIDRef());
                noticeCancellation.setReferencedID(idRef);
            }
            if (objeto.getUUIDRef().length() > 0) {
                UUIDType uuidRef = new UUIDType();
                uuidRef.setValue(objeto.getUUIDRef());
                noticeCancellation.setReferencedUUID(uuidRef);
            }
            if (objeto.getCancellationDescription().length() > 0) {
                DescriptionType description = new DescriptionType();
                description.setValue(objeto.getCancellationDescription());
                noticeCancellation.setDescription(description);
            }
            String idMotivoAnulacion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.02/CancellationReasonCode-2.02.gc")[objeto.getCancellationReasonCodeId()][1];
            Code motivoAnulacion = DocumentsGenerator.crearCode(idMotivoAnulacion, objeto.getCancellationReasonCode(), "http://contrataciondelestado.es/codice/cl/2.02/CancellationReasonCode-2.02.gc", "2.02");
            CancellationReasonCodeType cancellationReasonCode = new CancellationReasonCodeType();
            cancellationReasonCode.setValue(motivoAnulacion.getCodevalue());
            cancellationReasonCode.setLanguageID("es");
            cancellationReasonCode.setListURI(motivoAnulacion.getListUri());
            cancellationReasonCode.setListVersionID(motivoAnulacion.getListVersionId());
            cancellationReasonCode.setName(motivoAnulacion.getDescription());
            noticeCancellation.setCancellationReasonCode(cancellationReasonCode);
            if (objeto.getCancellationDocumentReferencePath().length() > 0) {
                Documentreference canceldr = new Documentreference();
                canceldr.setDocumentidentifier("DOC_ANUL");
                canceldr.setDocumenttypecode(DocumentsGenerator.crearCode("NOTICE_CANCELLATION", "Documento motivo de anulaci\u00f3n", "http://contrataciondelestado.es/codice/cl/2.05/TenderingDocumentTypeCode-2.05.gc", "2.05"));
                DocumentReferenceType canceldrType = DocumentsGenerator.createDocumentReference(canceldr, objeto.getCancellationDocumentReferencePath(), null);
                NoticeCancellationAttachmentDocumentReferenceType notcanceldr = new NoticeCancellationAttachmentDocumentReferenceType();
                notcanceldr.setIssueTime(canceldrType.getIssueTime());
                notcanceldr.setIssueDate(canceldrType.getIssueDate());
                notcanceldr.setID(canceldrType.getID());
                notcanceldr.setDocumentTypeCode(canceldrType.getDocumentTypeCode());
                notcanceldr.setAttachment(canceldrType.getAttachment());
                noticeCancellation.setNoticeCancellationAttachmentDocumentReference(notcanceldr);
            }
            documento.setNoticeCancellation(noticeCancellation);
            if (objeto.isEnviarDOUE()) {
                AdditionalPublicationRequestType addPubReqDOUE = new AdditionalPublicationRequestType();
                agencyID = new AgencyIDType();
                agencyID.setValue("DOUE");
                addPubReqDOUE.setAgencyID(agencyID);
                documento.getAdditionalPublicationRequest().add(addPubReqDOUE);
            }
            if (objeto.isEnviarBOE()) {
                AdditionalPublicationRequestType addPubReqBOE = new AdditionalPublicationRequestType();
                agencyID = new AgencyIDType();
                agencyID.setValue("BOE");
                addPubReqBOE.setAgencyID(agencyID);
                NoteType textoAnulBOE = new NoteType();
                textoAnulBOE.setLanguageID("es");
                textoAnulBOE.setValue(objeto.getTextoAnulacionBOE());
                addPubReqBOE.setNote(textoAnulBOE);
                documento.getAdditionalPublicationRequest().add(addPubReqBOE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return documento;
    }

    public static CancelGeneralContractDocumentRequestType generateCancelGeneralDocumentRequest(AnularDocumentoBean objeto, String id, String noticeid) {
        CancelGeneralContractDocumentRequestType documento = null;
        try {
            documento = cs.getCancelDocumentFactory().createCancelGeneralContractDocumentRequestType();
            documento.setID(DocumentsGenerator.getID(id));
            PartyIdentificationType partyIdentification = new PartyIdentificationType();
            IDType partyId = new IDType();
            partyId.setValue(objeto.getBuyerProfileId());
            partyId.setSchemeName("ID_PLATAFORMA");
            partyIdentification.setID(partyId);
            documento.setContractingPartyIdentification(partyIdentification);
            GeneralDocumentCancellationType docCancel = new GeneralDocumentCancellationType();
            if (objeto.getIDRef().length() > 0) {
                IDType idRef = new IDType();
                idRef.setValue(objeto.getIDRef());
                docCancel.setCancelledDocumentID(idRef);
            }
            if (objeto.getUUIDRef().length() > 0) {
                UUIDType uuidRef = new UUIDType();
                uuidRef.setValue(objeto.getUUIDRef());
                docCancel.setCancelledDocumentUUID(uuidRef);
            }
            if (objeto.getNumExpediente().length() > 0) {
                ContractFolderIDType numexp = new ContractFolderIDType();
                numexp.setValue(objeto.getNumExpediente());
                docCancel.setContractFolderID(numexp);
            }
            documento.setGeneralDocumentCancellation(docCancel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return documento;
    }

    public static String generarDocumentoCODICE(String tipoDocumento) {
        String resultado = "";
        int tipoDoc = TipoDocumento.obtenerTipoDocumento(tipoDocumento);
        SessionDataManager.getInstance();
        ExpedienteBean expediente = SessionDataManager.getExpediente();
        switch (tipoDoc) {
            case 1: {
                PriorInformationNoticeType pin = DocumentsGenerator.generateDocumentPriorInformationNotice(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializePriorInformationNotice(pin);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                ContractNoticeType contractnotice = DocumentsGenerator.generateDocumentContractNotice(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeContractNotice(contractnotice);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(contractnotice);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                CallForTendersType callforTender = DocumentsGenerator.generateDocumentCallForTenders(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeCallForTender(callforTender);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(callforTender);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                ContractAwardNoticeType can = DocumentsGenerator.generateDocumentContractAwardNoticeAdjudicacion(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeContractAwardNotice(can);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(can);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    Documentreference docref = new Documentreference();
                    String idTipoDoc = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.02/GeneralContractDocuments-2.02.gc")[expediente.getIdTypeDoc()][1];
                    Code tipoDocCode = DocumentsGenerator.crearCode(idTipoDoc, expediente.getTypeDoc(), "http://contrataciondelestado.es/codice/cl/2.02/GeneralContractDocuments-2.02.gc", "2.02");
                    docref.setDocumenttypecode(tipoDocCode);
                    DocumentReferenceType dr = DocumentsGenerator.createDocumentReference(docref, expediente.getUrlDocument(), expediente.getNameDocument());
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serialize_DocumentReferenceType(dr);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(dr);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 10: {
                SessionDataManager.getInstance();
                AnularAnuncioBean anularAnuncio = SessionDataManager.getAnularAnuncio();
                CancelNoticeRequestType cancelNotReq = DocumentsGenerator.generateCancelNoticeRequest(anularAnuncio, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeCancelNoticeRequest(cancelNotReq);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 11: {
                SessionDataManager.getInstance();
                AnularDocumentoBean anularDocumento = SessionDataManager.getAnularDocumento();
                CancelGeneralContractDocumentRequestType cancelDocReq = DocumentsGenerator.generateCancelGeneralDocumentRequest(anularDocumento, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeCancelGeneralDocumentRequest(cancelDocReq);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 12: {
                ContractAwardNoticeType form = DocumentsGenerator.generateDocumentContractAwardNoticeFormalizacion(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeContractAwardNotice(form);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(form);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 13: {
                ContractAwardNoticeType ren = DocumentsGenerator.generateDocumentContractAwardNoticeRenuncia(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeContractAwardNotice(ren);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(ren);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 14: {
                ContractAwardNoticeType men = DocumentsGenerator.generateDocumentContractAwardNoticeMenor(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeContractAwardNotice(men);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(men);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 15: {
                ContractModificationNoticeType mod = DocumentsGenerator.generateContractModificaction(expediente, "000001", "000001");
                try {
                    ByteArrayOutputStream docXML = (ByteArrayOutputStream)cs.serializeContractModificactionNotice(mod);
                    System.out.println("Documento serializado correctamente");
                    resultado = docXML.toString("UTF-8");
                    ClienteLlamadas.setDocSerializado(mod);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println("Tipo de documento no reconocido");
            }
        }
        return resultado;
    }

    public static String generarCODICE(String tipoDocumento) throws ClientException {
        String resultado = "";
        int tipoDoc = TipoDocumento.obtenerTipoDocumento(tipoDocumento);
        SessionDataManager.getInstance();
        String rutaFichero = SessionDataManager.getDatosUtilidades().getUrlDoc();
        FileInputStream is = null;
        try {
            File file = new File(rutaFichero);
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        switch (tipoDoc) {
            case 1: {
                try {
                    PriorInformationNoticeType pin = cs.deserializePriorInformationNotice(is);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    ClienteLlamadas.setDocSerializado(pin);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un Anuncio Previo CODICE v\u00e1lido");
                }
            }
            case 2: {
                try {
                    ContractNoticeType contractnotice = cs.deserializeContractNotice(is);
                    ClienteLlamadas.setDocSerializado(contractnotice);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un Anuncio de Licitaci\u00f3n CODICE v\u00e1lido");
                }
            }
            case 3: {
                try {
                    CallForTendersType callforTender = cs.deserializeCallforTenders(is);
                    ClienteLlamadas.setDocSerializado(callforTender);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un documento de Pliegos CODICE v\u00e1lido");
                }
            }
            case 4: {
                try {
                    ContractAwardNoticeType can = cs.deserializeContractAwardNotice(is);
                    ClienteLlamadas.setDocSerializado(can);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un Anuncio de Adjudicaci\u00f3n CODICE v\u00e1lido");
                }
            }
            case 5: {
                try {
                    DocumentReferenceType drt = cs.deserializeDocumentReferenceType(is);
                    ClienteLlamadas.setDocSerializado(drt);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un Documento General CODICE v\u00e1lido");
                }
            }
            case 14: {
                try {
                    ContractAwardNoticeType men = cs.deserializeContractAwardNotice(is);
                    ClienteLlamadas.setDocSerializado(men);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un Anuncio de Adjudicaci\u00f3n CODICE v\u00e1lido");
                }
            }
            case 15: {
                try {
                    ContractModificationNoticeType mod = cs.deserializeContractModificactionNotice(is);
                    ClienteLlamadas.setDocSerializado(mod);
                    ClienteLlamadas.setTipoDocumento(tipoDocumento);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClientException("Error al deserializar el documento CODICE. Este documento no es un Anuncio de Adjudicaci\u00f3n CODICE v\u00e1lido");
                }
            }
            default: {
                System.out.println("Tipo de documento no reconocido");
            }
        }
        return resultado;
    }

    private static AppealTermsType obtenerReceptorRecursos(ExpedienteBean objeto) {
        AppealTermsType appealTermsType = new AppealTermsType();
        if (objeto.getReceptor() != null) {
            ReceptorRecursosBean receptor = objeto.getReceptor();
            appealTermsType.setAppealReceiverParty(new PartyType());
            PartyNameType partyNameType = new PartyNameType();
            NameType nameType = new NameType();
            nameType.setValue(receptor.getEntidad());
            partyNameType.setName(nameType);
            appealTermsType.getAppealReceiverParty().getPartyName().add(partyNameType);
            WebsiteURIType websiteURI = new WebsiteURIType();
            websiteURI.setValue(receptor.getUrl());
            appealTermsType.getAppealReceiverParty().setWebsiteURI(websiteURI);
            AddressType address = new AddressType();
            AddressLineType addresLine = new AddressLineType();
            LineType line = new LineType();
            line.setValue(receptor.getDireccionCalle());
            addresLine.setLine(line);
            address.getAddressLine().add(addresLine);
            PostalZoneType postalZone = new PostalZoneType();
            postalZone.setValue(receptor.getDireccionCP());
            address.setPostalZone(postalZone);
            CityNameType cityName = new CityNameType();
            cityName.setValue(receptor.getDireccionPoblacion());
            address.setCityName(cityName);
            IdentificationCodeType identificationCode = new IdentificationCodeType();
            String idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[receptor.getIdPais()][1];
            Code pais = DocumentsGenerator.crearCode(idPais, receptor.getPais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            identificationCode.setValue(idPais);
            identificationCode.setListURI("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
            identificationCode.setListVersionID("0.3");
            identificationCode.setName(pais.getDescription());
            CountryType countryType = new CountryType();
            countryType.setIdentificationCode(identificationCode);
            NameType name = new NameType();
            name.setValue(pais.getDescription());
            countryType.setName(name);
            address.setCountry(countryType);
            appealTermsType.getAppealReceiverParty().setPostalAddress(address);
        }
        return appealTermsType;
    }

    private static ArrayList<ProcurementProjectLotType> obtenerDatosLotes(ExpedienteBean expediente) {
        Code nuts;
        String idNuts;
        Code pais;
        String idPais;
        CountrySubentityCodeType countrySubentityCodeType;
        LocationType locationType;
        CommodityClassificationType commodityClassificationType;
        ItemClassificationCodeType itemClassificationCodeType;
        Code cpv;
        String idCPV;
        TaxExclusiveAmountType taxExclusiveAmountType;
        TotalAmountType totalAmountType;
        BudgetAmountType budgetAmountType;
        NameType nameType;
        ProcurementProjectType procurementProjectType;
        IDType idType;
        ProcurementProjectLotType procurementProjectLotType;
        ArrayList<ProcurementProjectLotType> listaLotes = new ArrayList<ProcurementProjectLotType>();
        if (expediente.getLotes().getLote1Descripcion() != null && expediente.getLotes().getLote1Descripcion().length() > 0) {
            procurementProjectLotType = new ProcurementProjectLotType();
            idType = new IDType();
            idType.setValue("1");
            idType.setSchemeName("ID_LOTE");
            procurementProjectLotType.setID(idType);
            procurementProjectType = new ProcurementProjectType();
            procurementProjectType.setID(idType);
            nameType = new NameType();
            nameType.setValue(expediente.getLotes().getLote1Descripcion());
            procurementProjectType.getName().add(nameType);
            budgetAmountType = new BudgetAmountType();
            totalAmountType = new TotalAmountType();
            totalAmountType.setValue(new BigDecimal(expediente.getLotes().getLote1ImporteConImpuestos()));
            totalAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
            taxExclusiveAmountType = new TaxExclusiveAmountType();
            taxExclusiveAmountType.setValue(new BigDecimal(expediente.getLotes().getLote1ImporteSinImpuestos()));
            taxExclusiveAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
            budgetAmountType.setTotalAmount(totalAmountType);
            budgetAmountType.setTaxExclusiveAmount(taxExclusiveAmountType);
            procurementProjectType.setBudgetAmount(budgetAmountType);
            idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[expediente.getLotes().getLote1IdCpv()][1];
            cpv = DocumentsGenerator.crearCode(idCPV, expediente.getLotes().getLote1Cpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            itemClassificationCodeType = new ItemClassificationCodeType();
            itemClassificationCodeType.setValue(idCPV);
            itemClassificationCodeType.setListURI(cpv.getListUri());
            itemClassificationCodeType.setListVersionID(cpv.getListVersionId());
            itemClassificationCodeType.setName(cpv.getDescription());
            commodityClassificationType = new CommodityClassificationType();
            commodityClassificationType.setItemClassificationCode(itemClassificationCodeType);
            procurementProjectType.getRequiredCommodityClassification().add(commodityClassificationType);
            locationType = new LocationType();
            countrySubentityCodeType = new CountrySubentityCodeType();
            idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[expediente.getLotes().getLote1IdPais()][1];
            pais = DocumentsGenerator.crearCode(idPais, expediente.getLotes().getLote1Pais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            idNuts = expediente.getLotes().getLote1IdNuts();
            nuts = DocumentsGenerator.crearCode(idNuts, expediente.getLotes().getLote1Nuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            countrySubentityCodeType.setValue(idNuts);
            countrySubentityCodeType.setListURI(nuts.getListUri());
            countrySubentityCodeType.setListVersionID(nuts.getListVersionId());
            countrySubentityCodeType.setName(nuts.getDescription());
            locationType.setCountrySubentityCode(countrySubentityCodeType);
            AddressType addressType = new AddressType();
            CountryType countryType = new CountryType();
            IdentificationCodeType identificationCodeType = new IdentificationCodeType();
            identificationCodeType.setValue(idPais);
            identificationCodeType.setListURI(pais.getListUri());
            identificationCodeType.setListVersionID(pais.getListVersionId());
            identificationCodeType.setName(pais.getDescription());
            itemClassificationCodeType.setListName("CPV");
            countryType.setIdentificationCode(identificationCodeType);
            addressType.setCountry(countryType);
            locationType.setAddress(addressType);
            procurementProjectType.setRealizedLocation(locationType);
            procurementProjectLotType.setProcurementProject(procurementProjectType);
            listaLotes.add(procurementProjectLotType);
        }
        if (expediente.getLotes().getLote2Descripcion() != null && expediente.getLotes().getLote2Descripcion().length() > 0) {
            procurementProjectLotType = new ProcurementProjectLotType();
            idType = new IDType();
            idType.setValue("2");
            idType.setSchemeName("ID_LOTE");
            procurementProjectLotType.setID(idType);
            procurementProjectType = new ProcurementProjectType();
            procurementProjectType.setID(idType);
            nameType = new NameType();
            nameType.setValue(expediente.getLotes().getLote2Descripcion());
            procurementProjectType.getName().add(nameType);
            budgetAmountType = new BudgetAmountType();
            totalAmountType = new TotalAmountType();
            totalAmountType.setValue(new BigDecimal(expediente.getLotes().getLote2ImporteConImpuestos()));
            totalAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
            taxExclusiveAmountType = new TaxExclusiveAmountType();
            taxExclusiveAmountType.setValue(new BigDecimal(expediente.getLotes().getLote2ImporteSinImpuestos()));
            taxExclusiveAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
            budgetAmountType.setTotalAmount(totalAmountType);
            budgetAmountType.setTaxExclusiveAmount(taxExclusiveAmountType);
            procurementProjectType.setBudgetAmount(budgetAmountType);
            idCPV = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc")[expediente.getLotes().getLote2IdCpv()][1];
            cpv = DocumentsGenerator.crearCode(idCPV, expediente.getLotes().getLote2Cpv(), "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc", "2.04");
            itemClassificationCodeType = new ItemClassificationCodeType();
            itemClassificationCodeType.setValue(idCPV);
            itemClassificationCodeType.setListURI(cpv.getListUri());
            itemClassificationCodeType.setListVersionID(cpv.getListVersionId());
            itemClassificationCodeType.setName(cpv.getDescription());
            itemClassificationCodeType.setListName("CPV");
            commodityClassificationType = new CommodityClassificationType();
            commodityClassificationType.setItemClassificationCode(itemClassificationCodeType);
            procurementProjectType.getRequiredCommodityClassification().add(commodityClassificationType);
            locationType = new LocationType();
            countrySubentityCodeType = new CountrySubentityCodeType();
            idPais = ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[expediente.getLotes().getLote2IdPais()][1];
            pais = DocumentsGenerator.crearCode(idPais, expediente.getLotes().getLote2Pais(), "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc", "0.3");
            idNuts = expediente.getLotes().getLote2IdNuts();
            nuts = DocumentsGenerator.crearCode(idNuts, expediente.getLotes().getLote2Nuts(), "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc", "2009");
            countrySubentityCodeType.setValue(idNuts);
            countrySubentityCodeType.setListURI(nuts.getListUri());
            countrySubentityCodeType.setListVersionID(nuts.getListVersionId());
            countrySubentityCodeType.setName(nuts.getDescription());
            locationType.setCountrySubentityCode(countrySubentityCodeType);
            CountrySubentityType countrySubentityType = new CountrySubentityType();
            countrySubentityType.setValue(nuts.getDescription());
            locationType.setCountrySubentity(countrySubentityType);
            AddressType addressType = new AddressType();
            CountryType countryType = new CountryType();
            IdentificationCodeType identificationCodeType = new IdentificationCodeType();
            identificationCodeType.setValue(idPais);
            identificationCodeType.setListURI(pais.getListUri());
            identificationCodeType.setListVersionID(pais.getListVersionId());
            identificationCodeType.setName(pais.getDescription());
            countryType.setIdentificationCode(identificationCodeType);
            addressType.setCountry(countryType);
            locationType.setAddress(addressType);
            procurementProjectType.setRealizedLocation(locationType);
            procurementProjectLotType.setProcurementProject(procurementProjectType);
            listaLotes.add(procurementProjectLotType);
        }
        return listaLotes;
    }

    private static TendererQualificationRequestType obtenerRequisitosSolvencia(ExpedienteBean objeto, TendererQualificationRequestType tendererQualificationRequestType) {
        RequisitosParticipacionBean requisitos = objeto.getRequisitosParticipacion();
        if (tendererQualificationRequestType == null) {
            tendererQualificationRequestType = new TendererQualificationRequestType();
        }
        if (requisitos != null) {
            DescriptionType descriptionType;
            EvaluationCriteriaTypeCodeType evaluationCriteriaTypeCodeType;
            Code criterio;
            String idCriterio;
            EvaluationCriteriaType evaluationCriteriaType;
            if (requisitos.getIdSolvenciaTecnica1() >= 0) {
                evaluationCriteriaType = new EvaluationCriteriaType();
                idCriterio = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/TechnicalCapabilityTypeCode-2.0.gc")[requisitos.getIdSolvenciaTecnica1()][1];
                criterio = DocumentsGenerator.crearCode(idCriterio, requisitos.getSolvenciaTecnica1(), "http://contrataciondelestado.es/codice/cl/2.0/TechnicalCapabilityTypeCode-2.0.gc", "2.0");
                evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
                evaluationCriteriaTypeCodeType.setValue(idCriterio);
                evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
                evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
                evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
                evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(requisitos.getDescSolvenciaTecnica1());
                evaluationCriteriaType.getDescription().add(descriptionType);
                tendererQualificationRequestType.getTechnicalEvaluationCriteria().add(evaluationCriteriaType);
            }
            if (requisitos.getIdSolvenciaTecnica2() >= 0) {
                evaluationCriteriaType = new EvaluationCriteriaType();
                idCriterio = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/TechnicalCapabilityTypeCode-2.0.gc")[requisitos.getIdSolvenciaTecnica2()][1];
                criterio = DocumentsGenerator.crearCode(idCriterio, requisitos.getSolvenciaTecnica2(), "http://contrataciondelestado.es/codice/cl/2.0/TechnicalCapabilityTypeCode-2.0.gc", "2.0");
                evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
                evaluationCriteriaTypeCodeType.setValue(idCriterio);
                evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
                evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
                evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
                evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(requisitos.getDescSolvenciaTecnica2());
                evaluationCriteriaType.getDescription().add(descriptionType);
                tendererQualificationRequestType.getTechnicalEvaluationCriteria().add(evaluationCriteriaType);
            }
            if (requisitos.getIdSolvenciaEconomica1() >= 0) {
                evaluationCriteriaType = new EvaluationCriteriaType();
                idCriterio = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/FinancialCapabilityTypeCode-2.0.gc")[requisitos.getIdSolvenciaEconomica1()][1];
                criterio = DocumentsGenerator.crearCode(idCriterio, requisitos.getSolvenciaEconomica1(), "http://contrataciondelestado.es/codice/cl/2.0/FinancialCapabilityTypeCode-2.0.gc", "2.0");
                evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
                evaluationCriteriaTypeCodeType.setValue(idCriterio);
                evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
                evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
                evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
                evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(requisitos.getDescSolvenciaEconomica1());
                evaluationCriteriaType.getDescription().add(descriptionType);
                tendererQualificationRequestType.getFinancialEvaluationCriteria().add(evaluationCriteriaType);
            }
            if (requisitos.getIdSolvenciaEconomica2() >= 0) {
                evaluationCriteriaType = new EvaluationCriteriaType();
                idCriterio = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/FinancialCapabilityTypeCode-2.0.gc")[requisitos.getIdSolvenciaEconomica2()][1];
                criterio = DocumentsGenerator.crearCode(idCriterio, requisitos.getSolvenciaEconomica2(), "http://contrataciondelestado.es/codice/cl/2.0/FinancialCapabilityTypeCode-2.0.gc", "2.0");
                evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
                evaluationCriteriaTypeCodeType.setValue(idCriterio);
                evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
                evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
                evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
                evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(requisitos.getDescSolvenciaEconomica2());
                evaluationCriteriaType.getDescription().add(descriptionType);
                tendererQualificationRequestType.getFinancialEvaluationCriteria().add(evaluationCriteriaType);
            }
            if (requisitos.isCapacidadObrar()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(0));
            }
            if (requisitos.isNoProhibicionContratar()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(1));
            }
            if (requisitos.isNoIncompatibilidades()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(2));
            }
            if (requisitos.isCumplimientoObligacionesSS()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(3));
            }
            if (requisitos.isCumplimientoObligacionesTributarias()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(4));
            }
            if (requisitos.isNoAdjudicatarioAnterioridad()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(5));
            }
            if (requisitos.isPreregistroROLECE()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(6));
            }
            if (requisitos.isEmpresasExtranjeras()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(7));
            }
            if (requisitos.isReservadoCentrosEspeciales()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(8));
            }
            if (requisitos.isReservadorProgramasEmpleo()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(9));
            }
            if (requisitos.isDeclaracionTrabajadoresDiscapacidad()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(10));
            }
            if (requisitos.isDeclaracionPromocionLaboral()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(11));
            }
            if (requisitos.isReservadoProfesion()) {
                tendererQualificationRequestType.getSpecificTendererRequirement().add(DocumentsGenerator.crearCondicionContratar(12));
            }
        }
        return tendererQualificationRequestType;
    }

    private static TendererRequirementType crearCondicionContratar(int indice) {
        String idCondicion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/DeclarationTypeCode-2.0.gc")[indice][1];
        String nombreCondicion = ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/DeclarationTypeCode-2.0.gc")[indice][0];
        String listURL = "http://contrataciondelestado.es/codice/cl/2.0/DeclarationTypeCode-2.0.gc";
        String versionList = "2.0";
        TendererRequirementType tendererRequirementType = new TendererRequirementType();
        RequirementTypeCodeType requirementTypeCodeType = new RequirementTypeCodeType();
        requirementTypeCodeType.setValue(idCondicion);
        requirementTypeCodeType.setListURI(listURL);
        requirementTypeCodeType.setListVersionID(versionList);
        requirementTypeCodeType.setName(nombreCondicion);
        tendererRequirementType.setRequirementTypeCode(requirementTypeCodeType);
        return tendererRequirementType;
    }

    private static AwardingTermsType obtenerCriteriosAdjudiacion(ExpedienteBean expediente) {
        CristeriosAdjudicacionBean criterios = expediente.getCriteriosAdjudicacion();
        AwardingTermsType awardingTermsType = new AwardingTermsType();
        if (criterios != null) {
            WeightNumericType weightNumericType;
            AwardingCriteriaSubTypeCodeType awardingCriteriaSubTypeCodeType;
            DescriptionType descriptionType;
            AwardingCriteriaTypeCodeType awardingCriteriaTypeCodeType;
            IDType idType;
            AwardingCriteriaType awardingCriteriaType;
            if (criterios.getAutomaticoPrecioDescripcion() != null && criterios.getAutomaticoPrecioDescripcion().length() > 0) {
                awardingCriteriaType = new AwardingCriteriaType();
                idType = new IDType();
                idType.setValue("9001");
                awardingCriteriaType.setID(idType);
                awardingCriteriaTypeCodeType = new AwardingCriteriaTypeCodeType();
                awardingCriteriaTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc")[0][1]);
                awardingCriteriaTypeCodeType.setListURI("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc");
                awardingCriteriaTypeCodeType.setListVersionID("2.0");
                awardingCriteriaTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc")[0][0]);
                awardingCriteriaType.setAwardingCriteriaTypeCode(awardingCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(criterios.getAutomaticoPrecioDescripcion());
                awardingCriteriaType.getDescription().add(descriptionType);
                awardingCriteriaSubTypeCodeType = new AwardingCriteriaSubTypeCodeType();
                awardingCriteriaSubTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc")[0][1]);
                awardingCriteriaSubTypeCodeType.setListURI("http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc");
                awardingCriteriaSubTypeCodeType.setListVersionID("2.05");
                awardingCriteriaSubTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc")[0][0]);
                awardingCriteriaType.setAwardingCriteriaSubTypeCode(awardingCriteriaSubTypeCodeType);
                weightNumericType = new WeightNumericType();
                weightNumericType.setValue(new BigDecimal(criterios.getAutomaticoPrecioPonderacion()));
                awardingCriteriaType.setWeightNumeric(weightNumericType);
                awardingTermsType.getAwardingCriteria().add(awardingCriteriaType);
            }
            if (criterios.getAutomaticoOtrosDescripcion() != null && criterios.getAutomaticoOtrosDescripcion().length() > 0) {
                awardingCriteriaType = new AwardingCriteriaType();
                idType = new IDType();
                idType.setValue("9002");
                awardingCriteriaType.setID(idType);
                awardingCriteriaTypeCodeType = new AwardingCriteriaTypeCodeType();
                awardingCriteriaTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc")[0][1]);
                awardingCriteriaTypeCodeType.setListURI("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc");
                awardingCriteriaTypeCodeType.setListVersionID("2.0");
                awardingCriteriaTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc")[0][0]);
                awardingCriteriaType.setAwardingCriteriaTypeCode(awardingCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(criterios.getAutomaticoOtrosDescripcion());
                awardingCriteriaType.getDescription().add(descriptionType);
                awardingCriteriaSubTypeCodeType = new AwardingCriteriaSubTypeCodeType();
                awardingCriteriaSubTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc")[1][1]);
                awardingCriteriaSubTypeCodeType.setListURI("http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc");
                awardingCriteriaSubTypeCodeType.setListVersionID("2.05");
                awardingCriteriaSubTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc")[1][0]);
                awardingCriteriaType.setAwardingCriteriaSubTypeCode(awardingCriteriaSubTypeCodeType);
                weightNumericType = new WeightNumericType();
                weightNumericType.setValue(new BigDecimal(criterios.getAutomaticoOtrosPonderacion()));
                awardingCriteriaType.setWeightNumeric(weightNumericType);
                awardingTermsType.getAwardingCriteria().add(awardingCriteriaType);
            }
            if (criterios.getJuicioDescripcion() != null && criterios.getJuicioDescripcion().length() > 0) {
                awardingCriteriaType = new AwardingCriteriaType();
                idType = new IDType();
                idType.setValue("9003");
                awardingCriteriaType.setID(idType);
                awardingCriteriaTypeCodeType = new AwardingCriteriaTypeCodeType();
                awardingCriteriaTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc")[1][1]);
                awardingCriteriaTypeCodeType.setListURI("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc");
                awardingCriteriaTypeCodeType.setListVersionID("2.0");
                awardingCriteriaTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant("http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc")[1][0]);
                awardingCriteriaType.setAwardingCriteriaTypeCode(awardingCriteriaTypeCodeType);
                descriptionType = new DescriptionType();
                descriptionType.setValue(criterios.getJuicioDescripcion());
                awardingCriteriaType.getDescription().add(descriptionType);
                WeightNumericType weightNumericType2 = new WeightNumericType();
                weightNumericType2.setValue(new BigDecimal(criterios.getJuicioPonderacion()));
                awardingCriteriaType.setWeightNumeric(weightNumericType2);
                awardingTermsType.getAwardingCriteria().add(awardingCriteriaType);
            }
        }
        return awardingTermsType;
    }

    private static void insertarInformacionContacto(TenderingTermsType tenderingTerms) {
        Contractingauthorityparty datosOC = DocumentsGenerator.crearContractingParty();
        PartyType party = cs.getCacFactory().createPartyType();
        PartyNameType name = cs.getCacFactory().createPartyNameType();
        NameType namet = cs.getCbcFactory().createNameType();
        namet.setValue(datosOC.getPartyname());
        name.setName(namet);
        party.getPartyName().add(name);
        party = DocumentsGenerator.anyadeDireccionContactosPartyOC(party, datosOC);
        tenderingTerms.setAdditionalInformationParty(party);
        tenderingTerms.setDocumentProviderParty(party);
        tenderingTerms.setTenderRecipientParty(party);
    }
}

