/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows;

import es.contrataciondelestado.b2b.publicacion.Publication;
import es.contrataciondelestado.b2b.publicacion.Publications;
import es.dgpe.place.client.beans.ConsultaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.PublicacionesOficialesBean;
import es.dgpe.place.client.beans.UtilidadesBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ClienteLlamadas;
import es.dgpe.place.client.utils.CommonUtilities;
import es.dgpe.place.client.utils.SessionDataManager;
import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;
import org.w3c.dom.Node;

public class WebServiceCODICEForm
extends ThemeJFrame {
    private static String pagina = Acciones.INIT_WEB_SERVICE;
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelCodiceGenerado = null;
    private JTextArea jTextAreaMensajeEnviado = null;
    JScrollPane AreaMensajeEnviado = null;
    private JButton jButtonEnviarDatos = null;
    JFrame[] gestorVentanasGenCodice = new JFrame[2];
    private String tipoDocumento = "";
    private JScrollPane AreaMensajeRecibido = null;
    private JTextArea jTextAreaMensajeRespuesta = null;
    private JLabel jLabelMensajeRecibido = null;
    private JButton jButtonGuardarDatosEnviados = null;
    private JButton jButtonGuardarDatosRecibidos = null;
    final JFileChooser fc = new JFileChooser();
    private String mensajeEnviado = null;
    private String mensajeRecibido = null;

    public void setJButtonGuardarDatosEnviados(JButton buttonGuardarDatosEnviados) {
        this.jButtonGuardarDatosEnviados = buttonGuardarDatosEnviados;
    }

    public void setJButtonGuardarDatosRecibidos(JButton buttonGuardarDatosRecibidos) {
        this.jButtonGuardarDatosRecibidos = buttonGuardarDatosRecibidos;
    }

    public static String getPagina() {
        return pagina;
    }

    public static void setPagina(String pagina) {
        WebServiceCODICEForm.pagina = pagina;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public WebServiceCODICEForm(JFrame ventanaPadre, String tipoDocumento) throws ModelException {
        this.initialize();
        this.gestorVentanasGenCodice[0] = ventanaPadre;
        this.setTipoDocumento(tipoDocumento);
        ClienteLlamadas.setTipoDocumento(tipoDocumento);
        this.setHasButtonPrev(true);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        this.jButtonEnviarDatos.addActionListener(this);
        this.jButtonGuardarDatosEnviados.addActionListener(this);
        this.jButtonGuardarDatosRecibidos.addActionListener(this);
    }

    public WebServiceCODICEForm(JFrame ventanaPadre, String tipoDocumento, ClientException e) throws ModelException {
        this.initialize();
        this.gestorVentanasGenCodice[0] = ventanaPadre;
        this.setTipoDocumento(tipoDocumento);
        ClienteLlamadas.setTipoDocumento(tipoDocumento);
        this.setHasButtonPrev(true);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        this.jButtonEnviarDatos.setEnabled(false);
        this.jButtonGuardarDatosEnviados.setEnabled(false);
        this.jButtonGuardarDatosRecibidos.setEnabled(false);
        if (e != null) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            e.printStackTrace(printWriter);
            this.jTextAreaMensajeEnviado.setText("Se ha producido un error: Por favor revise la excepci\u00f3n\n" + ((Object)result).toString());
        }
    }

    private void initialize() {
        this.setBackground(Color.white);
        this.getJPanelContenido();
        this.setTitle("Env\u00edo de datos");
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jLabelMensajeRecibido = new JLabel();
            this.jLabelMensajeRecibido.setBounds(new Rectangle(35, 334, 149, 16));
            this.jLabelMensajeRecibido.setText("Mensaje recibido: ");
            this.jLabelCodiceGenerado = new JLabel();
            this.jLabelCodiceGenerado.setText("Mensaje a enviar/enviado: ");
            this.jLabelCodiceGenerado.setSize(new Dimension(250, 20));
            this.jLabelCodiceGenerado.setLocation(new Point(33, 88));
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.add((Component)this.jLabelCodiceGenerado, null);
            this.jPanelContenido.add((Component)this.getJButtonEnviarDatos(), null);
            this.jPanelContenido.add((Component)this.getJButtonGuardarDatosRecibidos(), null);
            this.jPanelContenido.add((Component)this.getJButtonGuardarDatosEnviados(), null);
            this.AreaMensajeEnviado = new JScrollPane(this.getJTextAreaCODICE());
            this.AreaMensajeEnviado.setVerticalScrollBarPolicy(22);
            this.AreaMensajeEnviado.setSize(new Dimension(this.getWidth() - 100, 164));
            this.AreaMensajeEnviado.setPreferredSize(new Dimension(this.getWidth() - 100, 300));
            this.AreaMensajeEnviado.setLocation(new Point(34, 119));
            this.jPanelContenido.add((Component)this.AreaMensajeEnviado, null);
            this.jPanelContenido.add((Component)this.getAreaMensajeRecibido(), null);
            this.jPanelContenido.add((Component)this.jLabelMensajeRecibido, null);
        }
        return this.jPanelContenido;
    }

    public JButton getJButtonGuardarDatosRecibidos() {
        if (this.jButtonGuardarDatosRecibidos == null) {
            this.jButtonGuardarDatosRecibidos = new JButton();
            this.jButtonGuardarDatosRecibidos.setLocation(new Point(super.getWidth() - 250, super.getHeight() - 100));
            this.jButtonGuardarDatosRecibidos.setText("Guardar mensaje recibido...");
            this.jButtonGuardarDatosRecibidos.setSize(new Dimension(200, 30));
            this.jButtonGuardarDatosRecibidos.setActionCommand(Acciones.SAVE_RESPONSE);
        }
        return this.jButtonGuardarDatosRecibidos;
    }

    public JButton getJButtonGuardarDatosEnviados() {
        if (this.jButtonGuardarDatosEnviados == null) {
            this.jButtonGuardarDatosEnviados = new JButton();
            this.jButtonGuardarDatosEnviados.setLocation(new Point(super.getWidth() - 500, super.getHeight() - 100));
            this.jButtonGuardarDatosEnviados.setText("Guardar mensaje enviado...");
            this.jButtonGuardarDatosEnviados.setSize(new Dimension(200, 30));
            this.jButtonGuardarDatosEnviados.setActionCommand(Acciones.SAVE_REQUEST);
        }
        return this.jButtonGuardarDatosEnviados;
    }

    public JTextArea getJTextAreaCODICE() {
        if (this.jTextAreaMensajeEnviado == null) {
            this.jTextAreaMensajeEnviado = new JTextArea();
            this.jTextAreaMensajeEnviado.setLocation(new Point(60, 90));
            this.jTextAreaMensajeEnviado.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jTextAreaMensajeEnviado.setColumns(10);
            this.jTextAreaMensajeEnviado.setName("jTextAreaMensajeEnviado");
            this.jTextAreaMensajeEnviado.setText("");
            this.jTextAreaMensajeEnviado.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.jTextAreaMensajeEnviado.setSize(new Dimension(this.getWidth() - 100, 300));
            this.jTextAreaMensajeEnviado.setEditable(false);
            this.jTextAreaMensajeEnviado.setAutoscrolls(true);
            this.jTextAreaMensajeEnviado.setLineWrap(true);
            this.jTextAreaMensajeEnviado.setWrapStyleWord(true);
            this.jTextAreaMensajeEnviado.setLineWrap(false);
            this.jTextAreaMensajeEnviado.setWrapStyleWord(false);
            this.jTextAreaMensajeEnviado.setRows(20);
        }
        return this.jTextAreaMensajeEnviado;
    }

    private JButton getJButtonEnviarDatos() {
        if (this.jButtonEnviarDatos == null) {
            this.jButtonEnviarDatos = new JButton();
            this.jButtonEnviarDatos.setLocation(new Point(292, 306));
            this.jButtonEnviarDatos.setText("Enviar datos");
            this.jButtonEnviarDatos.setSize(new Dimension(200, 25));
            this.jButtonEnviarDatos.setActionCommand(Acciones.INIT_COMM);
        }
        return this.jButtonEnviarDatos;
    }

    public JTextArea getJTextAreaMensajeRespuesta() {
        if (this.jTextAreaMensajeRespuesta == null) {
            this.jTextAreaMensajeRespuesta = new JTextArea();
            this.jTextAreaMensajeRespuesta.setLocation(new Point(60, 90));
            this.jTextAreaMensajeRespuesta.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jTextAreaMensajeRespuesta.setName("jTextAreaCODICE");
            this.jTextAreaMensajeRespuesta.setAutoscrolls(true);
            this.jTextAreaMensajeRespuesta.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.jTextAreaMensajeRespuesta.setText("");
            this.jTextAreaMensajeRespuesta.setEditable(false);
            this.jTextAreaMensajeRespuesta.setColumns(10);
            this.jTextAreaMensajeRespuesta.setRows(20);
            this.jTextAreaMensajeRespuesta.setLineWrap(true);
            this.jTextAreaMensajeRespuesta.setWrapStyleWord(true);
            this.jTextAreaMensajeRespuesta.setWrapStyleWord(false);
            this.jTextAreaMensajeRespuesta.setLineWrap(false);
            this.jTextAreaMensajeRespuesta.setSize(new Dimension(700, 300));
        }
        return this.jTextAreaMensajeRespuesta;
    }

    private JScrollPane getAreaMensajeRecibido() {
        if (this.AreaMensajeRecibido == null) {
            this.AreaMensajeRecibido = new JScrollPane(this.getJTextAreaMensajeRespuesta());
            this.AreaMensajeRecibido.setVerticalScrollBarPolicy(22);
            this.AreaMensajeRecibido.setLocation(new Point(34, 357));
            this.AreaMensajeRecibido.setSize(new Dimension(this.getWidth() - 100, 164));
            this.AreaMensajeRecibido.setPreferredSize(new Dimension(this.getWidth() - 100, 300));
        }
        return this.AreaMensajeRecibido;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_COMM)) {
            this.realizarLlamadaWebService(ClienteLlamadas.getTipoDocumento());
            StringWriter stringWriterEnviado = new StringWriter();
            StringWriter stringWriterRecibido = new StringWriter();
            StreamResult xmlOutEnviado = new StreamResult(stringWriterEnviado);
            StreamResult xmlOutRecibido = new StreamResult(stringWriterRecibido);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource((Node)ClienteLlamadas.getMensajeEnviado().getSOAPPart()), xmlOutEnviado);
                transformer.transform(new DOMSource((Node)ClienteLlamadas.getMensajeRecibido().getSOAPPart()), xmlOutRecibido);
            }
            catch (TransformerConfigurationException e1) {
                e1.printStackTrace();
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
            this.jTextAreaMensajeEnviado.setText(xmlOutEnviado.getWriter().toString());
            this.mensajeEnviado = new String(xmlOutEnviado.getWriter().toString());
            this.jTextAreaMensajeRespuesta.setText(xmlOutRecibido.getWriter().toString());
            this.mensajeRecibido = new String(xmlOutRecibido.getWriter().toString());
        } else if (e.getActionCommand().equalsIgnoreCase(Acciones.SAVE_REQUEST)) {
            int returnVal = this.fc.showSaveDialog(this.jButtonGuardarDatosEnviados);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    writer.write(this.mensajeEnviado);
                    ((Writer)writer).close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase(Acciones.SAVE_RESPONSE)) {
            int returnVal = this.fc.showSaveDialog(this.jButtonGuardarDatosEnviados);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    writer.write(this.mensajeRecibido);
                    ((Writer)writer).close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
            this.gestorVentanasGenCodice[0].setVisible(true);
            this.setVisible(false);
        }
    }

    public void realizarLlamadaWebService(String tipoDocumento) {
        int tipoDoc = TipoDocumento.obtenerTipoDocumento(tipoDocumento);
        SessionDataManager.getInstance();
        Publications pubs = this.obtenerPublicacionesOficiales(SessionDataManager.getExpediente().getDiarios());
        switch (tipoDoc) {
            case 1: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarPIN((PriorInformationNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarCN((ContractNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarCD((CallForTendersType)ClienteLlamadas.getDocSerializado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarCAN((ContractAwardNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    SessionDataManager.getInstance();
                    ExpedienteBean exp = SessionDataManager.getExpediente();
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarDOCGEN(String.valueOf(System.currentTimeMillis()), exp.getNumExpediente(), exp.getBuyerProfileId(), (DocumentReferenceType)ClienteLlamadas.getDocSerializado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                try {
                    SessionDataManager.getInstance();
                    ConsultaBean consultaExp = SessionDataManager.getDatosConsulta();
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarConsultaExp(consultaExp.getExpedientNumber(), consultaExp.getBuyerProfileId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 7: {
                try {
                    SessionDataManager.getInstance();
                    ConsultaBean consultaExp = SessionDataManager.getDatosConsulta();
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarConsultaBuyerProfile(consultaExp.getBuyerProfileId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    SessionDataManager.getInstance();
                    UtilidadesBean utilidades = SessionDataManager.getDatosUtilidades();
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarUtilidadValidacion(TipoDocumento.obtenerTipoDocumento(utilidades.getTipoDoc()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 9: {
                try {
                    SessionDataManager.getInstance();
                    UtilidadesBean utilidades = SessionDataManager.getDatosUtilidades();
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarUtilidadPrevisualizacion(TipoDocumento.obtenerTipoDocumento(utilidades.getTipoDoc()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 10: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarAnulacionAnuncio((CancelNoticeRequestType)ClienteLlamadas.getDocSerializado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 11: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarAnulacionDocumento((CancelGeneralContractDocumentRequestType)ClienteLlamadas.getDocSerializado());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 12: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarCAN((ContractAwardNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 13: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarCAN((ContractAwardNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 14: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarCAN((ContractAwardNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 15: {
                try {
                    ClienteLlamadas client = new ClienteLlamadas();
                    client.llamarModifiacionAnuncio((ContractModificationNoticeType)ClienteLlamadas.getDocSerializado(), pubs);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Publications obtenerPublicacionesOficiales(PublicacionesOficialesBean diarios) {
        Publications pubs = new Publications();
        Publication BOE = new Publication();
        Publication DOUE = new Publication();
        Publication Otros = new Publication();
        BOE.setPublishAgency("BOE");
        Otros.setPublishAgency("Others");
        if (diarios != null) {
            if (diarios.isEnviarBOE()) {
                BOE.setPublish(false);
                pubs.getPublication().add(BOE);
            } else if (diarios.isYaPublicadoBOE()) {
                BOE.setPublish(true);
                BOE.setPublishDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaPubBOE()));
                pubs.getPublication().add(BOE);
            }
            if (diarios.isEnviarDOUE()) {
                DOUE.setPublish(false);
                if (diarios.getTipoAnuncioDOUE() == "ATPV") {
                    DOUE.setPublishAgency("DOUE-ATPV");
                } else {
                    DOUE.setPublishAgency("DOUE");
                }
                pubs.getPublication().add(DOUE);
            } else if (diarios.isYaEnviadoDOUE()) {
                DOUE.setPublish(true);
                DOUE.setPublishAgency("DOUE");
                DOUE.setPublishDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaPubDOUE()));
                DOUE.setSendDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaEnvioDOUE()));
                pubs.getPublication().add(DOUE);
            }
            if (diarios.getNombreOtrosDiarios() != null && !diarios.getNombreOtrosDiarios().equalsIgnoreCase("") && diarios.getFechaPubOtrosDiarios() != null) {
                Otros.setPublish(true);
                Otros.setPublishAgency(diarios.getNombreOtrosDiarios());
                Otros.setPublishDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaPubOtrosDiarios()));
                pubs.getPublication().add(Otros);
            }
        }
        return pubs;
    }
}

