/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.PublicacionesOficialesForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AnuncioPrevioForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelExpediente = null;
    private JTextField jTextFieldExpediente = null;
    private JLabel jLabelTipoContrato = null;
    private JLabel jLabelSubTipoContrato = null;
    private JLabel jLabelObjetoContrato = null;
    private JLabel jLabelProcContratacion = null;
    private JLabel jLabelTipoTramitaci\u00f3n = null;
    private JLabel jLabelTramitacionGasto = null;
    private JLabel jLabelFechaPrevAdj = null;
    private JLabel jLabelSelCPV = null;
    private JLabel jLabelCodigoCPV = null;
    private JComboBox<String> jComboBoxDirectiva = null;
    private JComboBox jComboBoxTipoContrato = null;
    private JComboBox jComboBoxSubtipoContrato = null;
    private JComboBox jComboBoxProcContratacion = null;
    private JComboBox jComboBoxSistemaContratacio = null;
    private JTextField jTextFieldObjetoContrato = null;
    private JComboBox jComboBoxCPV = null;
    private JLabel jLabelAnuncioPrevio = null;
    private JTextField jTextFieldFechaInicioProcAdj = null;
    private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;
    JFrame[] gestorVentanasFormPIN = new JFrame[4];
    ExpedienteBean expediente = new ExpedienteBean();
    private JLabel jLabelImporteSin = null;
    private JLabel jLabelImporteCon = null;
    private JTextField jTextFieldImporteCon = null;
    private JTextField jTextFieldImporteSin = null;
    private JButton jButtonPubOff = null;
    private JButton jButtonReceptorRecursos = null;
    private JLabel lblValorEstimadoDel;
    private JTextField jTextFieldValorEstimado;

    public ExpedienteBean getExpediente() {
        if (this.expediente == null) {
            this.expediente = new ExpedienteBean();
        }
        this.expediente.setDirectivaAplicacion((String)this.jComboBoxDirectiva.getSelectedItem());
        this.expediente.setIdDirectivaAplicacion(this.jComboBoxDirectiva.getSelectedIndex());
        this.expediente.setNumExpediente(this.jTextFieldExpediente.getText());
        this.expediente.setTipoContrato((String)this.jComboBoxTipoContrato.getSelectedItem());
        this.expediente.setIdTipoContrato(this.jComboBoxTipoContrato.getSelectedIndex());
        this.expediente.setSubtipoContrato((String)this.jComboBoxSubtipoContrato.getSelectedItem());
        this.expediente.setIdSubtipoContrato(this.jComboBoxSubtipoContrato.getSelectedIndex());
        this.expediente.setObjetoContrato(this.jTextFieldObjetoContrato.getText());
        this.expediente.setProcContratacion((String)this.jComboBoxProcContratacion.getSelectedItem());
        this.expediente.setIdProcContratacion(this.jComboBoxProcContratacion.getSelectedIndex());
        this.expediente.setPais((String)this.jComboBoxPais.getSelectedItem());
        this.expediente.setIdPais(this.jComboBoxPais.getSelectedIndex());
        if (this.jComboBoxNuts.getSelectedIndex() > -1) {
            String nutsSeleccionado = (String)this.jComboBoxNuts.getSelectedItem();
            this.expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(") - 1));
            this.expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(") + 1, nutsSeleccionado.length() - 1));
        }
        Date fechaPrevIniProcAdj = null;
        if (this.jTextFieldFechaInicioProcAdj.getText().length() > 0) {
            try {
                fechaPrevIniProcAdj = new SimpleDateFormat("dd-MM-yyyy").parse(this.jTextFieldFechaInicioProcAdj.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha prevista de inicio del procedimiento");
            }
        }
        this.expediente.setFechaPrevIniProcAdj(fechaPrevIniProcAdj);
        this.expediente.setCpv((String)this.jComboBoxCPV.getSelectedItem());
        this.expediente.setIdCpv(this.jComboBoxCPV.getSelectedIndex());
        this.expediente.setImporteSinImpuestos(this.jTextFieldImporteSin.getText());
        this.expediente.setImporteConImpuestos(this.jTextFieldImporteCon.getText());
        this.expediente.setValorEstimado(this.jTextFieldValorEstimado.getText());
        SessionDataManager.getInstance();
        SessionDataManager.setExpediente(this.expediente);
        return this.expediente;
    }

    public void setExpediente(ExpedienteBean expediente) {
        this.expediente = expediente;
    }

    public void cargarDatosComboBoxs() {
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxTipoContrato, "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxProcContratacion, "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc");
        this.jComboBoxProcContratacion.setSelectedIndex(1);
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxCPV, "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxPais, "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
        this.jComboBoxDirectiva.addItem("No sujeto a regulacion armonizada");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxDirectiva, "http://contrataciondelestado.es/codice/cl/2.05/ProcurementLegislationDocumentReferenceID-2.05.gc");
    }

    public AnuncioPrevioForm(JFrame ventanaPadre) throws ModelException {
        this.initialize();
        this.cargarDatosComboBoxs();
        this.gestorVentanasFormPIN[0] = ventanaPadre;
        this.gestorVentanasFormPIN[1] = null;
        this.setHasButtonNext(true);
        this.setHasButtonPrev(true);
        if (this.isHasButtonNext()) {
            this.jPanelContenido.add((Component)this.getJButtonSiguiente(), null);
            this.getJButtonSiguiente().addActionListener(this);
        }
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        this.jButtonPubOff.addActionListener(this);
        this.jButtonReceptorRecursos.addActionListener(this);
        ventanaPadre.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AnuncioPrevioForm.this.escribeDatosExpediente();
            }
        });
        if (SessionDataManager.getExpediente() != null) {
            this.expediente = SessionDataManager.getExpediente();
            this.escribeDatosExpediente();
        }
    }

    private void escribeDatosExpediente() {
        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
        this.jComboBoxDirectiva.setSelectedIndex(this.expediente.getIdDirectivaAplicacion());
        this.jTextFieldExpediente.setText(this.expediente.getNumExpediente());
        this.jComboBoxTipoContrato.setSelectedIndex(this.expediente.getIdTipoContrato());
        this.jComboBoxSubtipoContrato.setSelectedIndex(this.expediente.getIdSubtipoContrato());
        this.jTextFieldObjetoContrato.setText(this.expediente.getObjetoContrato());
        this.jComboBoxProcContratacion.setSelectedIndex(this.expediente.getIdProcContratacion());
        if (this.expediente.getFechaPrevIniProcAdj() != null) {
            this.jTextFieldFechaInicioProcAdj.setText(df.format(this.expediente.getFechaPrevIniProcAdj()));
        }
        this.jTextFieldValorEstimado.setText(this.expediente.getValorEstimado());
        this.jTextFieldImporteSin.setText(this.expediente.getImporteSinImpuestos());
        this.jTextFieldImporteCon.setText(this.expediente.getImporteConImpuestos());
        this.jComboBoxCPV.setSelectedIndex(this.expediente.getIdCpv());
        this.jComboBoxPais.setSelectedIndex(this.expediente.getIdPais());
        this.jComboBoxNuts.setSelectedItem(String.valueOf(this.expediente.getNuts()) + " (" + this.expediente.getIdNuts() + ")");
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Servicio de Publicaci\u00f3n - Anuncio Previo");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jLabelProcContratacion = new JLabel();
            this.jLabelProcContratacion.setText("Procedimiento Contrataci\u00f3n:");
            this.jLabelProcContratacion.setSize(new Dimension(250, 18));
            this.jLabelProcContratacion.setLocation(new Point(60, 276));
            this.jLabelObjetoContrato = new JLabel();
            this.jLabelObjetoContrato.setText("Objeto del contrato:");
            this.jLabelObjetoContrato.setLocation(new Point(60, 246));
            this.jLabelObjetoContrato.setSize(new Dimension(250, 18));
            this.jLabelSubTipoContrato = new JLabel();
            this.jLabelSubTipoContrato.setText("Subtipo de contrato:");
            this.jLabelSubTipoContrato.setSize(new Dimension(250, 18));
            this.jLabelSubTipoContrato.setLocation(new Point(60, 216));
            this.jLabelTipoContrato = new JLabel();
            this.jLabelTipoContrato.setText("Tipo de contrato:");
            this.jLabelTipoContrato.setLocation(new Point(60, 186));
            this.jLabelTipoContrato.setSize(new Dimension(250, 18));
            this.jLabelExpediente = new JLabel();
            this.jLabelExpediente.setText("Expediente:");
            this.jLabelExpediente.setLocation(new Point(60, 156));
            this.jLabelExpediente.setSize(new Dimension(250, 18));
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.add((Component)this.jLabelExpediente, null);
            this.jPanelContenido.add((Component)this.getJTextFieldExpediente(), null);
            this.jPanelContenido.add((Component)this.jLabelTipoContrato, null);
            this.jPanelContenido.add((Component)this.getJComboBoxTipoContrato(), null);
            this.jPanelContenido.add((Component)this.jLabelSubTipoContrato, null);
            this.jPanelContenido.add((Component)this.jLabelObjetoContrato, null);
            this.jPanelContenido.add((Component)this.jLabelProcContratacion, null);
            this.jPanelContenido.add((Component)this.getJComboBoxSubtipoContrato(), null);
            this.jPanelContenido.add((Component)this.getJComboBoxProcContratacion(), null);
            this.jPanelContenido.add((Component)this.getJTextFieldObjetoContrato(), null);
            this.jPanelContenido.add((Component)this.getJButtonPubOff(), null);
            this.getPanel().add(this.getSeleccionCPV());
            this.getPanel().add(this.getCodigoCVP());
            this.getPanel().add(this.getJComboBoxCPV());
            this.jLabelImporteSin = new JLabel();
            this.jLabelImporteSin.setBounds(56, 393, 246, 16);
            this.getPanel().add(this.jLabelImporteSin);
            this.jLabelImporteSin.setText("Importe Base (Sin impuestos)");
            this.jLabelImporteSin.setPreferredSize(new Dimension(246, 16));
            this.jLabelImporteCon = new JLabel();
            this.jLabelImporteCon.setBounds(56, 423, 246, 16);
            this.getPanel().add(this.jLabelImporteCon);
            this.jLabelImporteCon.setText("Importe Base (Con impuestos)");
            this.jLabelImporteCon.setPreferredSize(new Dimension(246, 16));
            this.getPanel().add(this.getJTextFieldImporteCon());
            this.getPanel().add(this.getJTextFieldImporteSin());
            this.getPanel().add(this.getLblValorEstimadoDel());
            this.getPanel().add(this.getJTextFieldValorEstimado());
            this.getPanel().add(this.getJComboBoxNuts());
            this.getPanel().add(this.getJComboBoxPais());
            this.getPanel().add(this.getLblLugarDeEjecucin());
            this.jComboBoxTipoContrato.addItemListener(new ComboListener(this.jComboBoxTipoContrato, this.jComboBoxSubtipoContrato));
            this.jComboBoxPais.addItemListener(new ComboListenerCountry(this.jComboBoxPais, this.jComboBoxNuts));
            this.jLabelAnuncioPrevio = new JLabel();
            this.jLabelAnuncioPrevio.setBounds(33, 75, 250, 18);
            this.getPanel().add(this.jLabelAnuncioPrevio);
            this.jLabelAnuncioPrevio.setFont(new Font("Dialog", 1, 18));
            this.jLabelAnuncioPrevio.setText("Anuncio Previo");
            JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00f3n");
            lblDirectivaDeAplicacin.setBounds(56, 120, 178, 14);
            this.getPanel().add(lblDirectivaDeAplicacin);
            this.getPanel().add(this.getLabelFechaAdj());
            this.getPanel().add(this.getFechaInicioProcAdj());
            this.getPanel().add(this.getJButtonReceptorRecuros());
            this.jPanelContenido.add((Component)this.getJComboBoxDirectiva(), null);
        }
        return this.jPanelContenido;
    }

    private JComboBox getJComboBoxDirectiva() {
        if (this.jComboBoxDirectiva == null) {
            this.jComboBoxDirectiva = new JComboBox();
            this.jComboBoxDirectiva.setBounds(326, 117, 378, 20);
        }
        return this.jComboBoxDirectiva;
    }

    private JLabel getLabelFechaAdj() {
        if (this.jLabelFechaPrevAdj == null) {
            this.jLabelFechaPrevAdj = new JLabel();
            this.jLabelFechaPrevAdj.setBounds(56, 318, 250, 18);
            this.jLabelFechaPrevAdj.setText("Fecha prevista inicio del procedimiento:");
        }
        return this.jLabelFechaPrevAdj;
    }

    private JLabel getSeleccionCPV() {
        if (this.jLabelSelCPV == null) {
            this.jLabelSelCPV = new JLabel();
            this.jLabelSelCPV.setBounds(56, 453, 250, 18);
            this.jLabelSelCPV.setText("Selecci\u00f3n del CPV");
        }
        return this.jLabelSelCPV;
    }

    private JLabel getCodigoCVP() {
        if (this.jLabelCodigoCPV == null) {
            this.jLabelCodigoCPV = new JLabel();
            this.jLabelCodigoCPV.setBounds(86, 483, 220, 18);
            this.jLabelCodigoCPV.setText("C\u00f3digo CPV");
        }
        return this.jLabelCodigoCPV;
    }

    private JComboBox getJComboBoxCPV() {
        if (this.jComboBoxCPV == null) {
            this.jComboBoxCPV = new JComboBox();
            this.jComboBoxCPV.setBounds(326, 483, 493, 18);
        }
        return this.jComboBoxCPV;
    }

    private JTextField getFechaInicioProcAdj() {
        if (this.jTextFieldFechaInicioProcAdj == null) {
            this.jTextFieldFechaInicioProcAdj = new JTextField();
            this.jTextFieldFechaInicioProcAdj.setBounds(328, 318, 210, 18);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            this.jTextFieldFechaInicioProcAdj.setText(dateFormat.format(new Date()));
        }
        return this.jTextFieldFechaInicioProcAdj;
    }

    private JTextField getJTextFieldExpediente() {
        if (this.jTextFieldExpediente == null) {
            this.jTextFieldExpediente = new JTextField();
            this.jTextFieldExpediente.setSize(new Dimension(210, 18));
            this.jTextFieldExpediente.setLocation(new Point(330, 157));
        }
        return this.jTextFieldExpediente;
    }

    private JComboBox getJComboBoxTipoContrato() {
        if (this.jComboBoxTipoContrato == null) {
            this.jComboBoxTipoContrato = new JComboBox();
            this.jComboBoxTipoContrato.setLocation(new Point(330, 186));
            this.jComboBoxTipoContrato.setSize(new Dimension(210, 18));
        }
        return this.jComboBoxTipoContrato;
    }

    private JComboBox getJComboBoxSubtipoContrato() {
        if (this.jComboBoxSubtipoContrato == null) {
            this.jComboBoxSubtipoContrato = new JComboBox();
            this.jComboBoxSubtipoContrato.setLocation(new Point(330, 216));
            this.jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
        }
        return this.jComboBoxSubtipoContrato;
    }

    private JComboBox getJComboBoxProcContratacion() {
        if (this.jComboBoxProcContratacion == null) {
            this.jComboBoxProcContratacion = new JComboBox();
            this.jComboBoxProcContratacion.setLocation(new Point(330, 276));
            this.jComboBoxProcContratacion.setSize(new Dimension(210, 18));
        }
        return this.jComboBoxProcContratacion;
    }

    private JTextField getJTextFieldObjetoContrato() {
        if (this.jTextFieldObjetoContrato == null) {
            this.jTextFieldObjetoContrato = new JTextField();
            this.jTextFieldObjetoContrato.setLocation(new Point(330, 246));
            this.jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
        }
        return this.jTextFieldObjetoContrato;
    }

    private JTextField getJTextFieldImporteCon() {
        if (this.jTextFieldImporteCon == null) {
            this.jTextFieldImporteCon = new JTextField();
            this.jTextFieldImporteCon.setBounds(326, 423, 210, 18);
            this.jTextFieldImporteCon.setPreferredSize(new Dimension(210, 18));
        }
        return this.jTextFieldImporteCon;
    }

    private JTextField getJTextFieldImporteSin() {
        if (this.jTextFieldImporteSin == null) {
            this.jTextFieldImporteSin = new JTextField();
            this.jTextFieldImporteSin.setBounds(326, 393, 210, 18);
            this.jTextFieldImporteSin.setPreferredSize(new Dimension(210, 18));
        }
        return this.jTextFieldImporteSin;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(this.getExpediente());
            if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
                if (this.gestorVentanasFormPIN[1] == null) {
                    this.setVisible(false);
                    this.gestorVentanasFormPIN[1] = new GeneracionCODICEForm(this, "DOC_PIN");
                    this.gestorVentanasFormPIN[1].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormPIN[1].setVisible(true);
                }
            }
            if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_OFFICIAL_PUB)) {
                if (this.gestorVentanasFormPIN[2] == null) {
                    this.setVisible(false);
                    this.gestorVentanasFormPIN[2] = new PublicacionesOficialesForm(this, "DOC_PIN");
                    this.gestorVentanasFormPIN[2].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormPIN[2].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
                if (this.gestorVentanasFormPIN[3] == null) {
                    this.setVisible(false);
                    this.gestorVentanasFormPIN[3] = new ReceptorRecurosForm(this, "DOC_PIN");
                    this.gestorVentanasFormPIN[3].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormPIN[3].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
                this.setVisible(false);
                this.gestorVentanasFormPIN[0].setVisible(true);
            }
        }
        catch (ModelException e1) {
            e1.printStackTrace();
        }
    }

    private JButton getJButtonPubOff() {
        if (this.jButtonPubOff == null) {
            this.jButtonPubOff = new JButton();
            this.jButtonPubOff.setText("Publicaciones oficiales");
            this.jButtonPubOff.setLocation(new Point(56, 600));
            this.jButtonPubOff.setSize(new Dimension(180, 18));
            this.jButtonPubOff.setActionCommand(Acciones.INIT_OFFICIAL_PUB);
        }
        return this.jButtonPubOff;
    }

    private JButton getJButtonReceptorRecuros() {
        if (this.jButtonReceptorRecursos == null) {
            this.jButtonReceptorRecursos = new JButton();
            this.jButtonReceptorRecursos.setBounds(261, 600, 180, 18);
            this.jButtonReceptorRecursos.setText("Receptor de recursos");
            this.jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
        }
        return this.jButtonReceptorRecursos;
    }

    private JLabel getLblValorEstimadoDel() {
        if (this.lblValorEstimadoDel == null) {
            this.lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
            this.lblValorEstimadoDel.setBounds(58, 368, 210, 14);
        }
        return this.lblValorEstimadoDel;
    }

    private JTextField getJTextFieldValorEstimado() {
        if (this.jTextFieldValorEstimado == null) {
            this.jTextFieldValorEstimado = new JTextField();
            this.jTextFieldValorEstimado.setBounds(326, 365, 210, 20);
            this.jTextFieldValorEstimado.setColumns(10);
        }
        return this.jTextFieldValorEstimado;
    }

    private JComboBox getJComboBoxPais() {
        if (this.jComboBoxPais == null) {
            this.jComboBoxPais = new JComboBox();
            this.jComboBoxPais.setBounds(69, 550, 243, 18);
        }
        return this.jComboBoxPais;
    }

    private JComboBox getJComboBoxNuts() {
        if (this.jComboBoxNuts == null) {
            this.jComboBoxNuts = new JComboBox();
            this.jComboBoxNuts.setBounds(359, 550, 243, 18);
        }
        return this.jComboBoxNuts;
    }

    private JLabel getLblLugarDeEjecucin() {
        if (this.lblLugarDeEjecucin == null) {
            this.lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00f3n");
            this.lblLugarDeEjecucin.setBounds(56, 525, 230, 14);
        }
        return this.lblLugarDeEjecucin;
    }
}

