/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;
import es.dgpe.place.client.windows.publication.service.commons.CriteriosAdjudicacionForm;
import es.dgpe.place.client.windows.publication.service.commons.LotesForm;
import es.dgpe.place.client.windows.publication.service.commons.PublicacionesOficialesForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AnuncioRenunciaForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelExpediente = null;
    private JTextField jTextFieldExpediente = null;
    private JLabel jLabelTipoContrato = null;
    private JLabel jLabelSubTipoContrato = null;
    private JLabel jLabelObjetoContrato = null;
    private JLabel jLabelProcContratacion = null;
    private JLabel jLabelTipoTramitaci\u00f3n = null;
    private JLabel jLabelTramitacionGasto = null;
    private JLabel jLabelFechaPrevAdj = null;
    private JLabel jLabelSelCPV = null;
    private JLabel jLabelCodigoCPV = null;
    private JComboBox jComboBoxTipoContrato = null;
    private JComboBox jComboBoxSubtipoContrato = null;
    private JComboBox jComboBoxProcContratacion = null;
    private JComboBox jComboBoxTipoTramitacion = null;
    private JComboBox jComboBoxTramitacionGasto = null;
    private JComboBox<String> jComboBoxDirectiva = null;
    private JTextField jTextFieldObjetoContrato = null;
    private JComboBox jComboBoxCPV = null;
    private JLabel jLabelAnuncioLicitacion = null;
    private JLabel jLabelImporteSin = null;
    private JButton jButtonDuracionContrato = null;
    private JButton jButtonLotes;
    private JButton jButtonDiariosOficiales = null;
    private JLabel jLabelImporteCon = null;
    private JLabel jLabelClasificacion = null;
    private JLabel jLabelDescSolvencias = null;
    private JComboBox jComboBoxClasificacion = null;
    private JTextArea jTextAreaDescSolvencias = null;
    private JTextField jTextFieldImporteSin = null;
    private JTextField jTextFieldImporteCon = null;
    final JFileChooser fc = new JFileChooser();
    private JLabel lblValorEstimadoDel;
    private JTextField jTextFieldValorEstimado;
    private JTextArea textAreaAcuerdo;
    private JButton jButtonCriteriosAdjudicacion;
    private JButton jButtonReceptorRecursos = null;
    JFrame[] gestorVentanasFormCD = new JFrame[7];
    ExpedienteBean expediente = new ExpedienteBean();
    private JLabel lblNewLabel;
    private JRadioButton rdbtnDesierto = null;
    private JRadioButton rdbtnRenuncia = null;
    private JRadioButton rdbtnDesistimiento = null;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JTextField textFieldFechaAcuerdo = null;
    private JLabel lblNmeroDeOfertas;
    private JTextField jTextFieldNumOfertasRecibidas;
    private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;

    public ExpedienteBean getExpediente() {
        if (this.expediente == null) {
            this.expediente = new ExpedienteBean();
        }
        this.expediente.setDirectivaAplicacion((String)this.jComboBoxDirectiva.getSelectedItem());
        this.expediente.setIdDirectivaAplicacion(this.jComboBoxDirectiva.getSelectedIndex());
        this.expediente.setNumExpediente(this.jTextFieldExpediente.getText());
        this.expediente.setTipoContrato((String)this.jComboBoxTipoContrato.getSelectedItem());
        this.expediente.setIdTipoContrato(this.jComboBoxTipoContrato.getSelectedIndex());
        this.expediente.setSubtipoContrato((String)this.jComboBoxSubtipoContrato.getSelectedItem());
        this.expediente.setIdSubtipoContrato(this.jComboBoxSubtipoContrato.getSelectedIndex());
        this.expediente.setObjetoContrato(this.jTextFieldObjetoContrato.getText());
        this.expediente.setProcContratacion((String)this.jComboBoxProcContratacion.getSelectedItem());
        this.expediente.setIdProcContratacion(this.jComboBoxProcContratacion.getSelectedIndex());
        this.expediente.setTipoTramitacion((String)this.jComboBoxTipoTramitacion.getSelectedItem());
        this.expediente.setIdTipoTramitacion(this.jComboBoxTipoTramitacion.getSelectedIndex());
        this.expediente.setTipoTramitacionGasto((String)this.jComboBoxTramitacionGasto.getSelectedItem());
        this.expediente.setIdTipoTramitacionGasto(this.jComboBoxTramitacionGasto.getSelectedIndex());
        this.expediente.setCpv((String)this.jComboBoxCPV.getSelectedItem());
        this.expediente.setIdCpv(this.jComboBoxCPV.getSelectedIndex());
        this.expediente.setPais((String)this.jComboBoxPais.getSelectedItem());
        this.expediente.setIdPais(this.jComboBoxPais.getSelectedIndex());
        String nutsSeleccionado = (String)this.jComboBoxNuts.getSelectedItem();
        this.expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(") - 1));
        this.expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(") + 1, nutsSeleccionado.length() - 1));
        this.expediente.setClasificacion(this.jComboBoxClasificacion.getSelectedIndex());
        this.expediente.setDescSolvencia(this.jTextAreaDescSolvencias.getText());
        this.expediente.setImporteSinImpuestos(this.jTextFieldImporteSin.getText());
        this.expediente.setImporteConImpuestos(this.jTextFieldImporteCon.getText());
        this.expediente.setValorEstimado(this.jTextFieldValorEstimado.getText());
        if (this.rdbtnDesierto.isSelected()) {
            this.expediente.setTipoResolucion("DESIERTO");
        }
        if (this.rdbtnRenuncia.isSelected()) {
            this.expediente.setTipoResolucion("RENUNCIA");
        }
        if (this.rdbtnDesistimiento.isSelected()) {
            this.expediente.setTipoResolucion("DESISTIMIENTO");
        }
        this.expediente.setTextoAcuerdo(this.textAreaAcuerdo.getText());
        Date fechaAcuerdo = null;
        if (this.textFieldFechaAcuerdo.getText().length() > 0) {
            try {
                fechaAcuerdo = new SimpleDateFormat("dd-MM-yyyy").parse(this.textFieldFechaAcuerdo.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha del acuerd");
            }
        }
        this.expediente.setFechaAcuerdo(fechaAcuerdo);
        if (!this.jTextFieldNumOfertasRecibidas.getText().isEmpty()) {
            this.expediente.setNumOfertasRecibidas(Integer.parseInt(this.jTextFieldNumOfertasRecibidas.getText()));
        }
        SessionDataManager.getInstance();
        SessionDataManager.setExpediente(this.expediente);
        return this.expediente;
    }

    public void setAnuncioRenuncia(ExpedienteBean exp) {
        this.expediente = exp;
    }

    public void cargarDatosComboBoxs() {
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxTipoContrato, "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxProcContratacion, "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc");
        this.jComboBoxProcContratacion.setSelectedIndex(1);
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxTipoTramitacion, "http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxTramitacionGasto, "http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc");
        ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(this.jComboBoxClasificacion, "urn:dgpe:names:specification:codice:codelist:gc:RequiredBusinessProfileCode-2.05");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxCPV, "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxPais, "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
        this.jComboBoxDirectiva.addItem("No sujeto a regulacion armonizada");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxDirectiva, "http://contrataciondelestado.es/codice/cl/2.05/ProcurementLegislationDocumentReferenceID-2.05.gc");
    }

    public AnuncioRenunciaForm(JFrame ventanaPadre) throws ModelException {
        this.initialize();
        this.cargarDatosComboBoxs();
        this.gestorVentanasFormCD[0] = ventanaPadre;
        this.gestorVentanasFormCD[1] = null;
        this.jButtonDuracionContrato.addActionListener(this);
        this.jButtonLotes.addActionListener(this);
        this.jButtonCriteriosAdjudicacion.addActionListener(this);
        this.jButtonReceptorRecursos.addActionListener(this);
        this.setHasButtonNext(true);
        this.setHasButtonPrev(true);
        if (this.isHasButtonNext()) {
            this.jPanelContenido.add((Component)this.getJButtonSiguiente(), null);
            this.getJButtonSiguiente().addActionListener(this);
        }
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        if (SessionDataManager.getExpediente() != null) {
            this.expediente = SessionDataManager.getExpediente();
            this.escribeDatosExpediente();
        }
        ventanaPadre.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AnuncioRenunciaForm.this.escribeDatosExpediente();
            }
        });
    }

    private void escribeDatosExpediente() {
        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
        this.jComboBoxDirectiva.setSelectedIndex(this.expediente.getIdDirectivaAplicacion());
        this.jTextFieldExpediente.setText(this.expediente.getNumExpediente());
        this.jComboBoxTipoContrato.setSelectedIndex(this.expediente.getIdTipoContrato());
        this.jComboBoxSubtipoContrato.setSelectedIndex(this.expediente.getIdSubtipoContrato());
        this.jTextFieldObjetoContrato.setText(this.expediente.getObjetoContrato());
        this.jComboBoxProcContratacion.setSelectedIndex(this.expediente.getIdProcContratacion());
        this.jComboBoxTipoTramitacion.setSelectedIndex(this.expediente.getIdTipoTramitacion());
        this.jComboBoxTramitacionGasto.setSelectedIndex(this.expediente.getIdTipoTramitacionGasto());
        this.jTextFieldValorEstimado.setText(this.expediente.getValorEstimado());
        this.jTextFieldImporteSin.setText(this.expediente.getImporteSinImpuestos());
        this.jTextFieldImporteCon.setText(this.expediente.getImporteConImpuestos());
        this.jComboBoxCPV.setSelectedIndex(this.expediente.getIdCpv());
        this.jComboBoxClasificacion.setSelectedIndex(this.expediente.getClasificacion());
        this.jTextAreaDescSolvencias.setText(this.expediente.getDescSolvencia());
        this.jComboBoxPais.setSelectedIndex(this.expediente.getIdPais());
        this.jComboBoxNuts.setSelectedItem(String.valueOf(this.expediente.getNuts()) + " (" + this.expediente.getIdNuts() + ")");
        this.rdbtnDesierto.setSelected(false);
        this.rdbtnRenuncia.setSelected(false);
        this.rdbtnDesistimiento.setSelected(false);
        if (this.expediente.getTipoResolucion() != null) {
            if (this.expediente.getTipoResolucion().equals("DESIERTO")) {
                this.rdbtnDesierto.setSelected(true);
            } else if (this.expediente.getTipoResolucion().equals("RENUNCIA")) {
                this.rdbtnRenuncia.setSelected(true);
            } else {
                this.rdbtnDesistimiento.setSelected(true);
            }
        }
        this.textAreaAcuerdo.setText(this.expediente.getTextoAcuerdo());
        if (this.expediente.getFechaAcuerdo() != null) {
            this.textFieldFechaAcuerdo.setText(df.format(this.expediente.getFechaAcuerdo()));
        }
        if (this.expediente.getNumOfertasRecibidas() != null) {
            this.jTextFieldNumOfertasRecibidas.setText(this.expediente.getNumOfertasRecibidas().toString());
        }
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Servicio de Publicaci\u00f3n - Anuncio de Desierto, Renuncia, Desistimiento");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jLabelAnuncioLicitacion = new JLabel();
            this.jLabelAnuncioLicitacion.setFont(new Font("Dialog", 1, 18));
            this.jLabelAnuncioLicitacion.setLocation(new Point(17, 77));
            this.jLabelAnuncioLicitacion.setSize(new Dimension(461, 18));
            this.jLabelAnuncioLicitacion.setText("Anuncio de Renuncia, Desierto, Desistimiento");
            this.jLabelTramitacionGasto = new JLabel();
            this.jLabelTramitacionGasto.setText("Tramitaci\u00f3n Gasto:");
            this.jLabelTramitacionGasto.setSize(new Dimension(250, 18));
            this.jLabelTramitacionGasto.setLocation(new Point(63, 279));
            this.jLabelTipoTramitaci\u00f3n = new JLabel();
            this.jLabelTipoTramitaci\u00f3n.setText("Tipo  Tramitaci\u00f3n:");
            this.jLabelTipoTramitaci\u00f3n.setSize(new Dimension(250, 18));
            this.jLabelTipoTramitaci\u00f3n.setLocation(new Point(63, 254));
            this.jLabelProcContratacion = new JLabel();
            this.jLabelProcContratacion.setText("Procedimiento Contrataci\u00f3n:");
            this.jLabelProcContratacion.setSize(new Dimension(250, 18));
            this.jLabelProcContratacion.setLocation(new Point(63, 234));
            this.jLabelObjetoContrato = new JLabel();
            this.jLabelObjetoContrato.setText("Objeto del contrato:");
            this.jLabelObjetoContrato.setLocation(new Point(63, 209));
            this.jLabelObjetoContrato.setSize(new Dimension(250, 18));
            this.jLabelSubTipoContrato = new JLabel();
            this.jLabelSubTipoContrato.setText("Subtipo de contrato:");
            this.jLabelSubTipoContrato.setSize(new Dimension(250, 18));
            this.jLabelSubTipoContrato.setLocation(new Point(63, 184));
            this.jLabelTipoContrato = new JLabel();
            this.jLabelTipoContrato.setText("Tipo de contrato:");
            this.jLabelTipoContrato.setLocation(new Point(63, 159));
            this.jLabelTipoContrato.setSize(new Dimension(250, 18));
            this.jLabelExpediente = new JLabel();
            this.jLabelExpediente.setText("Expediente:");
            this.jLabelExpediente.setLocation(new Point(62, 134));
            this.jLabelExpediente.setSize(new Dimension(250, 18));
            this.getPanel().add(this.getJButtonCriteriosAdjudicacion());
            this.getPanel().add(this.getJButtonDiariosOficiales());
            this.jButtonDiariosOficiales.addActionListener(this);
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.add((Component)this.jLabelExpediente, null);
            this.jPanelContenido.add((Component)this.getJTextFieldExpediente(), null);
            this.jPanelContenido.add((Component)this.jLabelTipoContrato, null);
            this.jPanelContenido.add((Component)this.getJComboBoxTipoContrato(), null);
            this.jPanelContenido.add((Component)this.jLabelSubTipoContrato, null);
            this.jPanelContenido.add((Component)this.jLabelObjetoContrato, null);
            this.jPanelContenido.add((Component)this.jLabelProcContratacion, null);
            this.jPanelContenido.add((Component)this.jLabelTipoTramitaci\u00f3n, null);
            this.jPanelContenido.add((Component)this.jLabelTramitacionGasto, null);
            this.jPanelContenido.add((Component)this.getJComboBoxSubtipoContrato(), null);
            this.jPanelContenido.add((Component)this.getJComboBoxProcContratacion(), null);
            this.jPanelContenido.add((Component)this.getJComboBoxTipoTramitacion(), null);
            this.jPanelContenido.add((Component)this.getJComboBoxTramitacionGasto(), null);
            this.jPanelContenido.add((Component)this.getJTextFieldObjetoContrato(), null);
            this.jPanelContenido.add((Component)this.jLabelAnuncioLicitacion, null);
            this.getPanel().add(this.getJButtonLotes());
            this.getPanel().add(this.getJButtonReceptorRecuros());
            this.getPanel().add(this.getJComboBoxClasificacion());
            this.getPanel().add(this.getJTextAreaDescSolvencias());
            this.getPanel().add(this.getJTextFieldImporteSin());
            this.getPanel().add(this.getJTextFieldImporteCon());
            this.getPanel().add(this.getLblValorEstimadoDel());
            this.getPanel().add(this.getJTextFieldValorEstimado());
            this.jLabelSelCPV = new JLabel();
            this.jLabelSelCPV.setBounds(63, 420, 250, 18);
            this.getPanel().add(this.jLabelSelCPV);
            this.jLabelSelCPV.setText("Selecci\u00f3n del CPV");
            this.jLabelCodigoCPV = new JLabel();
            this.jLabelCodigoCPV.setBounds(93, 440, 220, 18);
            this.getPanel().add(this.jLabelCodigoCPV);
            this.jLabelCodigoCPV.setText("C\u00f3digo CPV");
            this.getPanel().add(this.getJComboBoxCPV());
            this.jLabelImporteSin = new JLabel();
            this.jLabelImporteSin.setBounds(63, 370, 250, 18);
            this.getPanel().add(this.jLabelImporteSin);
            this.jLabelImporteSin.setText("Importe Base (Sin impuestos)");
            this.jLabelImporteCon = new JLabel();
            this.jLabelImporteCon.setBounds(63, 395, 250, 18);
            this.getPanel().add(this.jLabelImporteCon);
            this.jLabelImporteCon.setText("Importe Base (Con impuestos)");
            this.jLabelClasificacion = new JLabel();
            this.jLabelClasificacion.setBounds(63, 465, 250, 18);
            this.getPanel().add(this.jLabelClasificacion);
            this.jLabelClasificacion.setText("Clasificaci\u00f3n:");
            this.jLabelDescSolvencias = new JLabel();
            this.jLabelDescSolvencias.setBounds(63, 490, 250, 18);
            this.getPanel().add(this.jLabelDescSolvencias);
            this.jLabelDescSolvencias.setText("Descripci\u00f3n de solvencias:");
            this.getPanel().add(this.getLblNewLabel());
            this.buttonGroup.add(this.getRdbtnDesierto());
            this.getPanel().add(this.getRdbtnDesierto());
            this.buttonGroup.add(this.getRdbtnRenuncia());
            this.getPanel().add(this.getRdbtnRenuncia());
            this.buttonGroup.add(this.getRdbtnDesistimiento());
            this.getPanel().add(this.getRdbtnDesistimiento());
            JLabel lblTextoDelAcuerdo = new JLabel();
            lblTextoDelAcuerdo.setText("Texto del acuerdo");
            lblTextoDelAcuerdo.setBounds(63, 634, 250, 18);
            this.getPanel().add(lblTextoDelAcuerdo);
            this.getPanel().add(this.getTextAreaAcuerdo());
            JLabel lblFechaDelAcuerdo = new JLabel();
            lblFechaDelAcuerdo.setText("Fecha del acuerdo (dd-mm-aaaa)");
            lblFechaDelAcuerdo.setBounds(63, 605, 250, 18);
            this.getPanel().add(lblFechaDelAcuerdo);
            this.getPanel().add(this.getTextFieldFechaAcuerdo());
            this.getPanel().add(this.getLblNmeroDeOfertas());
            this.getPanel().add(this.getJTextFieldNumOfertasRecibidas());
            this.getPanel().add(this.getJButtonDuracionContrato());
            this.getPanel().add(this.getJComboBoxPais());
            this.getPanel().add(this.getJComboBoxNuts());
            this.getPanel().add(this.getLblLugarDeEjecucin());
            this.jComboBoxTipoContrato.addItemListener(new ComboListener(this.jComboBoxTipoContrato, this.jComboBoxSubtipoContrato));
            this.jComboBoxPais.addItemListener(new ComboListenerCountry(this.jComboBoxPais, this.jComboBoxNuts));
            JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00f3n");
            lblDirectivaDeAplicacin.setBounds(62, 110, 178, 14);
            this.getPanel().add(lblDirectivaDeAplicacin);
            this.jPanelContenido.add((Component)this.getJComboBoxDirectiva(), null);
        }
        return this.jPanelContenido;
    }

    private JComboBox getJComboBoxDirectiva() {
        if (this.jComboBoxDirectiva == null) {
            this.jComboBoxDirectiva = new JComboBox();
            this.jComboBoxDirectiva.setBounds(333, 105, 378, 20);
        }
        return this.jComboBoxDirectiva;
    }

    private JTextField getTextFieldFechaAcuerdo() {
        if (this.textFieldFechaAcuerdo == null) {
            this.textFieldFechaAcuerdo = new JTextField();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            this.textFieldFechaAcuerdo.setText(dateFormat.format(new Date()));
            this.textFieldFechaAcuerdo.setBounds(333, 605, 116, 18);
        }
        return this.textFieldFechaAcuerdo;
    }

    private JRadioButton getRdbtnDesierto() {
        if (this.rdbtnDesierto == null) {
            this.rdbtnDesierto = new JRadioButton("Desierto");
            this.rdbtnDesierto.setBackground(Color.WHITE);
            this.rdbtnDesierto.setBounds(333, 568, 109, 23);
        }
        return this.rdbtnDesierto;
    }

    private JRadioButton getRdbtnRenuncia() {
        if (this.rdbtnRenuncia == null) {
            this.rdbtnRenuncia = new JRadioButton("Renuncia");
            this.rdbtnRenuncia.setBackground(Color.WHITE);
            this.rdbtnRenuncia.setBounds(480, 568, 109, 23);
        }
        return this.rdbtnRenuncia;
    }

    private JRadioButton getRdbtnDesistimiento() {
        if (this.rdbtnDesistimiento == null) {
            this.rdbtnDesistimiento = new JRadioButton("Desistimiento");
            this.rdbtnDesistimiento.setBackground(Color.WHITE);
            this.rdbtnDesistimiento.setBounds(644, 568, 109, 23);
        }
        return this.rdbtnDesistimiento;
    }

    private JTextArea getTextAreaAcuerdo() {
        if (this.textAreaAcuerdo == null) {
            this.textAreaAcuerdo = new JTextArea();
            this.textAreaAcuerdo.setBackground(SystemColor.menu);
            this.textAreaAcuerdo.setBounds(333, 634, 493, 50);
        }
        return this.textAreaAcuerdo;
    }

    private JTextField getJTextFieldExpediente() {
        if (this.jTextFieldExpediente == null) {
            this.jTextFieldExpediente = new JTextField();
            this.jTextFieldExpediente.setSize(new Dimension(210, 18));
            this.jTextFieldExpediente.setLocation(new Point(333, 134));
        }
        return this.jTextFieldExpediente;
    }

    private JComboBox getJComboBoxTipoContrato() {
        if (this.jComboBoxTipoContrato == null) {
            this.jComboBoxTipoContrato = new JComboBox();
            this.jComboBoxTipoContrato.setLocation(new Point(333, 159));
            this.jComboBoxTipoContrato.setSize(new Dimension(210, 18));
        }
        return this.jComboBoxTipoContrato;
    }

    private JComboBox getJComboBoxSubtipoContrato() {
        if (this.jComboBoxSubtipoContrato == null) {
            this.jComboBoxSubtipoContrato = new JComboBox();
            this.jComboBoxSubtipoContrato.setLocation(new Point(333, 184));
            this.jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
        }
        return this.jComboBoxSubtipoContrato;
    }

    private JComboBox getJComboBoxProcContratacion() {
        if (this.jComboBoxProcContratacion == null) {
            this.jComboBoxProcContratacion = new JComboBox();
            this.jComboBoxProcContratacion.setLocation(new Point(333, 234));
            this.jComboBoxProcContratacion.setSize(new Dimension(210, 18));
        }
        return this.jComboBoxProcContratacion;
    }

    private JComboBox getJComboBoxTipoTramitacion() {
        if (this.jComboBoxTipoTramitacion == null) {
            this.jComboBoxTipoTramitacion = new JComboBox();
            this.jComboBoxTipoTramitacion.setLocation(new Point(333, 254));
            this.jComboBoxTipoTramitacion.setSize(new Dimension(210, 18));
        }
        return this.jComboBoxTipoTramitacion;
    }

    private JComboBox getJComboBoxTramitacionGasto() {
        if (this.jComboBoxTramitacionGasto == null) {
            this.jComboBoxTramitacionGasto = new JComboBox();
            this.jComboBoxTramitacionGasto.setLocation(new Point(333, 279));
            this.jComboBoxTramitacionGasto.setSize(new Dimension(210, 18));
        }
        return this.jComboBoxTramitacionGasto;
    }

    private JTextField getJTextFieldObjetoContrato() {
        if (this.jTextFieldObjetoContrato == null) {
            this.jTextFieldObjetoContrato = new JTextField();
            this.jTextFieldObjetoContrato.setLocation(new Point(333, 209));
            this.jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
        }
        return this.jTextFieldObjetoContrato;
    }

    private JComboBox getJComboBoxCPV() {
        if (this.jComboBoxCPV == null) {
            this.jComboBoxCPV = new JComboBox();
            this.jComboBoxCPV.setBounds(333, 440, 493, 18);
        }
        return this.jComboBoxCPV;
    }

    private JComboBox getJComboBoxClasificacion() {
        if (this.jComboBoxClasificacion == null) {
            this.jComboBoxClasificacion = new JComboBox();
            this.jComboBoxClasificacion.setBounds(333, 465, 493, 18);
        }
        return this.jComboBoxClasificacion;
    }

    private JTextArea getJTextAreaDescSolvencias() {
        if (this.jTextAreaDescSolvencias == null) {
            this.jTextAreaDescSolvencias = new JTextArea();
            this.jTextAreaDescSolvencias.setBounds(333, 490, 493, 50);
            this.jTextAreaDescSolvencias.setBackground(SystemColor.control);
        }
        return this.jTextAreaDescSolvencias;
    }

    private JTextField getJTextFieldImporteSin() {
        if (this.jTextFieldImporteSin == null) {
            this.jTextFieldImporteSin = new JTextField();
            this.jTextFieldImporteSin.setBounds(333, 370, 210, 18);
        }
        return this.jTextFieldImporteSin;
    }

    private JTextField getJTextFieldImporteCon() {
        if (this.jTextFieldImporteCon == null) {
            this.jTextFieldImporteCon = new JTextField();
            this.jTextFieldImporteCon.setBounds(333, 395, 210, 18);
        }
        return this.jTextFieldImporteCon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(this.getExpediente());
            if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
                this.setVisible(false);
                this.gestorVentanasFormCD[0].setVisible(true);
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
                if (this.gestorVentanasFormCD[1] == null) {
                    this.getExpediente();
                    this.setVisible(false);
                    this.gestorVentanasFormCD[1] = new GeneracionCODICEForm(this, "RENUNCIA");
                    this.gestorVentanasFormCD[1].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[1].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
                if (this.gestorVentanasFormCD[2] == null) {
                    this.getExpediente();
                    this.setVisible(false);
                    this.gestorVentanasFormCD[2] = new CondicionesEjecucionForm(this, "RENUNCIA");
                    this.gestorVentanasFormCD[2].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[2].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_LOTES)) {
                if (this.gestorVentanasFormCD[3] == null) {
                    this.getExpediente();
                    this.setVisible(false);
                    this.gestorVentanasFormCD[3] = new LotesForm(this, "RENUNCIA");
                    this.gestorVentanasFormCD[3].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[3].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_CRITERIOS_ADJUDICACION)) {
                if (this.gestorVentanasFormCD[4] == null) {
                    this.getExpediente();
                    this.setVisible(false);
                    this.gestorVentanasFormCD[4] = new CriteriosAdjudicacionForm(this, "RENUNCIA");
                    this.gestorVentanasFormCD[4].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[4].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
                if (this.gestorVentanasFormCD[5] == null) {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[5] = new ReceptorRecurosForm(this, "RENUNCIA");
                    this.gestorVentanasFormCD[5].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[5].setVisible(true);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_OFFICIAL_PUB)) {
                if (this.gestorVentanasFormCD[6] == null) {
                    this.getExpediente();
                    this.setVisible(false);
                    this.gestorVentanasFormCD[6] = new PublicacionesOficialesForm(this, "RENUNCIA");
                    this.gestorVentanasFormCD[6].setVisible(true);
                } else {
                    this.setVisible(false);
                    this.gestorVentanasFormCD[6].setVisible(true);
                }
            }
        }
        catch (ModelException e1) {
            e1.printStackTrace();
        }
    }

    private JLabel getLblValorEstimadoDel() {
        if (this.lblValorEstimadoDel == null) {
            this.lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
            this.lblValorEstimadoDel.setBounds(63, 345, 230, 14);
        }
        return this.lblValorEstimadoDel;
    }

    private JTextField getJTextFieldValorEstimado() {
        if (this.jTextFieldValorEstimado == null) {
            this.jTextFieldValorEstimado = new JTextField();
            this.jTextFieldValorEstimado.setBounds(333, 339, 210, 20);
            this.jTextFieldValorEstimado.setColumns(10);
        }
        return this.jTextFieldValorEstimado;
    }

    private JLabel getLblNewLabel() {
        if (this.lblNewLabel == null) {
            this.lblNewLabel = new JLabel("Resultado del procedimiento");
            this.lblNewLabel.setBounds(63, 568, 167, 14);
        }
        return this.lblNewLabel;
    }

    private JLabel getLblNmeroDeOfertas() {
        if (this.lblNmeroDeOfertas == null) {
            this.lblNmeroDeOfertas = new JLabel("N\u00famero de ofertas recibidas");
            this.lblNmeroDeOfertas.setBounds(480, 607, 210, 14);
        }
        return this.lblNmeroDeOfertas;
    }

    private JTextField getJTextFieldNumOfertasRecibidas() {
        if (this.jTextFieldNumOfertasRecibidas == null) {
            this.jTextFieldNumOfertasRecibidas = new JTextField();
            this.jTextFieldNumOfertasRecibidas.setBounds(644, 603, 86, 20);
            this.jTextFieldNumOfertasRecibidas.setColumns(10);
        }
        return this.jTextFieldNumOfertasRecibidas;
    }

    private JButton getJButtonDuracionContrato() {
        if (this.jButtonDuracionContrato == null) {
            this.jButtonDuracionContrato = new JButton();
            this.jButtonDuracionContrato.setText("Duraci\u00f3n del contrato");
            this.jButtonDuracionContrato.setActionCommand(Acciones.EDIT_DURACION);
            this.jButtonDuracionContrato.setBounds(620, 231, 222, 18);
        }
        return this.jButtonDuracionContrato;
    }

    private JComboBox getJComboBoxPais() {
        if (this.jComboBoxPais == null) {
            this.jComboBoxPais = new JComboBox();
            this.jComboBoxPais.setBounds(593, 369, 243, 18);
        }
        return this.jComboBoxPais;
    }

    private JComboBox getJComboBoxNuts() {
        if (this.jComboBoxNuts == null) {
            this.jComboBoxNuts = new JComboBox();
            this.jComboBoxNuts.setBounds(593, 394, 243, 18);
        }
        return this.jComboBoxNuts;
    }

    private JLabel getLblLugarDeEjecucin() {
        if (this.lblLugarDeEjecucin == null) {
            this.lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00f3n");
            this.lblLugarDeEjecucin.setBounds(565, 355, 230, 14);
        }
        return this.lblLugarDeEjecucin;
    }

    private JButton getJButtonLotes() {
        if (this.jButtonLotes == null) {
            this.jButtonLotes = new JButton();
            this.jButtonLotes.setText("Lotes");
            this.jButtonLotes.setActionCommand(Acciones.EDIT_LOTES);
            this.jButtonLotes.setBounds(620, 255, 221, 18);
        }
        return this.jButtonLotes;
    }

    private JButton getJButtonCriteriosAdjudicacion() {
        if (this.jButtonCriteriosAdjudicacion == null) {
            this.jButtonCriteriosAdjudicacion = new JButton();
            this.jButtonCriteriosAdjudicacion.setText("Criterios de adjudicaci\u00f3n");
            this.jButtonCriteriosAdjudicacion.setFont(new Font("Tahoma", 0, 11));
            this.jButtonCriteriosAdjudicacion.setActionCommand(Acciones.EDIT_CRITERIOS_ADJUDICACION);
            this.jButtonCriteriosAdjudicacion.setBounds(620, 276, 220, 18);
        }
        return this.jButtonCriteriosAdjudicacion;
    }

    private JButton getJButtonReceptorRecuros() {
        if (this.jButtonReceptorRecursos == null) {
            this.jButtonReceptorRecursos = new JButton();
            this.jButtonReceptorRecursos.setBounds(620, 298, 221, 18);
            this.jButtonReceptorRecursos.setText("Receptor de recursos");
            this.jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
        }
        return this.jButtonReceptorRecursos;
    }

    private JButton getJButtonDiariosOficiales() {
        if (this.jButtonDiariosOficiales == null) {
            this.jButtonDiariosOficiales = new JButton();
            this.jButtonDiariosOficiales.setBounds(620, 327, 220, 18);
            this.jButtonDiariosOficiales.setText("Publicacion en diarios oficiales");
            this.jButtonDiariosOficiales.setActionCommand(Acciones.INIT_OFFICIAL_PUB);
        }
        return this.jButtonDiariosOficiales;
    }
}

