/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service.commons;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LicitadorBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdjudicatarioForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelDatosLic = null;
    JFrame[] gestorVentanasFormCD = new JFrame[2];
    private JLabel jLabelLicitador = null;
    private JLabel jLabelNombreLic = null;
    private JLabel jLabeIdentificador = null;
    private JLabel jLabelLugarDatosAdj = null;
    private JTextField jTextFieldNombre = null;
    private String tipoDocumento = null;
    private JLabel jLabeFechaAdjudicacion = null;
    private JLabel jLabeImporteSin = null;
    private JLabel jLabeImporteCon = null;
    private JTextField jTextFieldImporteSin = null;
    private JTextField jTextFieldImporteCon = null;
    private JTextField jTextFieldFechaAdj = null;
    private LicitadorBean licitador;
    private JComboBox jComboBoxTipoIdentificador = null;
    private JTextField jTextFieldIdentificador = null;
    private JTextField textFieldNumOfertasRecibidas;
    private ExpedienteBean expediente;

    public AdjudicatarioForm(JFrame ventanaPadre, String tipoDocumento) throws ModelException {
        this.initialize();
        this.gestorVentanasFormCD[0] = ventanaPadre;
        this.gestorVentanasFormCD[1] = null;
        this.setHasButtonPrev(true);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        if (SessionDataManager.getExpediente() != null) {
            this.expediente = SessionDataManager.getExpediente();
            this.escribeDatosExpediente();
        }
        ventanaPadre.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AdjudicatarioForm.this.escribeDatosExpediente();
            }
        });
        this.tipoDocumento = tipoDocumento;
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Licitador - Configuraci\u00f3n");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jLabelLugarDatosAdj = new JLabel();
            this.jLabelLugarDatosAdj.setText("Datos de la adjudicaci\u00f3n:");
            this.jLabelLugarDatosAdj.setLocation(new Point(61, 223));
            this.jLabelLugarDatosAdj.setSize(new Dimension(230, 16));
            this.jLabeIdentificador = new JLabel();
            this.jLabeIdentificador.setText("Identificador:");
            this.jLabeIdentificador.setSize(new Dimension(215, 18));
            this.jLabeIdentificador.setLocation(new Point(97, 179));
            this.jLabelNombreLic = new JLabel();
            this.jLabelNombreLic.setText("Nombre:");
            this.jLabelNombreLic.setSize(new Dimension(215, 18));
            this.jLabelNombreLic.setLocation(new Point(97, 149));
            this.jLabelLicitador = new JLabel();
            this.jLabelLicitador.setText("Adjudicatario");
            this.jLabelLicitador.setSize(new Dimension(288, 35));
            this.jLabelLicitador.setLocation(new Point(25, 79));
            this.jLabelLicitador.setFont(new Font("Dialog", 1, 18));
            this.jLabelDatosLic = new JLabel();
            this.jLabelDatosLic.setText("Datos del licitador:");
            this.jLabelDatosLic.setLocation(new Point(61, 121));
            this.jLabelDatosLic.setSize(new Dimension(250, 18));
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.setSize(new Dimension(800, 600));
            this.jPanelContenido.add((Component)this.jLabelDatosLic, null);
            this.jPanelContenido.add((Component)this.jLabelLicitador, null);
            this.jPanelContenido.add((Component)this.jLabelNombreLic, null);
            this.jPanelContenido.add((Component)this.jLabeIdentificador, null);
            this.jPanelContenido.add((Component)this.jLabelLugarDatosAdj, null);
            this.getPanel().add(this.getJTextFieldNombre());
            this.getPanel().add(this.getJTextFieldImporteSin());
            this.getPanel().add(this.getJTextFieldImporteCon());
            this.getPanel().add(this.getJComboBoxTipoIdentificador());
            this.getPanel().add(this.getJTextFieldIdentificador());
            this.getPanel().add(this.getJTextFieldFechaAdj());
            ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxTipoIdentificador, "http://contrataciondelestado.es/codice/cl/2.0/PartyIdentificationSchemeID-2.0.gc");
            JLabel lblNmeroDeOfertas = new JLabel("N\u00famero de ofertas recibidas");
            lblNmeroDeOfertas.setBounds(99, 367, 285, 14);
            this.getPanel().add(lblNmeroDeOfertas);
            this.textFieldNumOfertasRecibidas = new JTextField();
            this.textFieldNumOfertasRecibidas.setBounds(422, 364, 86, 20);
            this.getPanel().add(this.textFieldNumOfertasRecibidas);
            this.textFieldNumOfertasRecibidas.setColumns(10);
            this.jLabeFechaAdjudicacion = new JLabel();
            this.jLabeFechaAdjudicacion.setBounds(99, 264, 238, 18);
            this.getPanel().add(this.jLabeFechaAdjudicacion);
            this.jLabeFechaAdjudicacion.setText("Fecha adjudicaci\u00f3n (dd-mm-aaaa):");
            this.jLabeImporteSin = new JLabel();
            this.jLabeImporteSin.setBounds(99, 293, 215, 18);
            this.getPanel().add(this.jLabeImporteSin);
            this.jLabeImporteSin.setText("Importe Adjudicacion (Sin impuestos)");
            this.jLabeImporteCon = new JLabel();
            this.jLabeImporteCon.setBounds(99, 328, 220, 18);
            this.getPanel().add(this.jLabeImporteCon);
            this.jLabeImporteCon.setText("Importe Adjudicacion (Con impuestos)");
        }
        return this.jPanelContenido;
    }

    private JTextField getJTextFieldNombre() {
        if (this.jTextFieldNombre == null) {
            this.jTextFieldNombre = new JTextField();
            this.jTextFieldNombre.setBounds(422, 148, 250, 18);
        }
        return this.jTextFieldNombre;
    }

    private JTextField getJTextFieldImporteSin() {
        if (this.jTextFieldImporteSin == null) {
            this.jTextFieldImporteSin = new JTextField();
            this.jTextFieldImporteSin.setBounds(422, 293, 250, 18);
        }
        return this.jTextFieldImporteSin;
    }

    private JTextField getJTextFieldImporteCon() {
        if (this.jTextFieldImporteCon == null) {
            this.jTextFieldImporteCon = new JTextField();
            this.jTextFieldImporteCon.setBounds(422, 328, 250, 18);
        }
        return this.jTextFieldImporteCon;
    }

    private JTextField getJTextFieldFechaAdj() {
        if (this.jTextFieldFechaAdj == null) {
            this.jTextFieldFechaAdj = new JTextField();
            this.jTextFieldFechaAdj.setBounds(422, 264, 250, 18);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            this.jTextFieldFechaAdj.setText(dateFormat.format(new Date()));
        }
        return this.jTextFieldFechaAdj;
    }

    private JComboBox getJComboBoxTipoIdentificador() {
        if (this.jComboBoxTipoIdentificador == null) {
            this.jComboBoxTipoIdentificador = new JComboBox();
            this.jComboBoxTipoIdentificador.setBounds(422, 178, 100, 18);
        }
        return this.jComboBoxTipoIdentificador;
    }

    private JTextField getJTextFieldIdentificador() {
        if (this.jTextFieldIdentificador == null) {
            this.jTextFieldIdentificador = new JTextField();
            this.jTextFieldIdentificador.setBounds(532, 178, 140, 18);
        }
        return this.jTextFieldIdentificador;
    }

    public LicitadorBean getLicitador() {
        if (this.licitador == null) {
            this.licitador = new LicitadorBean();
        }
        this.licitador.setNombre(this.jTextFieldNombre.getText());
        this.licitador.setTipoIdentificador((String)this.jComboBoxTipoIdentificador.getSelectedItem());
        this.licitador.setIdentificador(this.jTextFieldIdentificador.getText());
        Date fechaAdj = null;
        if (this.jTextFieldFechaAdj.getText().length() > 0) {
            try {
                fechaAdj = new SimpleDateFormat("dd-MM-yyyy").parse(this.jTextFieldFechaAdj.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha de apertura de ofertas");
            }
        }
        this.licitador.setFechaAdjudicacion(fechaAdj);
        if (this.jTextFieldImporteSin.getText().length() > 0) {
            this.licitador.setImporteSinImpuestos(this.jTextFieldImporteSin.getText());
        }
        if (this.jTextFieldImporteCon.getText().length() > 0) {
            this.licitador.setImporteConImpuestos(this.jTextFieldImporteCon.getText());
        }
        if (this.textFieldNumOfertasRecibidas.getText().length() > 0) {
            this.licitador.setNumOfertasRecibidas(Integer.parseInt(this.textFieldNumOfertasRecibidas.getText()));
        }
        return this.licitador;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
            this.setVisible(false);
            this.getLicitador();
            this.gestorVentanasFormCD[0].setVisible(true);
            SessionDataManager.getInstance();
            ExpedienteBean expediente = SessionDataManager.getExpediente();
            expediente.setLicitador(this.getLicitador());
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(expediente);
        }
    }

    private void escribeDatosExpediente() {
        LicitadorBean licitador = this.expediente.getLicitador();
        if (licitador != null) {
            SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
            this.jTextFieldNombre.setText(licitador.getNombre());
            this.jComboBoxTipoIdentificador.setSelectedIndex(licitador.getIdtipoIdentificador());
            this.jTextFieldIdentificador.setText(licitador.getIdentificador());
            this.jTextFieldFechaAdj.setText(df.format(licitador.getFechaAdjudicacion()));
            this.jTextFieldImporteSin.setText(licitador.getImporteSinImpuestos());
            this.jTextFieldImporteCon.setText(licitador.getImporteConImpuestos());
        }
    }
}

