/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service.commons;

import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CondicionesEjecucionForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelEventoAperturaEconomica = null;
    JFrame[] gestorVentanasFormCD = new JFrame[2];
    private String tipoDocumento = null;
    private CondicionesEjecucionBean condicionesEjecucion = null;
    private JPanel panelSeleccion = null;
    private JLabel jLabelFechaInicio = null;
    private JLabel jLabelFechaFinal = null;
    private JLabel jLabelDuracion = null;
    private JLabel jLabelUnidad = null;
    private JTextField jTextFieldFechaInicio = null;
    private JTextField jTextFieldFechaFinal = null;
    private JTextField jTextFieldDuracion = null;
    private JComboBox jComboBoxUnidad = null;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton jRadioButtonFechaFinal = null;
    private JRadioButton jRadioButtonDuracion = null;
    private JLabel lblDuracinDelContrato;
    private JLabel lblPedidoElectronico;
    private JLabel lblFacturaElectronica;
    private JLabel lblSeUtilizarEl;
    private JLabel lblConsideracionesAmbientales;
    private JLabel lblConsideracionesSocial;
    private JLabel lblPromoverEmpleo;
    private JLabel lblEliminarDesigualdades;
    private JLabel lblCombatirParo;
    private JLabel lblFavorecerLaFormacin;
    private JLabel lblCumplimientoDeLas;
    private JLabel lblCondicionesEspecialesDe;
    private JTextField jTextFieldConsideracionesAmbientales;
    private JTextField jTextFieldConsideracionesSocial;
    private JTextField jTextFieldPromoverEmpleo;
    private JTextField jTextFieldEliminarDesigualdades;
    private JTextField jTextFieldCombatirParo;
    private JTextField jTextFieldFavorecerFormacion;
    private JTextField jTextFieldConvencionesOMT;
    private JComboBox jComboBoxPedidoElectronico = null;
    private JComboBox jComboBoxFacturaElectronica = null;
    private JComboBox jComboBoxPagoElectronico = null;
    private JLabel lblUsoDeHerramientas;

    public CondicionesEjecucionBean getCondicionesEjecucion() {
        CondicionesEjecucionBean condicionesEjecucion = new CondicionesEjecucionBean();
        Date fechaInicio = null;
        if (this.jTextFieldFechaInicio.getText().length() > 0) {
            try {
                fechaInicio = new SimpleDateFormat("dd-MM-yyyy").parse(this.jTextFieldFechaInicio.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha de inicio del contrato");
            }
        }
        condicionesEjecucion.setFechaInicio(fechaInicio);
        Date fechaFinal = null;
        if (this.jRadioButtonDuracion.isSelected()) {
            condicionesEjecucion.setFechaFinal(null);
            condicionesEjecucion.setDuracion(this.jTextFieldDuracion.getText());
            condicionesEjecucion.setUnidadDuracion(this.jComboBoxUnidad.getSelectedIndex());
        } else if (this.jRadioButtonFechaFinal.isSelected()) {
            condicionesEjecucion.setDuracion(null);
            if (this.jTextFieldFechaFinal.getText().length() > 0) {
                try {
                    fechaFinal = new SimpleDateFormat("dd-MM-yyyy").parse(this.jTextFieldFechaFinal.getText());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    System.out.println("Error en el formato de la fecha de finalizaci\u00f3n del contrato");
                }
            }
            condicionesEjecucion.setFechaFinal(fechaFinal);
        }
        condicionesEjecucion.setFacturaElectronica(this.jComboBoxFacturaElectronica.getSelectedIndex());
        condicionesEjecucion.setPedidoElectronico(this.jComboBoxPedidoElectronico.getSelectedIndex());
        condicionesEjecucion.setPagoElectronico(this.jComboBoxPagoElectronico.getSelectedIndex());
        condicionesEjecucion.setCombatirParo(this.jTextFieldCombatirParo.getText());
        condicionesEjecucion.setConsideracionesAmbientales(this.jTextFieldConsideracionesAmbientales.getText());
        condicionesEjecucion.setConsideracionesSocial(this.jTextFieldConsideracionesSocial.getText());
        condicionesEjecucion.setConvencionesOMT(this.jTextFieldConvencionesOMT.getText());
        condicionesEjecucion.setEliminarDesigualdades(this.jTextFieldEliminarDesigualdades.getText());
        condicionesEjecucion.setFavorecerFormacion(this.jTextFieldFavorecerFormacion.getText());
        condicionesEjecucion.setPromoverEmpleo(this.jTextFieldPromoverEmpleo.getText());
        return condicionesEjecucion;
    }

    public void setCondicionesEjecucion(CondicionesEjecucionBean condicionesEjecucion) {
        this.condicionesEjecucion = condicionesEjecucion;
    }

    public CondicionesEjecucionForm(JFrame ventanaPadre, String tipoDocumento) throws ModelException {
        this.initialize();
        this.gestorVentanasFormCD[0] = ventanaPadre;
        this.gestorVentanasFormCD[1] = null;
        this.tipoDocumento = tipoDocumento;
        this.cargarDatosComboBoxs();
        this.setHasButtonPrev(true);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        if (SessionDataManager.getExpediente() != null && SessionDataManager.getExpediente().getCondicionesEjecucion() != null) {
            this.condicionesEjecucion = SessionDataManager.getExpediente().getCondicionesEjecucion();
            this.escribeDatosCondicionesEjecucion();
        }
    }

    private void escribeDatosCondicionesEjecucion() {
        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
        if (this.condicionesEjecucion.getFechaInicio() != null) {
            this.jTextFieldFechaInicio.setText(df.format(this.condicionesEjecucion.getFechaInicio()));
        }
        if (this.condicionesEjecucion.getFechaFinal() != null) {
            this.jRadioButtonFechaFinal.setSelected(true);
            this.jRadioButtonDuracion.setSelected(false);
            this.jTextFieldFechaFinal.setText(df.format(this.condicionesEjecucion.getFechaFinal()));
        }
        if (this.condicionesEjecucion.getDuracion() != null) {
            this.jRadioButtonFechaFinal.setSelected(false);
            this.jRadioButtonDuracion.setSelected(true);
            this.jTextFieldDuracion.setText(this.condicionesEjecucion.getDuracion());
            this.jComboBoxUnidad.setSelectedIndex(this.condicionesEjecucion.getUnidadDuracion());
        }
        this.jComboBoxFacturaElectronica.setSelectedIndex(this.condicionesEjecucion.getFacturaElectronica());
        this.jComboBoxPedidoElectronico.setSelectedIndex(this.condicionesEjecucion.getPedidoElectronico());
        this.jComboBoxPagoElectronico.setSelectedIndex(this.condicionesEjecucion.getPagoElectronico());
        this.jTextFieldCombatirParo.setText(this.condicionesEjecucion.getCombatirParo());
        this.jTextFieldConsideracionesAmbientales.setText(this.condicionesEjecucion.getConsideracionesAmbientales());
        this.jTextFieldConsideracionesSocial.setText(this.condicionesEjecucion.getConsideracionesSocial());
        this.jTextFieldConvencionesOMT.setText(this.condicionesEjecucion.getConvencionesOMT());
        this.jTextFieldEliminarDesigualdades.setText(this.condicionesEjecucion.getEliminarDesigualdades());
        this.jTextFieldFavorecerFormacion.setText(this.condicionesEjecucion.getFavorecerFormacion());
        this.jTextFieldPromoverEmpleo.setText(this.condicionesEjecucion.getPromoverEmpleo());
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Duraci\u00f3n del contrato");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JLabel getLblDuracinDelContrato() {
        if (this.lblDuracinDelContrato == null) {
            this.lblDuracinDelContrato = new JLabel("Duraci\u00f3n del contrato");
            this.lblDuracinDelContrato.setFont(new Font("Tahoma", 1, 14));
            this.lblDuracinDelContrato.setBounds(50, 70, 270, 14);
        }
        return this.lblDuracinDelContrato;
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.setSize(new Dimension(800, 600));
            this.jLabelDuracion = new JLabel();
            this.jLabelDuracion.setText("Condiciones de ejecuci\u00f3n del contrato");
            this.jLabelDuracion.setBounds(72, 87, 275, 14);
            this.jLabelFechaInicio = new JLabel();
            this.jLabelFechaInicio.setBounds(50, 114, 171, 14);
            this.getPanel().add(this.jLabelFechaInicio);
            this.jLabelFechaInicio.setText("Fecha de inicio (dd-mm-aaaa)");
            this.getPanel().add(this.getJTextFieldFechaInicio());
            this.getPanel().add(this.getLblDuracinDelContrato());
            this.getPanel().add(this.getPanelSeleccion());
            this.getPanel().add(this.getLblPedidoElectronico());
            this.getPanel().add(this.getLblFacturaElectronica());
            this.getPanel().add(this.getLblSeUtilizarEl());
            this.getPanel().add(this.getJComboBoxPedidoElectronico());
            this.getPanel().add(this.getJComboBoxFacturaElectronica());
            this.getPanel().add(this.getJComboBoxPagoElectronico());
            this.getPanel().add(this.getLblConsideracionesAmbientales());
            this.getPanel().add(this.getLblConsideracionesSocial());
            this.getPanel().add(this.getLblPromoverEmpleo());
            this.getPanel().add(this.getLblEliminarDesigualdades());
            this.getPanel().add(this.getLblCombatirParo());
            this.getPanel().add(this.getLblFavorecerLaFormacin());
            this.getPanel().add(this.getLblCumplimientoDeLas());
            this.getPanel().add(this.getLblCondicionesEspecialesDe());
            this.jTextFieldConsideracionesAmbientales = new JTextField();
            this.jTextFieldConsideracionesAmbientales.setBounds(451, 403, 436, 31);
            this.getPanel().add(this.jTextFieldConsideracionesAmbientales);
            this.jTextFieldConsideracionesAmbientales.setColumns(10);
            this.jTextFieldConsideracionesSocial = new JTextField();
            this.jTextFieldConsideracionesSocial.setColumns(10);
            this.jTextFieldConsideracionesSocial.setBounds(451, 443, 436, 31);
            this.getPanel().add(this.jTextFieldConsideracionesSocial);
            this.jTextFieldPromoverEmpleo = new JTextField();
            this.jTextFieldPromoverEmpleo.setColumns(10);
            this.jTextFieldPromoverEmpleo.setBounds(451, 480, 436, 31);
            this.getPanel().add(this.jTextFieldPromoverEmpleo);
            this.jTextFieldEliminarDesigualdades = new JTextField();
            this.jTextFieldEliminarDesigualdades.setColumns(10);
            this.jTextFieldEliminarDesigualdades.setBounds(451, 517, 436, 31);
            this.getPanel().add(this.jTextFieldEliminarDesigualdades);
            this.jTextFieldCombatirParo = new JTextField();
            this.jTextFieldCombatirParo.setColumns(10);
            this.jTextFieldCombatirParo.setBounds(451, 552, 436, 31);
            this.getPanel().add(this.jTextFieldCombatirParo);
            this.jTextFieldFavorecerFormacion = new JTextField();
            this.jTextFieldFavorecerFormacion.setColumns(10);
            this.jTextFieldFavorecerFormacion.setBounds(451, 589, 436, 31);
            this.getPanel().add(this.jTextFieldFavorecerFormacion);
            this.jTextFieldConvencionesOMT = new JTextField();
            this.jTextFieldConvencionesOMT.setColumns(10);
            this.jTextFieldConvencionesOMT.setBounds(451, 625, 436, 31);
            this.getPanel().add(this.jTextFieldConvencionesOMT);
            this.getPanel().add(this.getLblUsoDeHerramientas());
        }
        return this.jPanelContenido;
    }

    private JTextField getJTextFieldFechaInicio() {
        if (this.jTextFieldFechaInicio == null) {
            this.jTextFieldFechaInicio = new JTextField();
            this.jTextFieldFechaInicio.setBounds(231, 112, 89, 18);
        }
        return this.jTextFieldFechaInicio;
    }

    private JTextField getJTextFieldFechaFinal() {
        if (this.jTextFieldFechaFinal == null) {
            this.jTextFieldFechaFinal = new JTextField();
            this.jTextFieldFechaFinal.setBounds(232, 47, 89, 18);
        }
        return this.jTextFieldFechaFinal;
    }

    private JComboBox getJComboBoxUnidad() {
        if (this.jComboBoxUnidad == null) {
            this.jComboBoxUnidad = new JComboBox();
            this.jComboBoxUnidad.setBounds(335, 92, 68, 18);
        }
        return this.jComboBoxUnidad;
    }

    private JRadioButton getJRadioButtonDuracion() {
        if (this.jRadioButtonDuracion == null) {
            this.jRadioButtonDuracion = new JRadioButton();
            this.jRadioButtonDuracion.setToolTipText("Duraci\u00f3n en d\u00edas, meses o a\u00f1os");
            this.jRadioButtonDuracion.setBounds(30, 94, 26, 14);
        }
        return this.jRadioButtonDuracion;
    }

    private JRadioButton getJRadioButtonFechaFinal() {
        if (this.jRadioButtonFechaFinal == null) {
            this.jRadioButtonFechaFinal = new JRadioButton();
            this.jRadioButtonFechaFinal.setToolTipText("Fecha final");
            this.jRadioButtonFechaFinal.setBounds(30, 51, 21, 14);
        }
        return this.jRadioButtonFechaFinal;
    }

    private JTextField getJTextFieldDuracion() {
        if (this.jTextFieldDuracion == null) {
            this.jTextFieldDuracion = new JTextField();
            this.jTextFieldDuracion.setBounds(232, 91, 68, 20);
            this.jTextFieldDuracion.setColumns(10);
        }
        return this.jTextFieldDuracion;
    }

    private JComboBox getJComboBoxPedidoElectronico() {
        if (this.jComboBoxPedidoElectronico == null) {
            this.jComboBoxPedidoElectronico = new JComboBox();
            this.jComboBoxPedidoElectronico.setBounds(359, 292, 116, 18);
        }
        return this.jComboBoxPedidoElectronico;
    }

    private JComboBox getJComboBoxFacturaElectronica() {
        if (this.jComboBoxFacturaElectronica == null) {
            this.jComboBoxFacturaElectronica = new JComboBox();
            this.jComboBoxFacturaElectronica.setBounds(359, 317, 116, 18);
        }
        return this.jComboBoxFacturaElectronica;
    }

    private JComboBox getJComboBoxPagoElectronico() {
        if (this.jComboBoxPagoElectronico == null) {
            this.jComboBoxPagoElectronico = new JComboBox();
            this.jComboBoxPagoElectronico.setBounds(359, 342, 116, 18);
        }
        return this.jComboBoxPagoElectronico;
    }

    private JPanel getPanelSeleccion() {
        if (this.panelSeleccion == null) {
            this.panelSeleccion = new JPanel();
            this.panelSeleccion.setBounds(345, 114, 461, 132);
            this.panelSeleccion.setBorder(new TitledBorder(null, "Seleccione entre", 4, 2, new Font("Tahoma", 1, 11)));
            this.panelSeleccion.setLayout(null);
            JLabel jLabelDuracion = new JLabel();
            jLabelDuracion.setText("Duraci\u00f3n");
            jLabelDuracion.setBounds(63, 94, 96, 14);
            this.panelSeleccion.add(jLabelDuracion);
            this.panelSeleccion.add(this.getJTextFieldDuracion());
            this.buttonGroup.add(this.getJRadioButtonFechaFinal());
            this.panelSeleccion.add(this.getJRadioButtonFechaFinal());
            this.buttonGroup.add(this.getJRadioButtonDuracion());
            this.panelSeleccion.add(this.getJRadioButtonDuracion());
            this.panelSeleccion.add(this.getJComboBoxUnidad());
            JLabel jLabelFechaFinal_1 = new JLabel();
            jLabelFechaFinal_1.setBounds(63, 51, 159, 14);
            this.panelSeleccion.add(jLabelFechaFinal_1);
            jLabelFechaFinal_1.setText("Fecha final (dd-mm-aaaa)");
            this.panelSeleccion.add(this.getJTextFieldFechaFinal());
        }
        return this.panelSeleccion;
    }

    public void cargarDatosComboBoxs() {
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxUnidad, "http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxPedidoElectronico, "/Si_No.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxFacturaElectronica, "/Si_No.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxPagoElectronico, "/Si_No.gc");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
            this.setVisible(false);
            this.getCondicionesEjecucion();
            this.gestorVentanasFormCD[0].setVisible(true);
            SessionDataManager.getInstance();
            ExpedienteBean expediente = SessionDataManager.getExpediente();
            expediente.setCondicionesEjecucion(this.getCondicionesEjecucion());
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(expediente);
        }
    }

    private JLabel getLblPedidoElectronico() {
        if (this.lblPedidoElectronico == null) {
            this.lblPedidoElectronico = new JLabel("Se utilizar\u00e1 el pedido electr\u00f3nico");
            this.lblPedidoElectronico.setBounds(50, 292, 246, 14);
        }
        return this.lblPedidoElectronico;
    }

    private JLabel getLblFacturaElectronica() {
        if (this.lblFacturaElectronica == null) {
            this.lblFacturaElectronica = new JLabel("Se utilizar\u00e1 la factura electr\u00f3nica");
            this.lblFacturaElectronica.setBounds(50, 317, 246, 14);
        }
        return this.lblFacturaElectronica;
    }

    private JLabel getLblSeUtilizarEl() {
        if (this.lblSeUtilizarEl == null) {
            this.lblSeUtilizarEl = new JLabel("Se utilizar\u00e1 el pago electr\u00f3nico");
            this.lblSeUtilizarEl.setBounds(50, 342, 246, 14);
        }
        return this.lblSeUtilizarEl;
    }

    private JLabel getLblConsideracionesAmbientales() {
        if (this.lblConsideracionesAmbientales == null) {
            this.lblConsideracionesAmbientales = new JLabel("Consideraciones de tipo ambiental");
            this.lblConsideracionesAmbientales.setBounds(61, 420, 329, 14);
        }
        return this.lblConsideracionesAmbientales;
    }

    private JLabel getLblConsideracionesSocial() {
        if (this.lblConsideracionesSocial == null) {
            this.lblConsideracionesSocial = new JLabel("Consideraciones de tipo social");
            this.lblConsideracionesSocial.setBounds(61, 458, 246, 14);
        }
        return this.lblConsideracionesSocial;
    }

    private JLabel getLblPromoverEmpleo() {
        if (this.lblPromoverEmpleo == null) {
            this.lblPromoverEmpleo = new JLabel("Promover el empleo de personas con dificultades especiales");
            this.lblPromoverEmpleo.setBounds(61, 493, 380, 14);
        }
        return this.lblPromoverEmpleo;
    }

    private JLabel getLblEliminarDesigualdades() {
        if (this.lblEliminarDesigualdades == null) {
            this.lblEliminarDesigualdades = new JLabel("Eliminar desigualdades entre el hombre y la mujer");
            this.lblEliminarDesigualdades.setBounds(61, 527, 380, 14);
        }
        return this.lblEliminarDesigualdades;
    }

    private JLabel getLblCombatirParo() {
        if (this.lblCombatirParo == null) {
            this.lblCombatirParo = new JLabel("Combatir el paro");
            this.lblCombatirParo.setBounds(61, 564, 246, 14);
        }
        return this.lblCombatirParo;
    }

    private JLabel getLblFavorecerLaFormacin() {
        if (this.lblFavorecerLaFormacin == null) {
            this.lblFavorecerLaFormacin = new JLabel("Favorecer la formaci\u00f3n en el lugar de trabajo");
            this.lblFavorecerLaFormacin.setBounds(61, 603, 361, 14);
        }
        return this.lblFavorecerLaFormacin;
    }

    private JLabel getLblCumplimientoDeLas() {
        if (this.lblCumplimientoDeLas == null) {
            this.lblCumplimientoDeLas = new JLabel("Cumplimiento de las convenciones fundamentales de la OMT");
            this.lblCumplimientoDeLas.setBounds(61, 642, 380, 14);
        }
        return this.lblCumplimientoDeLas;
    }

    private JLabel getLblCondicionesEspecialesDe() {
        if (this.lblCondicionesEspecialesDe == null) {
            this.lblCondicionesEspecialesDe = new JLabel("Condiciones especiales de ejecuci\u00f3n");
            this.lblCondicionesEspecialesDe.setFont(new Font("Tahoma", 1, 12));
            this.lblCondicionesEspecialesDe.setBounds(50, 386, 295, 14);
        }
        return this.lblCondicionesEspecialesDe;
    }

    private JLabel getLblUsoDeHerramientas() {
        if (this.lblUsoDeHerramientas == null) {
            this.lblUsoDeHerramientas = new JLabel("Uso de herramientas electr\u00f3nicas");
            this.lblUsoDeHerramientas.setFont(new Font("Tahoma", 1, 14));
            this.lblUsoDeHerramientas.setBounds(50, 257, 270, 14);
        }
        return this.lblUsoDeHerramientas;
    }
}

