/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service.commons;

import es.dgpe.place.client.beans.EventoAperturaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class EventosAperturaForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelEventoAperturaEconomica = null;
    JFrame[] gestorVentanasFormCD = new JFrame[2];
    private JLabel jLabelEventoApertura = null;
    private JLabel jLabelNombreEvento = null;
    private JLabel jLabelFechaApertura = null;
    private JLabel jLabelDescripcion = null;
    private JLabel jLabelLugarAperturaEconomica = null;
    private JLabel jLabelLugar = null;
    private JLabel jLabelCalle = null;
    private JLabel jLabelCP = null;
    private JLabel jLabelPoblacion = null;
    private JLabel jLabelPais = null;
    private JTextField jTextFieldNombre = null;
    private JTextPane jTextPaneDescripcion = null;
    private JTextField jTextFieldLugar = null;
    private JTextField jTextFieldCalle = null;
    private JTextField jTextFieldCP = null;
    private JTextField jTextFieldPoblacion = null;
    private String tipoDocumento = null;
    private EventoAperturaBean eventoApertura = null;
    private JComboBox<String> jComboBoxPais = null;
    private JTextField jTextFieldFechaApertura;
    private JTextArea textFieldRequisitosAsistentes;
    private JComboBox<String> comboBoxTipoEventoApertura;
    private ExpedienteBean expediente;

    public EventoAperturaBean getEventoApertura() {
        this.eventoApertura = new EventoAperturaBean();
        this.eventoApertura.setNombre(this.jTextFieldNombre.getText());
        Date fechaApertura = null;
        if (this.jTextFieldFechaApertura.getText().length() > 0) {
            try {
                fechaApertura = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(this.jTextFieldFechaApertura.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha de apertura de ofertas");
            }
        }
        this.eventoApertura.setFechaApertura(fechaApertura);
        this.eventoApertura.setDescripcion(this.jTextPaneDescripcion.getText());
        this.eventoApertura.setLugar(this.jTextFieldLugar.getText());
        this.eventoApertura.setCalle(this.jTextFieldCalle.getText());
        this.eventoApertura.setCp(this.jTextFieldCP.getText());
        this.eventoApertura.setPoblacion(this.jTextFieldPoblacion.getText());
        this.eventoApertura.setPais((String)this.jComboBoxPais.getSelectedItem());
        this.eventoApertura.setIdPais(this.jComboBoxPais.getSelectedIndex());
        if (this.tipoDocumento.equalsIgnoreCase("DOC_CN")) {
            SessionDataManager.getInstance();
            ExpedienteBean cn = SessionDataManager.getExpediente();
            cn.setEventoApertura(this.eventoApertura);
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(cn);
        }
        this.eventoApertura.setTipoEventoApertura((String)this.comboBoxTipoEventoApertura.getSelectedItem());
        this.eventoApertura.setIdTipoEventoApertura(this.comboBoxTipoEventoApertura.getSelectedIndex());
        this.eventoApertura.setRequisitosAsistentes(this.textFieldRequisitosAsistentes.getText());
        if (this.eventoApertura.getDescripcion().isEmpty() && this.eventoApertura.getLugar().isEmpty() && this.eventoApertura.getCalle().isEmpty() && this.eventoApertura.getCp().isEmpty() && this.eventoApertura.getPoblacion().isEmpty()) {
            this.eventoApertura = null;
        }
        return this.eventoApertura;
    }

    public void setEventoApertura(EventoAperturaBean eventoApertura) {
        this.eventoApertura = eventoApertura;
    }

    public EventosAperturaForm(JFrame ventanaPadre, String tipoDocumento) throws ModelException {
        this.initialize();
        this.gestorVentanasFormCD[0] = ventanaPadre;
        this.gestorVentanasFormCD[1] = null;
        this.tipoDocumento = tipoDocumento;
        this.setHasButtonPrev(true);
        this.jLabelFechaApertura = new JLabel();
        this.jLabelFechaApertura.setBounds(101, 223, 335, 18);
        this.getPanel().add(this.jLabelFechaApertura);
        this.jLabelFechaApertura.setText("Fecha de apertura de ofertas (dd-mm-aaaa hh:mm):");
        this.getPanel().add(this.getJTextFieldFechaApertura());
        this.jLabelEventoApertura = new JLabel();
        this.jLabelEventoApertura.setBounds(27, 73, 288, 35);
        this.getPanel().add(this.jLabelEventoApertura);
        this.jLabelEventoApertura.setText("Evento de apertura de oferta");
        this.jLabelEventoApertura.setFont(new Font("Dialog", 1, 18));
        JLabel lblTipoDeEvento = new JLabel();
        lblTipoDeEvento.setText("Tipo de evento de apertura");
        lblTipoDeEvento.setSize(new Dimension(215, 18));
        lblTipoDeEvento.setLocation(new Point(102, 510));
        lblTipoDeEvento.setBounds(101, 333, 215, 18);
        this.getPanel().add(lblTipoDeEvento);
        this.comboBoxTipoEventoApertura = new JComboBox();
        this.comboBoxTipoEventoApertura.setSize(new Dimension(250, 18));
        this.comboBoxTipoEventoApertura.setLocation(new Point(435, 510));
        this.comboBoxTipoEventoApertura.setBounds(435, 333, 250, 18);
        ComboBoxUtils.loadComboBoxFromConstant(this.comboBoxTipoEventoApertura, "http://contrataciondelestado.es/codice/cl/2.05/AttendanceRestrictionCode-2.05.gc");
        this.getPanel().add(this.comboBoxTipoEventoApertura);
        JLabel lblCondicionesDeAcceso = new JLabel();
        lblCondicionesDeAcceso.setText("Condiciones de acceso al evento de apertura:");
        lblCondicionesDeAcceso.setSize(new Dimension(215, 18));
        lblCondicionesDeAcceso.setLocation(new Point(102, 510));
        lblCondicionesDeAcceso.setBounds(101, 352, 344, 18);
        this.getPanel().add(lblCondicionesDeAcceso);
        this.jLabelLugarAperturaEconomica = new JLabel();
        this.jLabelLugarAperturaEconomica.setBounds(59, 416, 230, 16);
        this.getPanel().add(this.jLabelLugarAperturaEconomica);
        this.jLabelLugarAperturaEconomica.setText("Lugar de apertura de oferta:");
        this.jLabelLugar = new JLabel();
        this.jLabelLugar.setBounds(102, 446, 215, 18);
        this.getPanel().add(this.jLabelLugar);
        this.jLabelLugar.setText("Lugar:");
        this.jLabelCalle = new JLabel();
        this.jLabelCalle.setBounds(102, 476, 215, 18);
        this.getPanel().add(this.jLabelCalle);
        this.jLabelCalle.setText("Calle:");
        this.jLabelCP = new JLabel();
        this.jLabelCP.setBounds(102, 506, 215, 18);
        this.getPanel().add(this.jLabelCP);
        this.jLabelCP.setText("CP:");
        this.jLabelPoblacion = new JLabel();
        this.jLabelPoblacion.setBounds(102, 536, 215, 18);
        this.getPanel().add(this.jLabelPoblacion);
        this.jLabelPoblacion.setText("Poblaci\u00f3n:");
        this.jLabelPais = new JLabel();
        this.jLabelPais.setBounds(102, 566, 215, 18);
        this.getPanel().add(this.jLabelPais);
        this.jLabelPais.setText("Pa\u00eds:");
        this.getPanel().add(this.getJTextFieldLugar());
        this.getPanel().add(this.getJTextFieldCalle());
        this.getPanel().add(this.getJTextFieldCP());
        this.getPanel().add(this.getJTextFieldPoblacion());
        this.getPanel().add(this.getJComboBoxPais());
        this.textFieldRequisitosAsistentes = new JTextArea();
        this.textFieldRequisitosAsistentes.setBounds(101, 371, 584, 45);
        this.textFieldRequisitosAsistentes.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.getPanel().add(this.textFieldRequisitosAsistentes);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        if (SessionDataManager.getExpediente() != null) {
            this.expediente = SessionDataManager.getExpediente();
            this.escribeDatosEventosApertura();
        }
        ventanaPadre.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                EventosAperturaForm.this.escribeDatosEventosApertura();
            }
        });
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Eventos de Apertura - Configuraci\u00f3n");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jLabelDescripcion = new JLabel();
            this.jLabelDescripcion.setText("Descripci\u00f3n:");
            this.jLabelDescripcion.setLocation(new Point(102, 250));
            this.jLabelDescripcion.setSize(new Dimension(215, 18));
            this.jLabelNombreEvento = new JLabel();
            this.jLabelNombreEvento.setText("Nombre:");
            this.jLabelNombreEvento.setSize(new Dimension(215, 18));
            this.jLabelNombreEvento.setLocation(new Point(102, 190));
            this.jLabelEventoAperturaEconomica = new JLabel();
            this.jLabelEventoAperturaEconomica.setText("Evento de apertura de oferta econ\u00f3mica:");
            this.jLabelEventoAperturaEconomica.setLocation(new Point(59, 145));
            this.jLabelEventoAperturaEconomica.setSize(new Dimension(250, 18));
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.setSize(new Dimension(800, 600));
            this.jPanelContenido.add((Component)this.jLabelEventoAperturaEconomica, null);
            this.jPanelContenido.add((Component)this.jLabelNombreEvento, null);
            this.jPanelContenido.add((Component)this.jLabelDescripcion, null);
            this.jPanelContenido.add((Component)this.getJTextFieldNombre(), null);
            this.jPanelContenido.add((Component)this.getJTextPaneDescripcion(), null);
        }
        return this.jPanelContenido;
    }

    private JTextField getJTextFieldNombre() {
        if (this.jTextFieldNombre == null) {
            this.jTextFieldNombre = new JTextField();
            this.jTextFieldNombre.setLocation(new Point(435, 190));
            this.jTextFieldNombre.setSize(new Dimension(250, 18));
        }
        return this.jTextFieldNombre;
    }

    private JTextField getJTextFieldFechaApertura() {
        if (this.jTextFieldFechaApertura == null) {
            this.jTextFieldFechaApertura = new JTextField();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
            this.jTextFieldFechaApertura.setText(dateFormat.format(new Date()));
            this.jTextFieldFechaApertura.setBounds(435, 223, 250, 18);
        }
        return this.jTextFieldFechaApertura;
    }

    private JTextPane getJTextPaneDescripcion() {
        if (this.jTextPaneDescripcion == null) {
            this.jTextPaneDescripcion = new JTextPane();
            this.jTextPaneDescripcion.setBackground(SystemColor.control);
            this.jTextPaneDescripcion.setSize(new Dimension(250, 68));
            this.jTextPaneDescripcion.setLocation(new Point(435, 250));
        }
        return this.jTextPaneDescripcion;
    }

    private JTextField getJTextFieldLugar() {
        if (this.jTextFieldLugar == null) {
            this.jTextFieldLugar = new JTextField();
            this.jTextFieldLugar.setBounds(435, 446, 250, 18);
        }
        return this.jTextFieldLugar;
    }

    private JTextField getJTextFieldCalle() {
        if (this.jTextFieldCalle == null) {
            this.jTextFieldCalle = new JTextField();
            this.jTextFieldCalle.setBounds(435, 476, 250, 18);
        }
        return this.jTextFieldCalle;
    }

    private JTextField getJTextFieldCP() {
        if (this.jTextFieldCP == null) {
            this.jTextFieldCP = new JTextField();
            this.jTextFieldCP.setBounds(435, 506, 250, 18);
        }
        return this.jTextFieldCP;
    }

    private JTextField getJTextFieldPoblacion() {
        if (this.jTextFieldPoblacion == null) {
            this.jTextFieldPoblacion = new JTextField();
            this.jTextFieldPoblacion.setBounds(435, 536, 250, 18);
        }
        return this.jTextFieldPoblacion;
    }

    private JComboBox getJComboBoxPais() {
        if (this.jComboBoxPais == null) {
            this.jComboBoxPais = new JComboBox();
            this.jComboBoxPais.setBounds(435, 566, 250, 18);
            ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxPais, "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
            this.jComboBoxPais.setSelectedItem("Espa\u00f1a");
        }
        return this.jComboBoxPais;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
            this.setVisible(false);
            this.getEventoApertura();
            this.gestorVentanasFormCD[0].setVisible(true);
            SessionDataManager.getInstance();
            ExpedienteBean cn = SessionDataManager.getExpediente();
            cn.setEventoApertura(this.getEventoApertura());
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(cn);
        }
    }

    private void escribeDatosEventosApertura() {
        EventoAperturaBean eventoApertura = this.expediente.getEventoApertura();
        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm");
        if (eventoApertura != null) {
            this.jTextFieldNombre.setText(eventoApertura.getNombre());
            if (eventoApertura.getFechaApertura() != null) {
                this.jTextFieldFechaApertura.setText(df.format(eventoApertura.getFechaApertura()));
            }
            this.jTextPaneDescripcion.setText(eventoApertura.getDescripcion());
            this.comboBoxTipoEventoApertura.setSelectedIndex(eventoApertura.getIdTipoEventoApertura());
            this.textFieldRequisitosAsistentes.setText(eventoApertura.getRequisitosAsistentes());
            this.jTextFieldLugar.setText(eventoApertura.getLugar());
            this.jTextFieldCalle.setText(eventoApertura.getCalle());
            this.jTextFieldCP.setText(eventoApertura.getCp());
            this.jTextFieldPoblacion.setText(eventoApertura.getPoblacion());
            this.jComboBoxPais.setSelectedIndex(eventoApertura.getIdPais());
        }
    }
}

