/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service.commons;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LicitadorBean;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class LicitadorForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    private JLabel jLabelDatosLic = null;
    JFrame[] gestorVentanasFormCD = new JFrame[2];
    private JLabel jLabelLicitador = null;
    private JLabel jLabelNombreLic = null;
    private JLabel jLabeIdentificador = null;
    private JLabel jLabeMotivacion = null;
    private JLabel jLabelLugarDatosAdj = null;
    private JTextField jTextFieldNombre = null;
    private JTextPane jTextAreaMotivacion = null;
    private String tipoDocumento = null;
    private JLabel jLabeFechaAdjudicacion = null;
    private JLabel jLabeImporteSin = null;
    private JLabel jLabeImporteCon = null;
    private JTextField jTextFieldImporteSin = null;
    private JTextField jTextFieldImporteCon = null;
    private JTextField jTextFieldFechaAdj = null;
    private JTextField jTextFieldFechaFinForm = null;
    private LicitadorBean licitador;
    private JLabel jLabelFinFormalizacion = null;
    private ExpedienteBean expediente;
    private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;
    private JComboBox<String> jComboBoxTipoIdentificador = null;
    JComboBox<String> jComboBoxEsPyme = new JComboBox();
    JComboBox<String> jComboBoxOfertasBajas = new JComboBox();
    private JTextField jTextFieldIdentificador = null;
    private JTextField jtextFieldNumOfertasRecibidas;
    private JTextField jtextFieldnumOfertasPymes;
    private JTextField jtextFieldnumOfertasExtranjerosUE;
    private JTextField jtextFieldnumOfertasExtranjerosNoUE;
    private JTextField jtextFieldnumOfertasElectronicas;
    private JLabel lblPasOrigenDel;
    private JComboBox<String> comboBoxPaisOrigen;
    private JTextField txtDescripcionLimiteFormalizacion;
    private JLabel lblDireccin;
    private JTextField jtextFieldDireccion;
    private JTextField jtextFieldCiudad;
    private JTextField jtextFieldCodigoPostal;

    public LicitadorForm(JFrame ventanaPadre, String tipoDocumento) throws ModelException {
        this.initialize();
        this.cargarDatosComboBoxs();
        this.gestorVentanasFormCD[0] = ventanaPadre;
        this.gestorVentanasFormCD[1] = null;
        this.setHasButtonPrev(true);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
        if (SessionDataManager.getExpediente() != null) {
            this.expediente = SessionDataManager.getExpediente();
            this.escribeDatosLicitador();
        }
        ventanaPadre.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                LicitadorForm.this.escribeDatosLicitador();
            }
        });
        this.tipoDocumento = tipoDocumento;
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Licitador - Configuraci\u00f3n");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jLabelFinFormalizacion = new JLabel();
            this.jLabelFinFormalizacion.setText("Plazo l\u00edmite formalizaci\u00f3n (dd-mm-aaaa hh:mm):");
            this.jLabelFinFormalizacion.setSize(new Dimension(307, 18));
            this.jLabelFinFormalizacion.setLocation(new Point(101, 456));
            this.jLabeImporteCon = new JLabel();
            this.jLabeImporteCon.setText("Importe Adjudicacion (Con impuestos)");
            this.jLabeImporteCon.setLocation(new Point(101, 426));
            this.jLabeImporteCon.setSize(new Dimension(220, 18));
            this.jLabeImporteSin = new JLabel();
            this.jLabeImporteSin.setText("Importe Adjudicacion (Sin impuestos)");
            this.jLabeImporteSin.setSize(new Dimension(215, 18));
            this.jLabeImporteSin.setLocation(new Point(101, 396));
            this.jLabeFechaAdjudicacion = new JLabel();
            this.jLabeFechaAdjudicacion.setText("Fecha adjudicaci\u00f3n (dd-mm-aaaa):");
            this.jLabeFechaAdjudicacion.setSize(new Dimension(238, 18));
            this.jLabeFechaAdjudicacion.setLocation(new Point(101, 366));
            this.jLabelLicitador = new JLabel();
            this.jLabelLicitador.setText("Adjudicatario");
            this.jLabelLicitador.setSize(new Dimension(288, 35));
            this.jLabelLicitador.setLocation(new Point(25, 79));
            this.jLabelLicitador.setFont(new Font("Dialog", 1, 18));
            this.jLabelDatosLic = new JLabel();
            this.jLabelDatosLic.setText("Datos del licitador:");
            this.jLabelDatosLic.setLocation(new Point(61, 121));
            this.jLabelDatosLic.setSize(new Dimension(250, 18));
            this.getPanel().add(this.getJComboBoxNuts());
            this.getPanel().add(this.getJComboBoxPais());
            this.getPanel().add(this.getLblLugarDeEjecucin());
            this.jComboBoxPais.addItemListener(new ComboListenerCountry(this.jComboBoxPais, this.jComboBoxNuts));
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.setSize(new Dimension(800, 600));
            this.jPanelContenido.add((Component)this.jLabelDatosLic, null);
            this.jPanelContenido.add((Component)this.jLabelLicitador, null);
            this.jPanelContenido.add((Component)this.jLabeFechaAdjudicacion, null);
            this.jPanelContenido.add((Component)this.jLabeImporteSin, null);
            this.jPanelContenido.add((Component)this.jLabeImporteCon, null);
            this.jPanelContenido.add((Component)this.jLabelFinFormalizacion, null);
            this.getPanel().add(this.getJTextFieldNombre());
            this.getPanel().add(this.getJTextAreaMotivacion());
            this.getPanel().add(this.getJTextFieldImporteSin());
            this.getPanel().add(this.getJTextFieldImporteCon());
            this.getPanel().add(this.getJComboBoxTipoIdentificador());
            this.getPanel().add(this.getJTextFieldIdentificador());
            this.getPanel().add(this.getJTextFieldFechaAdj());
            this.getPanel().add(this.getJTextFieldFechaFinForm());
            JLabel lblNmeroDeOfertas = new JLabel("Ofertas recibidas");
            lblNmeroDeOfertas.setBounds(97, 486, 285, 14);
            this.getPanel().add(lblNmeroDeOfertas);
            this.jtextFieldNumOfertasRecibidas = new JTextField();
            this.jtextFieldNumOfertasRecibidas.setBounds(429, 484, 86, 20);
            this.getPanel().add(this.jtextFieldNumOfertasRecibidas);
            this.jtextFieldNumOfertasRecibidas.setColumns(10);
            JLabel lblNumeroOfertasPymes = new JLabel("Ofertas recibidas de PYMEs");
            lblNumeroOfertasPymes.setBounds(97, 511, 285, 14);
            this.getPanel().add(lblNumeroOfertasPymes);
            this.jtextFieldnumOfertasPymes = new JTextField();
            this.jtextFieldnumOfertasPymes.setColumns(10);
            this.jtextFieldnumOfertasPymes.setBounds(429, 509, 86, 20);
            this.getPanel().add(this.jtextFieldnumOfertasPymes);
            JLabel lblnumOfertasExtranjerosUE = new JLabel("Ofertas recibidas extranjeros comunitarios (UE)");
            lblnumOfertasExtranjerosUE.setBounds(97, 534, 285, 14);
            this.getPanel().add(lblnumOfertasExtranjerosUE);
            JLabel lblnumOfertasExtranjerosNoUE = new JLabel("Ofertas recibidas extranjeros extracomunitarios (No UE)");
            lblnumOfertasExtranjerosNoUE.setBounds(97, 559, 285, 14);
            this.getPanel().add(lblnumOfertasExtranjerosNoUE);
            JLabel lblnumOfertasElectronicas = new JLabel("Ofertas electr\u00f3nicas recibidas");
            lblnumOfertasElectronicas.setBounds(97, 583, 285, 14);
            this.getPanel().add(lblnumOfertasElectronicas);
            this.jtextFieldnumOfertasExtranjerosUE = new JTextField();
            this.jtextFieldnumOfertasExtranjerosUE.setColumns(10);
            this.jtextFieldnumOfertasExtranjerosUE.setBounds(429, 532, 86, 20);
            this.getPanel().add(this.jtextFieldnumOfertasExtranjerosUE);
            this.jtextFieldnumOfertasExtranjerosNoUE = new JTextField();
            this.jtextFieldnumOfertasExtranjerosNoUE.setColumns(10);
            this.jtextFieldnumOfertasExtranjerosNoUE.setBounds(429, 557, 86, 20);
            this.getPanel().add(this.jtextFieldnumOfertasExtranjerosNoUE);
            this.jtextFieldnumOfertasElectronicas = new JTextField();
            this.jtextFieldnumOfertasElectronicas.setColumns(10);
            this.jtextFieldnumOfertasElectronicas.setBounds(429, 581, 86, 20);
            this.getPanel().add(this.jtextFieldnumOfertasElectronicas);
            this.jLabelLugarDatosAdj = new JLabel();
            this.jLabelLugarDatosAdj.setBounds(63, 308, 230, 16);
            this.getPanel().add(this.jLabelLugarDatosAdj);
            this.jLabelLugarDatosAdj.setText("Datos de la adjudicaci\u00f3n:");
            JLabel lblAdjudicatarioPyme = new JLabel();
            lblAdjudicatarioPyme.setText("El adjudicatario es una PYME");
            lblAdjudicatarioPyme.setSize(new Dimension(215, 18));
            lblAdjudicatarioPyme.setLocation(new Point(97, 149));
            lblAdjudicatarioPyme.setBounds(97, 187, 215, 18);
            this.getPanel().add(lblAdjudicatarioPyme);
            this.jComboBoxEsPyme.setBounds(422, 187, 100, 18);
            this.getPanel().add(this.jComboBoxEsPyme);
            JLabel lblnumOfertasBajas = new JLabel("Se han recibido ofertas anormalmente bajas");
            lblnumOfertasBajas.setBounds(97, 611, 285, 14);
            this.getPanel().add(lblnumOfertasBajas);
            this.jComboBoxOfertasBajas.setBounds(429, 612, 86, 20);
            this.getPanel().add(this.jComboBoxOfertasBajas);
            this.getPanel().add(this.getLblPasOrigenDel());
            this.getPanel().add(this.getComboBoxPaisOrigen());
            this.txtDescripcionLimiteFormalizacion = new JTextField();
            this.txtDescripcionLimiteFormalizacion.setText("Descripci\u00f3n...");
            this.txtDescripcionLimiteFormalizacion.setBounds(564, 454, 349, 38);
            this.getPanel().add(this.txtDescripcionLimiteFormalizacion);
            this.jLabeMotivacion = new JLabel();
            this.jLabeMotivacion.setBounds(97, 335, 215, 18);
            this.getPanel().add(this.jLabeMotivacion);
            this.jLabeMotivacion.setText("Motivaci\u00f3n:");
            this.jLabelNombreLic = new JLabel();
            this.jLabelNombreLic.setBounds(97, 138, 215, 18);
            this.getPanel().add(this.jLabelNombreLic);
            this.jLabelNombreLic.setText("Nombre:");
            this.jLabeIdentificador = new JLabel();
            this.jLabeIdentificador.setBounds(97, 158, 215, 18);
            this.getPanel().add(this.jLabeIdentificador);
            this.jLabeIdentificador.setText("Identificador:");
            this.getPanel().add(this.getLblDireccin());
            this.jtextFieldDireccion = new JTextField();
            this.jtextFieldDireccion.setBounds(422, 215, 422, 18);
            this.getPanel().add(this.jtextFieldDireccion);
            JLabel lblCiudad = new JLabel();
            lblCiudad.setText("Ciudad");
            lblCiudad.setSize(new Dimension(215, 18));
            lblCiudad.setLocation(new Point(97, 149));
            lblCiudad.setBounds(97, 245, 215, 18);
            this.getPanel().add(lblCiudad);
            this.jtextFieldCiudad = new JTextField();
            this.jtextFieldCiudad.setBounds(422, 244, 173, 18);
            this.getPanel().add(this.jtextFieldCiudad);
            JLabel lblCdigoPostal = new JLabel();
            lblCdigoPostal.setText("C\u00f3digo Postal");
            lblCdigoPostal.setSize(new Dimension(215, 18));
            lblCdigoPostal.setLocation(new Point(97, 149));
            lblCdigoPostal.setBounds(637, 244, 79, 18);
            this.getPanel().add(lblCdigoPostal);
            this.jtextFieldCodigoPostal = new JTextField();
            this.jtextFieldCodigoPostal.setBounds(726, 245, 118, 18);
            this.getPanel().add(this.jtextFieldCodigoPostal);
        }
        return this.jPanelContenido;
    }

    private JTextField getJTextFieldNombre() {
        if (this.jTextFieldNombre == null) {
            this.jTextFieldNombre = new JTextField();
            this.jTextFieldNombre.setBounds(422, 138, 422, 18);
        }
        return this.jTextFieldNombre;
    }

    private JTextPane getJTextAreaMotivacion() {
        if (this.jTextAreaMotivacion == null) {
            this.jTextAreaMotivacion = new JTextPane();
            this.jTextAreaMotivacion.setBounds(429, 324, 484, 29);
            this.jTextAreaMotivacion.setBackground(SystemColor.control);
            this.jTextAreaMotivacion.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        return this.jTextAreaMotivacion;
    }

    private JTextField getJTextFieldImporteSin() {
        if (this.jTextFieldImporteSin == null) {
            this.jTextFieldImporteSin = new JTextField();
            this.jTextFieldImporteSin.setBounds(429, 395, 250, 18);
        }
        return this.jTextFieldImporteSin;
    }

    private JTextField getJTextFieldImporteCon() {
        if (this.jTextFieldImporteCon == null) {
            this.jTextFieldImporteCon = new JTextField();
            this.jTextFieldImporteCon.setBounds(429, 425, 250, 18);
        }
        return this.jTextFieldImporteCon;
    }

    private JTextField getJTextFieldFechaAdj() {
        if (this.jTextFieldFechaAdj == null) {
            this.jTextFieldFechaAdj = new JTextField();
            this.jTextFieldFechaAdj.setBounds(429, 365, 250, 18);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            this.jTextFieldFechaAdj.setText(dateFormat.format(new Date()));
        }
        return this.jTextFieldFechaAdj;
    }

    private JTextField getJTextFieldFechaFinForm() {
        if (this.jTextFieldFechaFinForm == null) {
            this.jTextFieldFechaFinForm = new JTextField();
            this.jTextFieldFechaFinForm.setBounds(429, 455, 118, 18);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
            this.jTextFieldFechaFinForm.setText(dateFormat.format(new Date()));
        }
        return this.jTextFieldFechaFinForm;
    }

    private JComboBox<String> getJComboBoxTipoIdentificador() {
        if (this.jComboBoxTipoIdentificador == null) {
            this.jComboBoxTipoIdentificador = new JComboBox();
            this.jComboBoxTipoIdentificador.setBounds(422, 158, 100, 18);
        }
        return this.jComboBoxTipoIdentificador;
    }

    private JTextField getJTextFieldIdentificador() {
        if (this.jTextFieldIdentificador == null) {
            this.jTextFieldIdentificador = new JTextField();
            this.jTextFieldIdentificador.setBounds(532, 158, 140, 18);
        }
        return this.jTextFieldIdentificador;
    }

    public LicitadorBean getLicitador() {
        if (this.licitador == null) {
            this.licitador = new LicitadorBean();
        }
        this.licitador.setNombre(this.jTextFieldNombre.getText());
        this.licitador.setTipoIdentificador((String)this.jComboBoxTipoIdentificador.getSelectedItem());
        this.licitador.setIdtipoIdentificador(this.jComboBoxTipoIdentificador.getSelectedIndex());
        this.licitador.setIdentificador(this.jTextFieldIdentificador.getText());
        if (this.jComboBoxEsPyme.getSelectedItem().toString().length() > 0) {
            this.licitador.setAdjudicatarioPyme(Boolean.valueOf(ComboBoxUtils.getComboBoxByConstant("/Si_No.gc")[this.jComboBoxEsPyme.getSelectedIndex() - 1][1]));
        }
        this.licitador.setMotivacion(this.jTextAreaMotivacion.getText());
        Date fechaAdj = null;
        if (this.jTextFieldFechaAdj.getText().length() > 0) {
            try {
                fechaAdj = new SimpleDateFormat("dd-MM-yyyy").parse(this.jTextFieldFechaAdj.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha de apertura de ofertas");
            }
        }
        this.licitador.setFechaAdjudicacion(fechaAdj);
        this.licitador.setImporteSinImpuestos(this.jTextFieldImporteSin.getText());
        this.licitador.setImporteConImpuestos(this.jTextFieldImporteCon.getText());
        if (this.jtextFieldNumOfertasRecibidas.getText().length() > 0) {
            this.licitador.setNumOfertasRecibidas(Integer.parseInt(this.jtextFieldNumOfertasRecibidas.getText()));
        }
        Date fechaFinForm = null;
        if (this.jTextFieldFechaFinForm.getText().length() > 0) {
            try {
                fechaFinForm = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(this.jTextFieldFechaFinForm.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha de apertura de ofertas");
            }
            this.licitador.setFechaFinFormalizacion(fechaFinForm);
        }
        if (this.jtextFieldnumOfertasPymes.getText().length() > 0) {
            this.licitador.setNumOfertasRecibidasPymes(Integer.parseInt(this.jtextFieldnumOfertasPymes.getText()));
        }
        if (this.jtextFieldnumOfertasExtranjerosUE.getText().length() > 0) {
            this.licitador.setNumOfertasExtranjerosUE(Integer.parseInt(this.jtextFieldnumOfertasExtranjerosUE.getText()));
        }
        if (this.jtextFieldnumOfertasExtranjerosNoUE.getText().length() > 0) {
            this.licitador.setNumOfertasExtranjerosNoUE(Integer.parseInt(this.jtextFieldnumOfertasExtranjerosNoUE.getText()));
        }
        if (this.jtextFieldnumOfertasElectronicas.getText().length() > 0) {
            this.licitador.setNumOfertasElectronicas(Integer.parseInt(this.jtextFieldnumOfertasElectronicas.getText()));
        }
        if (this.jComboBoxOfertasBajas.getSelectedItem().toString().length() > 0) {
            this.licitador.setOfertasBajas(Boolean.valueOf(ComboBoxUtils.getComboBoxByConstant("/Si_No.gc")[this.jComboBoxOfertasBajas.getSelectedIndex() - 1][1]));
        }
        if (this.comboBoxPaisOrigen.getSelectedItem().toString().length() > 0) {
            this.licitador.setPaisOrigen(ComboBoxUtils.getComboBoxByConstant("http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc")[this.comboBoxPaisOrigen.getSelectedIndex() - 1][1]);
        }
        this.licitador.setIdPaisOrigen(this.comboBoxPaisOrigen.getSelectedIndex() - 1);
        this.licitador.setPais((String)this.jComboBoxPais.getSelectedItem());
        this.licitador.setIdPais(this.jComboBoxPais.getSelectedIndex());
        if (this.jComboBoxNuts.getSelectedIndex() > 0) {
            String nutsSeleccionado = (String)this.jComboBoxNuts.getSelectedItem();
            this.licitador.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(") - 1));
            this.licitador.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(") + 1, nutsSeleccionado.length() - 1));
        }
        this.licitador.setDescripcionLimiteFormalizacion(this.txtDescripcionLimiteFormalizacion.getText());
        this.licitador.setDireccion(this.jtextFieldDireccion.getText());
        this.licitador.setCiudad(this.jtextFieldCiudad.getText());
        this.licitador.setCodigoPostal(this.jtextFieldCodigoPostal.getText());
        return this.licitador;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
            this.setVisible(false);
            this.getLicitador();
            this.gestorVentanasFormCD[0].setVisible(true);
            SessionDataManager.getInstance();
            ExpedienteBean expediente = SessionDataManager.getExpediente();
            expediente.setLicitador(this.getLicitador());
            SessionDataManager.getInstance();
            SessionDataManager.setExpediente(expediente);
        }
    }

    private void escribeDatosLicitador() {
        LicitadorBean licitador = this.expediente.getLicitador();
        if (licitador != null) {
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MM-yyyy HH:mm");
            this.jTextFieldNombre.setText(licitador.getNombre());
            this.jComboBoxTipoIdentificador.setSelectedIndex(licitador.getIdtipoIdentificador());
            this.jTextFieldIdentificador.setText(licitador.getIdentificador());
            this.jTextAreaMotivacion.setText(licitador.getMotivacion());
            if (licitador.getFechaAdjudicacion() != null) {
                this.jTextFieldFechaAdj.setText(df.format(licitador.getFechaAdjudicacion()));
            }
            this.jTextFieldImporteSin.setText(licitador.getImporteSinImpuestos());
            this.jTextFieldImporteCon.setText(licitador.getImporteConImpuestos());
            if (licitador.getFechaFinFormalizacion() != null) {
                this.jTextFieldFechaFinForm.setText(df2.format(licitador.getFechaFinFormalizacion()));
            }
            if (licitador.getNumOfertasRecibidas() != null) {
                this.jtextFieldNumOfertasRecibidas.setText(licitador.getNumOfertasRecibidas().toString());
            }
            if (licitador.getNumOfertasRecibidasPymes() != null) {
                this.jtextFieldnumOfertasPymes.setText(licitador.getNumOfertasRecibidasPymes().toString());
            }
            if (licitador.getNumOfertasExtranjerosUE() != null) {
                this.jtextFieldnumOfertasExtranjerosUE.setText(licitador.getNumOfertasExtranjerosUE().toString());
            }
            if (licitador.getNumOfertasExtranjerosNoUE() != null) {
                this.jtextFieldnumOfertasExtranjerosNoUE.setText(licitador.getNumOfertasExtranjerosNoUE().toString());
            }
            if (licitador.getNumOfertasElectronicas() != null) {
                this.jtextFieldnumOfertasElectronicas.setText(licitador.getNumOfertasElectronicas().toString());
            }
            if (licitador.getOfertasBajas() != null) {
                if (licitador.getOfertasBajas().booleanValue()) {
                    this.jComboBoxOfertasBajas.setSelectedIndex(1);
                } else {
                    this.jComboBoxOfertasBajas.setSelectedIndex(2);
                }
            }
            this.comboBoxPaisOrigen.setSelectedIndex(licitador.getIdPaisOrigen() + 1);
            this.jComboBoxPais.setSelectedIndex(licitador.getIdPais());
            this.jComboBoxNuts.setSelectedItem(licitador.getIdNuts());
            this.txtDescripcionLimiteFormalizacion.setText(licitador.getDescripcionLimiteFormalizacion());
            this.jtextFieldDireccion.setText(licitador.getDireccion());
            this.jtextFieldCiudad.setText(licitador.getCiudad());
            this.jtextFieldCodigoPostal.setText(licitador.getCodigoPostal());
        } else {
            this.jComboBoxPais.setSelectedIndex(9);
            this.jComboBoxNuts.setSelectedItem("ES");
        }
    }

    public void cargarDatosComboBoxs() {
        ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(this.jComboBoxEsPyme, "/Si_No.gc");
        ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(this.jComboBoxOfertasBajas, "/Si_No.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxTipoIdentificador, "http://contrataciondelestado.es/codice/cl/2.0/PartyIdentificationSchemeID-2.0.gc");
        ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(this.comboBoxPaisOrigen, "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxPais, "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc");
    }

    private JLabel getLblPasOrigenDel() {
        if (this.lblPasOrigenDel == null) {
            this.lblPasOrigenDel = new JLabel("Pa\u00eds origen del producto/servicio");
            this.lblPasOrigenDel.setBounds(97, 639, 285, 14);
        }
        return this.lblPasOrigenDel;
    }

    private JComboBox<String> getComboBoxPaisOrigen() {
        if (this.comboBoxPaisOrigen == null) {
            this.comboBoxPaisOrigen = new JComboBox();
            this.comboBoxPaisOrigen.setBounds(429, 643, 201, 20);
        }
        return this.comboBoxPaisOrigen;
    }

    private JComboBox getJComboBoxPais() {
        if (this.jComboBoxPais == null) {
            this.jComboBoxPais = new JComboBox();
            this.jComboBoxPais.setBounds(422, 272, 181, 18);
        }
        return this.jComboBoxPais;
    }

    private JComboBox getJComboBoxNuts() {
        if (this.jComboBoxNuts == null) {
            this.jComboBoxNuts = new JComboBox();
            this.jComboBoxNuts.setBounds(639, 272, 205, 18);
        }
        return this.jComboBoxNuts;
    }

    private JLabel getLblLugarDeEjecucin() {
        if (this.lblLugarDeEjecucin == null) {
            this.lblLugarDeEjecucin = new JLabel("Pais / Nuts");
            this.lblLugarDeEjecucin.setBounds(97, 274, 230, 14);
        }
        return this.lblLugarDeEjecucin;
    }

    private JLabel getLblDireccin() {
        if (this.lblDireccin == null) {
            this.lblDireccin = new JLabel();
            this.lblDireccin.setText("Direcci\u00f3n");
            this.lblDireccin.setSize(new Dimension(215, 18));
            this.lblDireccin.setLocation(new Point(97, 149));
            this.lblDireccin.setBounds(97, 216, 215, 18);
        }
        return this.lblDireccin;
    }
}

