/*
 * Decompiled with CFR 0.152.
 */
package es.dgpe.place.client.windows.publication.service.commons;

import es.dgpe.place.client.beans.DatosModificacionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

public class ModificacionContratoForm
extends ThemeJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelContenido = null;
    JFrame[] gestorVentanasFormCD = new JFrame[2];
    private String tipoDocumento = null;
    private JLabel jLabelNumeroModificacion = null;
    private JLabel jLabelDuracion = null;
    private JTextField jTextFieldNumeroModificacion = null;
    private JTextField jTextFieldFechaModificacion;
    private JTextField jTextFieldIncSinImpuetos;
    private JTextField jTextFieldIncConImpuetos;
    private JTextField jTextFieldImporteFinalSinImpuestos;
    private JTextField jTextFieldImporteFinalConImpuestos;
    private JTextField jTextFieldDuracionFinal;
    private JTextField jTextFieldIncrementoDuracion;
    private JComboBox<String> jComboBoxUnidadDuracion;
    private JComboBox<String> jComboBoxUnidadIncremento;
    private JComboBox<String> comboBoxCodigoTipoModificacion;
    private JTextArea txtrAas;
    private JTextField textFieldJustificacion;

    public DatosModificacionBean getDatosModificacion() {
        DatosModificacionBean datosModificacion = new DatosModificacionBean();
        datosModificacion.setNumeroModificiacion(this.jTextFieldNumeroModificacion.getText());
        if (this.jTextFieldFechaModificacion.getText().length() > 0) {
            Date fechaModificacion = null;
            try {
                fechaModificacion = new SimpleDateFormat("dd-MM-yyyy").parse(this.jTextFieldFechaModificacion.getText());
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la fecha de inicio del contrato");
            }
            datosModificacion.setFechaModificacion(fechaModificacion);
        }
        if (this.jTextFieldIncSinImpuetos.getText().length() > 0) {
            BigDecimal incrementoSinImpuestos = null;
            try {
                incrementoSinImpuestos = new BigDecimal(this.jTextFieldIncSinImpuetos.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Error en el formato del importe del incremento sin impuestos");
            }
            datosModificacion.setIncrementoSinImpuestos(incrementoSinImpuestos);
        }
        if (this.jTextFieldIncConImpuetos.getText().length() > 0) {
            BigDecimal incrementoConImpuestos = null;
            try {
                incrementoConImpuestos = new BigDecimal(this.jTextFieldIncConImpuetos.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Error en el formato del importe del incremento con impuestos");
            }
            datosModificacion.setIncrementoConImpuestos(incrementoConImpuestos);
        }
        if (this.jTextFieldImporteFinalSinImpuestos.getText().length() > 0) {
            BigDecimal finalSinImpuestos = null;
            try {
                finalSinImpuestos = new BigDecimal(this.jTextFieldImporteFinalSinImpuestos.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Error en el formato del importe final sin impuestos");
            }
            datosModificacion.setImporteTotalSinImpuestos(finalSinImpuestos);
        }
        if (this.jTextFieldImporteFinalConImpuestos.getText().length() > 0) {
            BigDecimal finalConImpuestos = null;
            try {
                finalConImpuestos = new BigDecimal(this.jTextFieldImporteFinalConImpuestos.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Error en el formato del importe final con impuestos");
            }
            datosModificacion.setImporteTotalConImpuestos(finalConImpuestos);
        }
        if (this.jTextFieldIncrementoDuracion.getText().length() > 0) {
            BigDecimal incrementoDuracion = null;
            try {
                incrementoDuracion = new BigDecimal(this.jTextFieldIncrementoDuracion.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Error en el formato del incremento de la duraci\u00f3n");
            }
            datosModificacion.setIncrementoDuracion(incrementoDuracion);
            datosModificacion.setUnidadDuracionIncremento(this.jComboBoxUnidadIncremento.getSelectedIndex());
        }
        if (this.jTextFieldDuracionFinal.getText().length() > 0) {
            BigDecimal duracionFinal = null;
            try {
                duracionFinal = new BigDecimal(this.jTextFieldDuracionFinal.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Error en el formato de la duraci\u00f3n final");
            }
            datosModificacion.setDuracionTotal(duracionFinal);
            datosModificacion.setUnidadDuracionTotal(this.jComboBoxUnidadDuracion.getSelectedIndex());
        }
        datosModificacion.setDescripcion(this.txtrAas.getText());
        datosModificacion.setCodigoMotivoModificacion(this.comboBoxCodigoTipoModificacion.getSelectedIndex());
        datosModificacion.setJustificacionModificacion(this.textFieldJustificacion.getText());
        return datosModificacion;
    }

    public ModificacionContratoForm(JFrame ventanaPadre, String tipoDocumento) throws ModelException {
        this.initialize();
        this.gestorVentanasFormCD[0] = ventanaPadre;
        this.gestorVentanasFormCD[1] = null;
        this.tipoDocumento = tipoDocumento;
        this.cargarDatosComboBoxs();
        this.setHasButtonPrev(true);
        if (this.isHasButtonPrev()) {
            this.jPanelContenido.add((Component)this.getJButtonAnterior(), null);
            this.getJButtonAnterior().addActionListener(this);
        }
    }

    private void initialize() {
        this.getJPanelContenido();
        this.setTitle("Datos de Modificaci\u00f3n");
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJPanelContenido() {
        if (this.jPanelContenido == null) {
            this.jPanelContenido = super.getPanel();
            this.jPanelContenido.setLayout(null);
            this.jPanelContenido.setBackground(Color.white);
            this.jPanelContenido.setSize(new Dimension(800, 600));
            this.jLabelDuracion = new JLabel();
            this.jLabelDuracion.setText("Modifiaci\u00f3n de datos de Contrato");
            this.jLabelDuracion.setBounds(72, 87, 275, 14);
            this.jLabelNumeroModificacion = new JLabel();
            this.jLabelNumeroModificacion.setBounds(50, 114, 318, 14);
            this.getPanel().add(this.jLabelNumeroModificacion);
            this.jLabelNumeroModificacion.setText("N\u00famero de Modificaci\u00f3n(*)");
            JLabel jLabelFechaDeModificacin = new JLabel();
            jLabelFechaDeModificacin.setText("Fecha de Modificaci\u00f3n (dd-mm-aaaa)(*)");
            jLabelFechaDeModificacin.setBounds(50, 139, 318, 14);
            this.getPanel().add(jLabelFechaDeModificacin);
            this.jTextFieldNumeroModificacion = new JTextField();
            this.jTextFieldNumeroModificacion.setBounds(300, 112, 89, 18);
            this.getPanel().add(this.jTextFieldNumeroModificacion);
            this.jTextFieldFechaModificacion = new JTextField();
            this.jTextFieldFechaModificacion.setBounds(300, 139, 89, 18);
            this.getPanel().add(this.jTextFieldFechaModificacion);
            JPanel panel_1 = new JPanel();
            panel_1.setLayout(null);
            panel_1.setBorder(new TitledBorder(null, "Modificaci\u00f3n del importe", 4, 2, new Font("Tahoma", 1, 11)));
            panel_1.setBounds(50, 233, 666, 185);
            this.getPanel().add(panel_1);
            JLabel jLabelIncSinImpuetos = new JLabel();
            jLabelIncSinImpuetos.setText("Incremento/decremento del importe sin impuestos");
            jLabelIncSinImpuetos.setBounds(21, 49, 474, 14);
            panel_1.add(jLabelIncSinImpuetos);
            this.jTextFieldIncSinImpuetos = new JTextField();
            this.jTextFieldIncSinImpuetos.setBounds(340, 49, 122, 18);
            panel_1.add(this.jTextFieldIncSinImpuetos);
            JLabel jLabelIncConImpuetos = new JLabel();
            jLabelIncConImpuetos.setText("Incremento/decremento del importe con impuestos");
            jLabelIncConImpuetos.setBounds(21, 74, 474, 14);
            panel_1.add(jLabelIncConImpuetos);
            JLabel jLabelImporteFinalSinImpuestos = new JLabel();
            jLabelImporteFinalSinImpuestos.setText("Importe sin impuestos total tras la modificacion");
            jLabelImporteFinalSinImpuestos.setBounds(21, 120, 474, 14);
            panel_1.add(jLabelImporteFinalSinImpuestos);
            JLabel jLabelImporteFinalConImpuestos = new JLabel();
            jLabelImporteFinalConImpuestos.setText("Importe con impuestos total tras la modificacion");
            jLabelImporteFinalConImpuestos.setBounds(21, 145, 474, 14);
            panel_1.add(jLabelImporteFinalConImpuestos);
            this.jTextFieldIncConImpuetos = new JTextField();
            this.jTextFieldIncConImpuetos.setBounds(340, 73, 122, 18);
            panel_1.add(this.jTextFieldIncConImpuetos);
            this.jTextFieldImporteFinalSinImpuestos = new JTextField();
            this.jTextFieldImporteFinalSinImpuestos.setBounds(340, 119, 122, 18);
            panel_1.add(this.jTextFieldImporteFinalSinImpuestos);
            this.jTextFieldImporteFinalConImpuestos = new JTextField();
            this.jTextFieldImporteFinalConImpuestos.setBounds(340, 144, 122, 18);
            panel_1.add(this.jTextFieldImporteFinalConImpuestos);
            JPanel panel = new JPanel();
            panel.setLayout(null);
            panel.setBorder(new TitledBorder(null, "Modificaci\u00f3n de la duraci\u00f3n", 4, 2, new Font("Tahoma", 1, 11)));
            panel.setBounds(50, 429, 666, 98);
            this.getPanel().add(panel);
            JLabel jLabelDuracionFinal = new JLabel();
            jLabelDuracionFinal.setText("Duraci\u00f3n total del contrato tras la modificaci\u00f3n");
            jLabelDuracionFinal.setBounds(23, 66, 419, 14);
            panel.add(jLabelDuracionFinal);
            this.jTextFieldDuracionFinal = new JTextField();
            this.jTextFieldDuracionFinal.setColumns(10);
            this.jTextFieldDuracionFinal.setBounds(300, 66, 68, 20);
            panel.add(this.jTextFieldDuracionFinal);
            this.jComboBoxUnidadDuracion = new JComboBox();
            this.jComboBoxUnidadDuracion.setBounds(380, 67, 68, 18);
            panel.add(this.jComboBoxUnidadDuracion);
            JLabel jLabelIncrementoDuracion = new JLabel();
            jLabelIncrementoDuracion.setText("Incremento/decremento duraci\u00f3n del contrato");
            jLabelIncrementoDuracion.setBounds(23, 35, 419, 14);
            panel.add(jLabelIncrementoDuracion);
            this.jTextFieldIncrementoDuracion = new JTextField();
            this.jTextFieldIncrementoDuracion.setColumns(10);
            this.jTextFieldIncrementoDuracion.setBounds(300, 35, 68, 20);
            panel.add(this.jTextFieldIncrementoDuracion);
            this.jComboBoxUnidadIncremento = new JComboBox();
            this.jComboBoxUnidadIncremento.setBounds(380, 35, 68, 18);
            panel.add(this.jComboBoxUnidadIncremento);
            JLabel jLabelDescripcion = new JLabel();
            jLabelDescripcion.setText("Descripci\u00f3n");
            jLabelDescripcion.setBounds(50, 538, 171, 14);
            this.getPanel().add(jLabelDescripcion);
            JTextPane textPane_1 = new JTextPane();
            textPane_1.setBounds(50, 560, 6, 20);
            this.getPanel().add(textPane_1);
            this.txtrAas = new JTextArea();
            this.txtrAas.setBackground(SystemColor.activeCaptionBorder);
            this.txtrAas.setForeground(Color.BLACK);
            this.txtrAas.setBounds(60, 565, 656, 77);
            this.getPanel().add(this.txtrAas);
            this.comboBoxCodigoTipoModificacion = new JComboBox();
            this.comboBoxCodigoTipoModificacion.setBounds(300, 162, 583, 18);
            this.getPanel().add(this.comboBoxCodigoTipoModificacion);
            this.textFieldJustificacion = new JTextField();
            this.textFieldJustificacion.setBounds(300, 191, 412, 18);
            this.getPanel().add(this.textFieldJustificacion);
            JLabel lblMotivoDeLa = new JLabel();
            lblMotivoDeLa.setText("Motivo de la modificaci\u00f3n");
            lblMotivoDeLa.setBounds(50, 164, 318, 14);
            this.getPanel().add(lblMotivoDeLa);
            JLabel lblJustificacion = new JLabel();
            lblJustificacion.setText("Justificacion");
            lblJustificacion.setBounds(50, 191, 318, 14);
            this.getPanel().add(lblJustificacion);
        }
        return this.jPanelContenido;
    }

    public void cargarDatosComboBoxs() {
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxUnidadDuracion, "http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.jComboBoxUnidadIncremento, "http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc");
        ComboBoxUtils.loadComboBoxFromConstant(this.comboBoxCodigoTipoModificacion, "http://contrataciondelestado.es/codice/cl/2.05/ContractModificationReasonCode-2.05.gc");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
            this.setVisible(false);
            this.getDatosModificacion();
            this.gestorVentanasFormCD[0].setVisible(true);
            if (this.tipoDocumento.equalsIgnoreCase("DOC_MODIF")) {
                SessionDataManager.getInstance();
                ExpedienteBean expediente = SessionDataManager.getExpediente();
                expediente.setDatosModificacion(this.getDatosModificacion());
                SessionDataManager.setExpediente(expediente);
            }
        }
    }
}

