/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider;

import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.WssProviderSecurityEnvironment;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.config.SecurityConfigurationXmlReader;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.provider.ConfigurationStates;
import com.sun.xml.wss.provider.ModuleOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.soap.SOAPMessage;

public class WssProviderAuthModule
implements ModuleOptions,
ConfigurationStates {
    protected boolean _DEBUG = false;
    protected SecurityPolicy _policy = null;
    protected WssProviderSecurityEnvironment _sEnvironment = null;
    private boolean runtimeUsernamePassword = false;
    public static final String DYNAMIC_USERNAME_PASSWORD = "DynamicUsernamePassword";
    private static final String SIGN_POLICY = "com.sun.xml.wss.impl.policy.mls.SignaturePolicy";
    private static final String ENCRYPT_POLICY = "com.sun.xml.wss.impl.policy.mls.EncryptionPolicy";
    private static final String TIMESTAMP_POLICY = "com.sun.xml.wss.impl.policy.mls.TimestampPolicy";
    private static final String AUTHENTICATION_POLICY = "com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy";
    private static final String USERNAMETOKEN_POLICY = "com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy.UsernameTokenBinding";
    private static final String USERNAMETOKEN = "UsernameToken";
    private static final String BODY = "Body";
    public static final String REQUESTER_SUBJECT = "REQUESTER_SUBJECT";
    public static final String REQUESTER_KEYID = "REQUESTER_KEYID";
    public static final String REQUESTER_ISSUERNAME = "REQUESTER_ISSUERNAME";
    public static final String REQUESTER_SERIAL = "REQUESTER_SERIAL";
    public static final String SELF_SUBJECT = "SELF_SUBJECT";
    protected int optimize = MessageConstants.NOT_OPTIMIZED;
    protected boolean configOptimizeAttribute = true;

    public void initialize(AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler, Map options, boolean isClientAuthModule) {
        String bg = (String)options.get("debug");
        if (bg != null && bg.equals("true")) {
            this._DEBUG = true;
        }
        String securityConfigurationURL = (String)options.get("security.config");
        try {
            String obj;
            this._policy = SecurityConfigurationXmlReader.createDeclarativeConfiguration((InputStream)new BufferedInputStream(new FileInputStream(new File(securityConfigurationURL))));
            int request_policy_state = 8;
            int response_policy_state = 8;
            if (requestPolicy != null) {
                request_policy_state = this.resolveConfigurationState(requestPolicy, true, isClientAuthModule);
            }
            if (responsePolicy != null) {
                response_policy_state = this.resolveConfigurationState(responsePolicy, false, isClientAuthModule);
            }
            if ((obj = (String)options.get(DYNAMIC_USERNAME_PASSWORD)) != null) {
                boolean bl = this.runtimeUsernamePassword = obj.equalsIgnoreCase("true");
            }
            if (isClientAuthModule) {
                this.augmentConfiguration(response_policy_state, true, handler);
                this.augmentConfiguration(request_policy_state, false, handler);
            } else {
                this.augmentConfiguration(response_policy_state, false, handler);
                this.augmentConfiguration(request_policy_state, true, handler);
            }
            this._sEnvironment = new WssProviderSecurityEnvironment(handler, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int resolveConfigurationState(AuthPolicy policy, boolean isRequestPolicy, boolean isClientAuthModule) {
        boolean orderForValidation = isClientAuthModule ? !isRequestPolicy : isRequestPolicy;
        boolean sourceAuthRequired = policy.isSourceAuthRequired();
        boolean recipientAuthRequired = policy.isRecipientAuthRequired();
        boolean senderAuthRequired = policy.isSenderAuthRequired();
        boolean contentAuthRequired = policy.isContentAuthRequired();
        boolean beforeContent = policy.isRecipientAuthBeforeContent(orderForValidation);
        int configurationState = -1;
        if (sourceAuthRequired && !recipientAuthRequired) {
            if (senderAuthRequired) {
                configurationState = 2;
            } else if (contentAuthRequired) {
                configurationState = 3;
            }
        } else if (!sourceAuthRequired && recipientAuthRequired) {
            configurationState = 1;
        } else if (sourceAuthRequired && recipientAuthRequired) {
            if (beforeContent) {
                if (senderAuthRequired) {
                    configurationState = 4;
                } else if (contentAuthRequired) {
                    configurationState = 6;
                }
            } else if (senderAuthRequired) {
                configurationState = 5;
            } else if (contentAuthRequired) {
                configurationState = 7;
            }
        } else {
            configurationState = 8;
        }
        if (configurationState == -1) {
            throw new RuntimeException("AuthPolicy configuration error: Invalid policy specification");
        }
        return configurationState;
    }

    private Collection getEncryptPolicies(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)policy) || this.hasEncryptUsernamePolicy((EncryptionPolicy)policy, mPolicy)) continue;
            requiredElements.add(policy);
        }
        if (requiredElements.isEmpty()) {
            throw new RuntimeException("Operation/Requirement (" + this.translate2configurationName(ENCRYPT_POLICY, senderConfiguration) + ") not specified " + "in the Config. file is required by the policy");
        }
        return requiredElements;
    }

    private Collection getEncryptPoliciesOptional(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)policy) || this.hasEncryptUsernamePolicy((EncryptionPolicy)policy, mPolicy)) continue;
            requiredElements.add(policy);
        }
        return requiredElements;
    }

    private Collection getSignPolicies(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.signaturePolicy((SecurityPolicy)policy)) continue;
            requiredElements.add(policy);
        }
        if (requiredElements.isEmpty()) {
            throw new RuntimeException("Operation/Requirement (" + this.translate2configurationName(SIGN_POLICY, senderConfiguration) + ") not specified " + "in the Config. file is required by the policy");
        }
        return requiredElements;
    }

    private WSSPolicy getUsernamePolicy(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        WSSPolicy usernamePolicy = null;
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.authenticationTokenPolicy((SecurityPolicy)policy) || policy.getFeatureBinding() == null || !PolicyTypeUtil.usernameTokenPolicy((SecurityPolicy)policy.getFeatureBinding())) continue;
            if (senderConfiguration && !this.runtimeUsernamePassword) {
                this.setUsernamePassword((AuthenticationTokenPolicy)policy, handler);
            }
            usernamePolicy = policy;
            break;
        }
        if (usernamePolicy == null) {
            throw new RuntimeException("Operation/Requirement (" + this.translate2configurationName(USERNAMETOKEN_POLICY, senderConfiguration) + ") not specified " + "in the Config. file is required by the policy");
        }
        return usernamePolicy;
    }

    private Collection getUsernamePolicies(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        WSSPolicy encryptUsernamePolicy = null;
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (PolicyTypeUtil.authenticationTokenPolicy((SecurityPolicy)policy)) {
                if (policy.getFeatureBinding() == null || !PolicyTypeUtil.usernameTokenPolicy((SecurityPolicy)policy.getFeatureBinding())) continue;
                if (senderConfiguration && !this.runtimeUsernamePassword) {
                    this.setUsernamePassword((AuthenticationTokenPolicy)policy, handler);
                }
                requiredElements.add(policy);
                continue;
            }
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)policy) || !this.isEncryptUsernamePolicy((EncryptionPolicy)policy, mPolicy)) continue;
            encryptUsernamePolicy = policy;
        }
        if (requiredElements.isEmpty()) {
            throw new RuntimeException("Operation/Requirement (" + this.translate2configurationName(USERNAMETOKEN_POLICY, senderConfiguration) + ") not specified " + "in the Config. file is required by the policy");
        }
        if (encryptUsernamePolicy != null) {
            requiredElements.add(encryptUsernamePolicy);
        }
        return requiredElements;
    }

    private Collection getEncryptUsernamePolicies(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        WSSPolicy eBU = this.getEncryptBodyUsernamePolicy(mPolicy);
        if (eBU != null) {
            Collection ePolicies = this.getNonBodyUsernameEncryptPolicies(mPolicy, handler, senderConfiguration);
            requiredElements.addAll(ePolicies);
            requiredElements.add(this.getUsernamePolicy(mPolicy, handler, senderConfiguration));
            requiredElements.add(eBU);
        } else {
            Collection ePolicies = this.getEncryptPoliciesOptional(mPolicy, handler, senderConfiguration);
            requiredElements.addAll(ePolicies);
            requiredElements.addAll(this.getUsernamePolicies(mPolicy, handler, senderConfiguration));
        }
        if (requiredElements.isEmpty()) {
            throw new RuntimeException("Operation/Requirement (" + this.translate2configurationName(ENCRYPT_POLICY, senderConfiguration) + ") not specified " + "in the Config. file is required by the policy");
        }
        return requiredElements;
    }

    private Collection getUsernameEncryptPolicies(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) throws PolicyGenerationException {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        WSSPolicy eUB = this.getEncryptUsernameBodyPolicy(mPolicy);
        if (eUB != null) {
            requiredElements.add(this.getUsernamePolicy(mPolicy, handler, senderConfiguration));
            requiredElements.add(eUB);
            Collection ePolicies = this.getNonBodyUsernameEncryptPolicies(mPolicy, handler, senderConfiguration);
            requiredElements.addAll(ePolicies);
        } else {
            requiredElements.addAll(this.getUsernamePolicies(mPolicy, handler, senderConfiguration));
            Collection ePolicies = this.getEncryptPoliciesOptional(mPolicy, handler, senderConfiguration);
            requiredElements.addAll(ePolicies);
        }
        if (requiredElements.isEmpty()) {
            throw new RuntimeException("Operation/Requirement (" + this.translate2configurationName(USERNAMETOKEN_POLICY, senderConfiguration) + ") not specified " + "in the Config. file is required by the policy");
        }
        return requiredElements;
    }

    private WSSPolicy getTimestampPolicy(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) {
        WSSPolicy timestampPolicy = null;
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.timestampPolicy((SecurityPolicy)policy)) continue;
            timestampPolicy = policy;
            break;
        }
        return timestampPolicy;
    }

    private void augmentConfiguration(int requiredState, boolean modifyReceiverSettings, CallbackHandler handler) throws PolicyGenerationException {
        MessagePolicy mPolicy = null;
        DeclarativeSecurityConfiguration dConfiguration = (DeclarativeSecurityConfiguration)this._policy;
        boolean senderConfiguration = false;
        if (requiredState == 8) {
            if (modifyReceiverSettings) {
                mPolicy = dConfiguration.receiverSettings();
                mPolicy.removeAll();
            } else {
                mPolicy = dConfiguration.senderSettings();
                mPolicy.removeAll();
            }
            return;
        }
        if (modifyReceiverSettings) {
            mPolicy = dConfiguration.receiverSettings();
        } else {
            mPolicy = dConfiguration.senderSettings();
            senderConfiguration = !senderConfiguration;
        }
        Collection newMPolicy = null;
        WSSPolicy ts = this.getTimestampPolicy(mPolicy, handler, senderConfiguration);
        switch (requiredState) {
            case 1: {
                newMPolicy = this.getEncryptPolicies(mPolicy, handler, senderConfiguration);
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                break;
            }
            case 2: {
                newMPolicy = this.getUsernamePolicies(mPolicy, handler, senderConfiguration);
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                if (modifyReceiverSettings || !this.configOptimizeAttribute) break;
                this.optimize = MessageConstants.SECURITY_HEADERS;
                break;
            }
            case 3: {
                newMPolicy = this.getSignPolicies(mPolicy, handler, senderConfiguration);
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                if (modifyReceiverSettings || !this.configOptimizeAttribute) break;
                this.optimize = MessageConstants.SIGN_BODY;
                break;
            }
            case 4: {
                newMPolicy = this.getEncryptUsernamePolicies(mPolicy, handler, senderConfiguration);
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                break;
            }
            case 5: {
                newMPolicy = this.getUsernameEncryptPolicies(mPolicy, handler, senderConfiguration);
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                break;
            }
            case 6: {
                newMPolicy = this.getEncryptPolicies(mPolicy, handler, senderConfiguration);
                newMPolicy.addAll(this.getSignPolicies(mPolicy, handler, senderConfiguration));
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                break;
            }
            case 7: {
                newMPolicy = this.getSignPolicies(mPolicy, handler, senderConfiguration);
                newMPolicy.addAll(this.getEncryptPolicies(mPolicy, handler, senderConfiguration));
                mPolicy.removeAll();
                mPolicy.appendAll(newMPolicy);
                if (modifyReceiverSettings || !this.configOptimizeAttribute) break;
                this.optimize = MessageConstants.SIGN_ENCRYPT_BODY;
                break;
            }
        }
        if (ts != null) {
            mPolicy.prepend((SecurityPolicy)ts);
        }
    }

    private String translate2configurationName(String opName, boolean senderConfiguration) {
        String value = null;
        if (opName == SIGN_POLICY) {
            value = senderConfiguration ? "xwss:Sign" : "xwss:RequireSignature";
        } else if (opName == ENCRYPT_POLICY) {
            value = senderConfiguration ? "xwss:Encrypt" : "xwss:RequireEncryption";
        } else if (opName == USERNAMETOKEN_POLICY) {
            value = senderConfiguration ? "xwss:UsernameToken" : "xwss:RequireUsernameToken";
        }
        return value;
    }

    private boolean isEncryptUsernamePolicy(EncryptionPolicy policy, MessagePolicy mPolicy) {
        EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
        int numTargets = fb.getTargetBindings().size();
        if (numTargets != 1) {
            return false;
        }
        Iterator it1 = fb.getTargetBindings().iterator();
        Target target = (Target)it1.next();
        if (target.getType() == "uri") {
            return this.uriIsUsernameToken(mPolicy, target.getValue());
        }
        int idx = target.getValue().indexOf(USERNAMETOKEN);
        return idx > -1;
    }

    private boolean hasEncryptUsernamePolicy(EncryptionPolicy policy, MessagePolicy mPolicy) {
        EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
        int numTargets = fb.getTargetBindings().size();
        Iterator it = fb.getTargetBindings().iterator();
        while (it.hasNext()) {
            Target target = (Target)it.next();
            if (target.getType() == "uri") {
                return this.uriIsUsernameToken(mPolicy, target.getValue());
            }
            int idx = target.getValue().indexOf(USERNAMETOKEN);
            if (idx <= -1) continue;
            return true;
        }
        return false;
    }

    private boolean uriIsUsernameToken(MessagePolicy mPolicy, String uri) {
        String fragment = uri;
        if (uri.startsWith("#")) {
            fragment = uri.substring(1);
        }
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            AuthenticationTokenPolicy.UsernameTokenBinding fb;
            MLSPolicy feature;
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.authenticationTokenPolicy((SecurityPolicy)policy) || (feature = policy.getFeatureBinding()) == null || !PolicyTypeUtil.usernameTokenPolicy((SecurityPolicy)feature) || !fragment.equals((fb = (AuthenticationTokenPolicy.UsernameTokenBinding)feature).getUUID())) continue;
            return true;
        }
        return false;
    }

    private WSSPolicy getEncryptBodyUsernamePolicy(MessagePolicy mPolicy) {
        WSSPolicy ret = null;
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            EncryptionPolicy.FeatureBinding fb;
            int numTargets;
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)policy) || (numTargets = (fb = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding()).getTargetBindings().size()) <= 1 || !this.hasBodyFollowedByUsername(fb.getTargetBindings())) continue;
            ret = policy;
            return ret;
        }
        return ret;
    }

    private WSSPolicy getEncryptUsernameBodyPolicy(MessagePolicy mPolicy) {
        WSSPolicy ret = null;
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            EncryptionPolicy.FeatureBinding fb;
            int numTargets;
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)policy) || (numTargets = (fb = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding()).getTargetBindings().size()) <= 1 || !this.hasUsernameFollowedByBody(fb.getTargetBindings())) continue;
            ret = policy;
            return ret;
        }
        return ret;
    }

    private boolean hasUsernameFollowedByBody(ArrayList targets) {
        Target t = (Target)targets.get(0);
        int idx = t.getValue().indexOf(USERNAMETOKEN);
        return idx != -1;
    }

    private boolean hasBodyFollowedByUsername(ArrayList targets) {
        Target t = (Target)targets.get(targets.size() - 1);
        int idx = t.getValue().indexOf(USERNAMETOKEN);
        return idx != -1;
    }

    private void setUsernamePassword(AuthenticationTokenPolicy policy, CallbackHandler handler) {
        AuthenticationTokenPolicy.UsernameTokenBinding up = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
        NameCallback nameCallback = new NameCallback("Username: ");
        PasswordCallback pwdCallback = new PasswordCallback("Password: ", false);
        try {
            Callback[] cbs = new Callback[]{nameCallback, pwdCallback};
            handler.handle(cbs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        up.setUsername(nameCallback.getName());
        up.setPassword(new String(pwdCallback.getPassword()));
    }

    private Collection getNonBodyUsernameEncryptPolicies(MessagePolicy mPolicy, CallbackHandler handler, boolean senderConfiguration) {
        ArrayList<WSSPolicy> requiredElements = new ArrayList<WSSPolicy>();
        Iterator it = mPolicy.iterator();
        while (it.hasNext()) {
            WSSPolicy policy = (WSSPolicy)it.next();
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)policy) || this.hasEncryptBodyPolicy((EncryptionPolicy)policy) || this.hasEncryptUsernamePolicy((EncryptionPolicy)policy, mPolicy)) continue;
            requiredElements.add(policy);
        }
        return requiredElements;
    }

    private boolean hasEncryptBodyPolicy(EncryptionPolicy policy) {
        EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
        Iterator it = fb.getTargetBindings().iterator();
        while (it.hasNext()) {
            Target target = (Target)it.next();
            int idx = target.getValue().indexOf(BODY);
            if (idx <= -1) continue;
            return true;
        }
        return false;
    }

    protected boolean isOptimized(SOAPMessage msg) {
        return msg.getClass().getName().equals("com.sun.xml.messaging.saaj.soap.ver1_1.ExpressMessage1_1Impl") || msg.getClass().getName().equals("com.sun.xml.messaging.saaj.soap.ver1_2.ExpressMessage1_2Impl");
    }
}

