/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.client.AsyncHandlerService;
import com.sun.xml.ws.client.BindingProviderProperties;
import com.sun.xml.ws.client.ContactInfoListImpl;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.client.EndpointIFBase;
import com.sun.xml.ws.client.EndpointIFContext;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.encoding.soap.internal.DelegateBase;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.pept.presentation.MessageStruct;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.wsdl.WSDLContext;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;

public class EndpointIFInvocationHandler
extends EndpointIFBase
implements InvocationHandler,
BindingProviderProperties {
    Object _proxy;
    DelegateBase _delegate;
    EndpointIFContext _endpointContext;
    Class _portInterface;
    QName _serviceQName;
    RuntimeContext _rtcontext;
    WSDLContext _wsdlContext;
    boolean failure;
    URL wsdlDocumentLocation;
    WSServiceDelegate _service;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EndpointIFInvocationHandler(Class portInterface, EndpointIFContext eif, WSServiceDelegate service, QName serviceName) {
        if (eif.getBindingID() == null || eif.getRuntimeContext() == null) {
            this.failure = true;
            return;
        }
        this._endpointContext = eif;
        this._portInterface = portInterface;
        this._rtcontext = eif.getRuntimeContext();
        this._bindingId = eif.getBindingID();
        this._service = service;
        if (serviceName != null) {
            if (!eif.contains(serviceName)) throw new WebServiceException("Supplied service QName " + serviceName + " does not exist in this wsdl.");
            this._serviceQName = serviceName;
        } else {
            this._serviceQName = eif.getServiceName();
        }
        if (eif.getEndpointAddress() != null) {
            this.getRequestContext().put("javax.xml.ws.service.endpoint.address", eif.getEndpointAddress());
        }
        ContactInfoListImpl cil = new ContactInfoListImpl();
        this._delegate = new DelegateBase(cil, service);
    }

    public void setModel(RuntimeContext rtcontext) {
        this._rtcontext = rtcontext;
    }

    public void setProxy(Object p) {
        this._proxy = p;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws WebServiceException, Throwable {
        try {
            if (this.isSEIMethod(method, this._portInterface)) {
                return this.implementSEIMethod(method, args);
            }
            return method.invoke((Object)this, args);
        }
        catch (IllegalAccessException e) {
            throw new WebServiceException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (UndeclaredThrowableException ex) {
            throw new WebServiceException(ex.getMessage(), ex.getCause());
        }
        catch (GenericSignatureFormatError ex) {
            throw new WebServiceException(ex.getMessage(), ex);
        }
        catch (MalformedParameterizedTypeException ex) {
            throw new WebServiceException(ex.getMessage(), ex);
        }
    }

    public Object implementSEIMethod(Method method, Object[] parameters) throws Throwable {
        MessageStruct messageStruct = this._delegate.getMessageStruct();
        int mmep = 0;
        if (this._rtcontext != null) {
            JavaMethod jmethod = this._rtcontext.getModel().getJavaMethod(method);
            if (jmethod != null) {
                int mep = jmethod.getMEP();
                mmep = mep == 1 ? 1 : (mep == 2 ? 2 : (mep == 3 ? 3 : 4));
            } else {
                throw new WebServiceException("runtime model information for java Method " + method.getName() + " is not known .");
            }
        }
        if (mmep == 4) {
            for (Object param : parameters) {
                if (!AsyncHandler.class.isAssignableFrom(param.getClass())) continue;
                messageStruct.setMetaData("com.sun.xml.ws.client.dispatch.asynchandler", new AsyncHandlerService((AsyncHandler)param, this.getCurrentExecutor()));
            }
        }
        messageStruct.setMethod(method);
        messageStruct.setData(parameters);
        RequestContext requestContext = (RequestContext)((BindingProvider)this._proxy).getRequestContext();
        requestContext.put("com.sun.xml.ws.client.handle", this._proxy);
        messageStruct.setMetaData("com.sun.xml.ws.runtime.context", this._rtcontext);
        messageStruct.setMetaData("com.sun.xml.ws.context.request", requestContext);
        Object mtomThreshold = requestContext.get("com.sun.xml.ws.common.MtomThresholdValue");
        messageStruct.setMetaData("com.sun.xml.ws.common.MtomThresholdValue", mtomThreshold);
        messageStruct.setMetaData("com.sun.xml.ws.runtime.wsdl", this._delegate.getServiceDelegate().getServiceContext().getWsdlContext());
        messageStruct.setMEP(mmep);
        ContentNegotiation.initialize(requestContext, messageStruct);
        if (this._rtcontext != null && this._rtcontext.getModel() != null) {
            SOAPBinding sb;
            SOAPBinding sOAPBinding = sb = this.binding instanceof SOAPBinding ? (SOAPBinding)((Object)this.binding) : null;
            if (sb != null) {
                this._rtcontext.getModel().enableMtom(sb.isMTOMEnabled());
            }
        }
        this._delegate.send(messageStruct);
        this.updateResponseContext((MessageInfo)messageStruct);
        switch (messageStruct.getResponseType()) {
            case 0: {
                break;
            }
            case 1: {
                if (this._rtcontext.getModel().isCheckedException(method, messageStruct.getResponse().getClass())) {
                    throw (Throwable)messageStruct.getResponse();
                }
                throw (Exception)messageStruct.getResponse();
            }
            case 2: {
                throw (RuntimeException)messageStruct.getResponse();
            }
        }
        return messageStruct.getResponse();
    }

    boolean isSEIMethod(Method method, Class sei) {
        return sei.equals(method.getDeclaringClass());
    }

    public EndpointIFContext getEndpointContext() {
        return this._endpointContext;
    }

    public QName getServiceQName() {
        return this._serviceQName;
    }

    public Class getPortInterface() {
        return this._portInterface;
    }

    Executor getCurrentExecutor() {
        return this._service.getExecutor();
    }
}

