/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.client.EndpointIFContext;
import com.sun.xml.ws.client.SCAnnotations;
import com.sun.xml.ws.client.ServiceContext;
import com.sun.xml.ws.handler.HandlerResolverImpl;
import com.sun.xml.ws.handler.PortInfoImpl;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.modeler.RuntimeModeler;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.HandlerAnnotationProcessor;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.wsdl.WSDLContext;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceContextBuilder {
    private ServiceContextBuilder() {
    }

    public static ServiceContext build(URL wsdlLocation, Class service, EntityResolver er) throws WebServiceException {
        ServiceContext serviceContext = new ServiceContext(er);
        SCAnnotations serviceCAnnotations = null;
        if (service != Service.class) {
            serviceCAnnotations = ServiceContextBuilder.getSCAnnotations(service);
            if (serviceCAnnotations == null) {
                throw new WebServiceException("Service Interface Annotations required, exiting...");
            }
            serviceContext.setSCAnnotations(serviceCAnnotations);
        }
        String temp = wsdlLocation != null ? wsdlLocation.toString() : serviceCAnnotations.wsdlLocation;
        try {
            wsdlLocation = new URL(JAXWSUtils.getFileOrURLName(temp));
        }
        catch (MalformedURLException e) {
            throw new WebServiceException(e);
        }
        if (wsdlLocation != null) {
            serviceContext.setWsdlContext(new WSDLContext(wsdlLocation, er));
        }
        if (serviceCAnnotations != null) {
            serviceContext.setServiceClass(service);
            for (Class clazz : serviceCAnnotations.classes) {
                ServiceContextBuilder.processAnnotations(serviceContext, clazz);
            }
        }
        return serviceContext;
    }

    public static void completeServiceContext(ServiceContext serviceContext, Class portInterface) {
        if (serviceContext.getWsdlContext() == null && portInterface != null) {
            URL wsdlLocation = null;
            try {
                wsdlLocation = new URL(JAXWSUtils.getFileOrURLName(ServiceContextBuilder.getWSDLLocation(portInterface)));
            }
            catch (MalformedURLException e) {
                throw new WebServiceException(e);
            }
            serviceContext.setWsdlContext(new WSDLContext(wsdlLocation, serviceContext.getEntityResolver()));
        }
        if (portInterface != null && serviceContext.getEndpointIFContext().isEmpty()) {
            ServiceContextBuilder.processAnnotations(serviceContext, portInterface);
        }
    }

    private static QName getServiceName(Class serviceInterface) {
        WebServiceClient wsClient = serviceInterface.getAnnotation(WebServiceClient.class);
        QName serviceName = null;
        if (wsClient != null) {
            String name = wsClient.name();
            String namespace = wsClient.targetNamespace();
            serviceName = new QName(namespace, name);
        }
        return serviceName;
    }

    private static QName getPortName(Class portInterface, Class serviceInterface) {
        QName portName = null;
        WebServiceClient wsClient = serviceInterface.getAnnotation(WebServiceClient.class);
        for (Method method : serviceInterface.getMethods()) {
            WebEndpoint webEndpoint;
            if (!method.getDeclaringClass().equals(serviceInterface) || (webEndpoint = method.getAnnotation(WebEndpoint.class)) == null || !method.getGenericReturnType().equals(portInterface) || !method.getName().startsWith("get")) continue;
            portName = new QName(wsClient.targetNamespace(), webEndpoint.name());
            break;
        }
        return portName;
    }

    private static void processAnnotations(ServiceContext serviceContext, Class portInterface) throws WebServiceException {
        EndpointIFContext eifc = serviceContext.getEndpointIFContext(portInterface.getName());
        if (eifc == null || eifc.getRuntimeContext() == null) {
            if (eifc == null) {
                eifc = new EndpointIFContext(portInterface);
                serviceContext.addEndpointIFContext(eifc);
            }
            QName serviceName = serviceContext.getServiceName();
            QName portName = eifc.getPortName();
            if (serviceContext.getServiceClass() != null) {
                if (serviceName == null) {
                    serviceName = ServiceContextBuilder.getServiceName(serviceContext.getServiceClass());
                }
                if (portName == null) {
                    portName = ServiceContextBuilder.getPortName(portInterface, serviceContext.getServiceClass());
                }
            }
            if (portName == null) {
                portName = serviceContext.getWsdlContext().getPortName();
            }
            String bindingId = serviceContext.getWsdlContext().getBindingID(serviceName, portName).toString();
            RuntimeModeler modeler = new RuntimeModeler(portInterface, serviceName, bindingId);
            modeler.setPortName(portName);
            RuntimeModel model = modeler.buildRuntimeModel();
            eifc.setRuntimeContext(new RuntimeContext(model));
            HandlerAnnotationInfo chainInfo = HandlerAnnotationProcessor.buildHandlerInfo(portInterface, model.getServiceQName(), model.getPortName(), bindingId);
            if (serviceContext.getServiceName() == null) {
                serviceContext.setServiceName(serviceContext.getWsdlContext().getFirstServiceName());
            }
            if (chainInfo != null) {
                HandlerResolverImpl resolver = ServiceContextBuilder.getHandlerResolver(serviceContext);
                resolver.setHandlerChain(new PortInfoImpl(bindingId, model.getPortName(), model.getServiceQName()), chainInfo.getHandlers());
                serviceContext.setRoles(portName, chainInfo.getRoles());
            }
        }
    }

    private static HandlerResolverImpl getHandlerResolver(ServiceContext serviceContext) {
        if (serviceContext.getHandlerResolver() == null) {
            serviceContext.setHandlerResolver(new HandlerResolverImpl());
        }
        return serviceContext.getHandlerResolver();
    }

    private ArrayList<Class<?>> getSEI(final Class sc) {
        if (sc == null) {
            throw new WebServiceException();
        }
        if (!Service.class.isAssignableFrom(sc)) {
            throw new WebServiceException("service.interface.required" + sc.getName());
        }
        final ArrayList classes = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method[] methods;
                for (Method method : methods = sc.getDeclaredMethods()) {
                    method.setAccessible(true);
                    Class<?> seiClazz = method.getReturnType();
                    if (seiClazz == null || seiClazz.equals("void")) continue;
                    classes.add(seiClazz);
                }
                return null;
            }
        });
        return classes;
    }

    private static String getWSDLLocation(Class<?> sei) throws MalformedURLException {
        WebService ws = sei.getAnnotation(WebService.class);
        if (ws == null) {
            return null;
        }
        return ws.wsdlLocation();
    }

    private static SCAnnotations getSCAnnotations(Class sc) {
        WebServiceClient wsc;
        SCAnnotations SCAnnotations2 = new SCAnnotations();
        ArrayList<QName> portQNames = new ArrayList<QName>();
        if (sc != null && (wsc = sc.getAnnotation(WebServiceClient.class)) != null) {
            String tns;
            String name = wsc.name();
            SCAnnotations2.tns = tns = wsc.targetNamespace();
            if (name != null) {
                SCAnnotations2.serviceQName = new QName(tns, name);
            }
            SCAnnotations2.wsdlLocation = wsc.wsdlLocation();
            final Class myClass = sc;
            Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return myClass.getDeclaredMethods();
                }
            });
            if (methods != null) {
                ArrayList classes = new ArrayList(methods.length);
                for (Method method : methods) {
                    Class<?> seiClazz;
                    WebEndpoint webEndpoint = (WebEndpoint)ServiceContextBuilder.getPrivMethodAnnotation(method, WebEndpoint.class);
                    if (webEndpoint != null) {
                        String endpointName = webEndpoint.name();
                        QName portQName = new QName(tns, endpointName);
                        portQNames.add(portQName);
                    }
                    if ((seiClazz = method.getReturnType()) == null || seiClazz.equals("void")) continue;
                    classes.add(seiClazz);
                }
                SCAnnotations2.portQNames.addAll(portQNames);
                SCAnnotations2.classes.addAll(classes);
            }
        }
        return SCAnnotations2;
    }

    private static <T> T getPrivMethodAnnotation(final Method method, final Class<WebEndpoint> T) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getAnnotation(T);
            }
        });
    }
}

