/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.AsyncHandlerService;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.client.InternalBindingProvider;
import com.sun.xml.ws.client.PortInfoBase;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.WSFuture;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DispatchContext;
import com.sun.xml.ws.client.dispatch.impl.DispatchContactInfoList;
import com.sun.xml.ws.client.dispatch.impl.DispatchDelegate;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.pept.Delegate;
import com.sun.xml.ws.pept.presentation.MessageStruct;
import com.sun.xml.ws.spi.runtime.ClientTransportFactory;
import com.sun.xml.ws.transport.http.client.HttpClientTransportFactory;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchBase
implements BindingProvider,
InternalBindingProvider,
Dispatch {
    private static ClientTransportFactory defaultTransportFactory = null;
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch").toString());
    protected Map _requestContext;
    protected Map _responseContext;
    protected Service.Mode _mode;
    protected WSServiceDelegate _service;
    protected Class _clazz;
    protected JAXBContext _jaxbContext;
    protected Delegate _delegate = new DispatchDelegate(new DispatchContactInfoList());
    protected PortInfoBase _portInfo = null;
    protected String _bindingId = null;
    protected BindingImpl binding;
    private ClientTransportFactory _transportFactory;
    private Lock _lock;

    public DispatchBase(PortInfoBase port, Class aClass, Service.Mode mode, WSServiceDelegate service) {
        this(port, mode, null, aClass, service);
    }

    public DispatchBase(PortInfoBase port, JAXBContext jaxbContext, Service.Mode mode, WSServiceDelegate service) {
        this(port, mode, jaxbContext, null, service);
    }

    DispatchBase(PortInfoBase port, Service.Mode mode, JAXBContext context, Class clazz, WSServiceDelegate service) {
        this._mode = mode;
        this._portInfo = port;
        this._jaxbContext = context;
        this._clazz = clazz;
        this._service = service;
    }

    public Object invoke(Object msg) throws WebServiceException {
        MessageStruct messageStruct = this.setupMessageStruct(msg);
        messageStruct.setMEP(1);
        return this.sendAndReceive(messageStruct);
    }

    public Response<Object> invokeAsync(Object msg) throws WebServiceException {
        MessageStruct messageStruct = this.setupMessageStruct(msg);
        messageStruct.setMEP(3);
        Object result = this.sendAsync(messageStruct);
        if (result instanceof Response) {
            return (Response)result;
        }
        throw (WebServiceException)result;
    }

    public Future<?> invokeAsync(Object msg, AsyncHandler handler) {
        MessageStruct messageStruct = this.setupMessageStruct(msg);
        if (handler == null) {
            throw new WebServiceException("AsyncHandler argument is null. AsyncHandler is required for asynchronous callback invocations ");
        }
        messageStruct.setMetaData("com.sun.xml.ws.client.dispatch.asynchandler", new AsyncHandlerService(handler, this.getCurrentExecutor()));
        messageStruct.setMEP(4);
        Object result = this.sendAsync(messageStruct);
        if (result instanceof WSFuture) {
            return (Future)result;
        }
        throw (WebServiceException)result;
    }

    public void invokeOneWay(Object msg) {
        MessageStruct messageStruct = this.setupMessageStruct(msg);
        messageStruct.setMEP(2);
        this.sendOneWay(messageStruct);
    }

    private boolean hasJAXBContext(Object msg, MessageStruct messageStruct) {
        RequestContext requestContext = (RequestContext)this.getRequestContext();
        if (this._jaxbContext != null) {
            requestContext.put("com.sun.xml.ws.jaxbcontext", (Object)this._jaxbContext);
            return true;
        }
        return false;
    }

    public void _setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    public Delegate _getDelegate() {
        return this._delegate;
    }

    public static void setDefaultTransportFactory(ClientTransportFactory factory) {
        defaultTransportFactory = factory;
    }

    public static ClientTransportFactory getDefaultTransportFactory() {
        if (defaultTransportFactory == null) {
            defaultTransportFactory = new HttpClientTransportFactory();
        }
        return defaultTransportFactory;
    }

    public ClientTransportFactory _getTransportFactory() {
        this._transportFactory = (ClientTransportFactory)this.getRequestContext().get("com.sun.xml.ws.client.ClientTransportFactory");
        if (this._transportFactory == null) {
            this._transportFactory = new HttpClientTransportFactory();
        }
        return this._transportFactory;
    }

    public void _setTransportFactory(ClientTransportFactory f) {
        this.getRequestContext().put("com.sun.xml.ws.client.ClientTransportFactory", f);
        this._transportFactory = f;
    }

    /*
     * Unable to fully structure code
     */
    private Object sendAndReceive(MessageStruct messageStruct) {
        response = null;
        this._delegate.send(messageStruct);
        response = messageStruct.getResponse();
        this.updateResponseContext(messageStruct);
        switch (messageStruct.getResponseType()) {
            case 0: {
                break;
            }
            case 1: {
                if (response instanceof SOAPFaultException) {
                    throw (SOAPFaultException)response;
                }
                if (!(response instanceof SOAPFaultInfo)) ** GOTO lbl21
                soapFaultInfo = (SOAPFaultInfo)response;
                jbe = null;
                if (!soapFaultInfo.getString().contains("javax.xml.bind")) ** GOTO lbl20
                jbe = new JAXBException(soapFaultInfo.getString());
                sfe = new SOAPFaultException(soapFaultInfo.getSOAPFault());
                sfe.initCause((Throwable)jbe);
                ** GOTO lbl25
lbl20:
                // 1 sources

                throw new SOAPFaultException(soapFaultInfo.getSOAPFault());
lbl21:
                // 1 sources

                if (response instanceof HTTPException) {
                    throw (HTTPException)response;
                }
                if (response instanceof WebServiceException) {
                    throw (WebServiceException)response;
                }
            }
lbl25:
            // 4 sources

            case 2: {
                if (response instanceof SOAPFaultException) {
                    throw (SOAPFaultException)response;
                }
                if (response instanceof HTTPException) {
                    throw (HTTPException)response;
                }
                throw (WebServiceException)response;
            }
            default: {
                if (response == null) break;
                throw new WebServiceException("Client side exception - examine cause ", (Exception)response);
            }
        }
        return response;
    }

    private Object sendAsync(MessageStruct messageStruct) throws WebServiceException {
        Object response = null;
        this._lock = new ReentrantLock();
        this._lock.lock();
        try {
            this._delegate.send(messageStruct);
            response = messageStruct.getResponse();
        }
        catch (Exception ex) {
            if (ex instanceof WebServiceException) {
                throw (WebServiceException)ex;
            }
            throw new WebServiceException("Client side exception before invocation ", ex);
        }
        finally {
            this._lock.unlock();
        }
        return response;
    }

    private Object sendOneWay(MessageStruct messageStruct) {
        this._delegate.send(messageStruct);
        Object response = messageStruct.getResponse();
        switch (messageStruct.getResponseType()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                if (response instanceof WebServiceException) {
                    throw (WebServiceException)response;
                }
                throw new WebServiceException(((Exception)response).getMessage(), (Exception)response);
            }
            default: {
                throw new WebServiceException("Client side Exception ", (Exception)response);
            }
        }
        return response;
    }

    private MessageStruct setupMessageStruct(Object msg) throws WebServiceException {
        MessageStruct messageStruct = this._delegate.getMessageStruct();
        if (msg != null) {
            MessageFactory factory = null;
            if (msg instanceof Source && this._mode == Service.Mode.MESSAGE && !this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                try {
                    factory = this._getBindingId().toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") ? MessageFactory.newInstance((String)"SOAP 1.2 Protocol") : MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
                    SOAPMessage message = factory.createMessage();
                    message.getSOAPPart().setContent((Source)msg);
                    message.saveChanges();
                    msg = message;
                }
                catch (SOAPException se) {
                    throw new WebServiceException(se);
                }
            }
            messageStruct.setData(new Object[]{msg});
            this.setMetadata(this.getRequestContext(), msg, messageStruct);
            ContentNegotiation.initialize(this.getRequestContext(), messageStruct);
        } else {
            if (!this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                throw new WebServiceException("No Message to Send to web service");
            }
            messageStruct.setData(new Object[]{msg});
            this.setMetadata(this.getRequestContext(), msg, messageStruct);
            ContentNegotiation.initialize(this.getRequestContext(), messageStruct);
        }
        this.setMessageStruct(messageStruct, msg);
        return messageStruct;
    }

    private void setMessageStruct(MessageStruct messageStruct, Object msg) {
        messageStruct.setData(new Object[]{msg});
        this.setMetadata(this.getRequestContext(), msg, messageStruct);
        ContentNegotiation.initialize(this.getRequestContext(), messageStruct);
    }

    private void updateResponseContext(MessageStruct messageStruct) {
        ResponseContext responseContext = (ResponseContext)messageStruct.getMetaData("com.sun.xml.ws.context.response");
        this.setResponseContext(responseContext);
    }

    private void setMetadata(Map jaxwsContext, Object obj, MessageStruct messageStruct) {
        jaxwsContext.put("com.sun.xml.ws.client.handle", this);
        jaxwsContext.put("javax.xml.ws.service.endpoint.address", this._portInfo.getTargetEndpoint());
        jaxwsContext.put("com.sun.xml.ws.binding", this._getBindingId().toString());
        if (this._jaxbContext != null) {
            jaxwsContext.put("com.sun.xml.ws.jaxbcontext", this._jaxbContext);
        }
        messageStruct.setMetaData("com.sun.xml.ws.context.request", jaxwsContext);
        messageStruct.setMetaData("com.sun.xml.ws.rt.client.dispatch.mode", (Object)this._mode);
        if (this._clazz != null) {
            messageStruct.setMetaData("com.sun.xml.ws.rt.client.dispatch.messageclass", this._clazz);
        }
        DispatchContext context = this.setDispatchContext(jaxwsContext, obj, this._mode);
        messageStruct.setMetaData("com.sun.xml.ws.client.dispatch.context", context);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void _setBinding(BindingImpl binding) {
        this.binding = binding;
    }

    public String _getBindingId() {
        this._bindingId = this._portInfo.getBindingId();
        if (this._bindingId == null) {
            this._bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        return this._bindingId;
    }

    public Map getRequestContext() {
        if (this._requestContext == null) {
            this._requestContext = new RequestContext(this);
        }
        return this._requestContext;
    }

    private void setResponseContext(ResponseContext context) {
        this._responseContext = context;
    }

    public Map getResponseContext() {
        if (this._responseContext == null) {
            this._responseContext = new ResponseContext(this);
        }
        return this._responseContext;
    }

    public DispatchContext setDispatchContext(Map jaxwsContext, Object obj, Service.Mode mode) {
        DispatchContext context = new DispatchContext();
        context.setProperty("com.sun.xml.ws.rt.client.dispatch.mode", (Object)mode);
        if (obj != null) {
            if (obj instanceof Source) {
                context.setProperty("com.sun.xml.ws.rt.client.dispatch.messageclass", (Object)DispatchContext.MessageClass.SOURCE);
            } else if (obj instanceof SOAPMessage) {
                context.setProperty("com.sun.xml.ws.rt.client.dispatch.messageclass", (Object)DispatchContext.MessageClass.SOAPMESSAGE);
            } else if (obj instanceof DataSource && this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                context.setProperty("com.sun.xml.ws.rt.client.dispatch.messageclass", (Object)DispatchContext.MessageClass.DATASOURCE);
            } else if (this._jaxbContext != null) {
                context.setProperty("com.sun.xml.ws.rt.client.dispatch.messageclass", (Object)DispatchContext.MessageClass.JAXBOBJECT);
            } else if (!this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                throw new WebServiceException("Object is not a javax.xml.transform.Source or there is no JAXB Context");
            }
        }
        if (this._clazz != null) {
            if (this._clazz.isAssignableFrom(Source.class)) {
                if (mode == Service.Mode.PAYLOAD) {
                    if (this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                        context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.HTTP_SOURCE_PAYLOAD);
                    } else {
                        context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.SOURCE_PAYLOAD);
                    }
                } else if (mode == Service.Mode.MESSAGE) {
                    if (this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                        context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.HTTP_SOURCE_MESSAGE);
                    } else {
                        context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.SOURCE_MESSAGE);
                    }
                }
            } else if (this._clazz.isAssignableFrom(SOAPMessage.class)) {
                if (mode == Service.Mode.PAYLOAD) {
                    throw new WebServiceException("SOAPMessages must be Service.Mode.MESSAGE. ");
                }
                if (mode == Service.Mode.MESSAGE) {
                    context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.SOAPMESSAGE_MESSAGE);
                }
            } else if (this._clazz.isAssignableFrom(DataSource.class)) {
                if (mode == Service.Mode.PAYLOAD) {
                    throw new WebServiceException("Can not have a Datahandler class with mode PAYLOAD");
                }
                if (mode == Service.Mode.MESSAGE) {
                    context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.HTTP_DATASOURCE_MESSAGE);
                }
            } else {
                context.setProperty("com.sun.xml.ws.rt.client.dispatch.messageclass", this._clazz);
            }
        } else if (this.hasJAXBContext(obj, null)) {
            if (mode == Service.Mode.PAYLOAD) {
                if (this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                    context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.HTTP_JAXB_PAYLOAD);
                } else {
                    context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.JAXB_PAYLOAD);
                }
            } else if (mode == Service.Mode.MESSAGE) {
                if (this._getBindingId().toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
                    throw new WebServiceException(" Can not have a JAXB object with mode MESSAGE");
                }
                context.setProperty("com.sun.xml.ws.rt.client.dispatch.messagetype", (Object)DispatchContext.MessageType.JAXB_MESSAGE);
            }
        }
        return context;
    }

    Executor getCurrentExecutor() {
        return this._service.getExecutor();
    }

    public QName getServiceName() {
        if (this._service != null) {
            return this._service.getServiceName();
        }
        return null;
    }

    public QName getPortName() {
        if (this._portInfo != null) {
            return this._portInfo.getName();
        }
        return null;
    }

    private boolean isValidHttpGETRequest(Object msg) {
        boolean isValid = false;
        String bindingId = this._getBindingId().toString();
        String method = (String)this.getRequestContext().get("javax.xml.ws.http.request.method");
        if (method != null) {
            isValid = "GET".equalsIgnoreCase(method);
        }
        return isValid;
    }
}

