/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.ws.handler.HandlerContext;
import com.sun.xml.ws.spi.runtime.MtomCallback;
import com.sun.xml.ws.util.ByteArrayDataSource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSAttachmentMarshaller
extends AttachmentMarshaller {
    private MtomCallback mtomCallback;
    private boolean isXOP;
    private boolean isXopped;
    private Map<String, AttachmentBlock> attachments;
    private HandlerContext hc;
    private int mtomThresholdValue = 1000;

    public JAXWSAttachmentMarshaller(boolean isXOP) {
        this.isXOP = isXOP;
    }

    public boolean isXOPPackage() {
        return this.isXOP;
    }

    public void setXOPPackage(boolean isXOP) {
        this.isXOP = isXOP;
    }

    public String addMtomAttachment(DataHandler data, String elementNamespace, String elementName) {
        if (!this.isXOP) {
            return null;
        }
        String cid = this.encodeCid(elementNamespace);
        if (cid != null) {
            String cidBracket = '<' + cid + '>';
            this.attachments.put(cidBracket, AttachmentBlock.fromDataHandler(cidBracket, data));
            this.addToMessageContext(cidBracket, data);
            if (this.mtomCallback != null) {
                this.mtomCallback.addedMtomAttachment(cidBracket, data, elementNamespace, elementName);
            }
            this.isXopped = true;
            cid = "cid:" + cid;
        }
        return cid;
    }

    public String addMtomAttachment(byte[] data, int offset, int len, String mimeType, String elementNamespace, String elementLocalName) {
        if (!this.isXOP) {
            return null;
        }
        if (len < this.mtomThresholdValue) {
            return null;
        }
        String cid = this.encodeCid(elementNamespace);
        if (cid != null) {
            String cidBracket = '<' + cid + '>';
            DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(data, offset, len, "application/octet-stream"));
            this.attachments.put(cidBracket, AttachmentBlock.fromDataHandler(cidBracket, dh));
            this.addToMessageContext(cidBracket, dh);
            if (this.mtomCallback != null) {
                this.mtomCallback.addedMtomAttachment(cidBracket, dh, elementNamespace, elementLocalName);
            }
            this.isXopped = true;
            cid = "cid:" + cid;
        }
        return cid;
    }

    public String addSwaRefAttachment(DataHandler data) {
        String cid = this.encodeCid(null);
        if (cid != null) {
            String cidBracket = '<' + cid + '>';
            this.attachments.put(cidBracket, AttachmentBlock.fromDataHandler("<" + cid + ">", data));
            this.addToMessageContext(cidBracket, data);
            this.isXopped = false;
            cid = "cid:" + cid;
        }
        return cid;
    }

    private void addToMessageContext(String cid, DataHandler dh) {
    }

    private String encodeCid(String ns) {
        String cid = "example.jaxws.sun.com";
        String name = UUID.randomUUID() + "@";
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
            catch (MalformedURLException e) {
                try {
                    cid = URLEncoder.encode(ns, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    throw new WebServiceException(e);
                }
            }
        }
        return name + cid;
    }

    public void setAttachments(Map<String, AttachmentBlock> attachments) {
        this.attachments = attachments;
        this.isXopped = false;
    }

    public void setHandlerContaxt(HandlerContext hc) {
        this.hc = hc;
    }

    public boolean isXopped() {
        return this.isXopped;
    }

    public void setMtomThresholdValue(Integer mtomThresholdValue) {
        if (mtomThresholdValue != null && mtomThresholdValue >= 0) {
            this.mtomThresholdValue = mtomThresholdValue;
        }
    }

    public void setMtomCallback(MtomCallback mtomCallback) {
        this.mtomCallback = mtomCallback;
    }
}

