/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap;

import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayloadSerializer;
import com.sun.xml.ws.encoding.soap.SerializationException;
import com.sun.xml.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.internal.SOAP12NotUnderstoodHeaderBlock;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.handler.HandlerContext;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.pept.encoding.Encoder;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.spi.runtime.InternalSoapEncoder;
import com.sun.xml.ws.spi.runtime.MtomCallback;
import com.sun.xml.ws.spi.runtime.RuntimeModule;
import com.sun.xml.ws.streaming.SourceReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.ModuleFinder;
import com.sun.xml.ws.util.xml.StAXResult;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPEncoder
implements Encoder,
InternalSoapEncoder {
    protected List<RuntimeModule> modules = ModuleFinder.findRuntimeModules();

    @Override
    public void encodeAndSend(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer encode(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    public InternalMessage toInternalMessage(MessageInfo messageInfo) {
        return null;
    }

    public DOMSource toDOMSource(JAXBBridgeInfo bridgeInfo, MessageInfo messageInfo) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        Document doc = DOMUtil.createDom();
        bridgeInfo.serialize(bridgeContext, doc);
        return new DOMSource(doc);
    }

    public DOMSource toDOMSource(RpcLitPayload rpcLitPayload, MessageInfo messageInfo) {
        try {
            ByteArrayBuffer baos = new ByteArrayBuffer();
            XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter(baos);
            this.writeRpcLitPayload(rpcLitPayload, messageInfo, writer);
            writer.close();
            baos.close();
            Transformer transformer = XmlUtil.newTransformer();
            StreamSource source = new StreamSource(baos.newInputStream());
            DOMResult domResult = new DOMResult();
            transformer.transform(source, domResult);
            return new DOMSource(domResult.getNode());
        }
        catch (TransformerException te) {
            throw new WebServiceException(te);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    public DOMSource toDOMSource(SOAPFaultInfo faultInfo, MessageInfo messageInfo) {
        try {
            ByteArrayBuffer baos = new ByteArrayBuffer();
            XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter(baos);
            this.writeFault(faultInfo, messageInfo, writer);
            writer.writeEndDocument();
            writer.close();
            baos.close();
            Transformer transformer = XmlUtil.newTransformer();
            StreamSource source = new StreamSource(baos.newInputStream());
            DOMResult domResult = new DOMResult();
            transformer.transform(source, domResult);
            return new DOMSource(domResult.getNode());
        }
        catch (TransformerException te) {
            throw new WebServiceException(te);
        }
        catch (XMLStreamException xe) {
            throw new WebServiceException(xe);
        }
    }

    protected void writeRpcLitPayload(RpcLitPayload rpcLitPayload, MessageInfo messageInfo, XMLStreamWriter writer) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        RpcLitPayloadSerializer.serialize(rpcLitPayload, bridgeContext, messageInfo, writer);
    }

    protected void writeRpcLitPayload(RpcLitPayload rpcLitPayload, MessageInfo messageInfo, OutputStream writer) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        RpcLitPayloadSerializer.serialize(rpcLitPayload, bridgeContext, writer);
    }

    private void writeJAXBBeanInfo(JAXBBeanInfo beanInfo, MessageInfo messageInfo, XMLStreamWriter writer) {
        OutputStream os = (OutputStream)messageInfo.getMetaData("com.sun.xml.bind.api.Bridge.outputStream");
        if (os != null) {
            try {
                writer.writeCharacters("");
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException(e);
            }
            beanInfo.writeTo(os);
        } else {
            beanInfo.writeTo(writer);
        }
    }

    private void writeJAXBBeanInfo(JAXBBeanInfo beanInfo, OutputStream writer) {
        beanInfo.writeTo(writer);
    }

    protected void writeJAXBBridgeInfo(JAXBBridgeInfo bridgeInfo, MessageInfo messageInfo, XMLStreamWriter writer) {
        RuntimeModule rtm = ModuleFinder.findAddressingModule();
        BridgeContext bridgeContext = null;
        if (rtm != null && bridgeInfo.getType().tagName.getNamespaceURI().equals(rtm.getNamespaceURI())) {
            bridgeContext = rtm.getBridgeContext();
        } else {
            RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
            bridgeContext = rtCtxt.getBridgeContext();
        }
        OutputStream os = (OutputStream)messageInfo.getMetaData("com.sun.xml.bind.api.Bridge.outputStream");
        if (os != null) {
            try {
                writer.writeCharacters("");
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException(e);
            }
            bridgeInfo.serialize(bridgeContext, os, writer.getNamespaceContext());
        } else {
            bridgeInfo.serialize(bridgeContext, writer);
        }
    }

    protected void writeJAXBBridgeInfo(JAXBBridgeInfo bridgeInfo, MessageInfo messageInfo, OutputStream writer) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        bridgeInfo.serialize(bridgeContext, writer, null);
    }

    protected void writeElement(Element element, XMLStreamWriter writer) {
        try {
            StAXResult result = new StAXResult(writer);
            DOMSource ds = new DOMSource(element);
            XmlUtil.newTransformer().transform(ds, result);
        }
        catch (TransformerException ex) {
            throw new WebServiceException(ex);
        }
    }

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, MessageInfo messageInfo) {
        return null;
    }

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, SOAPMessage soapMessage) {
        try {
            BodyBlock bodyBlock = internalMessage.getBody();
            if (bodyBlock == null) {
                return soapMessage;
            }
            Object value = bodyBlock.getValue();
            if (value == null) {
                return soapMessage;
            }
            if (!(value instanceof Source)) {
                throw new UnsupportedOperationException("Unknown object in BodyBlock:" + value.getClass());
            }
            Source source = (Source)value;
            SOAPBody body = soapMessage.getSOAPBody();
            body.removeContents();
            Transformer transformer = XmlUtil.newTransformer();
            transformer.transform(source, new DOMResult((Node)body));
            return soapMessage;
        }
        catch (Exception e) {
            throw new ServerRtException("soapencoder.err", new Object[]{e});
        }
    }

    public static void serializeReader(XMLStreamReader reader, XMLStreamWriter writer) {
        try {
            int state;
            block7: do {
                state = reader.next();
                switch (state) {
                    case 1: {
                        int i;
                        String uri = reader.getNamespaceURI();
                        String prefix = reader.getPrefix();
                        String localName = reader.getLocalName();
                        if (prefix == null) {
                            if (uri == null) {
                                writer.writeStartElement(localName);
                            } else {
                                writer.writeStartElement(uri, localName);
                            }
                        } else {
                            assert (uri != null);
                            if (prefix.length() > 0) {
                                String writerPrefix;
                                String writerURI = null;
                                if (writer.getNamespaceContext() != null) {
                                    writerURI = writer.getNamespaceContext().getNamespaceURI(prefix);
                                }
                                if (SOAPEncoder.declarePrefix(prefix, uri, writerPrefix = writer.getPrefix(uri), writerURI)) {
                                    writer.writeStartElement(prefix, localName, uri);
                                    writer.setPrefix(prefix, uri != null ? uri : "");
                                    writer.writeNamespace(prefix, uri);
                                } else {
                                    writer.writeStartElement(prefix, localName, uri);
                                }
                            } else {
                                writer.writeStartElement(prefix, localName, uri);
                            }
                        }
                        int n = reader.getNamespaceCount();
                        for (i = 0; i < n; ++i) {
                            String nsPrefix = reader.getNamespacePrefix(i);
                            if (nsPrefix == null) {
                                nsPrefix = "";
                            }
                            String writerURI = null;
                            if (writer.getNamespaceContext() != null) {
                                writerURI = writer.getNamespaceContext().getNamespaceURI(nsPrefix);
                            }
                            String readerURI = reader.getNamespaceURI(i);
                            if (writerURI != null && nsPrefix.length() != 0 && prefix.length() != 0 && (nsPrefix.equals(prefix) || writerURI.equals(readerURI))) continue;
                            writer.setPrefix(nsPrefix, readerURI != null ? readerURI : "");
                            writer.writeNamespace(nsPrefix, readerURI != null ? readerURI : "");
                        }
                        n = reader.getAttributeCount();
                        for (i = 0; i < n; ++i) {
                            String attrPrefix = reader.getAttributePrefix(i);
                            String attrURI = reader.getAttributeNamespace(i);
                            writer.writeAttribute(attrPrefix != null ? attrPrefix : "", attrURI != null ? attrURI : "", reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                            SOAPEncoder.setUndeclaredPrefix(attrPrefix, attrURI, writer);
                        }
                        continue block7;
                    }
                    case 2: {
                        writer.writeEndElement();
                        break;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                    }
                }
            } while (state != 8);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    private static void setUndeclaredPrefix(String prefix, String readerURI, XMLStreamWriter writer) throws XMLStreamException {
        String writerURI = null;
        if (writer.getNamespaceContext() != null) {
            writerURI = writer.getNamespaceContext().getNamespaceURI(prefix);
        }
        if (writerURI == null) {
            writer.setPrefix(prefix, readerURI != null ? readerURI : "");
            writer.writeNamespace(prefix, readerURI != null ? readerURI : "");
        }
    }

    private static boolean declarePrefix(String rPrefix, String rUri, String wPrefix, String wUri) {
        return wUri == null || wPrefix != null && !rPrefix.equals(wPrefix) || rUri != null && !wUri.equals(rUri);
    }

    protected void serializeSource(Source source, XMLStreamWriter writer) {
        try {
            XMLStreamReader reader = SourceReaderFactory.createSourceReader(source, true);
            SOAPEncoder.serializeReader(reader, writer);
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    protected void serializeSource(Source source, OutputStream writer) {
        try {
            Transformer t = XmlUtil.newTransformer();
            t.transform(source, new StreamResult(writer));
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

    protected void startEnvelope(XMLStreamWriter writer) {
        try {
            writer.writeStartElement("soapenv", "Envelope", "http://schemas.xmlsoap.org/soap/envelope/");
            writer.setPrefix("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            writer.writeNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    protected void writeEnvelopeNamespaces(XMLStreamWriter writer, MessageInfo messageInfo) throws XMLStreamException {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (rtCtxt != null && rtCtxt.getModel() != null) {
            writer.setPrefix("xsd", "http://www.w3.org/2001/XMLSchema");
            writer.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            int i = 1;
            for (String namespace : rtCtxt.getModel().getKnownNamespaceURIs()) {
                String prefix = "ns" + i++;
                writer.setPrefix(prefix, namespace);
                writer.writeNamespace(prefix, namespace);
            }
            writer.writeCharacters("");
        }
    }

    protected void startBody(XMLStreamWriter writer) {
        try {
            writer.writeStartElement("soapenv", "Body", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    protected void startHeader(XMLStreamWriter writer, MessageInfo messageInfo) {
        try {
            writer.writeStartElement("soapenv", "Header", "http://schemas.xmlsoap.org/soap/envelope/");
            for (RuntimeModule rtm : this.modules) {
                rtm.setNamespacePrefix(writer, messageInfo);
            }
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    protected void writeHeaders(XMLStreamWriter writer, InternalMessage response, MessageInfo messageInfo) {
        try {
            List<HeaderBlock> headerBlocks;
            this.startHeader(writer, messageInfo);
            Object context = messageInfo.getMetaData("com.sun.xml.ws.context.request");
            if (context != null) {
                for (RuntimeModule rtm : this.modules) {
                    rtm.writeClientOutboundHeaders(writer, messageInfo);
                }
            } else {
                for (RuntimeModule rtm : this.modules) {
                    rtm.writeServerOutboundHeaders(writer, messageInfo);
                }
            }
            if ((headerBlocks = response.getHeaders()) == null || headerBlocks.isEmpty()) {
                writer.writeEndElement();
                return;
            }
            for (HeaderBlock headerBlock : headerBlocks) {
                Object value = headerBlock.getValue();
                if (value != null) {
                    if (value instanceof JAXBBridgeInfo) {
                        this.writeJAXBBridgeInfo((JAXBBridgeInfo)value, messageInfo, writer);
                        continue;
                    }
                    if (value instanceof Element) {
                        this.writeElement((Element)value, writer);
                        continue;
                    }
                    throw new SerializationException("unknown.object", value.getClass().getName());
                }
                if (!(headerBlock instanceof SOAP12NotUnderstoodHeaderBlock)) continue;
                ((SOAP12NotUnderstoodHeaderBlock)headerBlock).write(writer);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    protected boolean hasAnnotations(Method method, Collection<Class> annotations) {
        Annotation[] declaredAnns = method.getDeclaredAnnotations();
        for (int i = 0; i < declaredAnns.length; ++i) {
            if (!annotations.contains(declaredAnns[i].annotationType())) continue;
            return true;
        }
        return false;
    }

    protected void writeBody(XMLStreamWriter writer, InternalMessage response, MessageInfo messageInfo) {
        try {
            this.startBody(writer);
            BodyBlock bodyBlock = response.getBody();
            if (bodyBlock != null) {
                Object value = bodyBlock.getValue();
                if (value instanceof JAXBBridgeInfo) {
                    this.writeJAXBBridgeInfo((JAXBBridgeInfo)value, messageInfo, writer);
                } else if (value instanceof RpcLitPayload) {
                    this.writeRpcLitPayload((RpcLitPayload)value, messageInfo, writer);
                } else if (value instanceof Source) {
                    this.serializeSource((Source)value, writer);
                } else if (value instanceof SOAPFaultInfo) {
                    this.writeFault((SOAPFaultInfo)value, messageInfo, writer);
                } else if (value instanceof JAXBBeanInfo) {
                    this.writeJAXBBeanInfo((JAXBBeanInfo)value, messageInfo, writer);
                } else {
                    throw new SerializationException("unknown.object", value.getClass().getName());
                }
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    public void setAttachmentsMap(MessageInfo mi, InternalMessage im) {
        Object rtc = mi.getMetaData("com.sun.xml.ws.runtime.context");
        if (rtc != null) {
            BridgeContext bc = ((RuntimeContext)rtc).getBridgeContext();
            if (bc == null) {
                return;
            }
            JAXWSAttachmentMarshaller am = (JAXWSAttachmentMarshaller)((RuntimeContext)rtc).getBridgeContext().getAttachmentMarshaller();
            am.setAttachments(im.getAttachments());
            am.setHandlerContaxt(((RuntimeContext)rtc).getHandlerContext());
            HandlerContext hc = ((RuntimeContext)rtc).getHandlerContext();
            Object mtomThreshold = hc == null ? mi.getMetaData("com.sun.xml.ws.common.MtomThresholdValue") : hc.getMessageContext().get("com.sun.xml.ws.common.MtomThresholdValue");
            if (mtomThreshold != null) {
                am.setMtomThresholdValue((Integer)mtomThreshold);
            }
        }
    }

    protected void processAttachments(InternalMessage im, SOAPMessage msg) throws SOAPException {
        for (Map.Entry<String, AttachmentBlock> e : im.getAttachments().entrySet()) {
            AttachmentBlock block = e.getValue();
            block.addTo(msg);
        }
    }

    protected void endEnvelope(XMLStreamWriter writer) {
        try {
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
    }

    protected void writeFault(SOAPFaultInfo instance, MessageInfo messageInfo, XMLStreamWriter writer) {
        throw new UnsupportedOperationException();
    }

    protected void writeFault(SOAPFaultInfo instance, MessageInfo messageInfo, OutputStream out) {
        XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter(out);
        this.writeFault(instance, messageInfo, writer);
    }

    @Override
    public void write(Object value, Object obj, OutputStream writer, MtomCallback mtomCallback) {
        BridgeContext bc;
        if (!(obj instanceof MessageInfo)) {
            throw new SerializationException("incorrect.messageinfo", obj.getClass().getName());
        }
        MessageInfo mi = (MessageInfo)obj;
        Object rtc = mi.getMetaData("com.sun.xml.ws.runtime.context");
        if (rtc != null && (bc = ((RuntimeContext)rtc).getBridgeContext()) != null) {
            JAXWSAttachmentMarshaller am = (JAXWSAttachmentMarshaller)((RuntimeContext)rtc).getBridgeContext().getAttachmentMarshaller();
            am.setMtomCallback(mtomCallback);
        }
        if (value instanceof JAXBBridgeInfo) {
            this.writeJAXBBridgeInfo((JAXBBridgeInfo)value, mi, writer);
        } else if (value instanceof RpcLitPayload) {
            this.writeRpcLitPayload((RpcLitPayload)value, mi, writer);
        } else if (value instanceof Source) {
            this.serializeSource((Source)value, writer);
        } else if (value instanceof SOAPFaultInfo) {
            this.writeFault((SOAPFaultInfo)value, mi, writer);
        } else if (value instanceof JAXBBeanInfo) {
            this.writeJAXBBeanInfo((JAXBBeanInfo)value, writer);
        } else {
            throw new SerializationException("unknown.object", value.getClass().getName());
        }
    }

    @Override
    public void write(Object value, Object obj, XMLStreamWriter writer, MtomCallback mtomCallback) {
        BridgeContext bc;
        if (!(obj instanceof MessageInfo)) {
            throw new SerializationException("incorrect.messageinfo", obj.getClass().getName());
        }
        MessageInfo mi = (MessageInfo)obj;
        Object rtc = mi.getMetaData("com.sun.xml.ws.runtime.context");
        if (rtc != null && (bc = ((RuntimeContext)rtc).getBridgeContext()) != null) {
            JAXWSAttachmentMarshaller am = (JAXWSAttachmentMarshaller)((RuntimeContext)rtc).getBridgeContext().getAttachmentMarshaller();
            am.setMtomCallback(mtomCallback);
        }
        if (value instanceof JAXBBridgeInfo) {
            this.writeJAXBBridgeInfo((JAXBBridgeInfo)value, mi, writer);
        } else if (value instanceof RpcLitPayload) {
            this.writeRpcLitPayload((RpcLitPayload)value, mi, writer);
        } else if (value instanceof Source) {
            this.serializeSource((Source)value, writer);
        } else if (value instanceof SOAPFaultInfo) {
            this.writeFault((SOAPFaultInfo)value, mi, writer);
        } else if (value instanceof JAXBBeanInfo) {
            this.writeJAXBBeanInfo((JAXBBeanInfo)value, mi, writer);
        } else {
            throw new SerializationException("unknown.object", value.getClass().getName());
        }
    }

    protected boolean getMTOMEncodingPolicy(MessageInfo messageInfo) {
        Object rtc = messageInfo.getMetaData("com.sun.xml.ws.runtime.context");
        if (rtc != null) {
            RuntimeModel model = ((RuntimeContext)rtc).getModel();
            return model != null ? model.mtomEncodingPolicy() : false;
        }
        return false;
    }
}

