/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.client;

import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.SenderException;
import com.sun.xml.ws.client.dispatch.DispatchContext;
import com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.ws.encoding.internal.InternalEncoder;
import com.sun.xml.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.SOAPUtil;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.Service;

public class SOAPXMLEncoder
extends SOAPEncoder {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch.util").toString());

    protected JAXBContext getJAXBContext(MessageInfo messageInfo) {
        JAXBContext jc = null;
        RequestContext context = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        if (context != null) {
            jc = (JAXBContext)context.get("com.sun.xml.ws.jaxbcontext");
        }
        return jc;
    }

    protected boolean skipHeader(MessageInfo messageInfo) {
        return messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.PAYLOAD;
    }

    protected QName getHeaderTag() {
        return SOAPConstants.QNAME_SOAP_HEADER;
    }

    protected void skipHeader(XMLStreamReader writer) {
    }

    public InternalMessage toInternalMessage(MessageInfo messageInfo) {
        InternalMessage internalMessage = new InternalMessage();
        DispatchContext context = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
        if (context != null) {
            DispatchContext.MessageType type = (DispatchContext.MessageType)((Object)context.getProperty("com.sun.xml.ws.rt.client.dispatch.messagetype"));
            Object[] data = messageInfo.getData();
            BodyBlock bodyBlock = null;
            switch (type) {
                case JAXB_MESSAGE: {
                    break;
                }
                case JAXB_PAYLOAD: {
                    JAXBBeanInfo jaxbInfo = new JAXBBeanInfo(data[0], this.getJAXBContext(messageInfo));
                    bodyBlock = new BodyBlock(jaxbInfo);
                    break;
                }
                case SOURCE_PAYLOAD: {
                    data = messageInfo.getData();
                    bodyBlock = new BodyBlock((Source)data[0]);
                    break;
                }
            }
            if (bodyBlock != null) {
                internalMessage.setBody(bodyBlock);
            }
        } else {
            SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            InternalEncoder internalEncoder = eptf.getInternalEncoder();
            return (InternalMessage)internalEncoder.toInternalMessage(messageInfo);
        }
        return internalMessage;
    }

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, MessageInfo messageInfo) {
        SOAPMessage message = null;
        XMLStreamWriter writer = null;
        JAXWSAttachmentMarshaller marshaller = null;
        boolean xopEnabled = false;
        try {
            this.setAttachmentsMap(messageInfo, internalMessage);
            ByteArrayBuffer bab = new ByteArrayBuffer();
            if (messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic") {
                writer = XMLStreamWriterFactory.createFIStreamWriter(bab);
                marshaller = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
                if (marshaller != null) {
                    xopEnabled = marshaller.isXOPPackage();
                    marshaller.setXOPPackage(false);
                }
            } else {
                messageInfo.setMetaData("com.sun.xml.bind.api.Bridge.outputStream", bab);
                writer = XMLStreamWriterFactory.createXMLStreamWriter(bab);
            }
            writer.writeStartDocument();
            this.startEnvelope(writer);
            this.writeEnvelopeNamespaces(writer, messageInfo);
            if (!this.skipHeader(messageInfo)) {
                this.writeHeaders(writer, internalMessage, messageInfo);
            }
            this.writeBody(writer, internalMessage, messageInfo);
            this.endEnvelope(writer);
            writer.writeEndDocument();
            writer.close();
            MimeHeaders mh = new MimeHeaders();
            mh.addHeader("Content-Type", this.getContentType(messageInfo, marshaller));
            message = SOAPUtil.createMessage(mh, bab.newInputStream(), this.getBindingId());
            this.processAttachments(internalMessage, message);
            if (marshaller != null) {
                marshaller.setXOPPackage(xopEnabled);
            }
        }
        catch (IOException e) {
            throw new SenderException("sender.request.messageNotReady", new Object[]{e});
        }
        catch (SOAPException e) {
            throw new SenderException(e);
        }
        catch (XMLStreamException e) {
            throw new SenderException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    throw new SenderException(e);
                }
            }
        }
        return message;
    }

    public InternalMessage createInternalMessage(MessageInfo messageInfo) {
        InternalMessage internalMessage = new InternalMessage();
        Object response = messageInfo.getResponse();
        BodyBlock bodyBlock = null;
        if (this.getJAXBContext(messageInfo) != null) {
            JAXBBeanInfo jaxbBean = new JAXBBeanInfo(response, this.getJAXBContext(messageInfo));
            bodyBlock = new BodyBlock(jaxbBean);
        } else if (response instanceof Source) {
            bodyBlock = new BodyBlock((Source)response);
        }
        internalMessage.setBody(bodyBlock);
        return internalMessage;
    }

    protected String getContentType(MessageInfo messageInfo, JAXWSAttachmentMarshaller marshaller) {
        String contentNegotiation = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (marshaller == null) {
            marshaller = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
        }
        if (marshaller != null && (marshaller.isXopped() || this.getMTOMEncodingPolicy(messageInfo))) {
            return "application/xop+xml;type=\"text/xml\"";
        }
        return contentNegotiation == "optimistic" ? "application/fastinfoset" : "text/xml";
    }

    protected String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

