/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.internal;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.ContactInfoBase;
import com.sun.xml.ws.client.ContextMap;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.encoding.soap.internal.MessageInfoBase;
import com.sun.xml.ws.pept.Delegate;
import com.sun.xml.ws.pept.ept.ContactInfo;
import com.sun.xml.ws.pept.ept.ContactInfoList;
import com.sun.xml.ws.pept.ept.ContactInfoListIterator;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.pept.presentation.MessageStruct;
import com.sun.xml.ws.pept.protocol.MessageDispatcher;
import javax.xml.ws.BindingProvider;

public class DelegateBase
implements Delegate {
    protected ContactInfoList contactInfoList;
    protected WSServiceDelegate service;

    public DelegateBase() {
    }

    public DelegateBase(ContactInfoList contactInfoList) {
        this.contactInfoList = contactInfoList;
    }

    public DelegateBase(ContactInfoList cil, WSServiceDelegate service) {
        this(cil);
        this.service = service;
    }

    public MessageStruct getMessageStruct() {
        return new MessageInfoBase();
    }

    public void send(MessageStruct messageStruct) {
        MessageInfo messageInfo = (MessageInfo)messageStruct;
        if (!this.contactInfoList.iterator().hasNext()) {
            throw new RuntimeException("can't pickup message encoder/decoder, no ContactInfo!");
        }
        ContextMap properties = (ContextMap)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        BindingProvider stub = (BindingProvider)properties.get("com.sun.xml.ws.client.handle");
        BindingImpl bi = (BindingImpl)stub.getBinding();
        String bindingId = bi.getBindingId();
        ContactInfo contactInfo = this.getContactInfo(this.contactInfoList, bindingId);
        messageInfo.setEPTFactory(contactInfo);
        MessageDispatcher messageDispatcher = contactInfo.getMessageDispatcher(messageInfo);
        messageDispatcher.send(messageInfo);
    }

    private ContactInfo getContactInfo(ContactInfoList cil, String bindingId) {
        ContactInfoListIterator iter = cil.iterator();
        while (iter.hasNext()) {
            ContactInfoBase cib = (ContactInfoBase)iter.next();
            if (!cib.getBindingId().equals(bindingId)) continue;
            return cib;
        }
        return cil.iterator().next();
    }

    public WSServiceDelegate getServiceDelegate() {
        return this.service;
    }
}

