/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.server;

import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.encoding.soap.SOAPDecoder;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.handler.HandlerContext;
import com.sun.xml.ws.handler.MessageContextUtil;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.streaming.SourceReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.MessageInfoUtil;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPXMLDecoder
extends SOAPDecoder {
    private static final Set<String> requiredRoles = new HashSet<String>();

    public SOAPXMLDecoder() {
        requiredRoles.add("http://schemas.xmlsoap.org/soap/actor/next");
        requiredRoles.add("");
    }

    @Override
    public InternalMessage toInternalMessage(SOAPMessage soapMessage, MessageInfo messageInfo) {
        InternalMessage internalMessage;
        block6: {
            XMLStreamReader reader = null;
            try {
                InternalMessage request = new InternalMessage();
                this.processAttachments(messageInfo, request, soapMessage);
                Source source = soapMessage.getSOAPPart().getContent();
                reader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(soapMessage));
                XMLStreamReaderUtil.nextElementContent(reader);
                this.decodeEnvelope(reader, request, false, messageInfo);
                internalMessage = request;
                if (reader == null) break block6;
            }
            catch (Exception e) {
                try {
                    if (this.isBadXML(e)) {
                        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
                        HandlerContext handlerCtxt = rtCtxt.getHandlerContext();
                        this.raiseBadXMLFault(handlerCtxt);
                    }
                    throw new ServerRtException("soapdecoder.err", new Object[]{e});
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        XMLStreamReaderUtil.close(reader);
                    }
                    throw throwable;
                }
            }
            XMLStreamReaderUtil.close(reader);
        }
        return internalMessage;
    }

    protected boolean isBadXML(Exception e) {
        while (e != null) {
            if (e instanceof XMLStreamException) {
                return true;
            }
            e = e.getCause() instanceof Exception ? (Exception)e.getCause() : null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InternalMessage toInternalMessage(SOAPMessage soapMessage, InternalMessage request, MessageInfo messageInfo) {
        XMLStreamReader reader = null;
        try {
            this.processAttachments(messageInfo, request, soapMessage);
            Source source = soapMessage.getSOAPPart().getContent();
            reader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(soapMessage));
            XMLStreamReaderUtil.nextElementContent(reader);
            this.decodeEnvelope(reader, request, true, messageInfo);
            this.convertBodyBlock(request, messageInfo);
            if (reader == null) return request;
        }
        catch (Exception e) {
            try {
                if (!this.isBadXML(e)) throw new ServerRtException("soapdecoder.err", new Object[]{e});
                RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
                HandlerContext handlerCtxt = rtCtxt.getHandlerContext();
                this.raiseBadXMLFault(handlerCtxt);
                throw new ServerRtException("soapdecoder.err", new Object[]{e});
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                XMLStreamReaderUtil.close(reader);
                throw throwable;
            }
        }
        XMLStreamReaderUtil.close(reader);
        return request;
    }

    @Override
    public void decodeDispatchMethod(XMLStreamReader reader, InternalMessage request, MessageInfo messageInfo) {
        RuntimeContext rtCtxt;
        Method method;
        QName name = reader.getEventType() == 1 ? reader.getName() : null;
        MessageContext msgCtxt = MessageInfoUtil.getMessageContext(messageInfo);
        if (msgCtxt != null) {
            MessageContextUtil.setWsdlOperation(msgCtxt, name);
        }
        if ((method = (rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo)).getDispatchMethod(name, messageInfo)) == null) {
            this.raiseFault(this.getSenderFaultCode(), "Cannot find the dispatch method");
        }
        messageInfo.setMethod(method);
    }

    @Override
    protected SOAPFaultInfo decodeFault(XMLStreamReader reader, InternalMessage internalMessage, MessageInfo messageInfo) {
        this.raiseFault(this.getSenderFaultCode(), "Server cannot handle fault message");
        return null;
    }

    @Override
    protected void raiseBadXMLFault(HandlerContext ctxt) {
        MessageContextUtil.setHttpStatusCode(ctxt.getMessageContext(), 400);
        this.raiseFault(this.getSenderFaultCode(), "Bad request");
    }

    @Override
    public Set<String> getRequiredRoles() {
        return requiredRoles;
    }

    @Override
    public String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAPConstants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
    }
}

