/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.xml;

import com.sun.xml.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.ws.encoding.jaxb.JAXBTypeSerializer;
import com.sun.xml.ws.protocol.xml.XMLMessageException;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.FastInfosetReflection;
import com.sun.xml.ws.util.FastInfosetUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;

public final class XMLMessage {
    private static final Logger log = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.protocol.xml");
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;
    protected MimeHeaders headers;
    private final DataRepresentation data;
    protected boolean useFastInfoset;
    protected boolean noData;

    public XMLMessage(MimeHeaders headers, InputStream in) {
        block7: {
            this.useFastInfoset = false;
            this.noData = false;
            this.headers = headers;
            String ct = null;
            if (headers != null) {
                ct = XMLMessage.getContentType(headers);
            }
            try {
                int contentTypeId;
                boolean isFastInfoset;
                if (ct == null || ct.equals("application/x-www-form-urlencoded")) {
                    this.data = new XMLSource(null, false);
                    return;
                }
                ContentType contentType = new ContentType(ct);
                if (contentType.getParameter("type") == null) {
                    contentType.setParameter("type", "text/xml");
                }
                boolean bl = isFastInfoset = ((contentTypeId = XMLMessage.identifyContentType(contentType)) & 0x10) > 0;
                if ((contentTypeId & 1) != 0) {
                    this.data = new XMLSource(in, isFastInfoset);
                    break block7;
                }
                if ((contentTypeId & 2) != 0) {
                    this.data = new XMLDataSource(ct, in, isFastInfoset);
                    break block7;
                }
                throw new XMLMessageException("xml.unknown.Content-Type", new Object[0]);
            }
            catch (Exception ex) {
                throw new XMLMessageException("xml.cannot.internalize.message", new Object[]{ex});
            }
        }
    }

    public XMLMessage(Source source, boolean useFastInfoset) {
        this.useFastInfoset = false;
        this.noData = false;
        if (source == null) {
            this.noData = true;
        }
        this.data = new XMLSource(source);
        this.headers = new MimeHeaders();
        this.useFastInfoset = useFastInfoset;
        this.headers.addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Exception err, boolean useFastInfoset) {
        this.useFastInfoset = false;
        this.noData = false;
        this.data = new XMLErr(err);
        this.headers = new MimeHeaders();
        this.useFastInfoset = useFastInfoset;
        this.headers.addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(DataSource dataSource, boolean useFastInfoset) {
        String contentType;
        this.useFastInfoset = false;
        this.noData = false;
        if (dataSource == null) {
            this.noData = true;
        }
        this.data = new XMLDataSource(dataSource, (contentType = dataSource.getContentType()).indexOf("application/fastinfoset") > 0);
        this.headers = new MimeHeaders();
        this.useFastInfoset = useFastInfoset;
        this.headers.addHeader("Content-Type", !useFastInfoset ? contentType : contentType.replaceFirst("text/xml", "application/fastinfoset"));
    }

    public XMLMessage(Object object, JAXBContext context, boolean useFastInfoset) {
        this.useFastInfoset = false;
        this.noData = false;
        if (object == null) {
            this.noData = true;
        }
        this.data = new XMLJaxb(object, context);
        this.headers = new MimeHeaders();
        this.useFastInfoset = useFastInfoset;
        this.headers.addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public boolean isFastInfoset() {
        return this.data.isFastInfoset();
    }

    public boolean hasNoData() {
        return this.noData;
    }

    public boolean acceptFastInfoset() {
        return FastInfosetUtil.isFastInfosetAccepted(this.headers.getHeader("Accept"));
    }

    public Source getSource() {
        return this.data.getSource();
    }

    public DataSource getDataSource() {
        return this.data.getDataSource();
    }

    private static int identifyContentType(ContentType contentType) {
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        if (primary.equalsIgnoreCase("multipart")) {
            if (sub.equalsIgnoreCase("related")) {
                String type = contentType.getParameter("type");
                if (XMLMessage.isXMLType(type)) {
                    return 2;
                }
                if (XMLMessage.isFastInfosetType(type)) {
                    return 18;
                }
                throw new XMLMessageException("xml.content-type.mustbe.multipart", new Object[0]);
            }
            throw new XMLMessageException("xml.invalid.content-type", primary + "/" + sub);
        }
        if (XMLMessage.isXMLType(primary, sub)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(primary, sub)) {
            return 17;
        }
        throw new XMLMessageException("xml.invalid.content-type", primary + "/" + sub);
    }

    protected static boolean isXMLType(String primary, String sub) {
        return primary.equalsIgnoreCase("text") && sub.equalsIgnoreCase("xml");
    }

    protected static boolean isXMLType(String type) {
        return type.toLowerCase().startsWith("text/xml");
    }

    protected static boolean isFastInfosetType(String primary, String sub) {
        return primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String type) {
        return type.toLowerCase().startsWith("application/fastinfoset");
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    private static String getContentType(MimeHeaders headers) {
        String[] values = headers.getHeader("Content-Type");
        return values == null ? null : values[0];
    }

    public String getContentType() {
        return XMLMessage.getContentType(this.headers);
    }

    public void setContentType(String type) {
        this.headers.setHeader("Content-Type", type);
    }

    public int getStatus() {
        return this.data.getStatus();
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!this.hasNoData()) {
            this.data.writeTo(out, this.useFastInfoset);
        }
    }

    public Source getPayload() {
        return this.data.getPayload();
    }

    public void setPayload(Source payload) {
        this.data.setPayload(payload);
    }

    public Object getPayload(JAXBContext context) {
        return this.data.getPayload(context);
    }

    public void setPayload(Object jaxbObj, JAXBContext context) {
        this.data.setPayload(jaxbObj, context);
    }

    private static final class XMLErr
    extends DataRepresentation {
        private final Exception err;

        XMLErr(Exception err) {
            this.err = err;
        }

        public Source getPayload() {
            return null;
        }

        public Object getPayload(JAXBContext context) {
            return null;
        }

        public void setPayload(Source payload) {
            throw new UnsupportedOperationException();
        }

        void setPayload(Object jaxbObject, JAXBContext context) {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream out, boolean useFastInfoset) throws IOException {
            String msg = this.err.getMessage();
            if (msg == null) {
                msg = this.err.toString();
            }
            msg = "<err>" + msg + "</err>";
            if (useFastInfoset) {
                FastInfosetUtil.transcodeXMLStringToFI(msg, out);
            } else {
                out.write(msg.getBytes());
            }
        }

        boolean isFastInfoset() {
            return false;
        }

        Source getSource() {
            return null;
        }

        DataSource getDataSource() {
            throw new UnsupportedOperationException();
        }

        int getStatus() {
            if (this.err instanceof HTTPException) {
                return ((HTTPException)this.err).getStatusCode();
            }
            return 500;
        }
    }

    public static class XMLJaxb
    extends DataRepresentation {
        private Object object;
        private JAXBContext jaxbContext;

        public XMLJaxb(Object object, JAXBContext jaxbContext) {
            this.object = object;
            this.jaxbContext = jaxbContext;
        }

        public void writeTo(OutputStream out, boolean useFastInfoset) {
            if (useFastInfoset) {
                JAXBTypeSerializer.serializeDocument(this.object, XMLStreamWriterFactory.createFIStreamWriter(out), this.jaxbContext);
            } else {
                JAXBTypeSerializer.serialize(this.object, out, this.jaxbContext);
            }
        }

        boolean isFastInfoset() {
            return false;
        }

        public Source getSource() {
            return JAXBTypeSerializer.serialize(this.object, this.jaxbContext);
        }

        DataSource getDataSource() {
            throw new UnsupportedOperationException();
        }

        public Source getPayload() {
            return this.getSource();
        }

        public void setPayload(Source source) {
            this.object = JAXBTypeSerializer.deserialize(source, this.jaxbContext);
        }

        public Object getPayload(JAXBContext ctxt) {
            return this.object;
        }

        public void setPayload(Object jaxbObj, JAXBContext ctxt) {
            this.object = jaxbObj;
            this.jaxbContext = ctxt;
        }
    }

    public static class XMLSource
    extends DataRepresentation {
        private Source source;
        private boolean isFastInfoset;

        public XMLSource(InputStream in, boolean isFastInfoset) throws Exception {
            this.source = isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(in) : new StreamSource(in);
            this.isFastInfoset = isFastInfoset;
        }

        public XMLSource(Source source) {
            this.source = source;
            this.isFastInfoset = source != null ? source.getClass() == FastInfosetReflection.fiFastInfosetSource : false;
        }

        public boolean isFastInfoset() {
            return this.isFastInfoset;
        }

        public void writeTo(OutputStream out, boolean useFastInfoset) {
            try {
                InputStream is = null;
                boolean canAvoidTransform = false;
                if (this.source instanceof StreamSource) {
                    is = ((StreamSource)this.source).getInputStream();
                    ByteArrayInputStream tis = (ByteArrayInputStream)is;
                    canAvoidTransform = !useFastInfoset;
                } else if (this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                    is = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                    canAvoidTransform = useFastInfoset;
                }
                assert (is != null);
                if (canAvoidTransform && is instanceof ByteInputStream) {
                    ByteInputStream bis = (ByteInputStream)is;
                    byte[] buf = bis.getBytes();
                    out.write(buf);
                    bis.close();
                    return;
                }
                Transformer transformer = XmlUtil.newTransformer();
                transformer.transform(this.source, useFastInfoset ? FastInfosetReflection.FastInfosetResult_new(out) : new StreamResult(out));
            }
            catch (Exception e) {
                throw new WebServiceException(e);
            }
        }

        public Source getSource() {
            return this.source;
        }

        DataSource getDataSource() {
            return null;
        }

        public Source getPayload() {
            try {
                if (this.source instanceof DOMSource) {
                    return this.source;
                }
                InputStream is = null;
                if (this.source instanceof StreamSource) {
                    is = ((StreamSource)this.source).getInputStream();
                } else if (this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                    is = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                }
                assert (is != null);
                if (is != null && is instanceof ByteInputStream) {
                    ByteInputStream bis = (ByteInputStream)is;
                    byte[] buf = bis.getBytes();
                    ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                    bis.close();
                    return this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(is) : new StreamSource(bais);
                }
                ByteArrayBuffer bab = new ByteArrayBuffer();
                Transformer transformer = XmlUtil.newTransformer();
                transformer.transform(this.source, this.isFastInfoset ? FastInfosetReflection.FastInfosetResult_new(bab) : new StreamResult(bab));
                bab.close();
                InputStream bis = bab.newInputStream();
                this.source = this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(bis) : new StreamSource(bis);
                bis = bab.newInputStream();
                return this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(bis) : new StreamSource(bis);
            }
            catch (Exception e) {
                throw new WebServiceException(e);
            }
        }

        public void setPayload(Source source) {
            this.source = source;
        }

        public Object getPayload(JAXBContext ctxt) {
            return JAXBTypeSerializer.deserialize(this.getPayload(), ctxt);
        }

        public void setPayload(Object jaxbObj, JAXBContext ctxt) {
            try {
                ByteArrayBuffer bab = new ByteArrayBuffer();
                if (this.isFastInfoset) {
                    JAXBTypeSerializer.serializeDocument(jaxbObj, XMLStreamWriterFactory.createFIStreamWriter(bab), ctxt);
                } else {
                    JAXBTypeSerializer.serialize(jaxbObj, bab, ctxt);
                }
                InputStream bis = bab.newInputStream();
                this.source = this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(bis) : new StreamSource(bis);
            }
            catch (Exception e) {
                throw new WebServiceException(e);
            }
        }
    }

    private static final class XMLDataSource
    extends DataRepresentation {
        private DataSource dataSource;
        private MimeMultipart multipart;
        private XMLSource xmlSource;
        private boolean isFastInfoset;

        public XMLDataSource(final String contentType, final InputStream is, boolean isFastInfoset) {
            this.isFastInfoset = isFastInfoset;
            this.dataSource = new DataSource(){

                public InputStream getInputStream() {
                    return is;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return contentType;
                }

                public String getName() {
                    return "";
                }
            };
        }

        public XMLDataSource(DataSource dataSource, boolean isFastInfoset) {
            this.dataSource = dataSource;
            this.isFastInfoset = isFastInfoset;
        }

        public boolean isFastInfoset() {
            return this.isFastInfoset;
        }

        public DataSource getDataSource() {
            if (this.dataSource != null) {
                return this.dataSource;
            }
            if (this.multipart != null) {
                return new DataSource(){

                    public InputStream getInputStream() {
                        try {
                            if (XMLDataSource.this.xmlSource != null) {
                                XMLDataSource.this.replaceRootPart(false);
                            }
                            ByteOutputStream bos = new ByteOutputStream();
                            XMLDataSource.this.multipart.writeTo((OutputStream)bos);
                            return bos.newInputStream();
                        }
                        catch (MessagingException me) {
                            throw new XMLMessageException("xml.get.ds.err", new Object[]{me});
                        }
                        catch (IOException ioe) {
                            throw new XMLMessageException("xml.get.ds.err", new Object[]{ioe});
                        }
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }

                    public String getContentType() {
                        return XMLDataSource.this.multipart.getContentType().toString();
                    }

                    public String getName() {
                        return "";
                    }
                };
            }
            return null;
        }

        private MimeBodyPart getRootPart() {
            try {
                ContentType contentType = this.multipart.getContentType();
                String startParam = contentType.getParameter("start");
                MimeBodyPart sourcePart = startParam == null ? this.multipart.getBodyPart(0) : this.multipart.getBodyPart(startParam);
                return sourcePart;
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
        }

        private void replaceRootPart(boolean useFastInfoset) {
            if (this.xmlSource == null) {
                return;
            }
            try {
                MimeBodyPart sourcePart = this.getRootPart();
                String ctype = sourcePart.getContentType();
                this.multipart.removeBodyPart(sourcePart);
                ByteOutputStream bos = new ByteOutputStream();
                this.xmlSource.writeTo((OutputStream)bos, useFastInfoset);
                InternetHeaders headers = new InternetHeaders();
                headers.addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : ctype);
                sourcePart = new MimeBodyPart(headers, bos.getBytes(), bos.getCount());
                this.multipart.addBodyPart(sourcePart, 0);
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
        }

        private void convertToMultipart() {
            if (this.dataSource != null) {
                try {
                    this.multipart = new MimeMultipart(this.dataSource, null);
                    this.dataSource = null;
                }
                catch (MessagingException ex) {
                    throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
                }
            }
        }

        public Source getSource() {
            try {
                if (this.xmlSource != null) {
                    return this.xmlSource.getPayload();
                }
                this.convertToMultipart();
                MimeBodyPart sourcePart = this.getRootPart();
                ContentType ctype = new ContentType(sourcePart.getContentType());
                String baseType = ctype.getBaseType();
                if (XMLMessage.isXMLType(baseType)) {
                    return new StreamSource(sourcePart.getInputStream());
                }
                if (XMLMessage.isFastInfosetType(baseType)) {
                    return FastInfosetReflection.FastInfosetSource_new(sourcePart.getInputStream());
                }
                throw new XMLMessageException("xml.root.part.invalid.Content-Type", baseType);
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
            catch (Exception ioe) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ioe});
            }
        }

        public Source getPayload() {
            return this.getSource();
        }

        public void setPayload(Source source) {
            this.xmlSource = new XMLSource(source);
        }

        public Object getPayload(JAXBContext ctxt) {
            return JAXBTypeSerializer.deserialize(this.getPayload(), ctxt);
        }

        public void setPayload(Object jaxbObj, JAXBContext ctxt) {
            this.xmlSource = new XMLSource(null);
            this.xmlSource.setPayload(jaxbObj, ctxt);
        }

        public void writeTo(OutputStream out, boolean useFastInfoset) {
            try {
                if (this.xmlSource != null) {
                    this.convertToMultipart();
                }
                if (this.dataSource != null) {
                    if (this.isFastInfoset == useFastInfoset) {
                        int len;
                        InputStream is = this.dataSource.getInputStream();
                        byte[] buf = new byte[1024];
                        while ((len = is.read(buf)) != -1) {
                            out.write(buf, 0, len);
                        }
                        return;
                    }
                    this.xmlSource = new XMLSource(this.getSource());
                }
                this.replaceRootPart(useFastInfoset);
                this.multipart.writeTo(out);
            }
            catch (Exception e) {
                throw new WebServiceException(e);
            }
        }
    }

    private static abstract class DataRepresentation {
        private DataRepresentation() {
        }

        abstract Source getPayload();

        abstract Object getPayload(JAXBContext var1);

        abstract void setPayload(Source var1);

        abstract void setPayload(Object var1, JAXBContext var2);

        abstract void writeTo(OutputStream var1, boolean var2) throws IOException;

        abstract boolean isFastInfoset();

        abstract Source getSource();

        abstract DataSource getDataSource();

        int getStatus() {
            return 200;
        }
    }
}

