/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.xml.ws.util.ByteArrayDataSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContextUtil {
    public static Integer getHttpStatusCode(MessageContext ctxt) {
        return (Integer)ctxt.get("javax.xml.ws.http.response.code");
    }

    public static void setHttpStatusCode(MessageContext ctxt, Integer code) {
        ctxt.put("javax.xml.ws.http.response.code", code);
        ctxt.setScope("javax.xml.ws.http.response.code", MessageContext.Scope.APPLICATION);
    }

    public static void setQueryString(MessageContext ctxt, String queryString) {
        ctxt.put("javax.xml.ws.http.request.querystring", queryString);
        ctxt.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
    }

    public static void setPathInfo(MessageContext ctxt, String pathInfo) {
        ctxt.put("javax.xml.ws.http.request.pathinfo", pathInfo);
        ctxt.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpExchange(MessageContext ctxt, HttpExchange exch) {
        ctxt.put("com.sun.xml.ws.http.exchange", exch);
        ctxt.setScope("com.sun.xml.ws.http.exchange", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpRequestMethod(MessageContext ctxt, String method) {
        ctxt.put("javax.xml.ws.http.request.method", method);
        ctxt.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpRequestHeaders(MessageContext ctxt, Map<String, List<String>> headers) {
        ctxt.put("javax.xml.ws.http.request.headers", headers);
        ctxt.setScope("javax.xml.ws.http.request.headers", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpResponseHeaders(MessageContext ctxt, Map<String, List<String>> headers) {
        ctxt.put("javax.xml.ws.http.response.headers", headers);
        ctxt.setScope("javax.xml.ws.http.response.headers", MessageContext.Scope.APPLICATION);
    }

    public static void setWsdlOperation(MessageContext ctxt, QName name) {
        ctxt.put("javax.xml.ws.wsdl.operation", name);
        ctxt.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
    }

    private static Map<String, DataHandler> getMessageAttachments(MessageContext ctxt) {
        Object att;
        String property = "javax.xml.ws.binding.attachments.inbound";
        if (((Boolean)ctxt.get("javax.xml.ws.handler.message.outbound")).booleanValue()) {
            property = "javax.xml.ws.binding.attachments.outbound";
        }
        if ((att = ctxt.get(property)) == null) {
            HashMap<String, DataHandler> attMap = new HashMap<String, DataHandler>();
            ctxt.put(property, attMap);
            ctxt.setScope(property, MessageContext.Scope.APPLICATION);
            return attMap;
        }
        return (Map)att;
    }

    public static void copyInboundMessageAttachments(MessageContext ctxt, Iterator<AttachmentPart> attachments) throws SOAPException {
        Map<String, DataHandler> attachMap = MessageContextUtil.getMessageAttachments(ctxt);
        while (attachments.hasNext()) {
            AttachmentPart ap = attachments.next();
            DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(ap.getRawContentBytes(), ap.getContentType()));
            attachMap.put(ap.getContentId(), dh);
        }
    }

    public static void setMessageAttachments(MessageContext ctxt, Iterator<AttachmentPart> attachments) throws SOAPException {
        Map<String, DataHandler> attachMap = MessageContextUtil.getMessageAttachments(ctxt);
        while (attachments.hasNext()) {
            AttachmentPart ap = attachments.next();
            DataHandler dh = new DataHandler((Object)new ByteArrayDataSource(ap.getRawContentBytes(), ap.getContentType()), ap.getContentType());
            attachMap.put(ap.getContentId(), dh);
        }
    }

    public static void addMessageAttachment(MessageContext ctxt, String cid, DataHandler dh) {
        Map<String, DataHandler> attachMap = MessageContextUtil.getMessageAttachments(ctxt);
        attachMap.put(cid, dh);
    }

    public static boolean ignoreFaultInMessage(MessageContext context) {
        if (context.get("ignore fault in message") == null) {
            return false;
        }
        return (Boolean)context.get("ignore fault in message");
    }
}

