/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.xml.client;

import com.sun.xml.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.AsyncHandlerService;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.client.ContextMap;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.WSFuture;
import com.sun.xml.ws.client.dispatch.DispatchContext;
import com.sun.xml.ws.client.dispatch.ResponseImpl;
import com.sun.xml.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.ws.encoding.soap.client.SOAP12XMLEncoder;
import com.sun.xml.ws.encoding.soap.client.SOAPXMLEncoder;
import com.sun.xml.ws.encoding.soap.internal.MessageInfoBase;
import com.sun.xml.ws.encoding.xml.XMLEncoder;
import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.handler.HandlerChainCaller;
import com.sun.xml.ws.handler.XMLHandlerContext;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.pept.ept.EPTFactory;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.spi.runtime.ClientTransportFactory;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.transport.http.client.HttpClientTransportFactory;
import com.sun.xml.ws.util.XMLConnectionUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMessageDispatcher
implements MessageDispatcher {
    protected static final int MAX_THREAD_POOL_SIZE = 3;
    protected static final long AWAIT_TERMINATION_TIME = 10L;
    protected ExecutorService executorService = null;
    private Map requestContext;

    @Override
    public void send(MessageInfo messageInfo) {
        if (this.isAsync(messageInfo)) {
            this.doSendAsync(messageInfo);
        } else {
            this.doSend(messageInfo);
        }
    }

    protected XMLMessage doSend(MessageInfo messageInfo) {
        EPTFactory contactInfo = messageInfo.getEPTFactory();
        XMLEncoder encoder = (XMLEncoder)contactInfo.getEncoder(messageInfo);
        boolean handlerResult = true;
        boolean isRequestResponse = messageInfo.getMEP() == 1;
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
        if (!this.isHTTPMessageType(dispatchContext)) {
            throw new WebServiceException("Mode not allowed with HTTP Binding. Must use other Service.mode");
        }
        XMLMessage xm = this.makeXMLMessage(messageInfo);
        try {
            HandlerChainCaller caller = this.getHandlerChainCaller(messageInfo);
            if (caller.hasHandlers()) {
                XMLHandlerContext handlerContext = new XMLHandlerContext(messageInfo, null, xm);
                this.updateMessageContext(messageInfo, handlerContext);
                handlerResult = this.callHandlersOnRequest(handlerContext);
                xm = handlerContext.getXMLMessage();
                if (xm == null) {
                    xm = encoder.toXMLMessage(handlerContext.getInternalMessage(), messageInfo);
                }
                if (isRequestResponse && !handlerResult) {
                    return xm;
                }
            }
            Map<String, Object> context = this.processMetadata(messageInfo, xm);
            HashMap<String, List<String>> ch = new HashMap<String, List<String>>();
            Iterator iter = xm.getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                ArrayList<String> h = new ArrayList<String>();
                MimeHeader mh = (MimeHeader)iter.next();
                h.clear();
                h.add(mh.getValue());
                ch.put(mh.getName(), h);
            }
            this.setConnection(messageInfo, context);
            messageInfo.getConnection().setHeaders(ch);
            if (!this.isAsync(messageInfo)) {
                WSConnection connection = messageInfo.getConnection();
                XMLConnectionUtil.sendResponse(connection, xm);
            }
            if (isRequestResponse && handlerResult) {
                this.receive(messageInfo);
                this.postReceiveHook(messageInfo);
            }
        }
        catch (Throwable e) {
            this.setResponseType(e, messageInfo);
            messageInfo.setResponse(e);
        }
        return xm;
    }

    protected Map<String, Object> processMetadata(MessageInfo messageInfo, XMLMessage xm) {
        JavaMethod javaMethod;
        HashMap<String, Object> messageContext = new HashMap<String, Object>();
        ArrayList header = new ArrayList();
        ContextMap properties = (ContextMap)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        DispatchContext dcontext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
        if (this.isHTTPMessageType(dcontext)) {
            this.setHTTPContext(messageContext, dcontext, properties);
        }
        if (messageInfo.getMEP() == 2) {
            messageContext.put("com.sun.xml.ws.server.OneWayOperation", "true");
        }
        if (properties != null) {
            Iterator<String> names = properties.getPropertyNames();
            while (names.hasNext()) {
                String propName = names.next();
                if (propName.equals(ClientTransportFactory.class.getName())) {
                    messageContext.put("com.sun.xml.ws.client.ClientTransportFactory", (ClientTransportFactory)properties.get(propName));
                    continue;
                }
                if (propName.equals("javax.xml.ws.session.maintain")) {
                    Object cookieJar;
                    Object maintainSession = properties.get("javax.xml.ws.session.maintain");
                    if (maintainSession == null || !maintainSession.equals(Boolean.TRUE) || (cookieJar = properties.get("com.sun.xml.ws.client.http.CookieJar")) == null) continue;
                    messageContext.put("com.sun.xml.ws.client.http.CookieJar", cookieJar);
                    continue;
                }
                messageContext.put(propName, properties.get(propName));
            }
        }
        String contentNegotiation = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        String bindingId = this.getBindingId(messageInfo);
        if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            xm.getMimeHeaders().addHeader("Accept", contentNegotiation != "none" ? "application/soap+fastinfoset, application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        } else {
            xm.getMimeHeaders().addHeader("Accept", contentNegotiation != "none" ? "application/fastinfoset, text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        Map requestHeaders = (Map)properties.get("javax.xml.ws.http.request.headers");
        if (requestHeaders != null && !requestHeaders.isEmpty()) {
            Set entrySet = requestHeaders.entrySet();
            MimeHeaders headers = xm.getMimeHeaders();
            for (Map.Entry entry : entrySet) {
                headers.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        messageContext.put("com.sun.xml.ws.binding", bindingId);
        RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.ws.runtime.context");
        if (runtimeContext != null && (javaMethod = runtimeContext.getModel().getJavaMethod(messageInfo.getMethod())) != null) {
            String soapAction = ((SOAPBinding)javaMethod.getBinding()).getSOAPAction();
            header.clear();
            if (soapAction == null) {
                xm.getMimeHeaders().addHeader("SOAPAction", "\"\"");
            } else {
                xm.getMimeHeaders().addHeader("SOAPAction", soapAction);
            }
        }
        return messageContext;
    }

    protected void setConnection(MessageInfo messageInfo, Map<String, Object> context) {
        ClientTransportFactory clientTransportFactory = (ClientTransportFactory)context.get("com.sun.xml.ws.client.ClientTransportFactory");
        WSConnection connection = null;
        if (clientTransportFactory == null) {
            clientTransportFactory = new HttpClientTransportFactory();
        }
        connection = clientTransportFactory.create(context);
        messageInfo.setConnection(connection);
    }

    protected void setResponseType(Throwable e, MessageInfo messageInfo) {
        if (e instanceof RuntimeException) {
            messageInfo.setResponseType(2);
            if (e instanceof ClientTransportException) {
                Throwable temp = e;
                e = new WebServiceException(temp.getMessage(), temp);
            }
        } else {
            messageInfo.setResponseType(1);
        }
        messageInfo.setResponse(e);
    }

    @Override
    public void receive(MessageInfo messageInfo) {
        EPTFactory contactInfo = messageInfo.getEPTFactory();
        XMLMessage xm = this.getXMLMessage(messageInfo);
        String contentNegotiation = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (contentNegotiation == "pessimistic") {
            try {
                if (xm.isFastInfoset()) {
                    Map requestContext = (Map)messageInfo.getMetaData("com.sun.xml.ws.context.request");
                    requestContext.put("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        XMLHandlerContext handlerContext = this.getInboundHandlerContext(messageInfo, xm);
        HandlerChainCaller caller = this.getHandlerChainCaller(messageInfo);
        if (caller.hasHandlers()) {
            this.callHandlersOnResponse(handlerContext);
            this.updateResponseContext(messageInfo, handlerContext);
        }
        this.setResponse(messageInfo, xm);
    }

    private void setResponse(MessageInfo messageInfo, XMLMessage xm) {
        block7: {
            block6: {
                DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
                Object clazz = dispatchContext.getProperty("com.sun.xml.ws.rt.client.dispatch.messageclass");
                if (!(clazz instanceof DispatchContext.MessageClass)) break block6;
                switch ((DispatchContext.MessageClass)((Object)clazz)) {
                    case SOURCE: {
                        messageInfo.setResponse(xm.getSource());
                        break block7;
                    }
                    case DATASOURCE: {
                        if (xm.getDataSource() != null) {
                            messageInfo.setResponse(xm.getDataSource());
                        }
                        break block7;
                    }
                    case JAXBOBJECT: {
                        messageInfo.setResponse(xm.getPayload(this.getJAXBContext(messageInfo)));
                        break block7;
                    }
                    default: {
                        throw new WebServiceException();
                    }
                }
            }
            messageInfo.setResponse(xm.getSource());
        }
    }

    private XMLHandlerContext getInboundHandlerContext(MessageInfo messageInfo, XMLMessage xm) {
        XMLHandlerContext handlerContext = (XMLHandlerContext)messageInfo.getMetaData("com.sun.xml.ws.handler.context");
        if (handlerContext != null) {
            handlerContext.setXMLMessage(xm);
            handlerContext.setInternalMessage(null);
        } else {
            handlerContext = new XMLHandlerContext(messageInfo, null, xm);
        }
        return handlerContext;
    }

    protected void doSendAsync(MessageInfo messageInfo) {
        try {
            this.preSendHook(messageInfo);
            XMLMessage xm = this.doSend(messageInfo);
            this.postSendHook(messageInfo);
            Response<Object> r = this.sendAsyncReceive(MessageInfoBase.copy(messageInfo), xm);
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
            }
            AsyncHandlerService service = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.asynchandler");
            WSFuture<Object> wsfuture = null;
            if (service != null) {
                wsfuture = service.setupAsyncCallback(r);
                ((ResponseImpl)r).setUID(service.getUID());
                ((ResponseImpl)r).setHandlerService(service);
            }
            this.executorService.execute((FutureTask)((Object)r));
            if (service == null) {
                messageInfo.setResponse(r);
            } else {
                messageInfo.setResponse(wsfuture);
            }
        }
        catch (Throwable e) {
            messageInfo.setResponse(e);
        }
    }

    protected Response<Object> sendAsyncReceive(final MessageInfo messageInfo, final XMLMessage xm) {
        boolean callback;
        AsyncHandlerService handler = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.asynchandler");
        boolean bl = callback = messageInfo.getMEP() == 4;
        if (callback && handler == null) {
            throw new WebServiceException("Asynchronous callback invocation, but no handler - AsyncHandler required");
        }
        ResponseImpl<Object> r = new ResponseImpl<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    WSConnection connection = messageInfo.getConnection();
                    XMLConnectionUtil.sendResponse(connection, xm);
                }
                catch (Throwable t) {
                    messageInfo.setResponse(t);
                    messageInfo.setResponseType(2);
                }
                XMLMessageDispatcher.this.preReceiveHook(messageInfo);
                try {
                    XMLMessageDispatcher.this.receive(messageInfo);
                }
                catch (Exception ex) {
                    messageInfo.setResponse(ex);
                }
                XMLMessageDispatcher.this.postReceiveHook(messageInfo);
                if (messageInfo.getResponse() instanceof Exception) {
                    throw (Exception)messageInfo.getResponse();
                }
                return messageInfo.getResponse();
            }
        });
        messageInfo.setMetaData("com.sun.xml.ws.client.dispatch.async.response.context", r);
        return r;
    }

    protected boolean callHandlersOnRequest(XMLHandlerContext handlerContext) {
        HandlerChainCaller caller = this.getHandlerChainCaller(handlerContext.getMessageInfo());
        boolean responseExpected = handlerContext.getMessageInfo().getMEP() != 2;
        return caller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, handlerContext, responseExpected);
    }

    protected boolean callHandlersOnResponse(XMLHandlerContext handlerContext) {
        HandlerChainCaller caller = this.getHandlerChainCaller(handlerContext.getMessageInfo());
        return caller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, handlerContext, false);
    }

    protected Binding getBinding(MessageInfo messageInfo) {
        ContextMap context = (ContextMap)((MessageInfoBase)messageInfo).getMetaData("com.sun.xml.ws.context.request");
        BindingProvider provider = (BindingProvider)context.get("com.sun.xml.ws.client.handle");
        return provider.getBinding();
    }

    protected HandlerChainCaller getHandlerChainCaller(MessageInfo messageInfo) {
        BindingImpl binding = (BindingImpl)this.getBinding(messageInfo);
        return binding.getHandlerChainCaller();
    }

    protected void updateMessageContext(MessageInfo messageInfo, XMLHandlerContext context) {
        MessageContext messageContext = context.getMessageContext();
        messageInfo.setMetaData("com.sun.xml.ws.handler.context", context);
        RequestContext ctxt = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        Iterator<String> i = ctxt.copy().getPropertyNames();
        while (i.hasNext()) {
            String name = i.next();
            Object value = ctxt.get(name);
            messageContext.put(name, value);
        }
    }

    protected void updateResponseContext(MessageInfo messageInfo, XMLHandlerContext context) {
        MessageContext messageContext = context.getMessageContext();
        BindingProvider provider = (BindingProvider)messageContext.get("com.sun.xml.ws.client.handle");
        ResponseContext responseContext = new ResponseContext(provider);
        for (String name : messageContext.keySet()) {
            MessageContext.Scope scope = messageContext.getScope(name);
            if (MessageContext.Scope.APPLICATION != scope) continue;
            Object value = messageContext.get(name);
            responseContext.put(name, value);
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        Iterator iter = context.getXMLMessage().getMimeHeaders().getAllHeaders();
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            responseHeaders.put(header.getName(), header.getValue());
        }
        responseContext.put("javax.xml.ws.http.response.headers", (Object)responseHeaders);
        responseContext.put("javax.xml.ws.http.response.code", (Object)context.getXMLMessage().getStatus());
        ResponseImpl asyncResponse = (ResponseImpl)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.async.response.context");
        if (asyncResponse != null) {
            asyncResponse.setResponseContext(responseContext.copy());
        } else {
            messageInfo.setMetaData("com.sun.xml.ws.context.response", responseContext.copy());
        }
    }

    protected boolean isAsync(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 3 || messageInfo.getMEP() == 4;
    }

    private void preSendHook(MessageInfo messageInfo) {
    }

    private void preReceiveHook(MessageInfo messageInfo) {
    }

    private void postSendHook(MessageInfo messageInfo) {
        if (messageInfo.getResponseType() != 0) {
            this.postReceiveHook(messageInfo);
            throw (WebServiceException)messageInfo.getResponse();
        }
    }

    private void postReceiveAndDecodeHook(MessageInfo messageInfo) {
    }

    private void postReceiveHook(MessageInfo messageInfo) {
        if (messageInfo.getMEP() == 2) {
            return;
        }
        Object response = messageInfo.getResponse();
        if (response instanceof StreamSource) {
            InputStream is = ((StreamSource)response).getInputStream();
            Transformer transformer = XmlUtil.newTransformer();
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(is.available());
                transformer.transform((StreamSource)response, new StreamResult(out));
                byte[] bytes = out.toByteArray();
                if (new String(bytes).indexOf("HTTPException") > -1) {
                    throw new HTTPException(500);
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                messageInfo.setResponse(new StreamSource(bis));
            }
            catch (TransformerException e) {
                throw new WebServiceException(e);
            }
            catch (IOException e) {
                throw new WebServiceException(e);
            }
        }
        switch (messageInfo.getResponseType()) {
            case 0: {
                return;
            }
            case 1: {
                if (response instanceof Exception) {
                    throw new HTTPException(500);
                }
                return;
            }
            case 2: {
                if (response instanceof ProtocolException) {
                    throw new HTTPException(500);
                }
                Object jex = null;
                if (response instanceof Exception) {
                    throw new WebServiceException((Exception)response);
                }
                messageInfo.setResponse(response);
                return;
            }
        }
        messageInfo.setResponse(response);
    }

    private void closeAllHandlers(XMLHandlerContext context) {
        HandlerChainCaller caller = this.getHandlerChainCaller(context.getMessageInfo());
        if (caller != null && caller.hasHandlers()) {
            caller.forceCloseHandlers(context);
        }
    }

    protected String getBindingId(MessageInfo messageInfo) {
        SOAPEncoder encoder = (SOAPEncoder)messageInfo.getEncoder();
        if (encoder instanceof SOAPXMLEncoder) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (encoder instanceof SOAP12XMLEncoder) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return "http://www.w3.org/2004/08/wsdl/http";
    }

    protected void logRequestMessage(XMLMessage request, MessageInfo messageInfo) throws IOException, MessagingException, TransformerException {
        OutputStream out = messageInfo.getConnection().getDebug();
        out = System.out;
        if (out != null) {
            String s = "******************\nRequest\n";
            out.write(s.getBytes());
            Iterator iter = request.getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                s = header.getName() + ": " + header.getValue() + "\n";
                out.write(s.getBytes());
            }
            out.flush();
            request.writeTo(out);
            s = "\n";
            out.write(s.getBytes());
            out.flush();
        }
    }

    protected void logResponseMessage(XMLMessage response, MessageInfo messageInfo) throws IOException, MessagingException, TransformerException {
        OutputStream out = messageInfo.getConnection().getDebug();
        out = System.out;
        if (out != null) {
            String s = "Response\n";
            out.write(s.getBytes());
            s = "Http Status Code: " + messageInfo.getConnection().getStatus() + "\n\n";
            out.write(s.getBytes());
            Iterator iter = response.getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                s = header.getName() + ": " + header.getValue() + "\n";
                out.write(s.getBytes());
            }
            out.flush();
            response.writeTo(out);
            s = "******************\n\n";
            out.write(s.getBytes());
        }
    }

    private XMLMessage getXMLMessage(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        return XMLConnectionUtil.getXMLMessage(con, messageInfo);
    }

    protected JAXBContext getJAXBContext(MessageInfo messageInfo) {
        JAXBContext jc = null;
        RequestContext context = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        if (context != null) {
            jc = (JAXBContext)context.get("com.sun.xml.ws.jaxbcontext");
        }
        return jc;
    }

    public void setHTTPContext(Map<String, Object> messageContext, DispatchContext dispatchContext, Map requestContext) {
        if (requestContext.get("javax.xml.ws.http.request.method") != null) {
            messageContext.put("javax.xml.ws.http.request.method", requestContext.get("javax.xml.ws.http.request.method"));
        }
        if (requestContext.get("javax.xml.ws.http.request.headers") != null) {
            messageContext.put("javax.xml.ws.http.request.headers", requestContext.get("javax.xml.ws.http.request.headers"));
        }
        String pathInfo = null;
        String queryString = null;
        if (requestContext.get("javax.xml.ws.http.request.pathinfo") != null) {
            pathInfo = (String)requestContext.get("javax.xml.ws.http.request.pathinfo");
        }
        if (requestContext.get("javax.xml.ws.http.request.querystring") != null) {
            queryString = (String)requestContext.get("javax.xml.ws.http.request.querystring");
        }
        String origEndpoint = null;
        String resolvedEndpoint = null;
        if (pathInfo != null || queryString != null) {
            pathInfo = this.checkPath(pathInfo);
            queryString = this.checkQuery(queryString);
            if (requestContext.get("javax.xml.ws.service.endpoint.address") != null) {
                origEndpoint = (String)requestContext.get("javax.xml.ws.service.endpoint.address");
                try {
                    URI endpointURI = new URI(origEndpoint);
                    resolvedEndpoint = this.resolveURI(endpointURI, pathInfo, queryString);
                }
                catch (URISyntaxException e) {
                    resolvedEndpoint = origEndpoint;
                }
            }
            requestContext.put("javax.xml.ws.service.endpoint.address", resolvedEndpoint);
            messageContext.put("javax.xml.ws.service.endpoint.address", resolvedEndpoint);
        }
    }

    protected String resolveURI(URI endpointURI, String pathInfo, String queryString) {
        String query = null;
        String fragment = null;
        if (queryString != null) {
            URI result = endpointURI.resolve(queryString);
            query = result.getQuery();
            fragment = result.getFragment();
        }
        String path = pathInfo != null ? endpointURI.getPath() + pathInfo : endpointURI.getPath();
        try {
            URI temp = new URI(null, null, path, query, fragment);
            return endpointURI.resolve(temp).toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return endpointURI.toString();
        }
    }

    private String checkPath(String path) {
        return path == null || path.startsWith("/") ? path : "/" + path;
    }

    private String checkQuery(String query) {
        return query == null || query.startsWith("?") ? query : "?" + query;
    }

    protected boolean isHTTPMessageType(DispatchContext dispatchContext) {
        DispatchContext.MessageType type = (DispatchContext.MessageType)((Object)dispatchContext.getProperty("com.sun.xml.ws.rt.client.dispatch.messagetype"));
        return type == DispatchContext.MessageType.HTTP_DATASOURCE_MESSAGE || type == DispatchContext.MessageType.HTTP_SOURCE_MESSAGE || type == DispatchContext.MessageType.HTTP_SOURCE_PAYLOAD || type == DispatchContext.MessageType.HTTP_JAXB_PAYLOAD;
    }

    protected XMLMessage makeXMLMessage(MessageInfo messageInfo) {
        XMLMessage xm = null;
        Class clazz = (Class)messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.messageclass");
        boolean useFastInfoset = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic";
        Object object = messageInfo.getData()[0];
        xm = clazz != null && clazz.isAssignableFrom(Source.class) ? new XMLMessage((Source)object, useFastInfoset) : (clazz != null && clazz.isAssignableFrom(DataSource.class) ? new XMLMessage((DataSource)object, useFastInfoset) : new XMLMessage(object, this.getJAXBContext(messageInfo), useFastInfoset));
        return xm;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r);
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

