/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.xml.server;

import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.xml.XMLDecoder;
import com.sun.xml.ws.encoding.xml.XMLEPTFactory;
import com.sun.xml.ws.encoding.xml.XMLEncoder;
import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.handler.HandlerChainCaller;
import com.sun.xml.ws.handler.XMLHandlerContext;
import com.sun.xml.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.pept.presentation.TargetFinder;
import com.sun.xml.ws.pept.presentation.Tie;
import com.sun.xml.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.ws.server.AppMsgContextImpl;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.Binding;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.XMLConnectionUtil;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLMessageDispatcher
implements MessageDispatcher {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.xmlmd");
    private Localizer localizer = new Localizer();
    private LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.xmlmd");

    public void send(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    public void receive(MessageInfo messageInfo) {
        try {
            XMLMessage xmlMessage = null;
            try {
                xmlMessage = this.getXMLMessage(messageInfo);
            }
            catch (Exception e) {
                this.sendResponseError(messageInfo, e);
                return;
            }
            if (xmlMessage.acceptFastInfoset()) {
                messageInfo.setMetaData("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
            }
            XMLHandlerContext context = new XMLHandlerContext(messageInfo, null, xmlMessage);
            this.updateContextPropertyBag(messageInfo, context);
            boolean skipEndpoint = false;
            SystemHandlerDelegate shd = this.getSystemHandlerDelegate(messageInfo);
            if (shd != null) {
                // empty if block
            }
            boolean peekOneWay = false;
            if (!skipEndpoint) {
                skipEndpoint = this.callHandlersOnRequest(messageInfo, context, !peekOneWay);
            }
            if (skipEndpoint) {
                xmlMessage = context.getXMLMessage();
                if (xmlMessage == null) {
                    InternalMessage internalMessage = context.getInternalMessage();
                    XMLEPTFactory eptf = (XMLEPTFactory)messageInfo.getEPTFactory();
                    XMLEncoder encoder = eptf.getXMLEncoder();
                    xmlMessage = encoder.toXMLMessage(internalMessage, messageInfo);
                }
                this.sendResponse(messageInfo, xmlMessage);
            } else {
                this.toMessageInfo(messageInfo, context);
                if (XMLMessageDispatcher.isOneway(messageInfo)) {
                    this.sendResponseOneway(messageInfo);
                    if (!peekOneWay) {
                        this.closeHandlers(messageInfo, context);
                    }
                }
                if (!XMLMessageDispatcher.isFailure(messageInfo)) {
                    if (shd != null) {
                        // empty if block
                    }
                    this.updateWebServiceContext(messageInfo, context);
                    this.invokeEndpoint(messageInfo, context);
                }
                if (XMLMessageDispatcher.isOneway(messageInfo)) {
                    if (XMLMessageDispatcher.isFailure(messageInfo)) {
                        // empty if block
                    }
                } else {
                    this.updateContextPropertyBag(messageInfo, context);
                    xmlMessage = this.getResponse(messageInfo, context);
                    if (shd != null) {
                        // empty if block
                    }
                    this.sendResponse(messageInfo, xmlMessage);
                }
            }
        }
        catch (Exception e) {
            this.sendResponseError(messageInfo, e);
        }
    }

    protected void toMessageInfo(MessageInfo messageInfo, XMLHandlerContext context) {
        InternalMessage internalMessage = context.getInternalMessage();
        try {
            XMLMessage xmlMessage = context.getXMLMessage();
            if (internalMessage == null) {
                XMLEPTFactory eptf = (XMLEPTFactory)messageInfo.getEPTFactory();
                XMLDecoder decoder = eptf.getXMLDecoder();
                internalMessage = decoder.toInternalMessage(xmlMessage, messageInfo);
            } else {
                XMLEPTFactory eptf = (XMLEPTFactory)messageInfo.getEPTFactory();
                XMLDecoder decoder = eptf.getXMLDecoder();
                internalMessage = decoder.toInternalMessage(xmlMessage, internalMessage, messageInfo);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            messageInfo.setResponseType(2);
            messageInfo.setResponse(e);
        }
        if (!XMLMessageDispatcher.isFailure(messageInfo)) {
            XMLEPTFactory eptf = (XMLEPTFactory)messageInfo.getEPTFactory();
            eptf.getInternalEncoder().toMessageInfo(internalMessage, messageInfo);
            if (messageInfo.getMethod() == null) {
                messageInfo.setResponseType(2);
            }
        }
    }

    private XMLMessage getXMLMessage(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        return XMLConnectionUtil.getXMLMessage(con, messageInfo);
    }

    protected void invokeEndpoint(MessageInfo messageInfo, XMLHandlerContext hc) {
        TargetFinder targetFinder = messageInfo.getEPTFactory().getTargetFinder(messageInfo);
        Tie tie = targetFinder.findTarget(messageInfo);
        tie._invoke(messageInfo);
    }

    protected XMLMessage getResponse(MessageInfo messageInfo, XMLHandlerContext context) {
        this.setResponseInContext(messageInfo, context);
        try {
            HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
            if (handlerCaller != null && handlerCaller.hasHandlers()) {
                int messageType = messageInfo.getResponseType();
                if (messageType == 1 || messageType == 2) {
                    this.callHandleFault(handlerCaller, context);
                } else {
                    this.callHandlersOnResponse(handlerCaller, context);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            InternalMessage internalMessage = SOAPRuntimeModel.createFaultInBody(e, null, null, null);
            context.setInternalMessage(internalMessage);
            context.setXMLMessage(null);
        }
        InternalMessage internalMessage = context.getInternalMessage();
        if (internalMessage != null) {
            XMLEPTFactory eptf = (XMLEPTFactory)messageInfo.getEPTFactory();
            XMLEncoder encoder = eptf.getXMLEncoder();
            XMLMessage xmlMessage = encoder.toXMLMessage(internalMessage, messageInfo);
            context.setXMLMessage(xmlMessage);
        }
        return context.getXMLMessage();
    }

    protected void setResponseInContext(MessageInfo messageInfo, XMLHandlerContext context) {
        XMLEPTFactory eptf = (XMLEPTFactory)messageInfo.getEPTFactory();
        InternalMessage internalMessage = (InternalMessage)eptf.getInternalEncoder().toInternalMessage(messageInfo);
        context.setInternalMessage(internalMessage);
        context.setXMLMessage(null);
    }

    private void sendResponse(MessageInfo messageInfo, XMLMessage xmlMessage) {
        WSConnection con = messageInfo.getConnection();
        XMLConnectionUtil.sendResponse(con, xmlMessage);
    }

    protected void sendResponseOneway(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        XMLConnectionUtil.sendResponseOneway(con);
    }

    private void sendResponseError(MessageInfo messageInfo, Exception e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
        WSConnection con = messageInfo.getConnection();
        XMLConnectionUtil.sendResponseError(con, messageInfo);
    }

    private boolean callHandlersOnRequest(MessageInfo messageInfo, XMLHandlerContext context, boolean responseExpected) {
        boolean skipEndpoint = false;
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerCaller != null && handlerCaller.hasHandlers()) {
            skipEndpoint = !handlerCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, context, responseExpected);
        }
        return skipEndpoint;
    }

    private HandlerChainCaller getCallerFromMessageInfo(MessageInfo info) {
        HandlerChainCaller caller = MessageInfoUtil.getHandlerChainCaller(info);
        if (caller == null) {
            RuntimeContext context = (RuntimeContext)info.getMetaData("com.sun.xml.ws.runtime.context");
            Binding binding = context.getRuntimeEndpointInfo().getBinding();
            caller = new HandlerChainCaller(binding.getHandlerChain());
            MessageInfoUtil.setHandlerChainCaller(info, caller);
        }
        return caller;
    }

    protected boolean callHandlersOnResponse(HandlerChainCaller caller, XMLHandlerContext context) {
        return caller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, context, false);
    }

    protected boolean callHandleFault(HandlerChainCaller caller, XMLHandlerContext context) {
        return false;
    }

    private void closeHandlers(MessageInfo info, XMLHandlerContext context) {
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(info);
        if (handlerCaller != null && handlerCaller.hasHandlers()) {
            handlerCaller.forceCloseHandlers(context);
        }
    }

    private static boolean isFailure(MessageInfo messageInfo) {
        return messageInfo.getResponseType() == 2;
    }

    public static boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    protected void updateWebServiceContext(MessageInfo messageInfo, XMLHandlerContext hc) {
        RuntimeEndpointInfo endpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        WebServiceContext wsContext = endpointInfo.getWebServiceContext();
        if (wsContext != null) {
            AppMsgContextImpl appCtxt = new AppMsgContextImpl(hc.getMessageContext());
            wsContext.setMessageContext(appCtxt);
        }
    }

    private void updateContextPropertyBag(MessageInfo messageInfo, XMLHandlerContext context) {
        RuntimeEndpointInfo endpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        WebServiceContext wsContext = endpointInfo.getWebServiceContext();
        if (wsContext != null) {
            context.setMessageContext(wsContext.getMessageContext());
        }
    }

    private SystemHandlerDelegate getSystemHandlerDelegate(MessageInfo mi) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        return endpointInfo.getBinding().getSystemHandlerDelegate();
    }
}

