/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.modeler.RuntimeModeler;
import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.WSDLGenResolver;
import com.sun.xml.ws.spi.runtime.Binding;
import com.sun.xml.ws.spi.runtime.RuntimeModule;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.HandlerAnnotationProcessor;
import com.sun.xml.ws.util.ModuleFinder;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import com.sun.xml.ws.wsdl.parser.Service;
import com.sun.xml.ws.wsdl.parser.WSDLDocument;
import com.sun.xml.ws.wsdl.writer.WSDLGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeEndpointInfo
extends Endpoint
implements com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo {
    private String name;
    private QName portName;
    private QName serviceName;
    private String wsdlFileName;
    private boolean deployed;
    private String urlPattern;
    private List<Source> metadata;
    private Binding binding;
    private RuntimeModel runtimeModel;
    private Object implementor;
    private Class implementorClass;
    private Map<String, DocInfo> docs;
    private Map<String, DocInfo> query2Doc;
    private WebServiceContext wsContext;
    private boolean beginServiceDone;
    private boolean endServiceDone;
    private boolean injectedContext;
    private boolean injectCompleted;
    private boolean publishingDone;
    private URL wsdlUrl;
    private EntityResolver wsdlResolver;
    private QName portTypeName;
    private Map<String, Object> properties;
    private Integer mtomThreshold;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");
    private static final Localizer localizer = new Localizer();
    private static final LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.server");

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    public void setWSDLFileName(String s) {
        this.wsdlFileName = s;
    }

    @Override
    public void setWsdlInfo(URL wsdlUrl, EntityResolver wsdlResolver) {
        this.wsdlUrl = wsdlUrl;
        this.wsdlResolver = wsdlResolver;
    }

    public EntityResolver getWsdlResolver() {
        return this.wsdlResolver;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    @Override
    public boolean isPublished() {
        return this.deployed;
    }

    @Override
    public void stop() {
    }

    @Override
    public void publish(Object obj) {
    }

    @Override
    public void publish(String address) {
    }

    public void createModel() {
        if (this.wsdlUrl == null) {
            RuntimeModeler rap = new RuntimeModeler(this.getImplementorClass(), this.getImplementor(), this.getServiceName(), ((BindingImpl)this.binding).getBindingId());
            if (this.getPortName() != null) {
                rap.setPortName(this.getPortName());
            }
            this.runtimeModel = rap.buildRuntimeModel();
        } else {
            try {
                WSDLDocument wsdlDoc = RuntimeWSDLParser.parse(this.getWsdlUrl(), this.getWsdlResolver());
                com.sun.xml.ws.wsdl.parser.Binding wsdlBinding = null;
                if (this.serviceName == null) {
                    this.serviceName = RuntimeModeler.getServiceName(this.getImplementorClass());
                }
                if (this.getPortName() != null) {
                    wsdlBinding = wsdlDoc.getBinding(this.getServiceName(), this.getPortName());
                    if (wsdlBinding == null) {
                        throw new ServerRtException("runtime.parser.wsdl.incorrectserviceport", this.serviceName, this.portName, this.getWsdlUrl());
                    }
                } else {
                    Service service = wsdlDoc.getService(this.serviceName);
                    if (service == null) {
                        throw new ServerRtException("runtime.parser.wsdl.noservice", this.serviceName, this.getWsdlUrl());
                    }
                    String bindingId = ((BindingImpl)this.binding).getBindingId();
                    List<com.sun.xml.ws.wsdl.parser.Binding> bindings = wsdlDoc.getBindings(service, bindingId);
                    if (bindings.size() == 0) {
                        throw new ServerRtException("runtime.parser.wsdl.nobinding", bindingId, this.serviceName, this.getWsdlUrl());
                    }
                    if (bindings.size() > 1) {
                        throw new ServerRtException("runtime.parser.wsdl.multiplebinding", bindingId, this.serviceName, this.getWsdlUrl());
                    }
                }
                RuntimeModeler rap = new RuntimeModeler(this.getImplementorClass(), this.getImplementor(), this.getServiceName(), wsdlBinding);
                if (this.getPortName() != null) {
                    rap.setPortName(this.getPortName());
                }
                this.runtimeModel = rap.buildRuntimeModel();
            }
            catch (IOException e) {
                throw new ServerRtException("runtime.parser.wsdl", this.getWsdlUrl().toString());
            }
            catch (XMLStreamException e) {
                throw new ServerRtException("runtime.saxparser.exception", e.getMessage(), e.getLocation());
            }
            catch (SAXException e) {
                throw new ServerRtException("runtime.parser.wsdl", this.getWsdlUrl().toString());
            }
        }
    }

    public boolean isProviderEndpoint() {
        WebServiceProvider ann = this.getImplementorClass().getAnnotation(WebServiceProvider.class);
        return ann != null;
    }

    public void doServiceNameProcessing() {
        if (this.getServiceName() == null) {
            if (this.isProviderEndpoint()) {
                WebServiceProvider wsProvider = this.getImplementorClass().getAnnotation(WebServiceProvider.class);
                String tns = wsProvider.targetNamespace();
                String local = wsProvider.serviceName();
                if (local.length() > 0) {
                    this.setServiceName(new QName(tns, local));
                }
            } else {
                this.setServiceName(RuntimeModeler.getServiceName(this.getImplementorClass()));
            }
        }
    }

    public void doPortNameProcessing() {
        if (this.getPortName() == null) {
            if (this.isProviderEndpoint()) {
                WebServiceProvider wsProvider = this.getImplementorClass().getAnnotation(WebServiceProvider.class);
                String tns = wsProvider.targetNamespace();
                String local = wsProvider.portName();
                if (local.length() > 0) {
                    this.setPortName(new QName(tns, local));
                }
            } else {
                this.setPortName(RuntimeModeler.getPortName(this.getImplementorClass(), this.getServiceName().getNamespaceURI()));
            }
        } else {
            String portNS;
            String serviceNS = this.getServiceName().getNamespaceURI();
            if (!serviceNS.equals(portNS = this.getPortName().getNamespaceURI())) {
                throw new ServerRtException("wrong.tns.for.port", portNS, serviceNS);
            }
        }
    }

    public void doPortTypeNameProcessing() {
        if (this.getPortTypeName() == null && !this.isProviderEndpoint()) {
            this.setPortTypeName(RuntimeModeler.getPortTypeName(this.getImplementorClass()));
        }
    }

    @Override
    public void init() {
        String bindingId;
        if (this.implementor == null) {
            throw new ServerRtException("null.implementor", new Object[0]);
        }
        if (this.implementorClass == null) {
            this.setImplementorClass(this.getImplementor().getClass());
        }
        this.doServiceNameProcessing();
        this.doPortNameProcessing();
        if (this.binding == null) {
            bindingId = RuntimeModeler.getBindingId(this.getImplementorClass());
            this.setBinding(new SOAPBindingImpl("http://schemas.xmlsoap.org/wsdl/soap/http"));
        }
        if (this.isProviderEndpoint()) {
            this.deployProvider();
        } else {
            this.createModel();
            if (this.getServiceName() == null) {
                this.setServiceName(this.runtimeModel.getServiceQName());
            }
            if (this.getPortName() == null) {
                this.setPortName(this.runtimeModel.getPortName());
            }
            if (this.getBinding().getHandlerChain() == null) {
                bindingId = ((BindingImpl)this.binding).getBindingId();
                HandlerAnnotationInfo chainInfo = HandlerAnnotationProcessor.buildHandlerInfo(this.implementorClass, this.getServiceName(), this.getPortName(), bindingId);
                if (chainInfo != null) {
                    this.getBinding().setHandlerChain(chainInfo.getHandlers());
                    if (this.getBinding() instanceof SOAPBinding) {
                        ((SOAPBinding)((Object)this.getBinding())).setRoles(chainInfo.getRoles());
                    }
                }
            }
            if (this.binding instanceof SOAPBindingImpl) {
                this.runtimeModel.enableMtom(((SOAPBinding)((Object)this.binding)).isMTOMEnabled());
            }
        }
        this.deployed = true;
    }

    public boolean needWSDLGeneration() {
        return this.getWsdlUrl() == null;
    }

    public boolean isPublishingDone() {
        return this.publishingDone;
    }

    public void setPublishingDone(boolean publishingDone) {
        this.publishingDone = publishingDone;
    }

    public void generateWSDL() {
        boolean unsupportedBindingId = true;
        BindingImpl bindingImpl = (BindingImpl)this.getBinding();
        String bindingId = bindingImpl.getActualBindingId();
        if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingId.equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            unsupportedBindingId = false;
        } else {
            List<RuntimeModule> runtimeModules = ModuleFinder.findRuntimeModules();
            for (RuntimeModule rtm : runtimeModules) {
                if (!rtm.supportedBindings().contains(bindingId)) continue;
                unsupportedBindingId = false;
                break;
            }
        }
        if (unsupportedBindingId) {
            throw new ServerRtException("can.not.generate.wsdl", bindingId);
        }
        if (bindingId.equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            String msg = localizer.localize(messageFactory.getMessage("generate.non.standard.wsdl", new Object[0]));
            logger.warning(msg);
        }
        if (this.getDocMetadata() == null) {
            this.setMetadata(new HashMap<String, DocInfo>());
        }
        WSDLGenResolver wsdlResolver = new WSDLGenResolver(this.getDocMetadata());
        WSDLGenerator wsdlGen = new WSDLGenerator(this.runtimeModel, wsdlResolver, ((BindingImpl)this.binding).getBindingId());
        try {
            wsdlGen.doGeneration();
        }
        catch (Exception e) {
            throw new ServerRtException("server.rt.err", new Object[]{e});
        }
        this.setWSDLFileName(wsdlResolver.getWSDLFile());
        this.setPublishingDone(true);
    }

    private void deployProvider() {
        if (!Provider.class.isAssignableFrom(this.getImplementorClass())) {
            throw new ServerRtException("not.implement.provider", this.getImplementorClass());
        }
    }

    public QName getPortName() {
        return this.portName;
    }

    @Override
    public void setPortName(QName n) {
        this.portName = n;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName n) {
        this.portTypeName = n;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(QName n) {
        this.serviceName = n;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String s) {
        this.urlPattern = s;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public List<Source> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(List<Source> metadata) {
        this.metadata = metadata;
    }

    public RuntimeModel getRuntimeModel() {
        return this.runtimeModel;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void setImplementor(Object implementor) {
        this.implementor = implementor;
    }

    @Override
    public Class getImplementorClass() {
        if (this.implementorClass == null) {
            this.implementorClass = this.implementor.getClass();
        }
        return this.implementorClass;
    }

    @Override
    public void setImplementorClass(Class implementorClass) {
        this.implementorClass = implementorClass;
    }

    public void setMetadata(Map<String, DocInfo> docs) {
        this.docs = docs;
        if (this.query2Doc != null) {
            this.query2Doc.clear();
        } else {
            this.query2Doc = new HashMap<String, DocInfo>();
        }
        Set<Map.Entry<String, DocInfo>> entries = docs.entrySet();
        for (Map.Entry<String, DocInfo> entry : entries) {
            DocInfo docInfo = entry.getValue();
            this.query2Doc.put(docInfo.getQueryString(), docInfo);
        }
    }

    public void updateQuery2DocInfo() {
        if (this.query2Doc != null) {
            this.query2Doc.clear();
        } else {
            this.query2Doc = new HashMap<String, DocInfo>();
        }
        Set<Map.Entry<String, DocInfo>> entries = this.docs.entrySet();
        for (Map.Entry<String, DocInfo> entry : entries) {
            DocInfo docInfo = entry.getValue();
            this.query2Doc.put(docInfo.getQueryString(), docInfo);
        }
    }

    @Override
    public WebServiceContext getWebServiceContext() {
        return this.wsContext;
    }

    @Override
    public void setWebServiceContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }

    public Map<String, DocInfo> getDocMetadata() {
        return this.docs;
    }

    public String getQueryString(URL url) {
        Set<Map.Entry<String, DocInfo>> entries = this.getDocMetadata().entrySet();
        for (Map.Entry<String, DocInfo> entry : entries) {
            if (!entry.getValue().getUrl().toString().equals(url.toString())) continue;
            return entry.getValue().getQueryString();
        }
        return null;
    }

    public String getPath(String queryString) {
        DocInfo docInfo = this.query2Doc.get(queryString);
        return docInfo == null ? null : docInfo.getUrl().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void injectContext() throws IllegalAccessException, InvocationTargetException {
        if (this.injectedContext) {
            return;
        }
        try {
            this.doFieldsInjection();
            this.doMethodsInjection();
        }
        finally {
            this.injectedContext = true;
        }
    }

    private void doFieldsInjection() {
        Field[] fields;
        Class c = this.getImplementorClass();
        for (Field field : fields = c.getDeclaredFields()) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            Class resourceType = resource.type();
            Class<javax.xml.ws.WebServiceContext> fieldType = field.getType();
            if (resourceType.equals(Object.class)) {
                if (!fieldType.equals(javax.xml.ws.WebServiceContext.class)) continue;
                this.injectField(field);
                continue;
            }
            if (!resourceType.equals(javax.xml.ws.WebServiceContext.class)) continue;
            if (fieldType.isAssignableFrom(javax.xml.ws.WebServiceContext.class)) {
                this.injectField(field);
                continue;
            }
            throw new ServerRtException("wrong.field.type", field.getName());
        }
    }

    private void doMethodsInjection() {
        Method[] methods;
        Class c = this.getImplementorClass();
        for (Method method : methods = c.getDeclaredMethods()) {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1) {
                throw new ServerRtException("wrong.no.parameters", method.getName());
            }
            Class resourceType = resource.type();
            Class<javax.xml.ws.WebServiceContext> argType = paramTypes[0];
            if (resourceType.equals(Object.class) && argType.equals(javax.xml.ws.WebServiceContext.class)) {
                this.invokeMethod(method, new Object[]{this.wsContext});
                continue;
            }
            if (!resourceType.equals(javax.xml.ws.WebServiceContext.class)) continue;
            if (argType.isAssignableFrom(javax.xml.ws.WebServiceContext.class)) {
                this.invokeMethod(method, new Object[]{this.wsContext});
                continue;
            }
            throw new ServerRtException("wrong.parameter.type", method.getName());
        }
    }

    private void injectField(final Field field) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(RuntimeEndpointInfo.this.implementor, RuntimeEndpointInfo.this.wsContext);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ServerRtException("server.rt.err", new Object[]{e.getException()});
        }
    }

    private void invokeMethod(final Method method, final Object[] args) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(RuntimeEndpointInfo.this.implementor, args);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ServerRtException("server.rt.err", new Object[]{e.getException()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginService() {
        if (this.beginServiceDone) {
            return;
        }
        try {
            this.invokeOnceMethod(PostConstruct.class);
        }
        finally {
            this.beginServiceDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endService() {
        if (this.endServiceDone) {
            return;
        }
        try {
            this.invokeOnceMethod(PreDestroy.class);
            this.destroy();
        }
        finally {
            this.endServiceDone = true;
        }
    }

    private void invokeOnceMethod(Class annType) {
        Class c = this.getImplementorClass();
        Method[] methods = c.getDeclaredMethods();
        boolean once = false;
        for (Method method : methods) {
            if (method.getAnnotation(annType) == null) continue;
            if (once) {
                throw new ServerRtException("annotation.only.once", annType);
            }
            if (method.getParameterTypes().length != 0) {
                throw new ServerRtException("not.zero.parameters", method.getName());
            }
            this.invokeMethod(method, new Object[0]);
            once = true;
        }
    }

    @Override
    public void destroy() {
        List<Handler> handlers;
        Binding binding = this.getBinding();
        if (binding != null && (handlers = binding.getHandlerChain()) != null) {
            block2: for (Handler handler : handlers) {
                for (Method method : handler.getClass().getMethods()) {
                    if (method.getAnnotation(PreDestroy.class) == null) continue;
                    try {
                        method.invoke((Object)handler, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.warning("exception ignored from handler @PreDestroy method: " + e.getMessage());
                    }
                    continue block2;
                }
            }
        }
    }

    @Override
    public Executor getExecutor() {
        return null;
    }

    @Override
    public void setExecutor(Executor executor) {
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Integer getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public static void fillDocInfo(RuntimeEndpointInfo endpointInfo) throws XMLStreamException {
        Map<String, DocInfo> metadata = endpointInfo.getDocMetadata();
        if (metadata != null) {
            for (Map.Entry<String, DocInfo> entry : metadata.entrySet()) {
                RuntimeWSDLParser.fillDocInfo(entry.getValue(), endpointInfo.getServiceName(), endpointInfo.getPortTypeName());
            }
        }
    }

    public static void publishWSDLDocs(RuntimeEndpointInfo endpointInfo) {
        Map<String, DocInfo> docs = endpointInfo.getDocMetadata();
        if (docs == null) {
            return;
        }
        Set<Map.Entry<String, DocInfo>> entries = docs.entrySet();
        ArrayList<String> wsdlSystemIds = new ArrayList<String>();
        ArrayList<String> schemaSystemIds = new ArrayList<String>();
        for (Map.Entry<String, DocInfo> entry : entries) {
            DocInfo docInfo = entry.getValue();
            DocInfo.DOC_TYPE docType = docInfo.getDocType();
            String query = docInfo.getQueryString();
            if (query != null || docType == null) continue;
            switch (docType) {
                case WSDL: {
                    wsdlSystemIds.add(entry.getKey());
                    break;
                }
                case SCHEMA: {
                    schemaSystemIds.add(entry.getKey());
                    break;
                }
            }
        }
        Collections.sort(wsdlSystemIds);
        int wsdlnum = 1;
        for (String wsdlSystemId : wsdlSystemIds) {
            DocInfo docInfo = docs.get(wsdlSystemId);
            docInfo.setQueryString("wsdl=" + wsdlnum++);
        }
        Collections.sort(schemaSystemIds);
        int xsdnum = 1;
        for (String schemaSystemId : schemaSystemIds) {
            DocInfo docInfo = docs.get(schemaSystemId);
            docInfo.setQueryString("xsd=" + xsdnum++);
        }
        endpointInfo.updateQuery2DocInfo();
    }
}

