/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.client;

import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.transport.WSConnectionImpl;
import com.sun.xml.ws.transport.http.client.CookieJar;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.soap.MessageFactory;
import javax.xml.ws.BindingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientTransport
extends WSConnectionImpl {
    private static String LAST_ENDPOINT = "";
    private static boolean redirect = true;
    private static final int START_REDIRECT_COUNT = 3;
    private static int redirectCount = 3;
    int statusCode;
    private Map<String, List<String>> respHeaders = null;
    private MessageFactory _messageFactory;
    HttpURLConnection httpConnection = null;
    String endpoint = null;
    Map<String, Object> context = null;
    CookieJar cookieJar = null;
    boolean isFailure = false;
    OutputStream _logStream = null;

    public HttpClientTransport() {
        this(null, new HashMap<String, Object>());
    }

    public HttpClientTransport(OutputStream logStream, Map<String, Object> context) {
        this.context = context;
        this._logStream = logStream;
        String bindingId = (String)context.get("com.sun.xml.ws.binding");
        try {
            if (bindingId == null) {
                bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
            this._messageFactory = bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") ? MessageFactory.newInstance((String)"SOAP 1.2 Protocol") : MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
            this.endpoint = (String)context.get("javax.xml.ws.service.endpoint.address");
        }
        catch (Exception e) {
            throw new ClientTransportException("http.client.cannotCreateMessageFactory", new Object[0]);
        }
    }

    @Override
    public OutputStream getOutput() {
        try {
            this.httpConnection = this.createHttpConnection(this.endpoint, this.context);
            this.cookieJar = this.sendCookieAsNeeded();
            if (!this.httpConnection.getRequestMethod().equalsIgnoreCase("GET")) {
                this.outputStream = this.httpConnection.getOutputStream();
            }
            this.connectForResponse();
        }
        catch (Exception ex) {
            throw new ClientTransportException("http.client.failed", new Object[]{ex});
        }
        return this.outputStream;
    }

    @Override
    public InputStream getInput() {
        InputStream in;
        try {
            in = this.readResponse();
        }
        catch (IOException e) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException("http.status.code", this.statusCode, this.httpConnection.getResponseMessage());
                }
                catch (IOException ex) {
                    throw new ClientTransportException("http.status.code", this.statusCode, ex);
                }
            }
            throw new ClientTransportException("http.client.failed", e.getMessage());
        }
        this.httpConnection = null;
        return in;
    }

    @Override
    public OutputStream getDebug() {
        return this._logStream;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.respHeaders != null) {
            return this.respHeaders;
        }
        try {
            this.isFailure = this.checkResponseCode();
            this.respHeaders = this.collectResponseMimeHeaders();
            this.saveCookieAsNeeded(this.cookieJar);
            this.setHeaders(this.respHeaders);
            return this.respHeaders;
        }
        catch (IOException e) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException("http.status.code", this.statusCode, this.httpConnection.getResponseMessage());
                }
                catch (IOException ex) {
                    throw new ClientTransportException("http.status.code", this.statusCode, ex);
                }
            }
            throw new ClientTransportException("http.client.failed", e.getMessage());
        }
    }

    protected InputStream readResponse() throws IOException {
        InputStream contentIn = this.isFailure ? this.httpConnection.getErrorStream() : this.httpConnection.getInputStream();
        ByteArrayBuffer bab = new ByteArrayBuffer();
        if (contentIn != null) {
            bab.write(contentIn);
            bab.close();
        }
        int length = this.httpConnection.getContentLength() == -1 ? bab.size() : this.httpConnection.getContentLength();
        return bab.newInputStream(0, length);
    }

    protected Map<String, List<String>> collectResponseMimeHeaders() {
        return this.httpConnection.getHeaderFields();
    }

    protected void connectForResponse() throws IOException {
        this.httpConnection.connect();
    }

    protected boolean checkResponseCode() throws IOException {
        boolean isFailure = false;
        try {
            this.statusCode = this.httpConnection.getResponseCode();
            this.setStatus(this.statusCode);
            if (this.httpConnection.getResponseCode() == 500) {
                isFailure = true;
            } else {
                if (this.httpConnection.getResponseCode() == 401) {
                    throw new ClientTransportException("http.client.unauthorized", this.httpConnection.getResponseMessage());
                }
                if (this.httpConnection.getResponseCode() == 404) {
                    throw new ClientTransportException("http.not.found", this.httpConnection.getResponseMessage());
                }
                if (this.statusCode == 302 || this.statusCode == 301) {
                    isFailure = true;
                    if (!redirect || redirectCount <= 0) {
                        throw new ClientTransportException("http.status.code", this.statusCode, this.getStatusMessage(this.httpConnection));
                    }
                } else {
                    if (this.statusCode < 200 || this.statusCode >= 303 && this.statusCode < 500) {
                        throw new ClientTransportException("http.status.code", this.statusCode, this.getStatusMessage(this.httpConnection));
                    }
                    if (this.statusCode >= 500) {
                        isFailure = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isFailure;
    }

    protected String getStatusMessage(HttpURLConnection httpConnection) throws IOException {
        String location;
        int statusCode = httpConnection.getResponseCode();
        String message = httpConnection.getResponseMessage();
        if ((statusCode == 201 || statusCode >= 300 && statusCode != 304 && statusCode < 400) && (location = httpConnection.getHeaderField("Location")) != null) {
            message = message + " - Location: " + location;
        }
        return message;
    }

    protected CookieJar sendCookieAsNeeded() {
        Boolean shouldMaintainSessionProperty = (Boolean)this.context.get("javax.xml.ws.session.maintain");
        if (shouldMaintainSessionProperty == null) {
            return null;
        }
        if (shouldMaintainSessionProperty.booleanValue()) {
            CookieJar cookieJar = (CookieJar)this.context.get("com.sun.xml.ws.client.http.CookieJar");
            if (cookieJar == null) {
                cookieJar = new CookieJar();
                BindingProvider bp = (BindingProvider)this.context.get("com.sun.xml.ws.client.handle");
                bp.getRequestContext().put("com.sun.xml.ws.client.http.CookieJar", cookieJar);
            }
            cookieJar.applyRelevantCookies(this.httpConnection);
            return cookieJar;
        }
        return null;
    }

    protected void saveCookieAsNeeded(CookieJar cookieJar) {
        if (cookieJar != null) {
            cookieJar.recordAnyCookies(this.httpConnection);
        }
    }

    protected HttpURLConnection createHttpConnection(String endpoint, Map<String, Object> context) throws IOException {
        String redirectProperty;
        boolean verification = false;
        String verificationProperty = (String)context.get("com.sun.xml.ws.client.http.HostnameVerificationProperty");
        if (verificationProperty != null && verificationProperty.equalsIgnoreCase("true")) {
            verification = true;
        }
        if ((redirectProperty = (String)context.get("com.sun.xml.ws.client.http.RedirectRequestProperty")) != null && redirectProperty.equalsIgnoreCase("false")) {
            redirect = false;
        }
        this.checkEndpoints(endpoint);
        HttpURLConnection httpConnection = this.createConnection(endpoint);
        if (!verification && httpConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpConnection).setHostnameVerifier(new HttpClientVerifier());
        }
        httpConnection.setAllowUserInteraction(true);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        String method = "POST";
        String requestMethod = (String)context.get("javax.xml.ws.http.request.method");
        if (context.get("com.sun.xml.ws.binding").equals("http://www.w3.org/2004/08/wsdl/http")) {
            method = requestMethod != null ? requestMethod : method;
        } else if (context.get("com.sun.xml.ws.binding").equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && "GET".equalsIgnoreCase(requestMethod)) {
            method = requestMethod != null ? requestMethod : method;
        }
        httpConnection.setRequestMethod(method);
        for (Map.Entry<String, List<String>> entry : super.getHeaders().entrySet()) {
            httpConnection.addRequestProperty(entry.getKey(), entry.getValue().get(0));
        }
        return httpConnection;
    }

    private HttpURLConnection createConnection(String endpoint) throws IOException {
        return (HttpURLConnection)new URL(endpoint).openConnection();
    }

    private boolean checkForRedirect(int statusCode) {
        return (statusCode == 301 || statusCode == 302) && redirect && redirectCount-- > 0;
    }

    private void checkEndpoints(String currentEndpoint) {
        if (!LAST_ENDPOINT.equalsIgnoreCase(currentEndpoint)) {
            redirectCount = 3;
            LAST_ENDPOINT = currentEndpoint;
        }
    }

    static class HttpClientVerifier
    implements HostnameVerifier {
        HttpClientVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

