/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.transport.http.server.HttpEndpoint;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServicePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object actualEndpoint;
    private RuntimeEndpointInfo rtEndpointInfo = new RuntimeEndpointInfo();

    public EndpointImpl(String bindingId, Object impl) {
        this.rtEndpointInfo.setImplementor(impl);
        this.rtEndpointInfo.setImplementorClass(impl.getClass());
        com.sun.xml.ws.spi.runtime.Binding binding = BindingImpl.getBinding(bindingId, impl.getClass(), null, false);
        this.rtEndpointInfo.setBinding(binding);
    }

    @Override
    public Binding getBinding() {
        return this.rtEndpointInfo.getBinding();
    }

    @Override
    public Object getImplementor() {
        return this.rtEndpointInfo.getImplementor();
    }

    @Override
    public void publish(String address) {
        this.checkPlatform();
        ((HttpEndpoint)this.actualEndpoint).publish(address);
    }

    @Override
    public void publish(Object serverContext) {
        this.checkPlatform();
        ((HttpEndpoint)this.actualEndpoint).publish(serverContext);
    }

    @Override
    public void stop() {
        ((HttpEndpoint)this.actualEndpoint).stop();
    }

    @Override
    public boolean isPublished() {
        return this.rtEndpointInfo.isDeployed();
    }

    @Override
    public List<Source> getMetadata() {
        return this.rtEndpointInfo.getMetadata();
    }

    @Override
    public void setMetadata(List<Source> metadata) {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot set Metadata. Already published");
        }
        this.rtEndpointInfo.setMetadata(metadata);
    }

    @Override
    public Executor getExecutor() {
        return this.rtEndpointInfo.getExecutor();
    }

    @Override
    public void setExecutor(Executor executor) {
        this.rtEndpointInfo.setExecutor(executor);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.rtEndpointInfo.getProperties();
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.rtEndpointInfo.setProperties(map);
    }

    private void checkPlatform() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
        }
        try {
            Class.forName("com.sun.net.httpserver.HttpServer");
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("NOT SUPPORTED");
        }
        this.actualEndpoint = new HttpEndpoint(this.rtEndpointInfo);
    }
}

