/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.transport.http.server.EndpointDocInfo;
import com.sun.xml.ws.transport.http.server.EndpointEntityResolver;
import com.sun.xml.ws.transport.http.server.ServerMgr;
import com.sun.xml.ws.transport.http.server.WSHttpHandler;
import com.sun.xml.ws.transport.http.server.WebServiceContextImpl;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;

public class HttpEndpoint {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private String address;
    private HttpContext httpContext;
    private boolean published;
    private RuntimeEndpointInfo endpointInfo;
    private static final int MAX_THREADS = 5;

    public HttpEndpoint(RuntimeEndpointInfo rtEndpointInfo) {
        this.endpointInfo = rtEndpointInfo;
        this.endpointInfo.setUrlPattern("");
    }

    private void setServiceName() {
        QName serviceName;
        Map<String, Object> properties = this.endpointInfo.getProperties();
        if (properties != null && (serviceName = (QName)properties.get("javax.xml.ws.wsdl.service")) != null) {
            this.endpointInfo.setServiceName(serviceName);
        }
    }

    private void setPortName() {
        QName portName;
        Map<String, Object> properties = this.endpointInfo.getProperties();
        if (properties != null && (portName = (QName)properties.get("javax.xml.ws.wsdl.port")) != null) {
            this.endpointInfo.setPortName(portName);
        }
    }

    private void setDocInfo() throws MalformedURLException {
        List<Source> metadata = this.endpointInfo.getMetadata();
        if (metadata != null) {
            HashMap<String, DocInfo> newMetadata = new HashMap<String, DocInfo>();
            Transformer transformer = XmlUtil.newTransformer();
            for (Source source : metadata) {
                ByteArrayBuffer baos = new ByteArrayBuffer();
                try {
                    transformer.transform(source, new StreamResult(baos));
                    baos.close();
                }
                catch (TransformerException te) {
                    throw new ServerRtException("server.rt.err", new Object[]{te});
                }
                String systemId = source.getSystemId();
                URL url = new URL(systemId);
                EndpointDocInfo docInfo = new EndpointDocInfo(url, baos);
                newMetadata.put(systemId, docInfo);
            }
            this.endpointInfo.setMetadata(newMetadata);
        }
    }

    private void findPrimaryWSDL() throws Exception {
        Map<String, DocInfo> metadata = this.endpointInfo.getDocMetadata();
        if (metadata != null) {
            for (Map.Entry<String, DocInfo> entry : metadata.entrySet()) {
                DocInfo docInfo = entry.getValue();
                if (docInfo.getService() == null) continue;
                URL wsdlUrl = new URL(entry.getKey());
                EndpointEntityResolver resolver = new EndpointEntityResolver(metadata);
                this.endpointInfo.setWsdlInfo(wsdlUrl, resolver);
                docInfo.setQueryString("wsdl");
                break;
            }
        }
    }

    public void fillEndpointInfo() throws Exception {
        this.setServiceName();
        this.setPortName();
        this.endpointInfo.doServiceNameProcessing();
        this.endpointInfo.doPortNameProcessing();
        this.endpointInfo.doPortTypeNameProcessing();
        this.setDocInfo();
        RuntimeEndpointInfo.fillDocInfo(this.endpointInfo);
        this.findPrimaryWSDL();
    }

    public void generateWSDLDocs() {
        if (this.endpointInfo.needWSDLGeneration()) {
            this.endpointInfo.generateWSDL();
        }
    }

    public void publish(String address) {
        try {
            this.address = address;
            this.httpContext = ServerMgr.getInstance().createContext(address);
            try {
                this.publish(this.httpContext);
            }
            catch (Exception e) {
                ServerMgr.getInstance().removeContext(this.httpContext);
                throw e;
            }
        }
        catch (Exception e) {
            throw new ServerRtException("server.rt.err", new Object[]{e});
        }
    }

    public void publish(Object serverContext) {
        if (!(serverContext instanceof HttpContext)) {
            throw new ServerRtException("not.HttpContext.type", serverContext.getClass());
        }
        this.httpContext = (HttpContext)serverContext;
        try {
            this.publish(this.httpContext);
        }
        catch (Exception e) {
            throw new ServerRtException("server.rt.err", new Object[]{e});
        }
        this.published = true;
    }

    public void stop() {
        if (this.address == null) {
            this.httpContext.getServer().removeContext(this.httpContext);
        } else {
            ServerMgr.getInstance().removeContext(this.httpContext);
        }
        this.endpointInfo.endService();
        this.published = false;
    }

    private void publish(HttpContext context) throws Exception {
        this.fillEndpointInfo();
        this.endpointInfo.init();
        this.generateWSDLDocs();
        RuntimeEndpointInfo.publishWSDLDocs(this.endpointInfo);
        logger.fine("Doc Metadata=" + this.endpointInfo.getDocMetadata());
        WebServiceContextImpl wsContext = new WebServiceContextImpl();
        this.endpointInfo.setWebServiceContext(wsContext);
        this.endpointInfo.injectContext();
        this.endpointInfo.beginService();
        Tie tie = new Tie();
        context.setHandler(new WSHttpHandler(tie, this.endpointInfo));
    }
}

