/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.spi.runtime.RuntimeModule;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleFinder {
    private static final String envId = "META-INF/services/com.sun.xml.ws.module";
    private static ArrayList<RuntimeModule> runtimeModules = new ArrayList();
    private static ArrayList<Object> tooltimeModules = new ArrayList();
    private static boolean isInitialized = false;

    private static Object newInstance(String className, ClassLoader classLoader) {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new WebServiceException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new WebServiceException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        ArrayList<RuntimeModule> arrayList = runtimeModules;
        synchronized (arrayList) {
            if (!isInitialized) {
                try {
                    ClassLoader classLoader;
                    InputStream is = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (Exception x) {
                        throw new WebServiceException(x.toString(), x);
                    }
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    Enumeration<URL> resources = classLoader.getResources(envId);
                    while (resources.hasMoreElements()) {
                        URL url = resources.nextElement();
                        is = url.openStream();
                        Properties props = new Properties();
                        props.load(is);
                        TYPE type = TYPE.RUNTIME;
                        String envClassName = null;
                        Enumeration<?> propNames = props.propertyNames();
                        while (propNames.hasMoreElements()) {
                            String propName = (String)propNames.nextElement();
                            if (propName.equals("runtime")) {
                                envClassName = props.getProperty("runtime");
                                type = TYPE.RUNTIME;
                            } else if (propName.equals("tooltime")) {
                                envClassName = props.getProperty("tooltime");
                                type = TYPE.TOOLTIME;
                            } else {
                                throw new IllegalArgumentException("Invalid module type " + propName + " in services file " + url.toString());
                            }
                            if (envClassName == null || "".equals(envClassName)) continue;
                            Object obj = ModuleFinder.newInstance(envClassName, classLoader);
                            if (obj instanceof RuntimeModule && type == TYPE.RUNTIME) {
                                runtimeModules.add((RuntimeModule)obj);
                                continue;
                            }
                            if (type != TYPE.TOOLTIME) continue;
                            tooltimeModules.add(obj);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new WebServiceException(ex);
                }
            }
        }
    }

    public static RuntimeModule findAddressingModule() {
        for (RuntimeModule rtm : runtimeModules) {
            String uri = rtm.getNamespaceURI();
            if (!uri.equals("http://www.w3.org/2005/08/addressing") && !uri.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) continue;
            return rtm;
        }
        return null;
    }

    public static List<RuntimeModule> findRuntimeModules() {
        return runtimeModules;
    }

    public static List<Object> findTooltimeModules() {
        return tooltimeModules;
    }

    static {
        ModuleFinder.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        TOOLTIME,
        RUNTIME;

    }
}

