/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.RuntimeModule;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.FastInfosetUtil;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.ModuleFinder;
import com.sun.xml.ws.util.SOAPUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPConnectionUtil {
    private static final String DEFAULT_SERVER_ERROR_ENVELOPE = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><env:Fault><faultcode>env:Server</faultcode><faultstring>Internal server error</faultstring></env:Fault></env:Body></env:Envelope>";
    private static final String DEFAULT_SERVER_ERROR_SOAP12_ENVELOPE = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"><env:Body><env:Fault><env:Code><env:Value>env:Receiver</env:Value></env:Code><env:Reason><env:Text lang=\"" + Locale.getDefault().getLanguage() + "\">" + "Internal server error</env:Text></env:Reason>" + "</env:Fault>" + "</env:Body>" + "</env:Envelope>";

    public static SOAPMessage getSOAPMessage(WSConnection con, MessageInfo mi, String bindingId) {
        try {
            RuntimeContext rtCtxt;
            Map<String, List<String>> headers = con.getHeaders();
            MimeHeaders mh = new MimeHeaders();
            if (headers != null) {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    String name = entry.getKey();
                    for (String value : entry.getValue()) {
                        try {
                            mh.addHeader(name, value);
                        }
                        catch (IllegalArgumentException ie) {}
                    }
                }
            }
            if ((rtCtxt = MessageInfoUtil.getRuntimeContext(mi)) != null) {
                RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
                if (bindingId == null) {
                    bindingId = ((BindingImpl)endpointInfo.getBinding()).getBindingId();
                }
            }
            SOAPMessage soapMessage = SOAPUtil.createMessage(mh, con.getInput(), bindingId);
            return soapMessage;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebServiceException(e);
        }
    }

    private static void send(WSConnection con, SOAPMessage soapMessage) {
        try {
            if (soapMessage.saveRequired()) {
                soapMessage.saveChanges();
            }
            JAXWSUtils.logMessage("Request", soapMessage, con);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            MimeHeaders mhs = soapMessage.getMimeHeaders();
            Iterator i = mhs.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mh = (MimeHeader)i.next();
                String name = mh.getName();
                ArrayList<String> values = (ArrayList<String>)headers.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    headers.put(name, values);
                }
                values.add(mh.getValue());
            }
            con.setHeaders(headers);
            soapMessage.writeTo(con.getOutput());
            con.closeOutput();
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

    public static void sendResponse(WSConnection con, SOAPMessage soapMessage) {
        SOAPConnectionUtil.send(con, soapMessage);
    }

    public static void sendKnownError(MessageInfo messageInfo, int status) {
        WSConnection con = messageInfo.getConnection();
        SOAPConnectionUtil.setStatus(con, status);
        con.getOutput();
        con.closeOutput();
    }

    public static void sendResponseOneway(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        SOAPConnectionUtil.setStatus(con, 202);
        con.getOutput();
        if (messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic") {
            List<String> acceptList = null;
            List<String> contentTypeList = null;
            Map<String, List<String>> headers = con.getHeaders();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("content-type")) {
                    contentTypeList = entry.getValue();
                    continue;
                }
                if (!entry.getKey().equalsIgnoreCase("accept")) continue;
                acceptList = entry.getValue();
            }
            assert (contentTypeList != null && acceptList != null);
            contentTypeList.set(0, FastInfosetUtil.getFastInfosetFromAccept(acceptList));
        }
        con.closeOutput();
    }

    public static void sendResponseError(WSConnection con, String bindingId, Exception ex) {
        try {
            SOAPMessage message = SOAPUtil.createMessage(bindingId);
            ByteArrayBuffer bufferedStream = new ByteArrayBuffer();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "UTF-8");
            RuntimeModule rtm = ModuleFinder.findAddressingModule();
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                writer.write(DEFAULT_SERVER_ERROR_SOAP12_ENVELOPE);
            } else {
                writer.write(DEFAULT_SERVER_ERROR_ENVELOPE);
            }
            ((Writer)writer).close();
            message.getSOAPPart().setContent((Source)new StreamSource(bufferedStream.newInputStream()));
            SOAPConnectionUtil.setStatus(con, 500);
            SOAPConnectionUtil.send(con, message);
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

    public static Map<String, List<String>> getHeaders(WSConnection con) {
        return con.getHeaders();
    }

    public static void setHeaders(WSConnection con, Map<String, List<String>> headers) {
        con.setHeaders(headers);
    }

    public static void setStatus(WSConnection con, int status) {
        con.setStatus(status);
    }
}

