/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.encoding.soap.message.SOAPMsgCreateException;
import com.sun.xml.ws.encoding.soap.message.SOAPMsgFactoryCreateException;
import com.sun.xml.ws.spi.runtime.RuntimeModule;
import com.sun.xml.ws.util.ModuleFinder;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class SOAPUtil {
    private static final MessageFactory soap11messageFactory = SOAPUtil.createMessageFactory("SOAP 1.1 Protocol");
    private static final MessageFactory soap12messageFactory = SOAPUtil.createMessageFactory("SOAP 1.2 Protocol");
    private static final SOAPFactory soap11Factory = SOAPUtil.createSOAPFactory("SOAP 1.1 Protocol");
    private static final SOAPFactory soap12Factory = SOAPUtil.createSOAPFactory("SOAP 1.2 Protocol");

    private static SOAPFactory createSOAPFactory(String soapProtocol) {
        try {
            return SOAPFactory.newInstance((String)soapProtocol);
        }
        catch (SOAPException e) {
            throw new SOAPMsgFactoryCreateException("soap.factory.create.err", new Object[]{e});
        }
    }

    public static SOAPFactory getSOAPFactory(String bindingId) {
        if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            return soap12Factory;
        }
        return soap11Factory;
    }

    public static SOAPFault createSOAPFault(String bindingId) {
        if (bindingId == null) {
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        try {
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                return soap12Factory.createFault();
            }
            return soap11Factory.createFault();
        }
        catch (SOAPException e) {
            throw new SOAPMsgFactoryCreateException("soap.fault.create.err", new Object[]{e});
        }
    }

    public static SOAPFault createSOAPFault(String msg, QName code, String actor, Detail detail, String bindingId) {
        if (bindingId == null) {
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        try {
            SOAPFault fault = null;
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                fault = soap12Factory.createFault(msg, code);
            } else if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                fault = soap11Factory.createFault(msg, code);
            }
            if (actor != null) {
                fault.setFaultActor(actor);
            }
            if (detail != null) {
                Node n = fault.getOwnerDocument().importNode((Node)detail, true);
                fault.appendChild(n);
            }
            return fault;
        }
        catch (SOAPException e) {
            throw new SOAPMsgFactoryCreateException("soap.fault.create.err", new Object[]{e});
        }
    }

    public static SOAPMessage createMessage() {
        return SOAPUtil.createMessage("http://schemas.xmlsoap.org/wsdl/soap/http");
    }

    public static SOAPMessage createMessage(String binding) {
        try {
            return SOAPUtil.getMessageFactory(binding).createMessage();
        }
        catch (SOAPException e) {
            throw new SOAPMsgCreateException("soap.msg.create.err", new Object[]{e});
        }
    }

    public static SOAPMessage createMessage(MimeHeaders headers, InputStream in, String binding) throws IOException {
        try {
            RuntimeModule rtm = ModuleFinder.findAddressingModule();
            if (rtm != null && rtm.supportedBindings().contains(binding)) {
                binding = rtm.getJAXWSBindingId(binding);
            }
            return SOAPUtil.getMessageFactory(binding).createMessage(headers, in);
        }
        catch (SOAPException e) {
            throw new SOAPMsgCreateException("soap.msg.create.err", new Object[]{e});
        }
    }

    public static SOAPMessage createMessage(MimeHeaders headers, InputStream in) throws IOException {
        return SOAPUtil.createMessage(headers, in, "http://schemas.xmlsoap.org/wsdl/soap/http");
    }

    public static MessageFactory getMessageFactory(String binding) {
        if (binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            return soap11messageFactory;
        }
        if (binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            return soap12messageFactory;
        }
        return soap11messageFactory;
    }

    private static MessageFactory createMessageFactory(String bindingId) {
        try {
            return MessageFactory.newInstance((String)bindingId);
        }
        catch (SOAPException e) {
            throw new SOAPMsgFactoryCreateException("soap.msg.factory.create.err", new Object[]{e});
        }
    }
}

