/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl.parser;

import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.spi.runtime.RuntimeModule;
import com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.ModuleFinder;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.parser.Binding;
import com.sun.xml.ws.wsdl.parser.BindingOperation;
import com.sun.xml.ws.wsdl.parser.MIMEConstants;
import com.sun.xml.ws.wsdl.parser.Message;
import com.sun.xml.ws.wsdl.parser.ParserUtil;
import com.sun.xml.ws.wsdl.parser.Port;
import com.sun.xml.ws.wsdl.parser.PortType;
import com.sun.xml.ws.wsdl.parser.PortTypeOperation;
import com.sun.xml.ws.wsdl.parser.SOAPConstants;
import com.sun.xml.ws.wsdl.parser.Service;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import com.sun.xml.ws.wsdl.parser.WSDLDocument;
import com.sun.xml.ws.wsdl.parser.policy.MtomPolicyAssertionHandler;
import com.sun.xml.ws.wsdl.parser.policy.Policy;
import com.sun.xml.ws.wsdl.parser.policy.PolicyAlternative;
import com.sun.xml.ws.wsdl.parser.policy.PolicyBuilder;
import com.sun.xml.ws.wsdl.parser.policy.PolicyReference;
import com.sun.xml.ws.wsdl.parser.policy.TextEncodingPolicyAssertionHandler;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeWSDLParser {
    private final WSDLDocument wsdlDoc = new WSDLDocument();
    private String targetNamespace;
    private final Set<String> importedWSDLs = new HashSet<String>();
    private final EntityResolver resolver;
    private RuntimeModule runtimeModule = ModuleFinder.findAddressingModule();

    public static WSDLDocument parse(URL wsdlLoc, EntityResolver resolver) throws IOException, XMLStreamException, SAXException {
        assert (resolver != null);
        RuntimeWSDLParser parser = new RuntimeWSDLParser(resolver);
        parser.parseWSDL(wsdlLoc);
        parser.wsdlDoc.resolvePolicy();
        return parser.wsdlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillDocInfo(DocInfo docInfo, QName serviceName, QName portTypeName) throws XMLStreamException {
        RuntimeWSDLParser parser = new RuntimeWSDLParser(null);
        InputSource source = new InputSource(docInfo.getDoc());
        XMLStreamReader reader = RuntimeWSDLParser.createReader(source);
        try {
            XMLStreamReaderUtil.nextElementContent(reader);
            if (reader.getName().equals(WSDLConstants.QNAME_SCHEMA)) {
                docInfo.setDocType(DocInfo.DOC_TYPE.SCHEMA);
                String tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
                docInfo.setTargetNamespace(tns);
                return;
            }
            if (reader.getName().equals(WSDLConstants.QNAME_DEFINITIONS)) {
                String tns;
                docInfo.setDocType(DocInfo.DOC_TYPE.WSDL);
                parser.targetNamespace = tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
                docInfo.setTargetNamespace(tns);
            } else {
                docInfo.setDocType(DocInfo.DOC_TYPE.OTHER);
                return;
            }
            while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
                if (reader.getEventType() == 8) {
                    break;
                }
                QName name = reader.getName();
                if (WSDLConstants.QNAME_PORT_TYPE.equals(name)) {
                    String pn = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                    if (!(portTypeName == null || portTypeName.getLocalPart().equals(pn) && portTypeName.getNamespaceURI().equals(docInfo.getTargetNamespace()))) {
                        docInfo.setPortType(true);
                    }
                    XMLStreamReaderUtil.skipElement(reader);
                    continue;
                }
                if (WSDLConstants.QNAME_SERVICE.equals(name)) {
                    String sn = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                    QName sqn = new QName(docInfo.getTargetNamespace(), sn);
                    if (!serviceName.equals(sqn)) continue;
                    parser.parseService(reader);
                    docInfo.setService(parser.wsdlDoc.getService(sqn));
                    if (reader.getEventType() == 2) continue;
                    XMLStreamReaderUtil.next(reader);
                    continue;
                }
                XMLStreamReaderUtil.skipElement(reader);
            }
        }
        finally {
            reader.close();
        }
    }

    private RuntimeWSDLParser(EntityResolver resolver) {
        this.resolver = resolver;
        PolicyBuilder.newInstance().registerAssertionHandler(new MtomPolicyAssertionHandler());
        PolicyBuilder.newInstance().registerAssertionHandler(new TextEncodingPolicyAssertionHandler());
    }

    private static XMLStreamReader createReader(InputSource source) {
        return XMLStreamReaderFactory.createFreshXMLStreamReader(source, true);
    }

    private void parseWSDL(URL wsdlLoc) throws XMLStreamException, IOException, SAXException {
        InputSource source = this.resolver.resolveEntity(null, wsdlLoc.toExternalForm());
        if (source == null) {
            source = new InputSource(wsdlLoc.toExternalForm());
        } else if (source.getSystemId() == null) {
            source.setSystemId(wsdlLoc.toExternalForm());
        }
        if (!this.importedWSDLs.add(source.getSystemId())) {
            return;
        }
        XMLStreamReader reader = RuntimeWSDLParser.createReader(source);
        XMLStreamReaderUtil.nextElementContent(reader);
        if (!reader.getName().equals(WSDLConstants.QNAME_DEFINITIONS)) {
            ParserUtil.failWithFullName("runtime.parser.wsdl.invalidElement", reader);
        }
        String tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
        String oldTargetNamespace = this.targetNamespace;
        this.targetNamespace = tns;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2 && reader.getEventType() != 8) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_IMPORT.equals(name)) {
                this.parseImport(wsdlLoc, reader);
                continue;
            }
            if (WSDLConstants.QNAME_MESSAGE.equals(name)) {
                this.parseMessage(reader);
                continue;
            }
            if (WSDLConstants.QNAME_PORT_TYPE.equals(name)) {
                this.parsePortType(reader);
                continue;
            }
            if (WSDLConstants.QNAME_BINDING.equals(name)) {
                this.parseBinding(reader);
                continue;
            }
            if (WSDLConstants.QNAME_SERVICE.equals(name)) {
                this.parseService(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
        this.targetNamespace = oldTargetNamespace;
        reader.close();
    }

    private Policy parsePolicy(XMLStreamReader reader) {
        String tns;
        String base = reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
        String uri = "#" + ParserUtil.getMandatoryNonEmptyAttribute(reader, WSDLConstants.QNAME_ATTR_POLICY_ID.getNamespaceURI(), WSDLConstants.QNAME_ATTR_POLICY_ID.getLocalPart());
        if (base != null) {
            uri = uri + base;
        }
        if ((tns = reader.getAttributeValue(null, "TargetNamespace")) == null) {
            tns = this.targetNamespace;
        }
        Policy policy = new Policy(this.targetNamespace, uri);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (!WSDLConstants.QNAME_POLICY_EXACTLY_ONE.equals(name)) continue;
            PolicyAlternative pa = new PolicyAlternative();
            this.parseAllOrExactlyOne(reader, policy, pa);
            if (pa.size() > 0) {
                policy.addAlternative(pa);
            }
            if (reader.getEventType() == 2) continue;
            XMLStreamReaderUtil.next(reader);
        }
        return policy;
    }

    private void parseAllOrExactlyOne(XMLStreamReader reader, Policy policy, PolicyAlternative pa) {
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_POLICY_ALL.equals(name)) {
                PolicyAlternative pall = new PolicyAlternative();
                this.parseAllOrExactlyOne(reader, policy, pall);
                policy.addAlternative(pall);
                if (reader.getEventType() == 2) continue;
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (WSDLConstants.QNAME_POLICY_EXACTLY_ONE.equals(name)) {
                this.parseAllOrExactlyOne(reader, policy, pa);
                if (reader.getEventType() == 2) continue;
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            PolicyBuilder.newInstance().handle(reader, pa);
        }
    }

    private void parseService(XMLStreamReader reader) {
        String serviceName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        Service service = new Service(new QName(this.targetNamespace, serviceName));
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_PORT.equals(name)) {
                RuntimeWSDLParser.parsePort(reader, service);
                if (reader.getEventType() == 2) continue;
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
        this.wsdlDoc.addService(service);
    }

    private static void parsePort(XMLStreamReader reader, Service service) {
        String portName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        String binding = ParserUtil.getMandatoryNonEmptyAttribute(reader, "binding");
        QName bindingName = ParserUtil.getQName(reader, binding);
        String location = null;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (SOAPConstants.QNAME_ADDRESS.equals(name) || SOAPConstants.QNAME_SOAP12ADDRESS.equals(name)) {
                location = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
        QName portQName = new QName(service.getName().getNamespaceURI(), portName);
        service.put(portQName, new Port(portQName, bindingName, location));
    }

    private void parseBinding(XMLStreamReader reader) {
        String bindingName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        String portTypeName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "type");
        if (bindingName == null || portTypeName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        Binding binding = new Binding(new QName(this.targetNamespace, bindingName), ParserUtil.getQName(reader, portTypeName));
        binding.setWsdlDocument(this.wsdlDoc);
        this.wsdlDoc.addBinding(binding);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.NS_SOAP_BINDING.equals(name)) {
                binding.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http");
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (WSDLConstants.NS_SOAP12_BINDING.equals(name)) {
                binding.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (WSDLConstants.QNAME_OPERATION.equals(name)) {
                RuntimeWSDLParser.parseBindingOperation(reader, binding);
                continue;
            }
            if (this.runtimeModule != null && this.runtimeModule.supportedBindingNames().contains(name)) {
                this.runtimeModule.parseBinding(binding, name);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (WSDLConstants.QNAME_WS_POLICYREFERENCE.equals(name)) {
                String base = reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
                String uri = ParserUtil.getMandatoryNonEmptyAttribute(reader, null, "URI");
                if (base != null) {
                    uri = uri + base;
                }
                PolicyReference pr = new PolicyReference(uri, WSDLConstants.QNAME_BINDING);
                binding.setPolicyRefernce(pr);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private static void parseBindingOperation(XMLStreamReader reader, Binding binding) {
        String bindingOpName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        if (bindingOpName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        BindingOperation bindingOp = new BindingOperation(bindingOpName);
        binding.put(bindingOpName, bindingOp);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_INPUT.equals(name)) {
                RuntimeWSDLParser.parseInputBinding(reader, bindingOp);
                continue;
            }
            if (WSDLConstants.QNAME_OUTPUT.equals(name)) {
                RuntimeWSDLParser.parseOutputBinding(reader, bindingOp);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private static void parseInputBinding(XMLStreamReader reader, BindingOperation bindingOp) {
        boolean bodyFound = false;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(name) || SOAPConstants.QNAME_SOAP12BODY.equals(name)) && !bodyFound) {
                bodyFound = true;
                bindingOp.setInputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(reader, bindingOp.getInputParts()));
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name) || SOAPConstants.QNAME_SOAP12HEADER.equals(name)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, bindingOp.getInputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(name)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(reader, bindingOp.getInputParts(), bindingOp.getOutputMimeTypes());
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private static void parseOutputBinding(XMLStreamReader reader, BindingOperation bindingOp) {
        boolean bodyFound = false;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(name) || SOAPConstants.QNAME_SOAP12BODY.equals(name)) && !bodyFound) {
                bodyFound = true;
                bindingOp.setOutputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(reader, bindingOp.getOutputParts()));
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name) || SOAPConstants.QNAME_SOAP12HEADER.equals(name)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, bindingOp.getOutputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(name)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(reader, bindingOp.getOutputParts(), bindingOp.getOutputMimeTypes());
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader reader, Map<String, ParameterBinding> parts) {
        String partsString = reader.getAttributeValue(null, "parts");
        if (partsString != null) {
            List<String> partsList = XmlUtil.parseTokenList(partsString);
            if (partsList.isEmpty()) {
                parts.put(" ", ParameterBinding.BODY);
            } else {
                for (String part : partsList) {
                    parts.put(part, ParameterBinding.BODY);
                }
            }
            return true;
        }
        return false;
    }

    private static void parseSOAPHeaderBinding(XMLStreamReader reader, Map<String, ParameterBinding> parts) {
        String part = reader.getAttributeValue(null, "part");
        if (part == null | part.equals("")) {
            return;
        }
        parts.put(part, ParameterBinding.HEADER);
        RuntimeWSDLParser.goToEnd(reader);
    }

    private static void parseMimeMultipartBinding(XMLStreamReader reader, Map<String, ParameterBinding> parts, Map<String, String> mimeTypes) {
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (MIMEConstants.QNAME_PART.equals(name)) {
                RuntimeWSDLParser.parseMIMEPart(reader, parts, mimeTypes);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private static void parseMIMEPart(XMLStreamReader reader, Map<String, ParameterBinding> parts, Map<String, String> mimeTypes) {
        boolean bodyFound = false;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (SOAPConstants.QNAME_BODY.equals(name) && !bodyFound) {
                bodyFound = true;
                RuntimeWSDLParser.parseSOAPBodyBinding(reader, parts);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name)) {
                bodyFound = true;
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, parts);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (MIMEConstants.QNAME_CONTENT.equals(name)) {
                String part = reader.getAttributeValue(null, "part");
                String type = reader.getAttributeValue(null, "type");
                if (part == null || type == null) {
                    XMLStreamReaderUtil.skipElement(reader);
                    continue;
                }
                ParameterBinding sb = ParameterBinding.createAttachment(type);
                parts.put(part, sb);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    protected void parseImport(URL baseURL, XMLStreamReader reader) throws IOException, SAXException, XMLStreamException {
        String importLocation = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
        URL importURL = new URL(baseURL, importLocation);
        this.parseWSDL(importURL);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private void parsePortType(XMLStreamReader reader) {
        String portTypeName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        if (portTypeName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        PortType portType = new PortType(new QName(this.targetNamespace, portTypeName));
        this.wsdlDoc.addPortType(portType);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_OPERATION.equals(name)) {
                this.parsePortTypeOperation(reader, portType);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private void parsePortTypeOperation(XMLStreamReader reader, PortType portType) {
        String operationName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        if (operationName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        QName operationQName = new QName(portType.getName().getNamespaceURI(), operationName);
        PortTypeOperation operation = new PortTypeOperation(operationQName);
        String parameterOrder = ParserUtil.getAttribute(reader, "parameterOrder");
        operation.setParameterOrder(parameterOrder);
        portType.put(operationName, operation);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (name.equals(WSDLConstants.QNAME_INPUT)) {
                this.parsePortTypeOperationInput(reader, operation);
                continue;
            }
            if (name.equals(WSDLConstants.QNAME_OUTPUT)) {
                this.parsePortTypeOperationOutput(reader, operation);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private void parsePortTypeOperationInput(XMLStreamReader reader, PortTypeOperation operation) {
        String msg = ParserUtil.getAttribute(reader, "message");
        QName msgName = ParserUtil.getQName(reader, msg);
        operation.setInputMessage(msgName);
        RuntimeWSDLParser.goToEnd(reader);
    }

    private void parsePortTypeOperationOutput(XMLStreamReader reader, PortTypeOperation operation) {
        String msg = ParserUtil.getAttribute(reader, "message");
        QName msgName = ParserUtil.getQName(reader, msg);
        operation.setOutputMessage(msgName);
        RuntimeWSDLParser.goToEnd(reader);
    }

    private void parseMessage(XMLStreamReader reader) {
        String msgName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        Message msg = new Message(new QName(this.targetNamespace, msgName));
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_PART.equals(name)) {
                String part = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                msg.add(part);
                if (reader.getEventType() == 2) continue;
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
        this.wsdlDoc.addMessage(msg);
        if (reader.getEventType() != 2) {
            RuntimeWSDLParser.goToEnd(reader);
        }
    }

    private static void goToEnd(XMLStreamReader reader) {
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            XMLStreamReaderUtil.skipElement(reader);
        }
    }
}

