/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl.parser.policy;

import com.sun.xml.ws.wsdl.parser.policy.PolicyAlternative;
import com.sun.xml.ws.wsdl.parser.policy.PolicyAssertionHandler;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public final class PolicyBuilder {
    private final Map<String, PolicyAssertionHandler> handlers = new HashMap<String, PolicyAssertionHandler>();
    private static PolicyBuilder pb = null;

    private PolicyBuilder() {
    }

    public static PolicyBuilder newInstance() {
        if (pb == null) {
            pb = new PolicyBuilder();
            return pb;
        }
        return pb;
    }

    public void registerAssertionHandler(PolicyAssertionHandler pah) {
        this.handlers.put(pah.assertionURI(), pah);
    }

    public void handle(XMLStreamReader reader, PolicyAlternative policyAlternative) {
        QName name = reader.getName();
        PolicyAssertionHandler pah = this.handlers.get(name.getNamespaceURI());
        if (pah != null) {
            pah.handle(reader, policyAlternative);
        }
    }
}

