/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl.writer;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.v2.schemagen.Util;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.output.ResultFactory;
import com.sun.xml.txw2.output.XmlSerializer;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import com.sun.xml.ws.model.CheckedException;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.model.Parameter;
import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.model.soap.Style;
import com.sun.xml.ws.model.soap.Use;
import com.sun.xml.ws.spi.runtime.RuntimeModule;
import com.sun.xml.ws.util.ModuleFinder;
import com.sun.xml.ws.wsdl.writer.WSDLOutputResolver;
import com.sun.xml.ws.wsdl.writer.document.Binding;
import com.sun.xml.ws.wsdl.writer.document.BindingOperationType;
import com.sun.xml.ws.wsdl.writer.document.Definitions;
import com.sun.xml.ws.wsdl.writer.document.Fault;
import com.sun.xml.ws.wsdl.writer.document.FaultType;
import com.sun.xml.ws.wsdl.writer.document.Import;
import com.sun.xml.ws.wsdl.writer.document.Message;
import com.sun.xml.ws.wsdl.writer.document.Operation;
import com.sun.xml.ws.wsdl.writer.document.ParamType;
import com.sun.xml.ws.wsdl.writer.document.Part;
import com.sun.xml.ws.wsdl.writer.document.Port;
import com.sun.xml.ws.wsdl.writer.document.PortType;
import com.sun.xml.ws.wsdl.writer.document.Service;
import com.sun.xml.ws.wsdl.writer.document.StartWithExtensionsType;
import com.sun.xml.ws.wsdl.writer.document.Types;
import com.sun.xml.ws.wsdl.writer.document.soap.Body;
import com.sun.xml.ws.wsdl.writer.document.soap.BodyType;
import com.sun.xml.ws.wsdl.writer.document.soap.Header;
import com.sun.xml.ws.wsdl.writer.document.soap12.SOAPAddress;
import com.sun.xml.ws.wsdl.writer.document.soap12.SOAPFault;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGenerator {
    private JAXWSOutputSchemaResolver resolver;
    private WSDLOutputResolver wsdlResolver = null;
    private RuntimeModel model;
    private Definitions serviceDefinitions;
    private Definitions portDefinitions;
    private Types types;
    public static final String DOT_WSDL = ".wsdl";
    public static final String RESPONSE = "Response";
    public static final String PARAMETERS = "parameters";
    public static final String RESULT = "parameters";
    public static final String UNWRAPPABLE_RESULT = "result";
    public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL_PREFIX = "wsdl";
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_PREFIX = "xsd";
    public static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP12_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String SOAP_PREFIX = "soap";
    public static final String SOAP12_PREFIX = "soap12";
    public static final String TNS_PREFIX = "tns";
    public static final String BINDING = "Binding";
    public static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP12_HTTP_TRANSPORT = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    public static final String DOCUMENT = "document";
    public static final String RPC = "rpc";
    public static final String LITERAL = "literal";
    public static final String REPLACE_WITH_ACTUAL_URL = "REPLACE_WITH_ACTUAL_URL";
    private Set<QName> processedExceptions = new HashSet<QName>();
    private String bindingId;
    private String wsdlLocation;
    private String portWSDLID;
    private String schemaPrefix;

    public WSDLGenerator(RuntimeModel model, WSDLOutputResolver wsdlResolver, String bindingId) {
        this.model = model;
        this.resolver = new JAXWSOutputSchemaResolver();
        this.wsdlResolver = wsdlResolver;
        this.bindingId = bindingId;
    }

    public void doGeneration() {
        XmlSerializer portWriter = null;
        String fileName = JAXBRIContext.mangleNameToClassName((String)this.model.getServiceQName().getLocalPart());
        Result result = this.wsdlResolver.getWSDLOutput(fileName + DOT_WSDL);
        if (result == null) {
            return;
        }
        this.wsdlLocation = result.getSystemId();
        XmlSerializer serviceWriter = ResultFactory.createSerializer((Result)result);
        if (this.model.getServiceQName().getNamespaceURI().equals(this.model.getTargetNamespace())) {
            portWriter = serviceWriter;
            this.schemaPrefix = fileName + "_";
        } else {
            String wsdlName = JAXBRIContext.mangleNameToClassName((String)this.model.getPortTypeName().getLocalPart());
            if (wsdlName.equals(fileName)) {
                wsdlName = wsdlName + "PortType";
            }
            Holder<String> absWSDLName = new Holder<String>();
            absWSDLName.value = wsdlName + DOT_WSDL;
            result = this.wsdlResolver.getAbstractWSDLOutput(absWSDLName);
            if (result != null) {
                this.portWSDLID = result.getSystemId();
                portWriter = this.portWSDLID.equals(this.wsdlLocation) ? serviceWriter : ResultFactory.createSerializer((Result)result);
            } else {
                this.portWSDLID = (String)absWSDLName.value;
            }
            this.schemaPrefix = new File(this.portWSDLID).getName();
            int idx = this.schemaPrefix.lastIndexOf(46);
            if (idx > 0) {
                this.schemaPrefix = this.schemaPrefix.substring(0, idx);
            }
            this.schemaPrefix = JAXBRIContext.mangleNameToClassName((String)this.schemaPrefix) + "_";
        }
        this.generateDocument(serviceWriter, portWriter);
    }

    private void generateDocument(XmlSerializer serviceStream, XmlSerializer portStream) {
        this.serviceDefinitions = (Definitions)TXW.create(Definitions.class, (XmlSerializer)serviceStream);
        this.serviceDefinitions._namespace(WSDL_NAMESPACE, "");
        this.serviceDefinitions._namespace(XSD_NAMESPACE, XSD_PREFIX);
        this.serviceDefinitions.targetNamespace(this.model.getServiceQName().getNamespaceURI());
        this.serviceDefinitions._namespace(this.model.getServiceQName().getNamespaceURI(), TNS_PREFIX);
        if (this.bindingId.equals(SOAP12_HTTP_TRANSPORT)) {
            this.serviceDefinitions._namespace(SOAP12_NAMESPACE, SOAP12_PREFIX);
        } else {
            this.serviceDefinitions._namespace(SOAP11_NAMESPACE, SOAP_PREFIX);
        }
        this.serviceDefinitions.name(this.model.getServiceQName().getLocalPart());
        if (serviceStream != portStream && portStream != null) {
            this.portDefinitions = (Definitions)TXW.create(Definitions.class, (XmlSerializer)portStream);
            this.portDefinitions._namespace(WSDL_NAMESPACE, "");
            this.portDefinitions._namespace(XSD_NAMESPACE, XSD_PREFIX);
            if (this.model.getTargetNamespace() != null) {
                this.portDefinitions.targetNamespace(this.model.getTargetNamespace());
                this.portDefinitions._namespace(this.model.getTargetNamespace(), TNS_PREFIX);
            }
            String schemaLoc = WSDLGenerator.relativize(this.portWSDLID, this.wsdlLocation);
            Import _import = this.serviceDefinitions._import().namespace(this.model.getTargetNamespace());
            _import.location(schemaLoc);
        } else if (portStream != null) {
            this.portDefinitions = this.serviceDefinitions;
        } else {
            String schemaLoc = WSDLGenerator.relativize(this.portWSDLID, this.wsdlLocation);
            Import _import = this.serviceDefinitions._import().namespace(this.model.getTargetNamespace());
            _import.location(schemaLoc);
        }
        if (this.portDefinitions != null) {
            this.generateTypes();
            this.generateMessages();
            this.generatePortType();
        }
        this.generateBinding();
        this.generateService();
        this.serviceDefinitions.commit();
        if (this.portDefinitions != null && this.portDefinitions != this.serviceDefinitions) {
            this.portDefinitions.commit();
        }
    }

    protected void generateTypes() {
        this.types = this.portDefinitions.types();
        if (this.model.getJAXBContext() != null) {
            try {
                this.model.getJAXBContext().generateSchema((SchemaOutputResolver)this.resolver);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new WebServiceException(e.getMessage());
            }
        }
    }

    protected void generateMessages() {
        for (JavaMethod method : this.model.getJavaMethods()) {
            if (!(method.getBinding() instanceof SOAPBinding)) continue;
            this.generateSOAPMessages(method, (SOAPBinding)method.getBinding());
        }
    }

    protected void generateSOAPMessages(JavaMethod method, SOAPBinding binding) {
        Part part;
        boolean isDoclit = binding.isDocLit();
        Message message = this.portDefinitions.message().name(method.getOperationName());
        JAXBRIContext jaxbContext = this.model.getJAXBContext();
        boolean unwrappable = true;
        for (Parameter param : method.getRequestParameters()) {
            if (isDoclit) {
                if (this.isHeaderParameter(param)) {
                    unwrappable = false;
                }
                if (param.isWrapperStyle()) {
                    part = message.part().name("parameters");
                    part.element(param.getName());
                    continue;
                }
                part = message.part().name(param.getPartName());
                part.element(param.getName());
                continue;
            }
            if (param.isWrapperStyle()) {
                for (Parameter childParam : ((WrapperParameter)param).getWrapperChildren()) {
                    part = message.part().name(childParam.getPartName());
                    part.type(jaxbContext.getTypeName(childParam.getTypeReference()));
                }
                continue;
            }
            part = message.part().name(param.getPartName());
            part.element(param.getName());
        }
        if (method.getMEP() != 2) {
            message = this.portDefinitions.message().name(method.getOperationName() + RESPONSE);
            if (unwrappable) {
                for (Parameter param : method.getResponseParameters()) {
                    if (!this.isHeaderParameter(param)) continue;
                    unwrappable = false;
                }
            }
            for (Parameter param : method.getResponseParameters()) {
                if (isDoclit) {
                    if (param.isWrapperStyle()) {
                        part = unwrappable ? message.part().name("parameters") : message.part().name(UNWRAPPABLE_RESULT);
                        part.element(param.getName());
                        continue;
                    }
                    part = message.part().name(param.getPartName());
                    part.element(param.getName());
                    continue;
                }
                if (param.isWrapperStyle()) {
                    for (Parameter childParam : ((WrapperParameter)param).getWrapperChildren()) {
                        part = message.part().name(childParam.getPartName());
                        part.type(jaxbContext.getTypeName(childParam.getTypeReference()));
                    }
                    continue;
                }
                part = message.part().name(param.getPartName());
                part.element(param.getName());
            }
        }
        for (CheckedException exception : method.getCheckedExceptions()) {
            QName tagName = exception.getDetailType().tagName;
            if (this.processedExceptions.contains(tagName)) continue;
            message = this.portDefinitions.message().name(tagName.getLocalPart());
            part = message.part().name(tagName.getLocalPart());
            part.element(tagName);
            this.processedExceptions.add(tagName);
        }
    }

    protected void generatePortType() {
        PortType portType = this.portDefinitions.portType().name(this.model.getPortTypeName().getLocalPart());
        for (JavaMethod method : this.model.getJavaMethods()) {
            Annotation[] as;
            Annotation[] arr$;
            int len$;
            int i$;
            Operation operation = portType.operation().name(method.getOperationName());
            this.generateParameterOrder(operation, method);
            switch (method.getMEP()) {
                case 1: {
                    this.generateInputMessage(operation, method);
                    this.generateOutputMessage(operation, method);
                    break;
                }
                case 2: {
                    this.generateInputMessage(operation, method);
                }
            }
            boolean gotFaultMessage = false;
            RuntimeModule rtm = null;
            if (this.model.isAddressing() && (rtm = ModuleFinder.findAddressingModule()) != null && (i$ = 0) < (len$ = (arr$ = (as = method.getMethod().getDeclaredAnnotations())).length)) {
                Annotation a = arr$[i$];
                if (rtm.supportedMethodAnnotations().contains(a.annotationType())) {
                    gotFaultMessage = true;
                }
            }
            for (CheckedException exception : method.getCheckedExceptions()) {
                QName tagName = exception.getDetailType().tagName;
                QName messageName = new QName(this.model.getTargetNamespace(), tagName.getLocalPart());
                FaultType paramType = operation.fault().name(tagName.getLocalPart()).message(messageName);
                if (!gotFaultMessage) continue;
                rtm.generateFaultMessage(paramType, method, exception);
            }
        }
    }

    protected boolean isWrapperStyle(JavaMethod method) {
        if (method.getRequestParameters().size() > 0) {
            Parameter param = method.getRequestParameters().iterator().next();
            return param.isWrapperStyle();
        }
        return false;
    }

    protected boolean isRpcLit(JavaMethod method) {
        return method.getBinding() instanceof SOAPBinding && ((SOAPBinding)method.getBinding()).getStyle().equals((Object)Style.RPC);
    }

    protected void generateParameterOrder(Operation operation, JavaMethod method) {
        if (method.getMEP() == 2) {
            return;
        }
        if (this.isRpcLit(method)) {
            this.generateRpcParameterOrder(operation, method);
        } else {
            this.generateDocumentParameterOrder(operation, method);
        }
    }

    protected void generateRpcParameterOrder(Operation operation, JavaMethod method) {
        StringBuffer paramOrder = new StringBuffer();
        HashSet<String> partNames = new HashSet<String>();
        List<Parameter> sortedParams = this.sortMethodParameters(method);
        int i = 0;
        for (Parameter parameter : sortedParams) {
            String partName;
            if (parameter.getIndex() < 0 || partNames.contains(partName = parameter.getPartName())) continue;
            if (i++ > 0) {
                paramOrder.append(' ');
            }
            paramOrder.append(partName);
            partNames.add(partName);
        }
        operation.parameterOrder(paramOrder.toString());
    }

    protected void generateDocumentParameterOrder(Operation operation, JavaMethod method) {
        StringBuffer paramOrder = new StringBuffer();
        HashSet<String> partNames = new HashSet<String>();
        List<Parameter> sortedParams = this.sortMethodParameters(method);
        boolean isWrapperStyle = this.isWrapperStyle(method);
        int i = 0;
        for (Parameter parameter : sortedParams) {
            if (parameter.getIndex() < 0) continue;
            String partName = isWrapperStyle && this.isBodyParameter(parameter) ? (method.getRequestParameters().contains(parameter) ? "parameters" : RESPONSE) : parameter.getPartName();
            if (partNames.contains(partName)) continue;
            if (i++ > 0) {
                paramOrder.append(' ');
            }
            paramOrder.append(partName);
            partNames.add(partName);
        }
        if (i > 1) {
            operation.parameterOrder(paramOrder.toString());
        }
    }

    protected List<Parameter> sortMethodParameters(JavaMethod method) {
        Parameter param2;
        HashSet<Parameter> paramSet = new HashSet<Parameter>();
        ArrayList<Parameter> sortedParams = new ArrayList<Parameter>();
        if (this.isRpcLit(method)) {
            for (Parameter param2 : method.getRequestParameters()) {
                if (param2 instanceof WrapperParameter) {
                    paramSet.addAll(((WrapperParameter)param2).getWrapperChildren());
                    continue;
                }
                paramSet.add(param2);
            }
            for (Parameter param2 : method.getResponseParameters()) {
                if (param2 instanceof WrapperParameter) {
                    paramSet.addAll(((WrapperParameter)param2).getWrapperChildren());
                    continue;
                }
                paramSet.add(param2);
            }
        } else {
            paramSet.addAll(method.getRequestParameters());
            paramSet.addAll(method.getResponseParameters());
        }
        Iterator params = paramSet.iterator();
        if (paramSet.size() == 0) {
            return sortedParams;
        }
        param2 = (Parameter)params.next();
        sortedParams.add(param2);
        for (int i = 1; i < paramSet.size(); ++i) {
            int pos;
            param2 = (Parameter)params.next();
            for (pos = 0; pos < i; ++pos) {
                Parameter sortedParam = (Parameter)sortedParams.get(pos);
                if (param2.getIndex() == sortedParam.getIndex() && param2 instanceof WrapperParameter || param2.getIndex() < sortedParam.getIndex()) break;
            }
            sortedParams.add(pos, param2);
        }
        return sortedParams;
    }

    protected boolean isBodyParameter(Parameter parameter) {
        ParameterBinding paramBinding = parameter.getBinding();
        return paramBinding.isBody();
    }

    protected boolean isHeaderParameter(Parameter parameter) {
        ParameterBinding paramBinding = parameter.getBinding();
        return paramBinding.isHeader();
    }

    protected boolean isAttachmentParameter(Parameter parameter) {
        ParameterBinding paramBinding = parameter.getBinding();
        return paramBinding.isAttachment();
    }

    protected void generateBinding() {
        RuntimeModule rtm;
        Binding binding = this.serviceDefinitions.binding().name(this.model.getPortName().getLocalPart() + BINDING);
        binding.type(this.model.getPortTypeName());
        if (this.model.isAddressing() && (rtm = ModuleFinder.findAddressingModule()) != null) {
            rtm.generateBinding(binding);
        }
        boolean first = true;
        for (JavaMethod method : this.model.getJavaMethods()) {
            if (first) {
                if (method.getBinding() instanceof SOAPBinding) {
                    Object soapBinding;
                    SOAPBinding sBinding = (SOAPBinding)method.getBinding();
                    SOAPVersion soapVersion = sBinding.getSOAPVersion();
                    if (soapVersion.equals(SOAP12_HTTP_TRANSPORT)) {
                        soapBinding = binding.soap12Binding();
                        soapBinding.transport(SOAP12_HTTP_TRANSPORT);
                        if (sBinding.getStyle().equals((Object)Style.DOCUMENT)) {
                            soapBinding.style(DOCUMENT);
                        } else {
                            soapBinding.style(RPC);
                        }
                    } else {
                        soapBinding = binding.soapBinding();
                        soapBinding.transport(SOAP_HTTP_TRANSPORT);
                        if (sBinding.getStyle().equals((Object)Style.DOCUMENT)) {
                            soapBinding.style(DOCUMENT);
                        } else {
                            soapBinding.style(RPC);
                        }
                    }
                }
                first = false;
            }
            if (this.bindingId.equals(SOAP12_HTTP_TRANSPORT)) {
                this.generateSOAP12BindingOperation(method, binding);
                continue;
            }
            this.generateBindingOperation(method, binding);
        }
    }

    protected void generateBindingOperation(JavaMethod method, Binding binding) {
        BindingOperationType operation = binding.operation().name(method.getOperationName());
        String targetNamespace = this.model.getTargetNamespace();
        QName requestMessage = new QName(targetNamespace, method.getOperationName());
        QName responseMessage = new QName(targetNamespace, method.getOperationName() + RESPONSE);
        if (method.getBinding() instanceof SOAPBinding) {
            ArrayList<Parameter> bodyParams = new ArrayList<Parameter>();
            ArrayList<Parameter> headerParams = new ArrayList<Parameter>();
            this.splitParameters(bodyParams, headerParams, method.getRequestParameters());
            SOAPBinding soapBinding = (SOAPBinding)method.getBinding();
            operation.soapOperation().soapAction(soapBinding.getSOAPAction());
            StartWithExtensionsType input = operation.input();
            BodyType body = (BodyType)input._element(Body.class);
            boolean isRpc = soapBinding.getStyle().equals((Object)Style.RPC);
            if (soapBinding.getUse().equals((Object)Use.LITERAL)) {
                body.use(LITERAL);
                if (headerParams.size() > 0) {
                    Parameter param = (Parameter)bodyParams.iterator().next();
                    if (isRpc) {
                        StringBuffer parts = new StringBuffer();
                        int i = 0;
                        for (Parameter parameter : ((WrapperParameter)param).getWrapperChildren()) {
                            if (i++ > 0) {
                                parts.append(' ');
                            }
                            parts.append(parameter.getPartName());
                        }
                        body.parts(parts.toString());
                    } else if (param.isWrapperStyle()) {
                        body.parts("parameters");
                    } else {
                        body.parts(param.getPartName());
                    }
                    this.generateSOAPHeaders(input, headerParams, requestMessage);
                }
                if (isRpc) {
                    body.namespace(method.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            } else {
                throw new WebServiceException("encoded use is not supported");
            }
            if (method.getMEP() != 2) {
                boolean unwrappable = headerParams.size() == 0;
                bodyParams.clear();
                headerParams.clear();
                this.splitParameters(bodyParams, headerParams, method.getResponseParameters());
                unwrappable = unwrappable ? headerParams.size() == 0 : unwrappable;
                StartWithExtensionsType output = operation.output();
                body = (BodyType)output._element(Body.class);
                body.use(LITERAL);
                if (headerParams.size() > 0) {
                    Parameter param = bodyParams.iterator().hasNext() ? (Parameter)bodyParams.iterator().next() : null;
                    String parts = "";
                    if (isRpc) {
                        int i = 0;
                        for (Parameter parameter : ((WrapperParameter)param).getWrapperChildren()) {
                            if (i++ > 0) {
                                parts = parts + " ";
                            }
                            parts = parts + parameter.getPartName();
                        }
                    } else if (param != null) {
                        parts = param.isWrapperStyle() ? (unwrappable ? "parameters" : UNWRAPPABLE_RESULT) : param.getPartName();
                    }
                    body.parts(parts);
                    this.generateSOAPHeaders(output, headerParams, responseMessage);
                }
                if (isRpc) {
                    body.namespace(method.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            }
            for (CheckedException exception : method.getCheckedExceptions()) {
                QName tagName = exception.getDetailType().tagName;
                Fault fault = operation.fault().name(tagName.getLocalPart());
                com.sun.xml.ws.wsdl.writer.document.soap.SOAPFault soapFault = ((com.sun.xml.ws.wsdl.writer.document.soap.SOAPFault)fault._element(com.sun.xml.ws.wsdl.writer.document.soap.SOAPFault.class)).name(tagName.getLocalPart());
                soapFault.use(LITERAL);
            }
        }
    }

    protected void generateSOAP12BindingOperation(JavaMethod method, Binding binding) {
        BindingOperationType operation = binding.operation().name(method.getOperationName());
        String targetNamespace = this.model.getTargetNamespace();
        QName requestMessage = new QName(targetNamespace, method.getOperationName());
        QName responseMessage = new QName(targetNamespace, method.getOperationName() + RESPONSE);
        if (method.getBinding() instanceof SOAPBinding) {
            ArrayList<Parameter> bodyParams = new ArrayList<Parameter>();
            ArrayList<Parameter> headerParams = new ArrayList<Parameter>();
            this.splitParameters(bodyParams, headerParams, method.getRequestParameters());
            SOAPBinding soapBinding = (SOAPBinding)method.getBinding();
            operation.soap12Operation().soapAction(soapBinding.getSOAPAction());
            StartWithExtensionsType input = operation.input();
            com.sun.xml.ws.wsdl.writer.document.soap12.BodyType body = (com.sun.xml.ws.wsdl.writer.document.soap12.BodyType)input._element(com.sun.xml.ws.wsdl.writer.document.soap12.Body.class);
            boolean isRpc = soapBinding.getStyle().equals((Object)Style.RPC);
            if (soapBinding.getUse().equals((Object)Use.LITERAL)) {
                body.use(LITERAL);
                if (headerParams.size() > 0) {
                    Parameter param = (Parameter)bodyParams.iterator().next();
                    if (isRpc) {
                        StringBuffer parts = new StringBuffer();
                        int i = 0;
                        for (Parameter parameter : ((WrapperParameter)param).getWrapperChildren()) {
                            if (i++ > 0) {
                                parts.append(' ');
                            }
                            parts.append(parameter.getPartName());
                        }
                        body.parts(parts.toString());
                    } else if (param.isWrapperStyle()) {
                        body.parts("parameters");
                    } else {
                        body.parts(param.getPartName());
                    }
                    this.generateSOAP12Headers(input, headerParams, requestMessage);
                }
                if (isRpc) {
                    body.namespace(method.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            } else {
                throw new WebServiceException("encoded use is not supported");
            }
            if (method.getMEP() != 2) {
                boolean unwrappable = headerParams.size() == 0;
                bodyParams.clear();
                headerParams.clear();
                this.splitParameters(bodyParams, headerParams, method.getResponseParameters());
                unwrappable = unwrappable ? headerParams.size() == 0 : unwrappable;
                StartWithExtensionsType output = operation.output();
                body = (com.sun.xml.ws.wsdl.writer.document.soap12.BodyType)output._element(com.sun.xml.ws.wsdl.writer.document.soap12.Body.class);
                body.use(LITERAL);
                if (headerParams.size() > 0) {
                    Parameter param = (Parameter)bodyParams.iterator().next();
                    if (isRpc) {
                        String parts = "";
                        int i = 0;
                        for (Parameter parameter : ((WrapperParameter)param).getWrapperChildren()) {
                            if (i++ > 0) {
                                parts = parts + " ";
                            }
                            parts = parts + parameter.getPartName();
                        }
                        body.parts(parts);
                    } else if (param.isWrapperStyle()) {
                        if (unwrappable) {
                            body.parts("parameters");
                        } else {
                            body.parts(UNWRAPPABLE_RESULT);
                        }
                    } else {
                        body.parts(param.getPartName());
                    }
                    this.generateSOAP12Headers(output, headerParams, responseMessage);
                }
                if (isRpc) {
                    body.namespace(method.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            }
            for (CheckedException exception : method.getCheckedExceptions()) {
                QName tagName = exception.getDetailType().tagName;
                Fault fault = operation.fault().name(tagName.getLocalPart());
                SOAPFault soapFault = ((SOAPFault)fault._element(SOAPFault.class)).name(tagName.getLocalPart());
                soapFault.use(LITERAL);
            }
        }
    }

    protected void splitParameters(List<Parameter> bodyParams, List<Parameter> headerParams, List<Parameter> params) {
        for (Parameter parameter : params) {
            if (this.isBodyParameter(parameter)) {
                bodyParams.add(parameter);
                continue;
            }
            headerParams.add(parameter);
        }
    }

    protected void generateSOAPHeaders(TypedXmlWriter writer, List<Parameter> parameters, QName message) {
        for (Parameter headerParam : parameters) {
            Header header = (Header)writer._element(Header.class);
            header.message(message);
            header.part(headerParam.getPartName());
            header.use(LITERAL);
        }
    }

    protected void generateSOAP12Headers(TypedXmlWriter writer, List<Parameter> parameters, QName message) {
        for (Parameter headerParam : parameters) {
            com.sun.xml.ws.wsdl.writer.document.soap12.Header header = (com.sun.xml.ws.wsdl.writer.document.soap12.Header)writer._element(com.sun.xml.ws.wsdl.writer.document.soap12.Header.class);
            header.message(message);
            header.part(headerParam.getPartName());
            header.use(LITERAL);
        }
    }

    protected void generateService() {
        QName portQName = this.model.getPortName();
        QName serviceQName = this.model.getServiceQName();
        Service service = this.serviceDefinitions.service().name(serviceQName.getLocalPart());
        Port port = service.port().name(portQName.getLocalPart());
        port.binding(new QName(serviceQName.getNamespaceURI(), portQName.getLocalPart() + BINDING));
        if (this.model.getJavaMethods().size() == 0) {
            return;
        }
        if (this.model.getJavaMethods().iterator().next().getBinding() instanceof SOAPBinding) {
            if (this.bindingId.equals(SOAP12_HTTP_TRANSPORT)) {
                SOAPAddress address = (SOAPAddress)port._element(SOAPAddress.class);
                address.location(REPLACE_WITH_ACTUAL_URL);
            } else {
                com.sun.xml.ws.wsdl.writer.document.soap.SOAPAddress address = (com.sun.xml.ws.wsdl.writer.document.soap.SOAPAddress)port._element(com.sun.xml.ws.wsdl.writer.document.soap.SOAPAddress.class);
                address.location(REPLACE_WITH_ACTUAL_URL);
            }
        }
    }

    protected void generateInputMessage(Operation operation, JavaMethod method) {
        block1: {
            Annotation[] as;
            Annotation[] arr$;
            int len$;
            int i$;
            RuntimeModule rtm;
            ParamType paramType = operation.input();
            paramType.message(new QName(this.model.getTargetNamespace(), method.getOperationName()));
            if (!this.model.isAddressing() || (rtm = ModuleFinder.findAddressingModule()) == null || (i$ = 0) >= (len$ = (arr$ = (as = method.getMethod().getDeclaredAnnotations())).length)) break block1;
            Annotation a = arr$[i$];
            if (rtm.supportedMethodAnnotations().contains(a.annotationType())) {
                rtm.generateInputMessage(paramType, method);
            }
        }
    }

    protected void generateOutputMessage(Operation operation, JavaMethod method) {
        block1: {
            Annotation[] as;
            Annotation[] arr$;
            int len$;
            int i$;
            RuntimeModule rtm;
            ParamType paramType = operation.output();
            paramType.message(new QName(this.model.getTargetNamespace(), method.getOperationName() + RESPONSE));
            if (!this.model.isAddressing() || (rtm = ModuleFinder.findAddressingModule()) == null || (i$ = 0) >= (len$ = (arr$ = (as = method.getMethod().getDeclaredAnnotations())).length)) break block1;
            Annotation a = arr$[i$];
            if (rtm.supportedMethodAnnotations().contains(a.annotationType())) {
                rtm.generateOutputMessage(paramType, method);
            }
        }
    }

    public Result createOutputFile(String namespaceUri, String suggestedFileName) throws IOException {
        if (namespaceUri.equals("")) {
            return null;
        }
        com.sun.xml.ws.wsdl.writer.document.xsd.Import _import = this.types.schema()._import().namespace(namespaceUri);
        Holder<String> fileNameHolder = new Holder<String>();
        fileNameHolder.value = this.schemaPrefix + suggestedFileName;
        Result result = this.wsdlResolver.getSchemaOutput(namespaceUri, fileNameHolder);
        String schemaLoc = result == null ? (String)fileNameHolder.value : WSDLGenerator.relativize(result.getSystemId(), this.wsdlLocation);
        _import.schemaLocation(schemaLoc);
        return result;
    }

    protected static String relativize(String uri, String baseUri) {
        try {
            assert (uri != null);
            if (baseUri == null) {
                return uri;
            }
            URI theUri = new URI(Util.escapeURI((String)uri));
            URI theBaseUri = new URI(Util.escapeURI((String)baseUri));
            if (theUri.isOpaque() || theBaseUri.isOpaque()) {
                return uri;
            }
            if (!Util.equalsIgnoreCase((String)theUri.getScheme(), (String)theBaseUri.getScheme()) || !Util.equal((String)theUri.getAuthority(), (String)theBaseUri.getAuthority())) {
                return uri;
            }
            String uriPath = theUri.getPath();
            String basePath = theBaseUri.getPath();
            if (!basePath.endsWith("/")) {
                basePath = Util.normalizeUriPath((String)basePath);
            }
            if (uriPath.equals(basePath)) {
                return ".";
            }
            String relPath = WSDLGenerator.calculateRelativePath(uriPath, basePath);
            if (relPath == null) {
                return uri;
            }
            StringBuffer relUri = new StringBuffer();
            relUri.append(relPath);
            if (theUri.getQuery() != null) {
                relUri.append('?').append(theUri.getQuery());
            }
            if (theUri.getFragment() != null) {
                relUri.append('#').append(theUri.getFragment());
            }
            return relUri.toString();
        }
        catch (URISyntaxException e) {
            throw new InternalError("Error escaping one of these uris:\n\t" + uri + "\n\t" + baseUri);
        }
    }

    private static String calculateRelativePath(String uri, String base) {
        if (base == null) {
            return null;
        }
        if (uri.startsWith(base)) {
            return uri.substring(base.length());
        }
        return "../" + WSDLGenerator.calculateRelativePath(uri, Util.getParentUriPath((String)base));
    }

    protected class JAXWSOutputSchemaResolver
    extends SchemaOutputResolver {
        protected JAXWSOutputSchemaResolver() {
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            return WSDLGenerator.this.createOutputFile(namespaceUri, suggestedFileName);
        }
    }
}

