/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPMessage;

public class FilterProcessingContext
extends ProcessingContextImpl {
    public static final int ADHOC = 0;
    public static final int POSTHOC = 1;
    public static final int DEFAULT = 2;
    private byte[] digestValue = null;
    private byte[] canonicalizedData = null;
    private int mode = 2;
    private boolean primaryPolicyViolation = false;
    private boolean optionalPolicyViolation = false;
    private Throwable _PolicyViolation = null;
    private boolean enableDynamicPolicyCallback = false;
    private HashMap tokenCache = new HashMap();
    private boolean timestampExported = false;
    private HashMap elementCache = new HashMap();
    private AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding;
    private WSSPolicy inferredPolicy = null;
    private SymmetricKeyBinding symmetricKeyBinding;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public FilterProcessingContext() {
    }

    public FilterProcessingContext(ProcessingContext context) throws XWSSecurityException {
        this.copy(this, context);
    }

    public FilterProcessingContext(int filterMode, String messageIdentifier, SecurityPolicy securityPolicy, SOAPMessage message) throws XWSSecurityException {
        this.mode = filterMode;
        this.setSecurityPolicy(securityPolicy);
        this.setMessageIdentifier(messageIdentifier);
        this.setSOAPMessage(message);
    }

    public void setSecurityPolicy(SecurityPolicy policy) throws XWSSecurityException {
        this.primaryPolicyViolation = false;
        this.optionalPolicyViolation = false;
        this._PolicyViolation = null;
        if (!(policy instanceof WSSPolicy || PolicyTypeUtil.messagePolicy(policy) || PolicyTypeUtil.applicationSecurityConfiguration(policy) || PolicyTypeUtil.dynamicSecurityPolicy(policy))) {
            log.log(Level.SEVERE, "WSS0801.illegal.securitypolicy");
            throw new XWSSecurityException("Illegal SecurityPolicy Type: required one of  WSSPolicy/MessagePolicy/ApplicationSecurityConfiguration");
        }
        super.setSecurityPolicy(policy);
    }

    public void setPVE(Throwable exception) {
        this._PolicyViolation = exception;
    }

    public Throwable getPVE() {
        return this._PolicyViolation;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void enableDynamicPolicyCallback(boolean enable) {
        this.enableDynamicPolicyCallback = enable;
    }

    public boolean makeDynamicPolicyCallback() {
        return this.enableDynamicPolicyCallback;
    }

    public void isPrimaryPolicyViolation(boolean assrt) {
        this.primaryPolicyViolation = assrt;
    }

    public boolean isPrimaryPolicyViolation() {
        return this.primaryPolicyViolation;
    }

    public void isOptionalPolicyViolation(boolean assrt) {
        this.optionalPolicyViolation = assrt;
    }

    public boolean isOptionalPolicyViolation() {
        return this.optionalPolicyViolation;
    }

    public HashMap getTokenCache() {
        return this.tokenCache;
    }

    public void timestampExported(boolean flag) {
        this.timestampExported = flag;
    }

    public boolean timestampExported() {
        return this.timestampExported;
    }

    public HashMap getElementCache() {
        return this.elementCache;
    }

    public void setX509CertificateBinding(AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding) {
        this.x509CertificateBinding = x509CertificateBinding;
    }

    public AuthenticationTokenPolicy.X509CertificateBinding getX509CertificateBinding() {
        return this.x509CertificateBinding;
    }

    public void setSymmetricKeyBinding(SymmetricKeyBinding symmetricKeyBinding) {
        this.symmetricKeyBinding = symmetricKeyBinding;
    }

    public SymmetricKeyBinding getSymmetricKeyBinding() {
        return this.symmetricKeyBinding;
    }

    public SecurableSoapMessage getSecurableSoapMessage() {
        return this.secureMessage;
    }

    public void reset() {
        this.elementCache.clear();
        this.tokenCache.clear();
    }

    public WSSPolicy getInferredPolicy() {
        return this.inferredPolicy;
    }

    public void setInferredPolicy(WSSPolicy policy) {
        this.inferredPolicy = policy;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public byte[] getCanonicalizedData() {
        return this.canonicalizedData;
    }

    public void setCanonicalizedData(byte[] canonicalizedData) {
        this.canonicalizedData = canonicalizedData;
    }
}

