/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.apachecrypto;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedData;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.xml.jaxws.JAXWSMessage;
import com.sun.xml.messaging.saaj.soap.ExpressMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedDataHeaderBlock;
import com.sun.xml.wss.core.EncryptedDataImpl;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.ReferenceListHeaderBlock;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import com.sun.xml.wss.impl.keyinfo.KeyNameStrategy;
import com.sun.xml.wss.impl.misc.KeyResolver;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.resolver.AttachmentSignatureInput;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml11.jaxb10.Assertion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionProcessor {
    private static byte[] crlf;
    protected static Logger log;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encrypt(FilterProcessingContext context) throws XWSSecurityException {
        Iterator _apartsI;
        SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
        SecurityHeader _secHeader = secureMsg.findOrCreateSecurityHeader();
        boolean _exportCertificate = false;
        SecretKey _symmetricKey = null;
        SecretKey keyEncSK = null;
        X509Certificate _x509Cert = null;
        KeyInfoStrategy keyInfoStrategy = null;
        String referenceType = null;
        String x509TokenId = null;
        String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        String symmetricKeyName = null;
        AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = null;
        WSSPolicy wssPolicy = (WSSPolicy)context.getSecurityPolicy();
        EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)wssPolicy.getFeatureBinding();
        WSSPolicy keyBinding = (WSSPolicy)wssPolicy.getKeyBinding();
        SecurityTokenReference samlTokenRef = null;
        SOAPElement x509TokenElement = null;
        String tmp = featureBinding.getDataEncryptionAlgorithm();
        if (tmp != null && !"".equals(tmp)) {
            dataEncAlgo = tmp;
        }
        if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
            if (context.getX509CertificateBinding() != null) {
                certificateBinding = context.getX509CertificateBinding();
                context.setX509CertificateBinding(null);
            } else {
                certificateBinding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
            }
            _x509Cert = certificateBinding.getX509Certificate();
            referenceType = certificateBinding.getReferenceType();
            keyInfoStrategy = KeyInfoStrategy.getInstance(referenceType);
            _exportCertificate = true;
            keyInfoStrategy.setCertificate(_x509Cert);
            x509TokenId = certificateBinding.getUUID();
            if (x509TokenId == null || x509TokenId.equals("")) {
                x509TokenId = secureMsg.generateId();
            }
            if ("Direct".equals(referenceType)) {
                HashMap tokenCache = context.getTokenCache();
                X509SecurityToken token = (X509SecurityToken)tokenCache.get(x509TokenId);
                if (token == null) {
                    token = new X509SecurityToken((Document)secureMsg.getSOAPPart(), _x509Cert, x509TokenId);
                }
                secureMsg.findOrCreateSecurityHeader().insertHeaderBlock(token);
                x509TokenElement = secureMsg.findOrCreateSecurityHeader().getFirstChildElement();
            }
            tmp = null;
            tmp = certificateBinding.getKeyAlgorithm();
            if (tmp != null && !tmp.equals("")) {
                keyEncAlgo = tmp;
            }
            _symmetricKey = EncryptionProcessor.generateSymmetricKey(dataEncAlgo);
        } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
            SymmetricKeyBinding skb = null;
            if (context.getSymmetricKeyBinding() != null) {
                skb = context.getSymmetricKeyBinding();
                context.setSymmetricKeyBinding(null);
            } else {
                skb = (SymmetricKeyBinding)keyBinding;
            }
            keyEncAlgo = skb.getKeyAlgorithm();
            if (keyEncAlgo != null && !"".equals(keyEncAlgo)) {
                _symmetricKey = EncryptionProcessor.generateSymmetricKey(dataEncAlgo);
            }
            keyInfoStrategy = KeyInfoStrategy.getInstance("KeyName");
            keyEncSK = skb.getSecretKey();
            symmetricKeyName = skb.getKeyIdentifier();
            String secKeyAlgo = keyEncSK.getAlgorithm();
            if (_symmetricKey == null) {
                ((KeyNameStrategy)keyInfoStrategy).setKeyName(symmetricKeyName);
                _symmetricKey = keyEncSK;
                keyEncSK = null;
            }
        } else {
            HashMap tokenCache;
            Assertion assertion2;
            com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion assertion1;
            AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding;
            block73: {
                if (!PolicyTypeUtil.samlTokenPolicy(keyBinding)) throw new XWSSecurityException("Unsupported Key Binding for EncryptionPolicy");
                samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                assertion1 = null;
                assertion2 = null;
                try {
                    if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb").equals("false") || System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null) {
                        assertion1 = com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion.fromElement(samlBinding.getAssertion());
                        break block73;
                    }
                    if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb").equals("true")) {
                        assertion2 = Assertion.fromElement(samlBinding.getAssertion());
                    }
                }
                catch (SAMLException ex) {
                    // empty catch block
                }
            }
            if (assertion1 != null) {
                tokenCache = context.getTokenCache();
                tokenCache.put(assertion1.getAssertionID(), assertion1);
            } else {
                if (assertion2 == null) throw new XWSSecurityException("SAML Assertion is NULL");
                tokenCache = context.getTokenCache();
                tokenCache.put(assertion1.getAssertionID(), assertion2);
            }
            Key key = null;
            if (assertion1 != null) {
                key = KeyResolver.resolveSamlAssertion(context.getSecurableSoapMessage(), assertion1, true, context);
            } else if (assertion2 != null) {
                key = KeyResolver.resolveSamlAssertion(context.getSecurableSoapMessage(), assertion2, true, context);
            }
            _x509Cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), (PublicKey)key, false);
            if (_x509Cert == null) {
                throw new XWSSecurityException("Could not locate Certificate corresponding to Key in SubjectConfirmation of SAML Assertion");
            }
            if (!"".equals(samlBinding.getKeyAlgorithm())) {
                keyEncAlgo = samlBinding.getKeyAlgorithm();
            }
            _symmetricKey = EncryptionProcessor.generateSymmetricKey(dataEncAlgo);
            referenceType = samlBinding.getReferenceType();
            if (referenceType.equals("Embedded")) {
                throw new XWSSecurityException("Embedded Reference Type for SAML Assertions not supported yet");
            }
            String assertionId = null;
            if (assertion1 != null) {
                assertionId = assertion1.getAssertionID();
            } else if (assertion2 != null) {
                assertionId = assertion2.getAssertionID();
            }
            Element binding = samlBinding.getAuthorityBinding();
            samlTokenRef = new SecurityTokenReference((Document)secureMsg.getSOAPPart());
            String strId = samlBinding.getSTRID();
            if (strId == null) {
                strId = secureMsg.generateId();
            }
            samlTokenRef.setWsuId(strId);
            if (binding != null) {
                samlTokenRef.setSamlAuthorityBinding(binding, (Document)secureMsg.getSOAPPart());
            }
            keyInfoStrategy = new KeyIdentifierStrategy(assertionId);
            keyInfoStrategy.insertKey(samlTokenRef, secureMsg);
        }
        XMLCipher _keyEncryptor = null;
        XMLCipher _dataEncryptor = null;
        Cipher _attachmentEncryptor = null;
        Cipher _dataCipher = null;
        try {
            if (_x509Cert != null) {
                _keyEncryptor = XMLCipher.getInstance((String)keyEncAlgo);
                _keyEncryptor.init(3, (Key)_x509Cert.getPublicKey());
            } else if (keyEncSK != null) {
                _keyEncryptor = XMLCipher.getInstance((String)keyEncAlgo);
                _keyEncryptor.init(3, (Key)keyEncSK);
            }
            String dataAlgorithm = JCEMapper.translateURItoJCEID(dataEncAlgo);
            _dataCipher = Cipher.getInstance(dataAlgorithm);
            _dataEncryptor = XMLCipher.getInstance((String)dataEncAlgo, (Cipher)_dataCipher);
            _dataCipher.init(1, _symmetricKey);
            _dataEncryptor.init(1, (Key)_symmetricKey);
        }
        catch (Exception xee) {
            log.log(Level.SEVERE, "WSS1205.unableto.initialize.xml.cipher", xee);
            throw new XWSSecurityException("Unable to initialize XML Cipher", xee);
        }
        ArrayList targets = featureBinding.getTargetBindings();
        ArrayList<Object[]> _aparts = new ArrayList<Object[]>();
        ArrayList<Object[]> _dnodes = new ArrayList<Object[]>();
        Iterator i = targets.iterator();
        while (i.hasNext()) {
            EncryptionTarget target = (EncryptionTarget)i.next();
            boolean contentOnly = target.getContentOnly();
            Boolean cOnly = new Boolean(contentOnly);
            if (target.getValue() == "cid:*") {
                Iterator itr = secureMsg.getAttachments();
                while (itr.hasNext()) {
                    AttachmentPart ap = (AttachmentPart)itr.next();
                    Object[] s = new Object[]{ap, cOnly};
                    _aparts.add(s);
                }
                continue;
            }
            Object mgpart = secureMsg.getMessageParts(target);
            ArrayList transforms = target.getCipherReferenceTransforms();
            if (mgpart instanceof AttachmentPart) {
                Object[] s = new Object[]{mgpart, cOnly};
                _aparts.add(s);
                continue;
            }
            if (mgpart instanceof Node) {
                Object[] s = new Object[]{mgpart, cOnly};
                _dnodes.add(s);
                continue;
            }
            if (!(mgpart instanceof NodeList)) continue;
            for (int j = 0; j < ((NodeList)mgpart).getLength(); ++j) {
                Object[] s = new Object[2];
                Node n = ((NodeList)mgpart).item(j);
                s[0] = n;
                s[1] = cOnly;
                _dnodes.add(s);
            }
        }
        EncryptedKey _encryptedKey = null;
        ReferenceListHeaderBlock _ekReferenceList = null;
        ReferenceListHeaderBlock _standaloneReferenceList = null;
        if (_keyEncryptor != null) {
            try {
                _encryptedKey = _keyEncryptor.encryptKey((Document)secureMsg.getSOAPPart(), (Key)_symmetricKey);
                KeyInfoHeaderBlock keyInfoBlock = new KeyInfoHeaderBlock((Document)secureMsg.getSOAPPart());
                if (samlTokenRef != null) {
                    keyInfoBlock.addSecurityTokenReference(samlTokenRef);
                } else if (_x509Cert != null) {
                    keyInfoStrategy.insertKey(keyInfoBlock, secureMsg, x509TokenId);
                } else if (keyEncSK != null) {
                    keyInfoBlock.addKeyName(symmetricKeyName);
                }
                KeyInfo keyInfo = keyInfoBlock.getKeyInfo();
                _encryptedKey.setKeyInfo(keyInfo);
            }
            catch (Exception xe) {
                throw new XWSSecurityException(xe);
            }
        }
        if (_encryptedKey != null) {
            _ekReferenceList = new ReferenceListHeaderBlock((Document)secureMsg.getSOAPPart());
        }
        SOAPElement x509Sibling = null;
        if (x509TokenElement != null) {
            x509Sibling = (SOAPElement)x509TokenElement.getNextSibling();
        }
        if ((_apartsI = _aparts.iterator()).hasNext()) {
            try {
                String dataAlgorithm = JCEMapper.translateURItoJCEID(dataEncAlgo);
                _attachmentEncryptor = Cipher.getInstance(dataAlgorithm);
                _attachmentEncryptor.init(1, _symmetricKey);
            }
            catch (Exception xee) {
                log.log(Level.SEVERE, "WSS1205.unableto.initialize.xml.cipher");
                throw new XWSSecurityException("Unable to initialize XML Cipher", xee);
            }
        }
        while (_apartsI.hasNext()) {
            Object[] s = (Object[])_apartsI.next();
            AttachmentPart p = (AttachmentPart)s[0];
            boolean b = (Boolean)s[1];
            EncryptedDataHeaderBlock edhb = new EncryptedDataHeaderBlock();
            String id = secureMsg.generateId();
            edhb.setId(id);
            edhb.setType(b ? "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only" : "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete");
            edhb.setMimeType(p.getContentType());
            String uri = p.getContentId();
            uri = uri != null ? "cid:" + uri.substring(1, uri.length() - 1) : p.getContentLocation();
            edhb.getCipherReference(true, uri);
            edhb.setEncryptionMethod(dataEncAlgo);
            edhb.addTransform("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform");
            EncryptionProcessor.encryptAttachment(p, b, _attachmentEncryptor);
            if (_ekReferenceList != null) {
                _ekReferenceList.addReference("#" + id);
            }
            if (x509Sibling == null && x509TokenElement == null) {
                _secHeader.insertHeaderBlock(edhb);
                continue;
            }
            if (x509Sibling != null) {
                _secHeader.insertBefore(edhb, (Node)x509Sibling);
                continue;
            }
            _secHeader.appendChild(edhb);
        }
        int optType = -1;
        Iterator _dnodeI = _dnodes.iterator();
        while (_dnodeI.hasNext()) {
            Element ed;
            block74: {
                Object[] s = (Object[])_dnodeI.next();
                Node n = (Node)s[0];
                boolean b = (Boolean)s[1];
                ed = null;
                boolean _fi = false;
                if (context.getConfigType() == MessageConstants.SIGN_ENCRYPT_BODY) {
                    if (_fi) {
                        ed = EncryptionProcessor.encryptBodyContent(secureMsg, context.getCanonicalizedData(), _dataEncryptor);
                        break block74;
                    } else {
                        EncryptionProcessor.signEncrypt(context, _dataCipher, _ekReferenceList, _standaloneReferenceList, keyInfoStrategy, dataEncAlgo);
                        continue;
                    }
                }
                ed = EncryptionProcessor.encryptElement(secureMsg, (SOAPElement)n, b, _dataEncryptor);
            }
            EncryptedDataHeaderBlock xencEncryptedData = new EncryptedDataHeaderBlock(XMLUtil.convertToSoapElement((Document)secureMsg.getSOAPPart(), ed));
            String xencEncryptedDataId = secureMsg.generateId();
            String xencEncryptedDataRef = "#" + xencEncryptedDataId;
            xencEncryptedData.setId(xencEncryptedDataId);
            if (_ekReferenceList != null) {
                _ekReferenceList.addReference(xencEncryptedDataRef);
            } else {
                if (_standaloneReferenceList == null) {
                    _standaloneReferenceList = new ReferenceListHeaderBlock((Document)secureMsg.getSOAPPart());
                }
                _standaloneReferenceList.addReference(xencEncryptedDataRef);
                KeyInfoHeaderBlock keyInfoBlock = new KeyInfoHeaderBlock((Document)secureMsg.getSOAPPart());
                keyInfoStrategy.insertKey(keyInfoBlock, secureMsg, null);
                xencEncryptedData.setKeyInfo(keyInfoBlock);
            }
            ed.getParentNode().replaceChild((Node)xencEncryptedData.getAsSoapElement(), ed);
        }
        try {
            x509Sibling = null;
            if (x509TokenElement != null) {
                x509Sibling = (SOAPElement)x509TokenElement.getNextSibling();
            }
            if (_encryptedKey == null) {
                if (_standaloneReferenceList == null) return;
                _secHeader.insertHeaderBlock(_standaloneReferenceList);
                return;
            }
            SOAPElement se = (SOAPElement)_keyEncryptor.martial(_encryptedKey);
            se = _secHeader.makeUsable(se);
            se.appendChild((Node)_ekReferenceList.getAsSoapElement());
            if (x509Sibling != null) {
                _secHeader.insertBefore((Node)se, (Node)x509Sibling);
                return;
            }
            if (x509TokenElement == null) {
                _secHeader.insertHeaderBlockElement(se);
                return;
            }
            _secHeader.appendChild((Node)se);
            return;
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    private static Element encryptElement(SecurableSoapMessage secureMsg, SOAPElement encryptElm, boolean contentOnly, XMLCipher xmlCipher) throws XWSSecurityException {
        Object contextNode;
        String localName = encryptElm.getLocalName();
        if (!contentOnly && ("http://schemas.xmlsoap.org/soap/envelope/".equalsIgnoreCase(encryptElm.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equalsIgnoreCase(encryptElm.getNamespaceURI())) && ("Header".equalsIgnoreCase(localName) || "Envelope".equalsIgnoreCase(localName) || "Body".equalsIgnoreCase(localName))) {
            log.log(Level.SEVERE, "WSS1206.illegal.target", encryptElm.getElementName().getQualifiedName());
            throw new XWSSecurityException("Encryption of SOAP " + localName + " is not allowed");
        }
        SOAPPart soapPart = secureMsg.getSOAPPart();
        Node refNode = null;
        if (contentOnly) {
            contextNode = encryptElm;
        } else {
            contextNode = encryptElm.getParentNode();
            refNode = encryptElm.getNextSibling();
        }
        try {
            xmlCipher.doFinal((Document)soapPart, (Element)encryptElm, contentOnly);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1207.unableto.encrypt.message");
            throw new XWSSecurityException("Unable to encrypt element", e);
        }
        Element xencEncryptedData = contentOnly ? (Element)contextNode.getFirstChild() : (refNode == null ? (Element)contextNode.getLastChild() : (Element)refNode.getPreviousSibling());
        return xencEncryptedData;
    }

    private static Element encryptBodyContent(SecurableSoapMessage contextNode, byte[] canonData, XMLCipher xmlCipher) throws XWSSecurityException {
        try {
            EncryptedData ed = xmlCipher.encryptData((Document)contextNode.getSOAPPart(), canonData, true);
            Element encryptedBodyContent = xmlCipher.martial(ed);
            SOAPBody body = ((ExpressMessage)contextNode.getSOAPMessage()).getEMBody();
            body.appendChild((Node)encryptedBodyContent);
            return encryptedBodyContent;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1207.unableto.encrypt.message");
            throw new XWSSecurityException("Unable to encrypt element", e);
        }
    }

    private static void signEncrypt(FilterProcessingContext fpc, Cipher cipher, ReferenceListHeaderBlock _ekReferenceList, ReferenceListHeaderBlock _standaloneReferenceList, KeyInfoStrategy keyInfoStrategy, String encAlgo) throws XWSSecurityException {
        try {
            byte[] canonData = fpc.getCanonicalizedData();
            byte[] cipherOutput = cipher.doFinal(canonData);
            byte[] iv = cipher.getIV();
            EncryptedDataImpl ed = new EncryptedDataImpl();
            ed.setEncryptedData(cipherOutput);
            ed.setIv(iv);
            ed.setEncAlgo(encAlgo);
            String xencEncryptedDataId = fpc.getSecurableSoapMessage().generateId();
            String xencEncryptedDataRef = "#" + xencEncryptedDataId;
            ed.setId(xencEncryptedDataId);
            if (_ekReferenceList != null) {
                _ekReferenceList.addReference(xencEncryptedDataRef);
            } else {
                if (_standaloneReferenceList == null) {
                    _standaloneReferenceList = new ReferenceListHeaderBlock((Document)fpc.getSecurableSoapMessage().getSOAPPart());
                }
                _standaloneReferenceList.addReference(xencEncryptedDataRef);
                KeyInfoHeaderBlock keyInfoBlock = new KeyInfoHeaderBlock((Document)fpc.getSecurableSoapMessage().getSOAPPart());
                keyInfoStrategy.insertKey(keyInfoBlock, fpc.getSecurableSoapMessage(), null);
                ed.setKeyInfo(keyInfoBlock);
            }
            SOAPMessage msg = fpc.getSOAPMessage();
            JAXWSMessage jxm = ((ExpressMessage)msg).getJAXWSMessage();
            ed.setXMLSerializer(jxm.getXmlSerializer());
            jxm.setEncryptedBody((ByteArrayOutputStream)ed);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1207.unableto.encrypt.message");
            throw new XWSSecurityException("Unable to encrypt element", e);
        }
    }

    private static void encryptAttachment(AttachmentPart part, boolean contentOnly, Cipher cipher) throws XWSSecurityException {
        try {
            byte[] cipherInput = null;
            if (contentOnly) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                part.getDataHandler().writeTo((OutputStream)baos);
                cipherInput = baos.toByteArray();
            } else {
                Object[] obj = AttachmentSignatureInput._getSignatureInput(part);
                byte[] headers = EncryptionProcessor.serializeHeaders((Vector)obj[0]);
                byte[] content = (byte[])obj[1];
                cipherInput = new byte[headers.length + content.length];
                System.arraycopy(headers, 0, cipherInput, 0, headers.length);
                System.arraycopy(content, 0, cipherInput, headers.length, content.length);
            }
            byte[] cipherOutput = cipher.doFinal(cipherInput);
            byte[] iv = cipher.getIV();
            byte[] encryptedBytes = new byte[iv.length + cipherOutput.length];
            System.arraycopy(iv, 0, encryptedBytes, 0, iv.length);
            System.arraycopy(cipherOutput, 0, encryptedBytes, iv.length, cipherOutput.length);
            int cLength = encryptedBytes.length;
            String cType = "application/octet-stream";
            String uri = part.getContentId();
            if (!contentOnly) {
                part.removeAllMimeHeaders();
            }
            if (uri != null) {
                part.setMimeHeader("Content-ID", uri);
            } else {
                uri = part.getContentLocation();
                if (uri != null) {
                    part.setMimeHeader("Content-Location", uri);
                }
            }
            part.setContentType(cType);
            part.setMimeHeader("Content-Length", new Integer(cLength).toString());
            part.setMimeHeader("Content-Transfer-Encoding", "base64");
            EncryptedAttachmentDataHandler dh = new EncryptedAttachmentDataHandler(new EncryptedAttachmentDataSource(encryptedBytes));
            part.setDataHandler((DataHandler)dh);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    private static byte[] serializeHeaders(Vector mimeHeaders) throws XWSSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < mimeHeaders.size(); ++i) {
                MimeHeader mh = (MimeHeader)mimeHeaders.elementAt(i);
                String name = mh.getName();
                String vlue = mh.getValue();
                String line = name + ":" + vlue + "\r\n";
                byte[] b = line.getBytes("US-ASCII");
                baos.write(b, 0, b.length);
            }
            baos.write(crlf, 0, crlf.length);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return baos.toByteArray();
    }

    private static SecretKey generateSymmetricKey(String algorithm) throws XWSSecurityException {
        try {
            String jceAlgo = JCEMapper.getJCEKeyAlgorithmFromURI(algorithm);
            KeyGenerator keyGen = KeyGenerator.getInstance(jceAlgo);
            int length = 0;
            length = jceAlgo.startsWith("DES") ? 168 : JCEMapper.getKeyLengthFromURI(algorithm);
            keyGen.init(length);
            return keyGen.generateKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1208.failedto.generate.random.symmetrickey", new Object[]{e.getMessage()});
            throw new XWSSecurityException("Unable to Generate Symmetric Key", e);
        }
    }

    static {
        block2: {
            crlf = null;
            log = Logger.getLogger("com.sun.xml.wss.logging.impl.crypto", "com.sun.xml.wss.logging.impl.crypto.LogStrings");
            try {
                crlf = "\r\n".getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException ue) {
                if (log == null) break block2;
                log.log(Level.SEVERE, "WSS1204.crlf.init.failed", ue);
            }
        }
    }

    private static class EncryptedAttachmentDataHandler
    extends DataHandler {
        EncryptedAttachmentDataHandler(DataSource ds) {
            super(ds);
        }

        public void writeTo(OutputStream os) throws IOException {
            ((ByteArrayOutputStream)this.getDataSource().getOutputStream()).writeTo(os);
        }
    }

    private static class EncryptedAttachmentDataSource
    implements DataSource {
        byte[] datasource;

        EncryptedAttachmentDataSource(byte[] ds) {
            this.datasource = ds;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.datasource);
        }

        public String getName() {
            return "Encrypted Attachment DataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.datasource, 0, this.datasource.length);
            return baos;
        }
    }
}

