/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.config;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.ConfigurationConstants;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DynamicSecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.Parameter;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SecurityConfigurationXmlReader
implements ConfigurationConstants {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    static Random rnd = new Random();

    private static Document parseXmlString(String sourceXml) throws Exception {
        return SecurityConfigurationXmlReader.parseXmlStream(new ByteArrayInputStream(sourceXml.getBytes()));
    }

    private static void validateConfiguration(Element element) throws Exception {
        NodeList timestamps = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Timestamp");
        if (timestamps.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:Timestamp element in security configuration file");
        }
        NodeList requireTimestamps = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "RequireTimestamp");
        if (requireTimestamps.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:RequireTimestamp element in security configuration file");
        }
        NodeList usernamePasswords = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "UsernameToken");
        if (usernamePasswords.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:UsernameToken element in security configuration file");
        }
        NodeList requireUsernamePasswords = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "RequireUsernameToken");
        if (requireUsernamePasswords.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:RequireUsernameToken element in security configuration file");
        }
        NodeList optionalTargets = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "OptionalTargets");
        if (optionalTargets.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:OptionalTargets element in security configuration file");
        }
        NodeList samlAssertions = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "SAMLAssertion");
        if (samlAssertions.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:SAMLAssertion element in security configuration file");
        }
        SecurityConfigurationXmlReader.checkIdUniqueness(element);
    }

    public static ApplicationSecurityConfiguration readApplicationSecurityConfigurationString(String sourceXml) throws Exception {
        return (ApplicationSecurityConfiguration)SecurityConfigurationXmlReader.createSecurityConfiguration(SecurityConfigurationXmlReader.parseXmlString(sourceXml).getDocumentElement());
    }

    private static Document parseXmlStream(InputStream xmlStream) throws Exception {
        return SecurityConfigurationXmlReader.parseXmlStream(xmlStream, null);
    }

    private static Document parseXmlStream(InputStream xmlStream, PrintStream out) throws Exception {
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        ((DocumentBuilderFactory)factory).setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.FALSE);
        ((DocumentBuilderFactory)factory).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        InputStream is = SecurityConfigurationXmlReader.class.getResourceAsStream("xwssconfig.xsd");
        ((DocumentBuilderFactory)factory).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
        factory.setValidating(true);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(out));
        Document configurationDocument = builder.parse(xmlStream);
        NodeList nodeList = configurationDocument.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "SecurityConfiguration");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SecurityConfigurationXmlReader.validateConfiguration((Element)nodeList.item(i));
        }
        return configurationDocument;
    }

    public static void validate(InputStream xmlStream, PrintStream out) throws Exception {
        SecurityConfigurationXmlReader.parseXmlStream(xmlStream, out);
    }

    public static DeclarativeSecurityConfiguration createDeclarativeConfiguration(InputStream xmlStream) throws Exception {
        return SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(SecurityConfigurationXmlReader.parseXmlStream(xmlStream).getDocumentElement(), new DeclarativeSecurityConfiguration());
    }

    public static ApplicationSecurityConfiguration createApplicationSecurityConfiguration(InputStream xmlStream) throws Exception {
        ApplicationSecurityConfiguration config = (ApplicationSecurityConfiguration)SecurityConfigurationXmlReader.createSecurityConfiguration(SecurityConfigurationXmlReader.parseXmlStream(xmlStream).getDocumentElement());
        config.init();
        return config;
    }

    private static DeclarativeSecurityConfiguration createDeclarativeConfiguration(Element configData) throws Exception {
        DeclarativeSecurityConfiguration declarations = new DeclarativeSecurityConfiguration();
        SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(configData, declarations);
        return declarations;
    }

    private static SecurityPolicy createSecurityConfiguration(Element configData) throws Exception {
        QName qname = SecurityConfigurationXmlReader.getQName(configData);
        if (JAXRPC_SECURITY_ELEMENT_QNAME.equals(qname)) {
            QName definitionType;
            ApplicationSecurityConfiguration declarations = new ApplicationSecurityConfiguration();
            String secEnvHandler = SecurityConfigurationXmlReader.getSecurityEnvironmentHandler(configData);
            if (secEnvHandler != null) {
                declarations.setSecurityEnvironmentHandler(secEnvHandler);
            }
            if (!SecurityConfigurationXmlReader.configHasSingleService(configData)) {
                throw new IllegalStateException("Single <xwss:Service> element expected under <xwss:JAXRPCSecurity> element");
            }
            String optimize = configData.getAttribute("optimize");
            boolean opt = new Boolean(optimize);
            declarations.isOptimized(opt);
            Element previousDefinitionElement = null;
            Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(configData);
            int secEnvTagCount = 0;
            HashMap serviceNameMap = new HashMap();
            while (eachDefinitionElement != null) {
                definitionType = SecurityConfigurationXmlReader.getQName(eachDefinitionElement);
                if (SERVICE_ELEMENT_QNAME.equals(definitionType)) {
                    StaticApplicationContext jaxrpcSContext = new StaticApplicationContext();
                    String name = eachDefinitionElement.getAttribute("name");
                    if (serviceNameMap.containsKey(name)) {
                        throw new IllegalStateException("Service Name " + name + " Already in use for another Service");
                    }
                    serviceNameMap.put(name, null);
                    SecurityConfigurationXmlReader.readApplicationSecurityConfiguration(eachDefinitionElement, declarations, null, jaxrpcSContext);
                } else if (SECURITY_ENVIRONMENT_HANDLER_ELEMENT_QNAME.equals(definitionType)) {
                    if (secEnvTagCount == 1) {
                        throw new IllegalStateException("More than one xwss:SecurityEnvironmentHandler element in security configuration file");
                    }
                    ++secEnvTagCount;
                } else {
                    log.log(Level.SEVERE, "WSS0413.illegal.configuration.element", eachDefinitionElement.getTagName());
                    throw new IllegalStateException(eachDefinitionElement.getTagName() + " is not a recognized definition type");
                }
                previousDefinitionElement = eachDefinitionElement;
                eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
            }
            definitionType = SecurityConfigurationXmlReader.getQName(previousDefinitionElement);
            if (!SECURITY_ENVIRONMENT_HANDLER_ELEMENT_QNAME.equals(definitionType)) {
                throw new IllegalStateException("The SecurityEnvironmentHandler must appear as the last Element inside a <xwss:JAXRPCSecurity>");
            }
            declarations.singleServiceNoPorts(SecurityConfigurationXmlReader.configHasSingleServiceAndNoPorts(configData));
            declarations.hasOperationPolicies(SecurityConfigurationXmlReader.configHasOperations(configData));
            return declarations;
        }
        if (DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(qname)) {
            if (SecurityConfigurationXmlReader.dynamicPolicy(configData)) {
                DynamicSecurityPolicy declarations = new DynamicSecurityPolicy();
                return declarations;
            }
            DeclarativeSecurityConfiguration declarations = new DeclarativeSecurityConfiguration();
            SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(configData, declarations);
            return declarations;
        }
        log.log(Level.SEVERE, "WSS0413.illegal.configuration.element", configData.getTagName());
        throw new IllegalStateException(configData.getTagName() + " is not a recognized definition type");
    }

    private static void readApplicationSecurityConfiguration(Element configData, SecurityPolicy declarations, SecurityPolicy subDeclarations, StaticApplicationContext iContext) throws Exception {
        QName qname = SecurityConfigurationXmlReader.getQName(configData);
        if (SERVICE_ELEMENT_QNAME.equals(qname)) {
            String id = SecurityConfigurationXmlReader.getIdAttribute(configData);
            String name = configData.getAttribute("name");
            String useCache = configData.getAttribute("useCache");
            boolean isBSP = SecurityConfigurationXmlReader.getBSPAttribute(configData, null);
            iContext.isService(true);
            iContext.setUUID(id);
            iContext.setServiceIdentifier(name);
            if (!"".equals(name)) {
                iContext.setApplicationContextRoot(name);
            } else if (!"".equals(id)) {
                iContext.setApplicationContextRoot(id);
            } else {
                iContext.setApplicationContextRoot(SecurityConfigurationXmlReader.generateUUID());
            }
            ApplicationSecurityConfiguration innerDeclarations = new ApplicationSecurityConfiguration();
            innerDeclarations.isBSP(isBSP);
            innerDeclarations.useCache(SecurityConfigurationXmlReader.parseBoolean("useCache", useCache));
            ((ApplicationSecurityConfiguration)declarations).setSecurityPolicy(iContext, innerDeclarations);
            String secEnvHandler = SecurityConfigurationXmlReader.getSecurityEnvironmentHandler(configData);
            if (secEnvHandler != null) {
                innerDeclarations.setSecurityEnvironmentHandler(secEnvHandler);
            } else if (((ApplicationSecurityConfiguration)declarations).getSecurityEnvironmentHandler() != null) {
                innerDeclarations.setSecurityEnvironmentHandler(((ApplicationSecurityConfiguration)declarations).getSecurityEnvironmentHandler());
            } else {
                throw new IllegalStateException("Missing <xwss:SecurityEnvironmentHandler> element for " + qname.getLocalPart());
            }
            NodeList nl = configData.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (!(child instanceof Element)) continue;
                SecurityConfigurationXmlReader.readApplicationSecurityConfiguration((Element)child, declarations, innerDeclarations, iContext);
            }
        } else if (PORT_ELEMENT_QNAME.equals(qname)) {
            if (subDeclarations == null) {
                throw new Exception("Unexpected <xwss:Port> element without a parent <xwss:Service> encountered");
            }
            String port = configData.getAttribute("name");
            StaticApplicationContext jContext = new StaticApplicationContext();
            jContext.copy(iContext);
            jContext.isPort(true);
            jContext.isService(false);
            jContext.setPortIdentifier(port);
            ApplicationSecurityConfiguration innerDeclarations = new ApplicationSecurityConfiguration();
            boolean isBSP = SecurityConfigurationXmlReader.getBSPAttribute(configData, (ApplicationSecurityConfiguration)subDeclarations);
            innerDeclarations.isBSP(isBSP);
            innerDeclarations.setSecurityEnvironmentHandler(((ApplicationSecurityConfiguration)subDeclarations).getSecurityEnvironmentHandler());
            ((ApplicationSecurityConfiguration)declarations).setSecurityPolicy(jContext, innerDeclarations);
            ((ApplicationSecurityConfiguration)subDeclarations).setSecurityPolicy(jContext, innerDeclarations);
            NodeList nl = configData.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (!(child instanceof Element)) continue;
                SecurityConfigurationXmlReader.readApplicationSecurityConfiguration((Element)child, declarations, innerDeclarations, jContext);
            }
        } else if (OPERATION_ELEMENT_QNAME.equals(qname)) {
            String operation = configData.getAttribute("name");
            StaticApplicationContext kContext = new StaticApplicationContext();
            kContext.copy(iContext);
            kContext.isOperation(true);
            kContext.isPort(false);
            kContext.setOperationIdentifier(operation);
            ApplicationSecurityConfiguration innerDeclarations = new ApplicationSecurityConfiguration();
            ((ApplicationSecurityConfiguration)declarations).setSecurityPolicy(kContext, innerDeclarations);
            ((ApplicationSecurityConfiguration)subDeclarations).setSecurityPolicy(kContext, innerDeclarations);
            boolean isBSP = SecurityConfigurationXmlReader.getBSPAttribute(configData, (ApplicationSecurityConfiguration)subDeclarations);
            innerDeclarations.isBSP(isBSP);
            innerDeclarations.setSecurityEnvironmentHandler(((ApplicationSecurityConfiguration)subDeclarations).getSecurityEnvironmentHandler());
            NodeList nl = configData.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (!(child instanceof Element)) continue;
                SecurityConfigurationXmlReader.readApplicationSecurityConfiguration((Element)child, declarations, innerDeclarations, kContext);
            }
        } else if (DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(qname)) {
            if (SecurityConfigurationXmlReader.dynamicPolicy(configData)) {
                ((ApplicationSecurityConfiguration)subDeclarations).setSecurityPolicy(iContext, new DynamicSecurityPolicy());
            }
            DeclarativeSecurityConfiguration innerDeclarations = new DeclarativeSecurityConfiguration();
            boolean isBSP = SecurityConfigurationXmlReader.getBSPAttribute(configData, (ApplicationSecurityConfiguration)subDeclarations);
            innerDeclarations.isBSP(isBSP);
            ((ApplicationSecurityConfiguration)subDeclarations).setSecurityPolicy(iContext, innerDeclarations);
            SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(configData, innerDeclarations, ((ApplicationSecurityConfiguration)subDeclarations).getSecurityEnvironmentHandler());
        } else if (SECURITY_ENVIRONMENT_HANDLER_ELEMENT_QNAME.equals(qname) && !iContext.isService()) {
            throw new IllegalStateException("An <xwss:SecurityEnvironmentHandler> can only appearunder a <xwss:Service>/<xwss:JAXRPCSecurity> element");
        }
    }

    private static DeclarativeSecurityConfiguration readContainerForBaseConfigurationData(Element configData, DeclarativeSecurityConfiguration declarations) throws Exception {
        return SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(configData, declarations, null);
    }

    private static DeclarativeSecurityConfiguration readContainerForBaseConfigurationData(Element configData, DeclarativeSecurityConfiguration declarations, String securityHandlerClass) throws Exception {
        QName qname = SecurityConfigurationXmlReader.getQName(configData);
        if (DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(qname)) {
            NamedNodeMap configurationAttributes = configData.getAttributes();
            int attributeCount = configurationAttributes.getLength();
            String attributeName = null;
            for (int index = 0; index < attributeCount; ++index) {
                Attr configurationAttribute = (Attr)configurationAttributes.item(index);
                attributeName = configurationAttribute.getName();
                if ("dumpMessages".equalsIgnoreCase(attributeName)) {
                    declarations.setDumpMessages(SecurityConfigurationXmlReader.parseBoolean("dumpMessages", configurationAttribute.getValue()));
                    continue;
                }
                if ("http://www.w3.org/2000/xmlns/".equals(configurationAttribute.getNamespaceURI())) continue;
                if ("enableDynamicPolicy".equalsIgnoreCase(attributeName)) {
                    declarations.enableDynamicPolicy(SecurityConfigurationXmlReader.parseBoolean("enableDynamicPolicy", configurationAttribute.getValue()));
                    continue;
                }
                log.log(Level.SEVERE, "WSS0412.illegal.attribute.name", new Object[]{attributeName, configData.getTagName()});
                throw new IllegalStateException(attributeName + " is not a recognized attribute of SecurityConfiguration");
            }
        } else {
            log.log(Level.SEVERE, "WSS0413.illegal.configuration.element", configData.getTagName());
            throw new IllegalStateException(configData.getTagName() + " is not a recognized definition type");
        }
        SecurityConfigurationXmlReader.readBaseConfigurationData(configData, declarations, securityHandlerClass);
        return declarations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readBaseConfigurationData(Element configData, DeclarativeSecurityConfiguration declarations, String securityHandlerClass) throws PolicyGenerationException, XWSSecurityException {
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(configData);
        boolean timestampFound = false;
        boolean senderEnableDynamicPolicy = declarations.senderSettings().enableDynamicPolicy();
        boolean receiverEnableDynamicPolicy = declarations.receiverSettings().enableDynamicPolicy();
        boolean receiverBSPFlag = declarations.receiverSettings().isBSP();
        while (eachDefinitionElement != null) {
            TimestampPolicy t;
            boolean timeStamp;
            SignaturePolicy signaturePolicy;
            EncryptionPolicy encryptionPolicy;
            TimestampPolicy timestampPolicy;
            QName definitionType = SecurityConfigurationXmlReader.getQName(eachDefinitionElement);
            if (TIMESTAMP_ELEMENT_QNAME.equals(definitionType)) {
                if (timestampFound) {
                    log.log(Level.SEVERE, "WSS0516.duplicate.configuration.element", new Object[]{definitionType, configData.getLocalName()});
                    throw new IllegalStateException("Duplicate Timestamp element");
                }
                timestampPolicy = new TimestampPolicy();
                SecurityConfigurationXmlReader.readTimestampSettings(timestampPolicy, eachDefinitionElement);
                SecurityConfigurationXmlReader.applyDefaults(timestampPolicy, senderEnableDynamicPolicy);
                declarations.senderSettings().append(timestampPolicy);
                timestampFound = true;
            } else if (ENCRYPT_OPERATION_ELEMENT_QNAME.equals(definitionType)) {
                encryptionPolicy = new EncryptionPolicy();
                SecurityConfigurationXmlReader.readEncryptionSettings(encryptionPolicy, eachDefinitionElement);
                SecurityConfigurationXmlReader.applyDefaults(encryptionPolicy, senderEnableDynamicPolicy);
                declarations.senderSettings().append(encryptionPolicy);
            } else if (SIGN_OPERATION_ELEMENT_QNAME.equals(definitionType)) {
                signaturePolicy = new SignaturePolicy();
                SecurityConfigurationXmlReader.readSigningSettings(signaturePolicy, eachDefinitionElement, senderEnableDynamicPolicy);
                String string = eachDefinitionElement.getAttribute("includeTimestamp");
                timeStamp = SecurityConfigurationXmlReader.getBooleanValue(string);
                if (timeStamp && !SecurityConfigurationXmlReader.hasTimestampSiblingPolicy(eachDefinitionElement)) {
                    t = new TimestampPolicy();
                    t.setMaxClockSkew(300000L);
                    t.setTimestampFreshness(300000L);
                    SecurityConfigurationXmlReader.applyDefaults(t, senderEnableDynamicPolicy);
                    declarations.senderSettings().append(t);
                }
                declarations.senderSettings().append(signaturePolicy);
            } else {
                AuthenticationTokenPolicy samlBinding;
                AuthenticationTokenPolicy utBinding;
                if (USERNAME_PASSWORD_AUTHENTICATION_ELEMENT_QNAME.equals(definitionType)) {
                    try {
                        utBinding = new AuthenticationTokenPolicy();
                        AuthenticationTokenPolicy.UsernameTokenBinding usernameTokenBinding = (AuthenticationTokenPolicy.UsernameTokenBinding)utBinding.newUsernameTokenFeatureBinding();
                        SecurityConfigurationXmlReader.readUsernamePasswordSettings(usernameTokenBinding, eachDefinitionElement);
                        SecurityConfigurationXmlReader.applyDefaults(usernameTokenBinding, senderEnableDynamicPolicy);
                        declarations.senderSettings().append(utBinding);
                    }
                    catch (PolicyGenerationException pge) {
                        throw new IllegalStateException(pge.getMessage());
                    }
                }
                if (SAML_ELEMENT_QNAME.equals(definitionType)) {
                    try {
                        samlBinding = new AuthenticationTokenPolicy();
                        AuthenticationTokenPolicy.SAMLAssertionBinding sAMLAssertionBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)samlBinding.newSAMLAssertionFeatureBinding();
                        SecurityConfigurationXmlReader.readSAMLTokenSettings(sAMLAssertionBinding, eachDefinitionElement);
                        SecurityConfigurationXmlReader.applyDefaults(sAMLAssertionBinding, senderEnableDynamicPolicy);
                        declarations.senderSettings().append(samlBinding);
                    }
                    catch (PolicyGenerationException pge) {
                        throw new IllegalStateException(pge.getMessage());
                    }
                }
                if (SIGNATURE_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                    signaturePolicy = new SignaturePolicy();
                    SecurityConfigurationXmlReader.readVerifySettings(signaturePolicy, eachDefinitionElement, receiverBSPFlag, receiverEnableDynamicPolicy);
                    declarations.receiverSettings().append(signaturePolicy);
                    String string = eachDefinitionElement.getAttribute("requireTimestamp");
                    timeStamp = SecurityConfigurationXmlReader.getBooleanValue(string);
                    if (timeStamp && !SecurityConfigurationXmlReader.hasTimestampSiblingPolicy(eachDefinitionElement)) {
                        t = new TimestampPolicy();
                        SecurityConfigurationXmlReader.applyReceiverDefaults(t, receiverBSPFlag, securityHandlerClass, receiverEnableDynamicPolicy);
                        declarations.receiverSettings().append(t);
                    }
                } else if (ENCRYPTION_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                    encryptionPolicy = new EncryptionPolicy();
                    SecurityConfigurationXmlReader.readDecryptionSettings(encryptionPolicy, eachDefinitionElement);
                    SecurityConfigurationXmlReader.applyReceiverDefaults(encryptionPolicy, receiverBSPFlag, receiverEnableDynamicPolicy);
                    declarations.receiverSettings().append(encryptionPolicy);
                } else if (USERNAMETOKEN_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                    try {
                        utBinding = new AuthenticationTokenPolicy();
                        AuthenticationTokenPolicy.UsernameTokenBinding usernameTokenBinding = (AuthenticationTokenPolicy.UsernameTokenBinding)utBinding.newUsernameTokenFeatureBinding();
                        SecurityConfigurationXmlReader.readUsernamePasswordRequirementSettings(usernameTokenBinding, eachDefinitionElement);
                        SecurityConfigurationXmlReader.applyReceiverDefaults(usernameTokenBinding, receiverBSPFlag, securityHandlerClass, receiverEnableDynamicPolicy);
                        declarations.receiverSettings().append(utBinding);
                    }
                    catch (PolicyGenerationException pge) {
                        throw new IllegalStateException(pge.getMessage());
                    }
                } else if (TIMESTAMP_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                    timestampPolicy = new TimestampPolicy();
                    SecurityConfigurationXmlReader.readTimestampRequirementSettings(timestampPolicy, eachDefinitionElement);
                    SecurityConfigurationXmlReader.applyReceiverDefaults(timestampPolicy, receiverBSPFlag, securityHandlerClass, receiverEnableDynamicPolicy);
                    declarations.receiverSettings().append(timestampPolicy);
                } else if (SAML_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                    try {
                        samlBinding = new AuthenticationTokenPolicy();
                        AuthenticationTokenPolicy.SAMLAssertionBinding sAMLAssertionBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)samlBinding.newSAMLAssertionFeatureBinding();
                        SecurityConfigurationXmlReader.readRequireSAMLTokenSettings(sAMLAssertionBinding, eachDefinitionElement);
                        SecurityConfigurationXmlReader.applyReceiverDefaults(sAMLAssertionBinding, receiverBSPFlag, receiverEnableDynamicPolicy);
                        declarations.receiverSettings().append(samlBinding);
                    }
                    catch (PolicyGenerationException pge) {
                        throw new IllegalStateException(pge.getMessage());
                    }
                } else {
                    if (!OPTIONAL_TARGETS_ELEMENT_QNAME.equals(definitionType)) {
                        log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
                        throw new IllegalStateException(definitionType + " is not a recognized definition type");
                    }
                    SecurityConfigurationXmlReader.readOptionalTargetSettings(declarations.receiverSettings(), eachDefinitionElement);
                }
            }
            eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
        }
        return;
    }

    private static void readVerifySettings(SignaturePolicy signaturePolicy, Element signingSettings, boolean bsp, boolean dp) {
        SecurityConfigurationXmlReader.readVerifySettings(signaturePolicy, signingSettings);
        SecurityConfigurationXmlReader.applyReceiverDefaults(signaturePolicy, bsp, dp);
        String includeTimeStamp = signingSettings.getAttribute("requireTimestamp");
        boolean timeStamp = SecurityConfigurationXmlReader.getBooleanValue(includeTimeStamp);
        if (timeStamp) {
            SignatureTarget st = new SignatureTarget();
            st.setType("qname");
            st.setValue("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp");
            st.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            ((SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding()).addTargetBinding(st);
        }
        signaturePolicy.isBSP(bsp);
    }

    private static void readVerifySettings(SignaturePolicy signaturePolicy, Element signingSettings) {
        SecurityConfigurationXmlReader.readSigningSettings(signaturePolicy, signingSettings);
    }

    private static void readSigningSettings(SignaturePolicy signaturePolicy, Element signingSettings, boolean enableDynamicPolicy) {
        SecurityConfigurationXmlReader.readSigningSettings(signaturePolicy, signingSettings);
        SecurityConfigurationXmlReader.applyDefaults(signaturePolicy, enableDynamicPolicy);
        String includeTimeStamp = signingSettings.getAttribute("includeTimestamp");
        boolean timeStamp = SecurityConfigurationXmlReader.getBooleanValue(includeTimeStamp);
        if (timeStamp) {
            SignatureTarget st = new SignatureTarget();
            st.setType("qname");
            st.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            st.setValue("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp");
            ((SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding()).addTargetBinding(st);
        }
    }

    private static boolean hasTimestampSiblingPolicy(Element signElement) {
        if ("Sign".equals(signElement.getLocalName())) {
            Element signParent = (Element)signElement.getParentNode();
            NodeList timeStampNodes = signParent.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Timestamp");
            if (timeStampNodes.getLength() > 0) {
                return true;
            }
        } else {
            Element signParent = (Element)signElement.getParentNode();
            NodeList timeStampNodes = signParent.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "RequireTimestamp");
            if (timeStampNodes.getLength() > 0) {
                return true;
            }
            NamedNodeMap requireTimestampAttrNode = null;
            for (Node requireSignatureNode = signElement.getPreviousSibling(); requireSignatureNode != null; requireSignatureNode = requireSignatureNode.getPreviousSibling()) {
                if (!"RequireSignature".equals(requireSignatureNode.getLocalName()) || !"true".equalsIgnoreCase((requireTimestampAttrNode = requireSignatureNode.getAttributes()).getNamedItem("requireTimestamp").getLocalName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void readSigningSettings(SignaturePolicy signaturePolicy, Element signingSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(signingSettings);
        signaturePolicy.setUUID(id);
        NamedNodeMap signingAttributes = signingSettings.getAttributes();
        int attributeCount = signingAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr signingAttribute = (Attr)signingAttributes.item(index);
            attributeName = signingAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName) || "includeTimestamp".equalsIgnoreCase(attributeName) && "Sign".equals(signingSettings.getLocalName()) || "requireTimestamp".equalsIgnoreCase(attributeName) && "RequireSignature".equals(signingSettings.getLocalName())) continue;
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, signingSettings.getTagName()});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of " + signingSettings.getTagName());
        }
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(signingSettings);
        int keyBearingTokensSeen = 0;
        while (eachSubElement != null) {
            SignaturePolicy.FeatureBinding featureBinding;
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (TARGET_QNAME.equals(subElementQName)) {
                featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
                featureBinding.addTargetBinding(SecurityConfigurationXmlReader.readTargetSettings(eachSubElement, true));
            } else if (X509TOKEN_ELEMENT_QNAME.equals(subElementQName)) {
                if (keyBearingTokensSeen > 0) {
                    log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
                    throw new IllegalStateException("Atmost one of X509token/SymmetricKey/SAMLAssertion  key bindings can be configured for an Sign/RequireSignature operation");
                }
                ++keyBearingTokensSeen;
                SecurityConfigurationXmlReader.readX509TokenSettings((AuthenticationTokenPolicy.X509CertificateBinding)signaturePolicy.newX509CertificateKeyBinding(), eachSubElement);
            } else if (SYMMETRIC_KEY_ELEMENT_QNAME.equals(subElementQName)) {
                if (keyBearingTokensSeen > 0) {
                    log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
                    throw new IllegalStateException("Atmost one of X509token/SymmetricKey/SAMLAssertion  key bindings can be configured for an Sign/RequireSignature operation");
                }
                ++keyBearingTokensSeen;
                SecurityConfigurationXmlReader.readSymmetricKeySettings((SymmetricKeyBinding)signaturePolicy.newSymmetricKeyBinding(), eachSubElement);
            } else if (SAML_ELEMENT_QNAME.equals(subElementQName)) {
                if (keyBearingTokensSeen > 0) {
                    log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
                    throw new IllegalStateException("Atmost one of X509token/SymmetricKey/SAMLAssertion  key bindings can be configured for an Sign/RequireSignature operation");
                }
                ++keyBearingTokensSeen;
                SecurityConfigurationXmlReader.readSAMLTokenSettings((AuthenticationTokenPolicy.SAMLAssertionBinding)signaturePolicy.newSAMLAssertionKeyBinding(), eachSubElement);
            } else if (SIGNATURE_TARGET_ELEMENT_QNAME.equals(subElementQName)) {
                featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
                featureBinding.addTargetBinding(SecurityConfigurationXmlReader.readSignatureTargetSettings(eachSubElement));
            } else if (CANONICALIZATION_METHOD_ELEMENT_QNAME.equals(subElementQName)) {
                SecurityConfigurationXmlReader.readCanonMethodSettings(signaturePolicy, eachSubElement);
            } else if (SIGNATURE_METHOD_ELEMENT_QNAME.equals(subElementQName)) {
                SecurityConfigurationXmlReader.readSigMethodSettings(signaturePolicy, eachSubElement);
            } else {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of Sign/RequireSignature");
            }
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
    }

    private static void readSymmetricKeySettings(SymmetricKeyBinding keyBinding, Element symmKeyElement) {
        NamedNodeMap symmKeyAttributes = symmKeyElement.getAttributes();
        int attributeCount = symmKeyAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr symmKeyAttribute = (Attr)symmKeyAttributes.item(index);
            attributeName = symmKeyAttribute.getName();
            if (!"keyAlias".equalsIgnoreCase(attributeName)) {
                log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:SymmetricKey"});
                throw new IllegalStateException(attributeName + " is not a recognized attribute of SymmetricKey");
            }
            keyBinding.setKeyIdentifier(symmKeyAttribute.getValue());
        }
    }

    private static void readX509TokenSettings(AuthenticationTokenPolicy.X509CertificateBinding keyBinding, Element token) {
        keyBinding.newPrivateKeyBinding();
        String id = SecurityConfigurationXmlReader.getIdAttribute(token);
        keyBinding.setUUID(id);
        NamedNodeMap tokenAttributes = token.getAttributes();
        int attributeCount = tokenAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr tokenAttribute = (Attr)tokenAttributes.item(index);
            attributeName = tokenAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) continue;
            if ("keyReferenceType".equalsIgnoreCase(attributeName)) {
                String keyReferenceStrategy = tokenAttribute.getValue();
                keyBinding.setReferenceType(keyReferenceStrategy);
                continue;
            }
            if ("certificateAlias".equalsIgnoreCase(attributeName)) {
                String certificateAlias = tokenAttribute.getValue();
                keyBinding.setCertificateIdentifier(certificateAlias);
                continue;
            }
            if ("EncodingType".equalsIgnoreCase(attributeName)) {
                String encodingType = tokenAttribute.getValue();
                keyBinding.setEncodingType(encodingType);
                continue;
            }
            if ("ValueType".equalsIgnoreCase(attributeName)) {
                String valueType = tokenAttribute.getValue();
                keyBinding.setValueType(valueType);
                continue;
            }
            if ("strId".equalsIgnoreCase(attributeName)) {
                String strid = tokenAttribute.getValue();
                keyBinding.setSTRID(strid);
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:X509Token"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of X509Token");
        }
    }

    private static void readOptionalTargetSettings(MessagePolicy requirements, Element optionalTargetSettings) throws XWSSecurityException {
        ArrayList<Target> targets = new ArrayList<Target>();
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(optionalTargetSettings);
        while (eachSubElement != null) {
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (!TARGET_QNAME.equals(subElementQName)) {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of OptionalTargets");
            }
            Target t = new Target();
            t.setEnforce(false);
            Target t1 = SecurityConfigurationXmlReader.readTargetSettings(eachSubElement, t);
            targets.add(t1);
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
        requirements.addOptionalTargets(targets);
        requirements.iterator();
    }

    private static void readDecryptionSettings(EncryptionPolicy encryptionPolicy, Element encryptionSettings) {
        SecurityConfigurationXmlReader.readEncryptionSettings(encryptionPolicy, encryptionSettings);
    }

    private static void readEncryptionSettings(EncryptionPolicy encryptionPolicy, Element encryptionSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(encryptionSettings);
        encryptionPolicy.setUUID(id);
        NamedNodeMap encryptAttributes = encryptionSettings.getAttributes();
        int attributeCount = encryptAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr encAttr = (Attr)encryptAttributes.item(index);
            attributeName = encAttr.getName();
            if ("id".equalsIgnoreCase(attributeName)) continue;
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, encryptionSettings.getTagName()});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of " + encryptionSettings.getTagName());
        }
        int keyBearingTokensSeen = 0;
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(encryptionSettings);
        while (eachSubElement != null) {
            EncryptionPolicy.FeatureBinding featureBinding;
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (TARGET_QNAME.equals(subElementQName)) {
                featureBinding = (EncryptionPolicy.FeatureBinding)encryptionPolicy.getFeatureBinding();
                featureBinding.addTargetBinding(SecurityConfigurationXmlReader.readTargetSettings(eachSubElement, false));
            } else if (X509TOKEN_ELEMENT_QNAME.equals(subElementQName)) {
                if (keyBearingTokensSeen > 0) {
                    log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
                    throw new IllegalStateException("Atmost one of X509token/SymmetricKey/SAMLAssertion  key bindings can be configured for an Encrypt/RequireEncryption operation");
                }
                ++keyBearingTokensSeen;
                SecurityConfigurationXmlReader.readX509TokenSettings((AuthenticationTokenPolicy.X509CertificateBinding)encryptionPolicy.newX509CertificateKeyBinding(), eachSubElement);
            } else if (SYMMETRIC_KEY_ELEMENT_QNAME.equals(subElementQName)) {
                if (keyBearingTokensSeen > 0) {
                    log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
                    throw new IllegalStateException("Atmost one of X509token/SymmetricKey/SAMLAssertion  key bindings can be configured for an Encrypt/RequireEncryption operation");
                }
                ++keyBearingTokensSeen;
                SecurityConfigurationXmlReader.readSymmetricKeySettings((SymmetricKeyBinding)encryptionPolicy.newSymmetricKeyBinding(), eachSubElement);
            } else if (SAML_ELEMENT_QNAME.equals(subElementQName)) {
                if (keyBearingTokensSeen > 0) {
                    log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
                    throw new IllegalStateException("Atmost one of X509token/SymmetricKey/SAMLAssertion  key bindings can be configured for an Encrypt/RequireEncryption operation");
                }
                ++keyBearingTokensSeen;
                SecurityConfigurationXmlReader.readSAMLTokenSettings((AuthenticationTokenPolicy.SAMLAssertionBinding)encryptionPolicy.newSAMLAssertionKeyBinding(), eachSubElement);
            } else if (ENCRYPTION_TARGET_ELEMENT_QNAME.equals(subElementQName)) {
                featureBinding = (EncryptionPolicy.FeatureBinding)encryptionPolicy.getFeatureBinding();
                featureBinding.addTargetBinding(SecurityConfigurationXmlReader.readEncryptionTargetSettings(eachSubElement));
            } else if (KEY_ENCRYPTION_METHOD_ELEMENT_QNAME.equals(subElementQName)) {
                SecurityConfigurationXmlReader.readKeyEncMethodSettings(encryptionPolicy, eachSubElement);
            } else if (DATA_ENCRYPTION_METHOD_ELEMENT_QNAME.equals(subElementQName)) {
                SecurityConfigurationXmlReader.readDataEncMethodSettings(encryptionPolicy, eachSubElement);
            } else {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of Encrypt/RequireEncryption");
            }
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
    }

    private static void readKeyEncMethodSettings(EncryptionPolicy encryptionPolicy, Element keyEncSettings) {
        String algorithm = keyEncSettings.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalArgumentException("Empty/Missing algorithm attribute on " + keyEncSettings.getTagName());
        }
        SecurityConfigurationXmlReader.checkCompatibility(algorithm, keyEncSettings);
        MLSPolicy keyBinding = encryptionPolicy.getKeyBinding();
        if (keyBinding == null) {
            keyBinding = encryptionPolicy.newX509CertificateKeyBinding();
            ((AuthenticationTokenPolicy.X509CertificateBinding)keyBinding).setReferenceType("Direct");
        }
        SecurityConfigurationXmlReader.setKeyAlgorithm(keyBinding, algorithm);
    }

    private static void checkCompatibility(String keyEncAlgo, Element keyEncSettings) {
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(keyEncAlgo) || "http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(keyEncAlgo)) {
            if (SecurityConfigurationXmlReader.hasSymmetricKeySibling(keyEncSettings)) {
                throw new IllegalStateException("Invalid SymmetricKey association specified for KeyEncryptionMethod " + keyEncAlgo + ", required X509Token/SAML key association");
            }
        } else if ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(keyEncAlgo) || keyEncAlgo.startsWith("http://www.w3.org/2001/04/xmlenc#kw-aes")) {
            if (!SecurityConfigurationXmlReader.hasSymmetricKeySibling(keyEncSettings)) {
                throw new IllegalStateException("Missing SymmetricKey association  for KeyEncryptionMethod " + keyEncAlgo);
            }
            if (SecurityConfigurationXmlReader.hasX509Sibling(keyEncSettings)) {
                throw new IllegalStateException("Invalid X509Token/SAML key association specified for KeyEncryptionMethod " + keyEncAlgo + ",  required SymmetricKey association");
            }
        } else {
            throw new IllegalArgumentException("Invalid/Unsupported Algorithm " + keyEncAlgo + " specified for " + "KeyEncryptionMethod");
        }
    }

    private static boolean hasX509Sibling(Element keyEncSettings) {
        Element parent = (Element)keyEncSettings.getParentNode();
        NodeList x509Nodes = parent.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "X509Token");
        return x509Nodes.getLength() > 0;
    }

    private static boolean hasSymmetricKeySibling(Element keyEncSettings) {
        Element parent = (Element)keyEncSettings.getParentNode();
        NodeList symKeyNodes = parent.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "SymmetricKey");
        return symKeyNodes.getLength() > 0;
    }

    private static void setDefaultKeyAlgorithm(SecurityPolicy keyBinding, String algorithm) {
        if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
            if ("".equals(samlBinding.getKeyAlgorithm())) {
                samlBinding.setKeyAlgorithm(algorithm);
            }
        } else if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
            if ("".equals(x509Binding.getKeyAlgorithm())) {
                x509Binding.setKeyAlgorithm(algorithm);
            }
        } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
            SymmetricKeyBinding symBinding = (SymmetricKeyBinding)keyBinding;
            if ("".equals(symBinding.getKeyAlgorithm())) {
                symBinding.setKeyAlgorithm(algorithm);
            }
        } else {
            throw new IllegalArgumentException("Unknown Key Type " + keyBinding.getClass().getName());
        }
    }

    private static void setKeyAlgorithm(SecurityPolicy keyBinding, String algorithm) {
        if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
            samlBinding.setKeyAlgorithm(algorithm);
        } else if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
            x509Binding.setKeyAlgorithm(algorithm);
        } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
            SymmetricKeyBinding symBinding = (SymmetricKeyBinding)keyBinding;
            symBinding.setKeyAlgorithm(algorithm);
        } else {
            throw new IllegalArgumentException("Unknown Key Type " + keyBinding.getClass().getName());
        }
    }

    private static void readDataEncMethodSettings(EncryptionPolicy encryptionPolicy, Element dataEncSettings) {
        String algorithm = dataEncSettings.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalArgumentException("Empty/Missing algorithm attribute on " + dataEncSettings.getTagName());
        }
        EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)encryptionPolicy.getFeatureBinding();
        featureBinding.setDataEncryptionAlgorithm(algorithm);
    }

    private static void readCanonMethodSettings(SignaturePolicy signaturePolicy, Element canonSettings) {
        String algorithm = canonSettings.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalArgumentException("Empty/Missing algorithm attribute on " + canonSettings.getTagName());
        }
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
        featureBinding.setCanonicalizationAlgorithm(algorithm);
    }

    private static void readSigMethodSettings(SignaturePolicy signaturePolicy, Element sigMethodSettings) {
        String algorithm = sigMethodSettings.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalArgumentException("Empty/Missing algorithm attribute on " + sigMethodSettings.getTagName());
        }
        MLSPolicy keyBinding = signaturePolicy.getKeyBinding();
        if (keyBinding == null) {
            keyBinding = signaturePolicy.newX509CertificateKeyBinding();
            ((AuthenticationTokenPolicy.X509CertificateBinding)keyBinding).setReferenceType("Direct");
        }
        SecurityConfigurationXmlReader.setKeyAlgorithm(keyBinding, algorithm);
    }

    private static QName getQName(Node element) {
        return new QName(element.getNamespaceURI(), element.getLocalName());
    }

    private static Element getFirstChildElement(Node node) {
        Node nextSibling;
        for (nextSibling = node.getFirstChild(); nextSibling != null && !(nextSibling instanceof Element); nextSibling = nextSibling.getNextSibling()) {
        }
        return (Element)nextSibling;
    }

    private static Element getNextElement(Node node) {
        Node nextSibling = node;
        while (nextSibling != null && !((nextSibling = nextSibling.getNextSibling()) instanceof Element)) {
        }
        return (Element)nextSibling;
    }

    private static boolean parseBoolean(String attr, String value) throws Exception {
        if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("0".equals(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        log.log(Level.SEVERE, "WSS0511.illegal.boolean.value", value);
        throw new Exception("Boolean attribute " + attr + " has value other than 'true' or 'false'");
    }

    private static long parseLong(String str) {
        if (!"".equals(str)) {
            String ret = str;
            int idx = str.indexOf(".");
            if (idx > 0) {
                ret = str.substring(0, idx);
            }
            return Long.parseLong(ret);
        }
        return 0L;
    }

    private static void readTimestampSettings(TimestampPolicy policy, Element timestampSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(timestampSettings);
        policy.setUUID(id);
        String timeout = timestampSettings.getAttribute("timeout");
        policy.setTimeout(SecurityConfigurationXmlReader.parseLong(timeout) * 1000L);
        Element someElement = SecurityConfigurationXmlReader.getFirstChildElement(timestampSettings);
        if (someElement != null) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", SecurityConfigurationXmlReader.getQName(someElement));
            throw new IllegalStateException(SecurityConfigurationXmlReader.getQName(someElement) + " is not a recognized sub-element of Timestamp");
        }
    }

    private static void readTimestampRequirementSettings(TimestampPolicy policy, Element timestampSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(timestampSettings);
        policy.setUUID(id);
        String maxClockSkew = timestampSettings.getAttribute("maxClockSkew");
        String timestampFreshness = timestampSettings.getAttribute("timestampFreshnessLimit");
        policy.setMaxClockSkew(SecurityConfigurationXmlReader.parseLong(maxClockSkew) * 1000L);
        policy.setTimestampFreshness(SecurityConfigurationXmlReader.parseLong(timestampFreshness) * 1000L);
        Element someElement = SecurityConfigurationXmlReader.getFirstChildElement(timestampSettings);
        if (someElement != null) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", SecurityConfigurationXmlReader.getQName(someElement));
            throw new IllegalStateException(SecurityConfigurationXmlReader.getQName(someElement) + " is not a recognized sub-element of RequireTimestamp");
        }
    }

    private static void readUsernamePasswordSettings(AuthenticationTokenPolicy.UsernameTokenBinding utBinding, Element usernamePasswordSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(usernamePasswordSettings);
        utBinding.setUUID(id);
        NamedNodeMap usernameAttributes = usernamePasswordSettings.getAttributes();
        int attributeCount = usernameAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr usernamePasswordAttribute = (Attr)usernameAttributes.item(index);
            attributeName = usernamePasswordAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) {
                utBinding.setUUID(usernamePasswordAttribute.getValue());
            } else if ("name".equalsIgnoreCase(attributeName)) {
                utBinding.setUsername(usernamePasswordAttribute.getValue());
            } else if ("password".equalsIgnoreCase(attributeName)) {
                utBinding.setPassword(usernamePasswordAttribute.getValue());
            } else if ("useNonce".equalsIgnoreCase(attributeName)) {
                utBinding.setUseNonce(SecurityConfigurationXmlReader.getBooleanValue(usernamePasswordAttribute.getValue()));
            } else if ("digestPassword".equalsIgnoreCase(attributeName)) {
                utBinding.setDigestOn(SecurityConfigurationXmlReader.getBooleanValue(usernamePasswordAttribute.getValue()));
            } else {
                log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, usernamePasswordSettings.getTagName()});
                throw new IllegalStateException(attributeName + " is not a recognized attribute of UsernameToken");
            }
            if (!utBinding.getDigestOn() || utBinding.getUseNonce()) continue;
            throw new IllegalStateException("useNonce attribute must be true if digestPassword is true");
        }
        Element someElement = SecurityConfigurationXmlReader.getFirstChildElement(usernamePasswordSettings);
        if (someElement != null) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", SecurityConfigurationXmlReader.getQName(someElement));
            throw new IllegalStateException(SecurityConfigurationXmlReader.getQName(someElement) + " is not a recognized sub-element of UsernameToken");
        }
    }

    private static void readUsernamePasswordRequirementSettings(AuthenticationTokenPolicy.UsernameTokenBinding utBinding, Element authenticateUserSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(authenticateUserSettings);
        utBinding.setUUID(id);
        TimestampPolicy tPolicy = null;
        try {
            tPolicy = (TimestampPolicy)utBinding.newTimestampFeatureBinding();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        NamedNodeMap authenticateUserAttributes = authenticateUserSettings.getAttributes();
        int attributeCount = authenticateUserAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr authenticateUserAttribute = (Attr)authenticateUserAttributes.item(index);
            attributeName = authenticateUserAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) continue;
            if ("nonceRequired".equalsIgnoreCase(attributeName)) {
                utBinding.setUseNonce(SecurityConfigurationXmlReader.getBooleanValue(authenticateUserAttribute.getValue()));
                continue;
            }
            if ("passwordDigestRequired".equalsIgnoreCase(attributeName)) {
                utBinding.setDigestOn(SecurityConfigurationXmlReader.getBooleanValue(authenticateUserAttribute.getValue()));
                continue;
            }
            if ("maxClockSkew".equalsIgnoreCase(attributeName)) {
                tPolicy.setMaxClockSkew(SecurityConfigurationXmlReader.parseLong(authenticateUserAttribute.getValue()) * 1000L);
                continue;
            }
            if ("timestampFreshnessLimit".equalsIgnoreCase(attributeName)) {
                tPolicy.setTimestampFreshness(SecurityConfigurationXmlReader.parseLong(authenticateUserAttribute.getValue()) * 1000L);
                continue;
            }
            if ("maxNonceAge".equalsIgnoreCase(attributeName)) {
                utBinding.setMaxNonceAge(SecurityConfigurationXmlReader.parseLong(authenticateUserAttribute.getValue()) * 1000L);
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:RequireUsernameToken"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of RequireUsernameToken");
        }
        Element someElement = SecurityConfigurationXmlReader.getFirstChildElement(authenticateUserSettings);
        if (someElement != null) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", SecurityConfigurationXmlReader.getQName(someElement));
            throw new IllegalStateException(SecurityConfigurationXmlReader.getQName(someElement) + " is not a recognized sub-element of RequireUsernameToken");
        }
        if (utBinding.getDigestOn() && !utBinding.getUseNonce()) {
            throw new IllegalStateException("nonceRequired attribute must be true if passwordDigestRequired is true");
        }
    }

    private static void readSAMLTokenSettings(AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, Element samlTokenSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(samlTokenSettings);
        samlBinding.setUUID(id);
        String type = samlTokenSettings.getAttribute("type");
        SecurityConfigurationXmlReader.validateSAMLType(type, samlTokenSettings);
        NamedNodeMap samlAttributes = samlTokenSettings.getAttributes();
        int attributeCount = samlAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr samlAttribute = (Attr)samlAttributes.item(index);
            attributeName = samlAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) continue;
            if ("type".equalsIgnoreCase(attributeName)) {
                samlBinding.setAssertionType(samlAttribute.getValue());
                continue;
            }
            if ("authorityId".equalsIgnoreCase(attributeName)) {
                samlBinding.setAuthorityIdentifier(samlAttribute.getValue());
                continue;
            }
            if ("keyIdentifier".equalsIgnoreCase(attributeName)) {
                samlBinding.setKeyIdentifier(samlAttribute.getValue());
                continue;
            }
            if ("keyReferenceType".equalsIgnoreCase(attributeName)) {
                String attributeValue = samlAttribute.getValue();
                SecurityConfigurationXmlReader.validateSAMLKeyReferenceType(attributeValue);
                samlBinding.setReferenceType(attributeValue);
                continue;
            }
            if ("strId".equalsIgnoreCase(attributeName)) {
                String strid = samlAttribute.getValue();
                samlBinding.setSTRID(strid);
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:SAMLAssertion"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of SAMLAssertion");
        }
    }

    private static void readRequireSAMLTokenSettings(AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, Element samlTokenSettings) {
        String id = SecurityConfigurationXmlReader.getIdAttribute(samlTokenSettings);
        samlBinding.setUUID(id);
        String type = samlTokenSettings.getAttribute("type");
        SecurityConfigurationXmlReader.validateRequireSAMLType(type, samlTokenSettings);
        NamedNodeMap samlAttributes = samlTokenSettings.getAttributes();
        int attributeCount = samlAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr samlAttribute = (Attr)samlAttributes.item(index);
            attributeName = samlAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) continue;
            if ("type".equalsIgnoreCase(attributeName)) {
                samlBinding.setAssertionType(samlAttribute.getValue());
                continue;
            }
            if ("authorityId".equalsIgnoreCase(attributeName)) {
                samlBinding.setAuthorityIdentifier(samlAttribute.getValue());
                continue;
            }
            if ("keyReferenceType".equalsIgnoreCase(attributeName)) {
                String attributeValue = samlAttribute.getValue();
                SecurityConfigurationXmlReader.validateSAMLKeyReferenceType(attributeValue);
                samlBinding.setReferenceType(attributeValue);
                continue;
            }
            if ("strId".equalsIgnoreCase(attributeName)) {
                String strid = samlAttribute.getValue();
                samlBinding.setSTRID(strid);
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:RequireSAMLAssertion"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of RequireSAMLAssertion");
        }
    }

    private static EncryptionTarget readEncryptionTargetSettings(Element targetSettings) {
        EncryptionTarget target = new EncryptionTarget();
        NamedNodeMap targetAttributes = targetSettings.getAttributes();
        int attributeCount = targetAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr targetAttribute = (Attr)targetAttributes.item(index);
            attributeName = targetAttribute.getName();
            if ("type".equalsIgnoreCase(attributeName)) {
                String targetType = targetAttribute.getValue();
                if ("qname".equalsIgnoreCase(targetType)) {
                    target.setType("qname");
                    continue;
                }
                if ("xpath".equalsIgnoreCase(targetType)) {
                    target.setType("xpath");
                    continue;
                }
                if ("uri".equalsIgnoreCase(targetType)) {
                    target.setType("uri");
                    continue;
                }
                log.log(Level.SEVERE, "WSS0519.illegal.attribute.value", "xwss:Target@Type");
                throw new IllegalStateException(targetType + " is not a recognized type of Target");
            }
            if ("contentOnly".equalsIgnoreCase(attributeName)) {
                String contentOnly = targetAttribute.getValue();
                target.setContentOnly(SecurityConfigurationXmlReader.getBooleanValue(contentOnly));
                continue;
            }
            if ("enforce".equalsIgnoreCase(attributeName)) {
                String enforce_S = targetAttribute.getValue();
                boolean enforce = new Boolean(enforce_S);
                target.setEnforce(enforce);
                continue;
            }
            if ("value".equalsIgnoreCase(attributeName)) continue;
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:Target"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Target");
        }
        String targetValue = targetSettings.getAttribute("value");
        if (targetValue == null) {
            throw new IllegalStateException("value attribute of the EncryptionTarget element missing/empty");
        }
        if (targetValue.startsWith("#")) {
            targetValue = targetValue.substring(1);
        }
        target.setValue(targetValue);
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(targetSettings);
        while (eachDefinitionElement != null) {
            QName definitionType = SecurityConfigurationXmlReader.getQName(eachDefinitionElement);
            if (!TRANSFORM_ELEMENT_QNAME.equals(definitionType)) {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
                throw new IllegalStateException(definitionType + " is not a recognized sub-element of EncryptionTarget");
            }
            EncryptionTarget.Transform transform = SecurityConfigurationXmlReader.readEncTransform(eachDefinitionElement);
            target.addCipherReferenceTransform(transform);
            eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
        }
        return target;
    }

    private static Target readTargetSettings(Element targetSettings, boolean signature) {
        if (signature) {
            SignatureTarget target = new SignatureTarget();
            target.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            return SecurityConfigurationXmlReader.readTargetSettings(targetSettings, target);
        }
        EncryptionTarget target = new EncryptionTarget();
        return SecurityConfigurationXmlReader.readTargetSettings(targetSettings, target);
    }

    private static Target readTargetSettings(Element targetSettings, Target target) {
        NamedNodeMap targetAttributes = targetSettings.getAttributes();
        int attributeCount = targetAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr targetAttribute = (Attr)targetAttributes.item(index);
            attributeName = targetAttribute.getName();
            if ("type".equalsIgnoreCase(attributeName)) {
                String targetType = targetAttribute.getValue();
                if ("qname".equalsIgnoreCase(targetType)) {
                    target.setType("qname");
                    continue;
                }
                if ("xpath".equalsIgnoreCase(targetType)) {
                    target.setType("xpath");
                    continue;
                }
                if ("uri".equalsIgnoreCase(targetType)) {
                    target.setType("uri");
                    continue;
                }
                log.log(Level.SEVERE, "WSS0519.illegal.attribute.value", "xwss:Target@Type");
                throw new IllegalStateException(targetType + " is not a recognized type of Target");
            }
            if ("contentOnly".equalsIgnoreCase(attributeName)) {
                if (targetAttribute.getSpecified()) {
                    SecurityConfigurationXmlReader.validateTargetContentOnly(targetSettings);
                }
                String contentOnly = targetAttribute.getValue();
                target.setContentOnly(SecurityConfigurationXmlReader.getBooleanValue(contentOnly));
                continue;
            }
            if ("enforce".equalsIgnoreCase(attributeName)) {
                String enforce_S = targetAttribute.getValue();
                boolean enforce = SecurityConfigurationXmlReader.getBooleanValue(enforce_S);
                Node parent = targetSettings.getParentNode();
                if ("OptionalTargets".equals(parent.getLocalName())) {
                    if (!targetAttribute.getSpecified() || !enforce) continue;
                    log.warning("WSS0760.warning.optionaltarget.enforce.ignored");
                    continue;
                }
                target.setEnforce(enforce);
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:Target"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Target");
        }
        String targetValue = XMLUtil.getFullTextFromChildren(targetSettings);
        if (targetValue == null || targetValue.equals("")) {
            throw new IllegalStateException("Value of the Target element is required to be specified");
        }
        if (targetValue.startsWith("#")) {
            targetValue = targetValue.substring(1);
        }
        target.setValue(targetValue);
        return target;
    }

    private static SignatureTarget readSignatureTargetSettings(Element targetSettings) {
        SignatureTarget target = new SignatureTarget();
        NamedNodeMap targetAttributes = targetSettings.getAttributes();
        int attributeCount = targetAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr targetAttribute = (Attr)targetAttributes.item(index);
            attributeName = targetAttribute.getName();
            if ("type".equalsIgnoreCase(attributeName)) {
                String targetType = targetAttribute.getValue();
                if ("qname".equalsIgnoreCase(targetType)) {
                    target.setType("qname");
                    continue;
                }
                if ("xpath".equalsIgnoreCase(targetType)) {
                    target.setType("xpath");
                    continue;
                }
                if ("uri".equalsIgnoreCase(targetType)) {
                    target.setType("uri");
                    continue;
                }
                log.log(Level.SEVERE, "WSS0519.illegal.attribute.value", "xwss:Target@Type");
                throw new IllegalStateException(targetType + " is not a recognized type of Target");
            }
            if ("contentOnly".equalsIgnoreCase(attributeName)) {
                if (!targetAttribute.getSpecified()) continue;
                throw new IllegalStateException("invalid contentOnly attribute in a xwss:SignatureTarget");
            }
            if ("enforce".equalsIgnoreCase(attributeName)) {
                String enforce_S = targetAttribute.getValue();
                boolean enforce = SecurityConfigurationXmlReader.getBooleanValue(enforce_S);
                target.setEnforce(enforce);
                continue;
            }
            if ("value".equalsIgnoreCase(attributeName)) continue;
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:Target"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Target");
        }
        String targetValue = targetSettings.getAttribute("value");
        if (targetValue == null) {
            throw new IllegalStateException("value attribute of the SignatureTarget element missing/empty");
        }
        target.setValue(targetValue);
        boolean attachmentTxSeen = false;
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(targetSettings);
        while (eachDefinitionElement != null) {
            QName definitionType = SecurityConfigurationXmlReader.getQName(eachDefinitionElement);
            if (DIGEST_METHOD_ELEMENT_QNAME.equals(definitionType)) {
                String algorithm = SecurityConfigurationXmlReader.readDigestMethod(eachDefinitionElement);
                target.setDigestAlgorithm(algorithm);
            } else if (TRANSFORM_ELEMENT_QNAME.equals(definitionType)) {
                SignatureTarget.Transform transform = SecurityConfigurationXmlReader.readSigTransform(eachDefinitionElement);
                if (transform.getTransform().equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform") || transform.getTransform().equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete-Transform")) {
                    attachmentTxSeen = true;
                }
                target.addTransform(transform);
            } else {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
                throw new IllegalStateException(definitionType + " is not a recognized sub-element of SignatureTarget");
            }
            eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
        }
        if ("".equals(target.getDigestAlgorithm())) {
            target.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        if ((target.getValue().startsWith("cid") || target.getValue().startsWith("CID") || target.getValue().startsWith("attachmentRef:")) && !attachmentTxSeen) {
            throw new IllegalStateException("Missing Transform specification for Attachment Target " + target.getValue());
        }
        return target;
    }

    private static String readDigestMethod(Element digestMethod) {
        String algorithm = digestMethod.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalArgumentException("Empty/missing algorithm attribute on SignatureTarget");
        }
        return algorithm;
    }

    private static SignatureTarget.Transform readSigTransform(Element transform) {
        String algorithm = transform.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalStateException(" Empty/Missing algorithm attribute on xwss:Transform element");
        }
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(transform);
        HashMap props = new HashMap();
        SignatureTarget.Transform trans = new SignatureTarget.Transform();
        trans.setTransform(algorithm);
        if (algorithm.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            SecurityConfigurationXmlReader.fillXPATHTransformParams(eachDefinitionElement, trans);
        } else if (algorithm.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
            SecurityConfigurationXmlReader.fillXPATH2TransformParams(eachDefinitionElement, trans);
        } else if (algorithm.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
            SecurityConfigurationXmlReader.fillSTRTransformParams(eachDefinitionElement, trans);
        } else if (log.getLevel() == Level.FINE) {
            log.log(Level.FINE, "Algorithm Parameters not supportedfor transform", algorithm);
        }
        return trans;
    }

    private static void fillXPATHTransformParams(Element algoElement, SignatureTarget.Transform transform) {
        String value;
        QName definitionType = SecurityConfigurationXmlReader.getQName(algoElement);
        if (ALGORITHM_PARAMETER_ELEMENT_QNAME.equals(definitionType)) {
            String name = algoElement.getAttribute("name");
            value = algoElement.getAttribute("value");
            if (!name.equals("XPATH")) {
                throw new IllegalStateException("XPATH Transform must have XPATH attribute name and an XPATH Expression as value");
            }
        } else {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
            throw new IllegalStateException(definitionType + " is not a recognized sub-element of Transform");
        }
        transform.setAlgorithmParameters(new XPathFilterParameterSpec(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fillXPATH2TransformParams(Element algoElement, SignatureTarget.Transform transform) {
        ArrayList<XPathType> xpathTypeList = new ArrayList<XPathType>();
        while (algoElement != null) {
            QName definitionType = SecurityConfigurationXmlReader.getQName(algoElement);
            if (ALGORITHM_PARAMETER_ELEMENT_QNAME.equals(definitionType)) {
                String name = algoElement.getAttribute("name");
                String value = algoElement.getAttribute("value");
                if (name.equalsIgnoreCase("UNION")) {
                    xpathTypeList.add(new XPathType(value, XPathType.Filter.UNION));
                } else if (name.equalsIgnoreCase("INTERSECT")) {
                    xpathTypeList.add(new XPathType(value, XPathType.Filter.INTERSECT));
                } else {
                    if (!name.equalsIgnoreCase("SUBTRACT")) throw new IllegalStateException("XPATH2 Transform AlgorithmParameter name attribute should be one of UNION,INTERSECT,SUBTRACT");
                    xpathTypeList.add(new XPathType(value, XPathType.Filter.SUBTRACT));
                }
            } else {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
                throw new IllegalStateException(definitionType + " is not a recognized sub-element of Transform");
            }
            algoElement = SecurityConfigurationXmlReader.getNextElement(algoElement);
        }
        transform.setAlgorithmParameters(new XPathFilter2ParameterSpec(xpathTypeList));
    }

    private static void fillSTRTransformParams(Element algoElement, SignatureTarget.Transform transform) {
        QName definitionType = SecurityConfigurationXmlReader.getQName(algoElement);
        if (!ALGORITHM_PARAMETER_ELEMENT_QNAME.equals(definitionType)) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
            throw new IllegalStateException(definitionType + " is not a recognized sub-element of Transform");
        }
        String name = algoElement.getAttribute("name");
        String value = algoElement.getAttribute("value");
        transform.setAlgorithmParameters(new Parameter(name, value));
    }

    private static EncryptionTarget.Transform readEncTransform(Element transform) {
        String algorithm = transform.getAttribute("algorithm");
        if ("".equals(algorithm)) {
            throw new IllegalStateException(" Empty/Missing algorithm attribute on xwss:Transform element");
        }
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(transform);
        EncryptionTarget.Transform trans = new EncryptionTarget.Transform();
        trans.setTransform(algorithm);
        return trans;
    }

    private static void validateContentOnly(Element target) {
        Node parent = target.getParentNode();
        String parentName = parent.getLocalName();
        if ("RequireSignature".equalsIgnoreCase(parentName) || "Sign".equalsIgnoreCase(parentName)) {
            String targetValue = target.getAttribute("value");
            String targetType = target.getAttribute("type");
            if ("uri".equalsIgnoreCase(targetType)) {
                if (!targetValue.startsWith("cid") && !targetValue.startsWith("CID")) {
                    throw new IllegalStateException("invalid contentOnly attribute on a non-attachment SignatureTarget");
                }
            } else {
                throw new IllegalStateException("invalid contentOnly attribute in a SignatureTarget");
            }
        }
        if (!"Encrypt".equalsIgnoreCase(parentName) && !"RequireEncryption".equalsIgnoreCase(parentName)) {
            throw new IllegalStateException("contentOnly attribute not allowed on Targets under element " + parentName);
        }
    }

    private static void validateSAMLKeyReferenceType(String typeName) {
        if (!"Identifier".equalsIgnoreCase(typeName) && !"Embedded".equalsIgnoreCase(typeName)) {
            throw new IllegalStateException("Reference Type " + typeName + " not allowed for SAMLAssertion References");
        }
    }

    private static void validateRequireSAMLType(String type, Element samlTokenSettings) {
        if (!"SV".equals(type)) {
            throw new IllegalStateException("Allowed Assertion Types for <xwss:RequireSAMLAssertion> is SV only");
        }
        Node parent = samlTokenSettings.getParentNode();
        if (parent == null) {
            throw new IllegalStateException("<xwss:RequireSAMLAssertion> cannot occur at this position");
        }
        String parentName = parent.getLocalName();
        if (!"SecurityConfiguration".equals(parentName)) {
            throw new IllegalStateException("<xwss:RequireSAMLAssertion> of Type=SV cannot occur as child of " + parentName);
        }
    }

    private static void validateSAMLType(String type, Element samlTokenSettings) {
        if (!"SV".equals(type) && !"HOK".equals(type)) {
            throw new IllegalStateException(type + " not a valid SAML Assertion Type, require one of HOK|SV");
        }
        if ("SV".equals(type)) {
            Node parent = samlTokenSettings.getParentNode();
            if (parent == null) {
                throw new IllegalStateException("SAML Assertion cannot occur at this position");
            }
            String parentName = parent.getLocalName();
            if (!"SecurityConfiguration".equals(parentName)) {
                throw new IllegalStateException("SAML Assertion of Type=SV cannot occur as child of " + parentName);
            }
        }
    }

    private static boolean dynamicPolicy(Element configData) {
        String dynamicFlag = configData.getAttribute("enableDynamicPolicy");
        NodeList nl = configData.getElementsByTagName("*");
        if ("".equals(dynamicFlag) || "false".equals(dynamicFlag) || "0".equals(dynamicFlag)) {
            return false;
        }
        return ("true".equals(dynamicFlag) || "1".equals(dynamicFlag)) && nl.getLength() == 0;
    }

    private static boolean getBSPAttribute(Element configData, ApplicationSecurityConfiguration parent) {
        String conformanceValue = configData.getAttribute("conformance");
        if ("bsp".equals(conformanceValue)) {
            return true;
        }
        if ("".equals(conformanceValue) && parent != null) {
            return parent.isBSP();
        }
        return false;
    }

    private static String getIdAttribute(Element configData) {
        String id = configData.getAttribute("id");
        if (id.startsWith("#")) {
            throw new IllegalArgumentException("Illegal id attribute " + id + ", id attributes on policy elements cannot begin with a '#' character");
        }
        if ("".equals(id)) {
            id = SecurityConfigurationXmlReader.generateUUID();
        }
        return id;
    }

    private static String generateUUID() {
        int intRandom = rnd.nextInt();
        String id = "XWSSGID-" + String.valueOf(System.currentTimeMillis()) + String.valueOf(intRandom);
        return id;
    }

    private static void validateTargetContentOnly(Element target) {
        Node parent = target.getParentNode();
        String parentName = parent.getLocalName();
        if (!"Encrypt".equalsIgnoreCase(parentName) && !"RequireEncryption".equalsIgnoreCase(parentName)) {
            throw new IllegalStateException("contentOnly attribute not allowed on Targets under element " + parentName);
        }
    }

    private static String getSecurityEnvironmentHandler(Element element) {
        int secEnvCount = 0;
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(element);
        String handlerClsName = null;
        while (eachDefinitionElement != null) {
            QName definitionType = SecurityConfigurationXmlReader.getQName(eachDefinitionElement);
            if (SECURITY_ENVIRONMENT_HANDLER_ELEMENT_QNAME.equals(definitionType)) {
                if (secEnvCount > 0) {
                    throw new IllegalStateException("More than one <xwss:SecurityEnvironmentHandler> element under " + element.getTagName());
                }
                ++secEnvCount;
                handlerClsName = XMLUtil.getFullTextFromChildren(eachDefinitionElement);
                if (handlerClsName == null || handlerClsName.equals("")) {
                    throw new IllegalStateException("A Handler class name has to be specified in security configuration file");
                }
            }
            eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
        }
        return handlerClsName;
    }

    private static void readAlgorithmProperties(HashMap props, Element eachDefinitionElement) {
        String name = eachDefinitionElement.getAttribute("name");
        String value = eachDefinitionElement.getAttribute("value");
        props.put(name, value);
    }

    private static boolean getBooleanValue(String valueString) {
        if ("0".equals(valueString) || "false".equalsIgnoreCase(valueString)) {
            return false;
        }
        if ("1".equals(valueString) || "true".equalsIgnoreCase(valueString)) {
            return true;
        }
        log.log(Level.SEVERE, "WSS0511.illegal.boolean.value", valueString);
        throw new IllegalArgumentException(valueString + " is not a valid boolean value");
    }

    private static void applyDefaults(TimestampPolicy policy, boolean dp) {
        if (policy.getTimeout() == 0L) {
            policy.setTimeout(5000L);
        }
    }

    private static void applyDefaults(EncryptionPolicy policy, boolean dp) {
        boolean targetsEmpty;
        EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
        boolean bl = targetsEmpty = featureBinding.getTargetBindings().size() == 0;
        if (!dp && targetsEmpty) {
            EncryptionTarget t = new EncryptionTarget();
            featureBinding.addTargetBinding((Target)t);
        }
        if (policy.getKeyBinding() == null) {
            AuthenticationTokenPolicy.X509CertificateBinding x509Policy = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
            x509Policy.setReferenceType("Direct");
        }
    }

    private static void applyDefaults(SignaturePolicy policy, boolean dp) {
        boolean targetsEmpty;
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        boolean bl = targetsEmpty = featureBinding.getTargetBindings().size() == 0;
        if (!dp && targetsEmpty) {
            SignatureTarget t = new SignatureTarget();
            t.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            featureBinding.addTargetBinding(t);
        }
        if (policy.getKeyBinding() == null) {
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
            x509Binding.newPrivateKeyBinding();
            x509Binding.setReferenceType("Direct");
        }
        SecurityConfigurationXmlReader.setDefaultKeyAlgorithm(policy.getKeyBinding(), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        if ("".equals(featureBinding.getCanonicalizationAlgorithm())) {
            featureBinding.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
    }

    private static void applyDefaults(AuthenticationTokenPolicy.UsernameTokenBinding policy, boolean dp) {
    }

    private static void applyDefaults(AuthenticationTokenPolicy.SAMLAssertionBinding policy, boolean dp) {
        if ("".equals(policy.getReferenceType())) {
            policy.setReferenceType("Identifier");
        }
    }

    private static void applyReceiverDefaults(SignaturePolicy policy, boolean bsp, boolean dp) {
        boolean targetsEmpty;
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        boolean bl = targetsEmpty = featureBinding.getTargetBindings().size() == 0;
        if (!dp && targetsEmpty) {
            SignatureTarget t = new SignatureTarget();
            t.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            featureBinding.addTargetBinding(t);
        }
        policy.isBSP(bsp);
    }

    private static void applyReceiverDefaults(EncryptionPolicy policy, boolean bsp, boolean dp) {
        boolean targetsEmpty;
        EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
        boolean bl = targetsEmpty = featureBinding.getTargetBindings().size() == 0;
        if (!dp && targetsEmpty) {
            EncryptionTarget t = new EncryptionTarget();
            featureBinding.addTargetBinding((Target)t);
        }
        policy.isBSP(bsp);
    }

    private static void applyReceiverDefaults(AuthenticationTokenPolicy.UsernameTokenBinding policy, boolean bsp, String securityHandlerClass, boolean dp) throws PolicyGenerationException {
        policy.isBSP(bsp);
    }

    private static void applyReceiverDefaults(TimestampPolicy timestampPolicy, boolean bsp, String securityHandlerClass, boolean dp) {
        if (timestampPolicy.getMaxClockSkew() == 0L) {
            timestampPolicy.setMaxClockSkew(300000L);
        }
        if (timestampPolicy.getTimestampFreshness() == 0L) {
            timestampPolicy.setTimestampFreshness(300000L);
        }
        timestampPolicy.isBSP(bsp);
    }

    private static void applyReceiverDefaults(AuthenticationTokenPolicy.SAMLAssertionBinding policy, boolean bsp, boolean dp) {
        if ("".equals(policy.getReferenceType())) {
            policy.setReferenceType("Identifier");
        }
        policy.isBSP(bsp);
    }

    private static boolean configHasSingleService(Element config) {
        NodeList services = config.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Service");
        return services.getLength() <= 1 && services.getLength() != 0;
    }

    private static boolean configHasSingleServiceAndNoPorts(Element config) {
        NodeList services = config.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Service");
        if (services.getLength() > 1 || services.getLength() == 0) {
            return false;
        }
        NodeList ports = config.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Port");
        return ports.getLength() == 0;
    }

    private static boolean configHasOperations(Element config) {
        NodeList ops = config.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Operation");
        return ops.getLength() > 0;
    }

    private static void checkIdUniqueness(Element elem) {
        NodeList nl = elem.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "*");
        int len = nl.getLength();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            Element subElem = (Element)nl.item(i);
            String idAttr = subElem.getAttribute("id");
            if (!"".equals(idAttr)) {
                if (map.containsKey(idAttr)) {
                    throw new IllegalArgumentException("id attribute value '" + idAttr + "' not unique");
                }
                map.put(idAttr, idAttr);
            }
            if ("".equals(idAttr = subElem.getAttribute("strId"))) continue;
            if (map.containsKey(idAttr)) {
                throw new IllegalArgumentException("strId/id attribute value '" + idAttr + "' not unique");
            }
            map.put(idAttr, idAttr);
        }
    }

    private static class ErrorHandler
    extends DefaultHandler {
        PrintStream out;

        public ErrorHandler(PrintStream out) {
            this.out = out;
        }

        public void error(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
            throw e;
        }
    }
}

