/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionUtil;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeySelectorImpl
extends KeySelector {
    private static KeySelectorImpl keyResolver = null;
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    private KeySelectorImpl() {
    }

    public static KeySelector getInstance() {
        return keyResolver;
    }

    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            if (logger.getLevel() == Level.SEVERE) {
                logger.log(Level.SEVERE, "WSS1317.keyinfo.null");
            }
            throw new KeySelectorException("Null KeyInfo object!");
        }
        try {
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            FilterProcessingContext wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            if (isBSP && list.size() > 1) {
                logger.log(Level.SEVERE, "BSP Violation of R5402: KeyInfo MUST have exactly one child");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "BSP Violation of R5402: KeyInfo MUST have exactly one child", null);
            }
            boolean isStr = false;
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    PublicKey pk = null;
                    try {
                        pk = ((KeyValue)xmlStructure).getPublicKey();
                    }
                    catch (KeyException ke) {
                        throw new KeySelectorException(ke);
                    }
                    if (!KeySelectorImpl.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new SimpleKeySelectorResult(pk);
                }
                if (xmlStructure instanceof DOMStructure) {
                    SOAPElement reference = (SOAPElement)((DOMStructure)xmlStructure).getNode();
                    if (!KeySelectorImpl.isSecurityTokenReference((Element)reference)) continue;
                    isStr = true;
                    final Key key = KeySelectorImpl.resolve(reference, context, purpose);
                    return new KeySelectorResult(){

                        public Key getKey() {
                            return key;
                        }
                    };
                }
                if (xmlStructure instanceof KeyName) {
                    KeyName keyName = (KeyName)xmlStructure;
                    SecretKey returnKey = wssContext.getSecurityEnvironment().getSecretKey(wssContext.getExtraneousProperties(), keyName.getName(), false);
                    if (returnKey == null) {
                        X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), keyName.getName(), false);
                        if (cert == null || !KeySelectorImpl.algEquals(sm.getAlgorithm(), cert.getPublicKey().getAlgorithm())) continue;
                        return new SimpleKeySelectorResult(cert.getPublicKey());
                    }
                    return new SimpleKeySelectorResult(returnKey);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                Key key = KeySelectorImpl.resolveX509Data(wssContext, (X509Data)xmlStructure, purpose);
                return new SimpleKeySelectorResult(key);
            }
            if (isBSP && !isStr) {
                logger.log(Level.SEVERE, "BSP Violation of R5409: Child element of KeyInfo MUST be a STR element");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "BSP Violation of R5409: Child element of KeyInfo MUST be a STR element", null);
            }
        }
        catch (KeySelectorException kse) {
            throw kse;
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolving keyinformation" + ex.getMessage());
            throw new KeySelectorException(ex);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Key resolve(SOAPElement securityTokenReference, XMLCryptoContext context, KeySelector.Purpose purpose) throws KeySelectorException {
        try {
            void var12_30;
            FilterProcessingContext wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            SecurableSoapMessage secureMsg = wssContext.getSecurableSoapMessage();
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            SecurityTokenReference str = new SecurityTokenReference(securityTokenReference, isBSP);
            ReferenceElement refElement = str.getReference();
            HashMap tokenCache = wssContext.getTokenCache();
            SignaturePolicy policy = (SignaturePolicy)wssContext.getInferredPolicy();
            AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
            if (policy != null) {
                keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
            }
            Object var12_16 = null;
            if (refElement instanceof KeyIdentifier) {
                KeyIdentifier keyId = (KeyIdentifier)refElement;
                if (keyBinding != null) {
                    keyBinding.setReferenceType("Identifier");
                    keyBinding.setValueType(keyId.getValueType());
                }
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(keyId.getValueType())) {
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue());
                        wssContext.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                        PublicKey publicKey = wssContext.getSecurityEnvironment().getPublicKey(wssContext.getExtraneousProperties(), keyIdBytes);
                        return var12_30;
                    }
                    if (purpose != KeySelector.Purpose.SIGN) return var12_30;
                    PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                    return var12_30;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyId.getValueType())) {
                    String assertionID = keyId.getDecodedReferenceValue();
                    Assertion samlAssertion = (Assertion)tokenCache.get(assertionID);
                    Element tokenElement = null;
                    if (samlAssertion == null) {
                        tokenElement = str.getSamlAuthorityBinding() != null ? wssContext.getSecurityEnvironment().locateSAMLAssertion(wssContext.getExtraneousProperties(), str.getSamlAuthorityBinding(), assertionID, (Document)secureMsg.getSOAPPart()) : SAMLUtil.locateSamlAssertion(assertionID, (Document)secureMsg.getSOAPPart());
                        try {
                            samlAssertion = AssertionUtil.fromElement(tokenElement);
                            tokenCache.put(assertionID, samlAssertion);
                        }
                        catch (Exception e) {
                            logger.log(Level.FINEST, "Error occurred while trying to resolve SAML assertion" + e.getMessage());
                            throw new KeySelectorException(e);
                        }
                    }
                    Key key = KeySelectorImpl.resolveSamlAssertion(wssContext, tokenElement, purpose);
                    KeySelectorImpl.addAuthorityId(tokenElement, wssContext);
                    return var12_30;
                }
                String assertionID = keyId.getDecodedReferenceValue();
                Element samlAssertion = null;
                try {
                    samlAssertion = KeySelectorImpl.resolveSAMLToken(str, assertionID, wssContext);
                }
                catch (Exception e) {
                    logger.log(Level.FINEST, "Error occurred while trying to resolve SAML assertion" + e.getMessage());
                }
                if (samlAssertion != null) {
                    Key key = KeySelectorImpl.resolveSamlAssertion(wssContext, samlAssertion, purpose);
                    KeySelectorImpl.addAuthorityId(samlAssertion, wssContext);
                    return var12_30;
                }
                if (purpose == KeySelector.Purpose.VERIFY) {
                    byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue());
                    wssContext.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                    PublicKey publicKey = wssContext.getSecurityEnvironment().getPublicKey(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                    return var12_30;
                }
                if (purpose != KeySelector.Purpose.SIGN) return var12_30;
                PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var12_30;
            }
            if (refElement instanceof DirectReference) {
                if (keyBinding != null) {
                    keyBinding.setReferenceType("Direct");
                }
                String uri = ((DirectReference)refElement).getURI();
                if (isBSP && !uri.startsWith("#")) {
                    throw new XWSSecurityException("Violation of BSP R5204 : When a SECURITY_TOKEN_REFERENCE uses a Direct Reference to an INTERNAL_SECURITY_TOKEN, it MUST use a Shorthand XPointer Reference");
                }
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(((DirectReference)refElement).getValueType())) {
                    String wsuId;
                    X509SecurityToken token;
                    if (keyBinding != null) {
                        keyBinding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                    }
                    if ((token = (X509SecurityToken)tokenCache.get(wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri))) == null) {
                        token = (X509SecurityToken)KeySelectorImpl.resolveToken(wsuId, context);
                        if (token == null) {
                            throw new KeySelectorException("Token with Id " + wsuId + "not found");
                        }
                        tokenCache.put(wsuId, token);
                    }
                    Key key = KeySelectorImpl.resolveX509Token(wssContext, token, purpose);
                    return var12_30;
                }
                if (null != ((DirectReference)refElement).getValueType()) {
                    logger.log(Level.SEVERE, "WSS1307.unsupported.directref.mechanism", new Object[]{((DirectReference)refElement).getValueType()});
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "unsupported directreference ValueType " + ((DirectReference)refElement).getValueType(), null);
                }
                logger.log(Level.WARNING, "Fails BSP requirements R3058 and 3059");
                String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityToken token = (SecurityToken)tokenCache.get(wsuId);
                if (token == null) {
                    token = KeySelectorImpl.resolveToken(wsuId, context);
                    if (token == null) {
                        throw new KeySelectorException("Token with Id " + wsuId + "not found");
                    }
                    tokenCache.put(wsuId, token);
                }
                if (token instanceof X509SecurityToken) {
                    Key key = KeySelectorImpl.resolveX509Token(wssContext, (X509SecurityToken)token, purpose);
                    return var12_30;
                }
                String message = " Cannot Resolve URI " + uri;
                logger.log(Level.SEVERE, "WSS1307.unsupported.directref.mechanism", new Object[]{message});
                KeySelectorException xwsse = new KeySelectorException(message);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
            }
            if (!(refElement instanceof X509IssuerSerial)) {
                logger.log(Level.SEVERE, "WSS1308.unsupported.reference.mechanism");
                KeySelectorException xwsse = new KeySelectorException("Key reference mechanism not supported");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            if (keyBinding != null) {
                keyBinding.setReferenceType("IssuerSerialNumber");
            }
            X509IssuerSerial xisElement = (X509IssuerSerial)refElement;
            BigInteger serialNumber = xisElement.getSerialNumber();
            String issuerName = xisElement.getIssuerName();
            if (purpose == KeySelector.Purpose.VERIFY) {
                wssContext.setExtraneousProperty("requester.serial", serialNumber);
                wssContext.setExtraneousProperty("requester.issuername", issuerName);
                PublicKey publicKey = wssContext.getSecurityEnvironment().getPublicKey(wssContext.getExtraneousProperties(), serialNumber, issuerName);
                return var12_30;
            }
            if (purpose != KeySelector.Purpose.SIGN) return var12_30;
            PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), serialNumber, issuerName);
            return var12_30;
        }
        catch (KeySelectorException kse) {
            throw kse;
        }
        catch (XWSSecurityException xwsExp) {
            if (logger.getLevel() != Level.FINEST) throw new KeySelectorException(xwsExp);
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", xwsExp);
            throw new KeySelectorException(xwsExp);
        }
        catch (MarshalException me) {
            if (logger.getLevel() != Level.FINEST) throw new KeySelectorException(me);
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", me);
            throw new KeySelectorException(me);
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", ex);
            throw new KeySelectorException(ex);
        }
    }

    private static Key resolveSamlAssertion(FilterProcessingContext context, Element samlAssertion, KeySelector.Purpose purpose) throws MarshalException, KeySelectorException, XWSSecurityException {
        X509Certificate cert;
        boolean signatureVerified = true;
        if (purpose == KeySelector.Purpose.VERIFY) {
            NodeList nl = samlAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                XWSSecurityException e = new XWSSecurityException("Unsigned SAML Assertion encountered");
                logger.log(Level.SEVERE, "WSS1309.saml.signature.verify.failed", e);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception during Signature verfication in SAML Assertion", e);
            }
            SignaturePolicy policy = (SignaturePolicy)context.getInferredPolicy();
            AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
            if (policy != null) {
                keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
            }
            Element elem = (Element)nl.item(0);
            try {
                if (!SignatureProcessor.verifySignature(elem, context)) {
                    logger.log(Level.SEVERE, "WSS1310.saml.signature.invalid");
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", new Exception("SAML Assertion has invalid Signature"));
                }
            }
            catch (XWSSecurityException ex) {
                logger.log(Level.SEVERE, "WSS1310.saml.signature.invalid");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", ex);
            }
        }
        Element keyInfoElem = AssertionUtil.getSubjectConfirmationKeyInfo(samlAssertion);
        KeyInfo keyInfo = KeyInfoFactory.getInstance().unmarshalKeyInfo(new DOMStructure(keyInfoElem));
        List<XMLStructure> keyInfoList = keyInfo.getContent();
        Iterator<XMLStructure> content = keyInfoList.iterator();
        Key key = null;
        if (content.hasNext()) {
            XMLStructure data = content.next();
            if (data instanceof KeyName) {
                throw new XWSSecurityException("Unsupported KeyName under SAML SubjectConfirmation");
            }
            if (data instanceof KeyValue) {
                key = KeySelectorImpl.resolveKeyValue(context, (KeyValue)data, purpose);
            } else if (data instanceof X509Data) {
                key = KeySelectorImpl.resolveX509Data(context, (X509Data)data, purpose);
            } else {
                logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                throw new KeySelectorException("Unsupported Key Information");
            }
        }
        if (purpose == KeySelector.Purpose.VERIFY && !signatureVerified && (cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), (PublicKey)key, true)) != null) {
            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
        }
        try {
            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), AssertionUtil.fromElement(samlAssertion));
        }
        catch (SAMLException ex) {
            // empty catch block
        }
        return key;
    }

    private static Key resolveKeyValue(FilterProcessingContext context, KeyValue keyValue, KeySelector.Purpose purpose) throws KeySelectorException {
        try {
            if (purpose == KeySelector.Purpose.VERIFY) {
                return keyValue.getPublicKey();
            }
            if (purpose == KeySelector.Purpose.SIGN) {
                return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), keyValue.getPublicKey(), true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1313.illegal.key.value", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    private static Key resolveX509Data(FilterProcessingContext context, X509Data x509Data, KeySelector.Purpose purpose) throws KeySelectorException {
        X509Certificate cert = null;
        try {
            List<?> data = x509Data.getContent();
            Iterator<?> iterator = data.iterator();
            while (iterator.hasNext()) {
                Object content = iterator.next();
                if (content instanceof X509Certificate) {
                    cert = (X509Certificate)content;
                } else if (content instanceof byte[]) {
                    byte[] ski = (byte[])content;
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        return context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), ski);
                    }
                    if (purpose == KeySelector.Purpose.SIGN) {
                        return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), ski);
                    }
                } else {
                    if (content instanceof String) {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                    }
                    if (content instanceof javax.xml.crypto.dsig.keyinfo.X509IssuerSerial) {
                        javax.xml.crypto.dsig.keyinfo.X509IssuerSerial xis = (javax.xml.crypto.dsig.keyinfo.X509IssuerSerial)content;
                        if (purpose == KeySelector.Purpose.VERIFY) {
                            return context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                        }
                        if (purpose == KeySelector.Purpose.SIGN) {
                            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                        }
                    } else {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("Unsupported child element of X509Data encountered");
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY) {
                    return cert.getPublicKey();
                }
                if (purpose != KeySelector.Purpose.SIGN) continue;
                return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1314.illegal.x509.data", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    private static Key resolveX509Token(FilterProcessingContext context, X509SecurityToken token, KeySelector.Purpose purpose) throws XWSSecurityException {
        if (purpose == KeySelector.Purpose.VERIFY) {
            SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
            X509Certificate cert = token.getCertificate();
            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
            return cert.getPublicKey();
        }
        if (purpose == KeySelector.Purpose.SIGN) {
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), token.getCertificate());
        }
        return null;
    }

    private static boolean isSecurityTokenReference(Element reference) {
        return "SecurityTokenReference".equals(reference.getLocalName());
    }

    protected static SecurityToken resolveToken(final String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        URIDereferencer resolver = context.getURIDereferencer();
        URIReference uriRef = new URIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }
        };
        FilterProcessingContext wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
        boolean isBSP = false;
        if (securityPolicy != null) {
            isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
        }
        try {
            NodeSetData set = (NodeSetData)resolver.dereference(uriRef, context);
            Iterator itr = set.iterator();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if (!"BinarySecurityToken".equals(node.getLocalName())) continue;
                X509SecurityToken token = new X509SecurityToken((SOAPElement)node, isBSP);
                X509Certificate cert = null;
                try {
                    cert = token.getCertificate();
                }
                catch (XWSSecurityException xwe) {
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "A Invalid security token was provided ", xwe);
                }
                if (!wssContext.getSecurityEnvironment().validateCertificate(cert)) {
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", null);
                }
                return token;
            }
        }
        catch (URIReferenceException ure) {
            logger.log(Level.SEVERE, "WSS1304.FC_SECURITY_TOKEN_UNAVAILABLE", ure);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", ure);
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "WSS1305.UnSupported.security.token");
        }
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, "A Unsupported token was provided ", null);
    }

    private static Element resolveSAMLToken(SecurityTokenReference tokenRef, String assertionId, FilterProcessingContext context) throws XWSSecurityException {
        Assertion ret = null;
        Element tokenElement = null;
        tokenElement = tokenRef.getSamlAuthorityBinding() != null ? context.getSecurityEnvironment().locateSAMLAssertion(context.getExtraneousProperties(), tokenRef.getSamlAuthorityBinding(), assertionId, (Document)context.getSOAPMessage().getSOAPPart()) : SAMLUtil.locateSamlAssertion(assertionId, (Document)context.getSOAPMessage().getSOAPPart());
        try {
            ret = AssertionUtil.fromElement(tokenElement);
        }
        catch (Exception e) {
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "Error occured while resolvingSAML assertion", e);
            }
            throw new XWSSecurityException(e);
        }
        context.getTokenCache().put(assertionId, ret);
        return tokenElement;
    }

    private static void addAuthorityId(Element assertion, FilterProcessingContext fp) {
        SignaturePolicy ep = (SignaturePolicy)fp.getInferredPolicy();
        if (ep != null) {
            AuthenticationTokenPolicy.SAMLAssertionBinding kb = (AuthenticationTokenPolicy.SAMLAssertionBinding)ep.getKeyBinding();
            String issuer = assertion.getAttribute("Issuer");
            kb.setAuthorityIdentifier(issuer);
        }
    }

    static {
        keyResolver = new KeySelectorImpl();
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private Key pk;

        SimpleKeySelectorResult(Key pk) {
            this.pk = pk;
        }

        public Key getKey() {
            return this.pk;
        }
    }
}

