/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SamlAssertionHeaderBlock;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.dsig.AttachmentData;
import com.sun.xml.wss.impl.dsig.DSigResolver;
import com.sun.xml.wss.impl.dsig.DataWrapper;
import com.sun.xml.wss.impl.dsig.KeySelectorImpl;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.SignaturePolicyVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureProcessor {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int sign(FilterProcessingContext context) throws XWSSecurityException {
        try {
            void var7_17;
            String referenceType;
            PrivateKeyBinding privKBinding;
            SignaturePolicy signaturePolicy = (SignaturePolicy)context.getSecurityPolicy();
            SOAPMessage soapMessage = context.getSOAPMessage();
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            WSSPolicy keyBinding = (WSSPolicy)signaturePolicy.getKeyBinding();
            PrivateKey privKey = null;
            Object signMethod = null;
            Object var7_9 = null;
            WSSPolicyConsumerImpl dsigHelper = WSSPolicyConsumerImpl.getInstance();
            KeyInfo keyInfo = null;
            SecurityHeader securityHeader = secureMessage.findOrCreateSecurityHeader();
            if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                AuthenticationTokenPolicy.X509CertificateBinding certInfo = null;
                if (context.getX509CertificateBinding() != null) {
                    certInfo = context.getX509CertificateBinding();
                    context.setX509CertificateBinding(null);
                } else {
                    certInfo = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
                }
                privKBinding = (PrivateKeyBinding)certInfo.getKeyBinding();
                privKey = privKBinding.getPrivateKey();
                referenceType = certInfo.getReferenceType();
                String strId = certInfo.getSTRID();
                if (strId == null) {
                    strId = secureMessage.generateId();
                }
                HashMap tokenCache = context.getTokenCache();
                if (referenceType.equals("Direct")) {
                    DirectReference reference = new DirectReference();
                    reference.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                    String id = keyBinding.getUUID();
                    if (id == null || id.equals("")) {
                        id = secureMessage.generateId();
                    }
                    reference.setURI("#" + id);
                    SecurityTokenReference secTokenRef = new SecurityTokenReference();
                    secTokenRef.setReference(reference);
                    secTokenRef.setWsuId(strId);
                    keyInfo = dsigHelper.constructKeyInfo(signaturePolicy, secTokenRef);
                    X509SecurityToken token = null;
                    token = (X509SecurityToken)tokenCache.get(id);
                    if (token == null) {
                        token = new X509SecurityToken((Document)secureMessage.getSOAPPart(), certInfo.getX509Certificate(), id);
                        secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(token);
                    }
                    Node node = token.getAsSoapElement().getNextSibling();
                } else if (referenceType.equals("Identifier")) {
                    KeyIdentifierStrategy keyIdentifier = new KeyIdentifierStrategy(certInfo.getCertificateIdentifier(), true);
                    keyIdentifier.setCertificate(certInfo.getX509Certificate());
                    SecurityTokenReference secTokenRef = new SecurityTokenReference();
                    keyIdentifier.insertKey(secTokenRef, secureMessage);
                    secTokenRef.setWsuId(strId);
                    X509SubjectKeyIdentifier re = (X509SubjectKeyIdentifier)secTokenRef.getReference();
                    String id = re.getReferenceValue();
                    tokenCache.put(id, re);
                    re.setCertificate(certInfo.getX509Certificate());
                    keyInfo = dsigHelper.constructKeyInfo(signaturePolicy, secTokenRef);
                    SOAPElement sOAPElement = securityHeader.getFirstChildElement();
                } else {
                    if (!referenceType.equals("IssuerSerialNumber")) throw new XWSSecurityException("Reference type " + referenceType + "not supported");
                    X509Certificate xCert = certInfo.getX509Certificate();
                    X509IssuerSerial xis = new X509IssuerSerial((Document)secureMessage.getSOAPPart(), xCert.getIssuerDN().getName(), xCert.getSerialNumber());
                    SecurityTokenReference secTokenRef = new SecurityTokenReference();
                    secTokenRef.setReference(xis);
                    secTokenRef.setWsuId(strId);
                    xis.setCertificate(xCert);
                    tokenCache.put(xis.getIssuerName() + xis.getSerialNumber(), xis);
                    keyInfo = dsigHelper.constructKeyInfo(signaturePolicy, secTokenRef);
                    SOAPElement sOAPElement = securityHeader.getFirstChildElement();
                }
            } else {
                if (!PolicyTypeUtil.samlTokenPolicy(keyBinding)) throw new XWSSecurityException("Unsupported Key Binding for SignaturePolicy");
                AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                privKBinding = (PrivateKeyBinding)samlBinding.getKeyBinding();
                if (privKBinding == null) {
                    throw new XWSSecurityException("PrivateKey binding not set for SAML Policy  by CallbackHandler");
                }
                privKey = privKBinding.getPrivateKey();
                if (privKey == null) {
                    throw new XWSSecurityException("PrivateKey null inside PrivateKeyBinding set for SAML Policy ");
                }
                referenceType = samlBinding.getReferenceType();
                if (referenceType.equals("Embedded")) {
                    throw new XWSSecurityException("Embedded Reference Type for SAML Assertions not supported yet");
                }
                String assertionId = samlBinding.getAssertionId();
                Element _assertion = samlBinding.getAssertion();
                Element _authorityBinding = samlBinding.getAuthorityBinding();
                if (assertionId == null) {
                    if (_assertion == null) {
                        throw new XWSSecurityException("None of SAML Assertion, SAML Assertion Id information was set into  the Policy by the CallbackHandler");
                    }
                    assertionId = _assertion.getAttribute("AssertionID");
                }
                SecurityTokenReference tokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                String strId = samlBinding.getSTRID();
                if (strId == null) {
                    strId = secureMessage.generateId();
                }
                tokenRef.setWsuId(strId);
                if (_authorityBinding != null) {
                    tokenRef.setSamlAuthorityBinding(_authorityBinding, (Document)secureMessage.getSOAPPart());
                }
                KeyIdentifierStrategy strat = new KeyIdentifierStrategy(assertionId);
                strat.insertKey(tokenRef, secureMessage);
                keyInfo = dsigHelper.constructKeyInfo(signaturePolicy, tokenRef);
                if (_assertion != null && _authorityBinding == null) {
                    SamlAssertionHeaderBlock samlHeaderblock = new SamlAssertionHeaderBlock(_assertion, (Document)secureMessage.getSOAPPart());
                    secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(samlHeaderblock);
                    Node node = samlHeaderblock.getAsSoapElement().getNextSibling();
                } else {
                    SOAPElement sOAPElement = securityHeader.getFirstChildElement();
                }
            }
            SignedInfo signedInfo = WSSPolicyConsumerImpl.getInstance().constructSignedInfo(context);
            DOMSignContext signContext = null;
            signContext = var7_17 == null ? new DOMSignContext(privKey, (Node)securityHeader.getAsSoapElement()) : new DOMSignContext(privKey, (Node)securityHeader.getAsSoapElement(), (Node)var7_17);
            signContext.setURIDereferencer(DSigResolver.getInstance());
            XMLSignature signature = dsigHelper.constructSignature(signedInfo, keyInfo);
            signContext.put("http://wss.sun.com#processingContext", context);
            signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            signature.sign(signContext);
            return 0;
        }
        catch (XWSSecurityException xe) {
            if (logger.getLevel() != Level.SEVERE) throw xe;
            logger.log(Level.SEVERE, "WSS1316.sign.failed", xe);
            throw xe;
        }
        catch (Exception ex) {
            if (logger.getLevel() != Level.SEVERE) throw new XWSSecurityException(ex);
            logger.log(Level.SEVERE, "WSS1316.sign.failed", ex);
            throw new XWSSecurityException(ex);
        }
    }

    public static int verify(FilterProcessingContext context) throws XWSSecurityException {
        try {
            SecurityPolicy policy;
            WSSPolicyConsumerImpl dsigUtil = WSSPolicyConsumerImpl.getInstance();
            SOAPElement signElement = context.getSecurableSoapMessage().findSecurityHeader().getCurrentHeaderElement();
            if (signElement == null || signElement.getLocalName() == null || !"Signature".equals(signElement.getLocalName())) {
                context.setPVE(new PolicyViolationException("Expected Signature Element as per receiver requirements, found  " + signElement.getLocalName()));
                context.isPrimaryPolicyViolation(true);
                int n = 0;
                return n;
            }
            DOMValidateContext validationContext = new DOMValidateContext(KeySelectorImpl.getInstance(), (Node)signElement);
            XMLSignatureFactory signatureFactory = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            XMLSignature signature = signatureFactory.unmarshalXMLSignature(validationContext);
            validationContext.setURIDereferencer(DSigResolver.getInstance());
            validationContext.put("http://wss.sun.com#processingContext", context);
            SignaturePolicy currentMessagePolicy = null;
            if (context.getMode() == 1 || context.getMode() == 0) {
                currentMessagePolicy = new SignaturePolicy();
                context.setInferredPolicy(currentMessagePolicy);
            }
            boolean coreValidity = signature.validate(validationContext);
            SecurityPolicy securityPolicy = context.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            if (!coreValidity) {
                if (logger.getLevel() == Level.FINEST) {
                    logger.log(Level.FINEST, "Signature failed core validation");
                    boolean sv = signature.getSignatureValue().validate(validationContext);
                    logger.log(Level.FINEST, "Signature validation status: " + sv);
                    Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                    int j = 0;
                    while (i.hasNext()) {
                        Reference ref = i.next();
                        logger.log(Level.FINEST, "Reference ID " + ref.getId());
                        logger.log(Level.FINEST, "Reference URI " + ref.getURI());
                        boolean refValid = ref.validate(validationContext);
                        logger.log(Level.FINEST, "Reference[" + j + "] validity status: " + refValid);
                        ++j;
                    }
                }
                if (logger.getLevel() == Level.SEVERE) {
                    logger.log(Level.SEVERE, "WSS1315.signature.verification.failed");
                }
                XWSSecurityException xwsse = new XWSSecurityException("Signature verification failed");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Signature verification failed ", xwsse);
            }
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINE, "Signature Passed Core Validation");
            }
            SignedInfo signInfo = signature.getSignedInfo();
            if (isBSP) {
                Iterator<Reference> i = signInfo.getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference reference = i.next();
                    Iterator<Transform> t = reference.getTransforms().iterator();
                    int index = 0;
                    while (t.hasNext()) {
                        ExcC14NParameterSpec spec;
                        Transform transform = t.next();
                        if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(transform.getAlgorithm())) {
                            throw new XWSSecurityException("Enveloped signatures not permitted by BSP");
                        }
                        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform.getAlgorithm()) && transform.getParameterSpec() != null && (spec = (ExcC14NParameterSpec)transform.getParameterSpec()).getPrefixList().isEmpty()) {
                            throw new XWSSecurityException("Prefix List cannot be empty: violation of BSP 5407");
                        }
                        ++index;
                    }
                    ++j;
                }
            }
            if (context.getMode() == 1) {
                policy = (MessagePolicy)context.getSecurityPolicy();
                dsigUtil.constructSignaturePolicy(signInfo, ((MessagePolicy)policy).isBSP(), currentMessagePolicy);
                ((MessagePolicy)policy).append(currentMessagePolicy);
            }
            if (context.getMode() == 0) {
                SignatureProcessor.verifyRequirements(context, signature, validationContext);
                policy = (SignaturePolicy)context.getSecurityPolicy();
                dsigUtil.constructSignaturePolicy(signInfo, ((WSSPolicy)policy).isBSP(), currentMessagePolicy);
                SignaturePolicyVerifier spv = new SignaturePolicyVerifier();
                spv.verifyPolicy(policy, currentMessagePolicy);
                if (logger.getLevel() == Level.FINEST) {
                    logger.log(Level.FINE, "Reciever Requirements  are met");
                }
            }
        }
        catch (XWSSecurityException xwe) {
            throw xwe;
        }
        catch (XMLSignatureException xse) {
            Throwable t1 = xse.getCause();
            if (t1 == null) {
                throw new XWSSecurityException(xse);
            }
            if (t1 instanceof KeySelectorException || t1 instanceof URIReferenceException) {
                Throwable t2 = t1.getCause();
                if (t2 != null && t2 instanceof WssSoapFaultException) {
                    throw (WssSoapFaultException)t2;
                }
                throw new XWSSecurityException((Exception)t1);
            }
            throw new XWSSecurityException(xse);
        }
        catch (Exception ex) {
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "Error occurred during signatureverification " + ex.getMessage());
            }
            throw new XWSSecurityException(ex);
        }
        finally {
            context.setInferredPolicy(null);
        }
        return 0;
    }

    public static void verifyRequirements(FilterProcessingContext context, XMLSignature signature, DOMValidateContext validationContext) throws Exception {
        int i;
        SignaturePolicy policy = (SignaturePolicy)context.getSecurityPolicy();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        WSSPolicyConsumerImpl dsigUtil = WSSPolicyConsumerImpl.getInstance();
        ArrayList targets = featureBinding.getTargetBindings();
        if (targets == null || targets.size() == 0) {
            return;
        }
        SignedInfo signedInfo = signature.getSignedInfo();
        List<Reference> signedReferences = signedInfo.getReferences();
        ListIterator<Reference> sr = signedReferences.listIterator();
        ArrayList<DataWrapper> signedDataList = new ArrayList<DataWrapper>();
        ArrayList<Reference> signedReferenceList = new ArrayList<Reference>();
        while (sr.hasNext()) {
            Reference reference = (Reference)sr.next();
            Data tmpObj = SignatureProcessor.getData(reference, validationContext);
            signedDataList.add(new DataWrapper(tmpObj));
            signedReferenceList.add(reference);
        }
        ArrayList<SignatureTarget> optionalReqList = new ArrayList<SignatureTarget>();
        ArrayList<DataWrapper> requiredDataList = new ArrayList<DataWrapper>();
        ArrayList<Reference> requiredReferenceList = new ArrayList<Reference>();
        ArrayList<DataWrapper> optionalDataList = new ArrayList<DataWrapper>();
        ArrayList<Reference> optionalReferenceList = new ArrayList<Reference>();
        Iterator targetItr = targets.iterator();
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        block9: while (targetItr.hasNext()) {
            List referenceList;
            boolean requiredTarget;
            SignatureTarget signatureTarget;
            block28: {
                signatureTarget = (SignatureTarget)targetItr.next();
                requiredTarget = signatureTarget.getEnforce();
                referenceList = null;
                try {
                    if (requiredTarget) {
                        referenceList = dsigUtil.generateReferenceList(Collections.singletonList(signatureTarget), secureMessage, context, true);
                    } else {
                        optionalReqList.add(signatureTarget);
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "WSS1302.reflist_error", ex);
                    if (!requiredTarget) break block28;
                    throw new XWSSecurityException("Receiver requirement for SignatureTarget " + signatureTarget.getValue() + " is not met");
                }
            }
            if (!requiredTarget) continue;
            if (referenceList.size() <= 0) {
                throw new XWSSecurityException("Receiver requirement for SignatureTarget " + signatureTarget.getValue() + " is not met");
            }
            boolean allRef = false;
            if (signatureTarget.getValue().startsWith("cid:*")) {
                allRef = true;
            }
            for (int i2 = 0; i2 < referenceList.size(); ++i2) {
                block29: {
                    Reference reference = (Reference)referenceList.get(i2);
                    Data data = null;
                    try {
                        data = SignatureProcessor.getData(reference, validationContext);
                        if (requiredTarget && data != null) {
                            DataWrapper tmpObj = new DataWrapper(data);
                            tmpObj.setTarget(signatureTarget);
                            requiredDataList.add(tmpObj);
                            requiredReferenceList.add(reference);
                        }
                    }
                    catch (Exception ex) {
                        if (!requiredTarget) break block29;
                        throw new XWSSecurityException("Receiver requirement for SignatureTarget " + signatureTarget.getValue() + " is not met");
                    }
                }
                if (!allRef) continue block9;
            }
        }
        if (optionalReqList.size() == 0 && requiredReferenceList.size() != signedReferenceList.size()) {
            throw new XWSSecurityException("Number of Targets in the message dont match number of Targets in receiver requirements");
        }
        if (requiredDataList.size() == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "No mandatory receiver requirements were provided");
            }
            return;
        }
        for (int i3 = 0; i3 < requiredDataList.size(); ++i3) {
            DataWrapper rData = (DataWrapper)requiredDataList.get(i3);
            boolean found = false;
            for (int j = 0; j < signedDataList.size(); ++j) {
                DataWrapper sData = null;
                sData = (DataWrapper)signedDataList.get(j);
                if (!SignatureProcessor.isEqual(rData, sData, (Reference)requiredReferenceList.get(i3), (Reference)signedReferenceList.get(j))) continue;
                signedDataList.remove(j);
                signedReferenceList.remove(j);
                found = true;
                break;
            }
            if (found) continue;
            String uri = rData.getTarget().getValue();
            String type = rData.getTarget().getType();
            throw new XWSSecurityException("Receiver requirement for SignatureTarget having " + type + " type and value " + uri + " is not met");
        }
        if (signedDataList.size() == 0) {
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "All receiver requirements are met");
            }
            return;
        }
        List referenceList = null;
        for (i = 0; i < optionalReqList.size(); ++i) {
            SignatureTarget signatureTarget;
            block30: {
                signatureTarget = (SignatureTarget)optionalReqList.get(i);
                try {
                    referenceList = null;
                    referenceList = dsigUtil.generateReferenceList(Collections.singletonList(signatureTarget), secureMessage, context, true);
                }
                catch (Exception ex) {
                    if (logger.getLevel() != Level.FINE) break block30;
                    logger.log(Level.FINE, "Optional Target not found in the message ", ex);
                }
            }
            if (referenceList == null || referenceList.size() <= 0) continue;
            Reference reference = (Reference)referenceList.get(0);
            Data data = null;
            try {
                data = SignatureProcessor.getData(reference, validationContext);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (data == null) continue;
            DataWrapper tmpObj = new DataWrapper(data);
            tmpObj.setTarget(signatureTarget);
            optionalDataList.add(tmpObj);
            optionalReferenceList.add(reference);
        }
        for (i = 0; i < signedDataList.size(); ++i) {
            DataWrapper sData = (DataWrapper)signedDataList.get(i);
            DataWrapper oData = null;
            boolean found = false;
            for (int j = 0; j < optionalDataList.size(); ++j) {
                oData = (DataWrapper)optionalDataList.get(j);
                if (!SignatureProcessor.isEqual(oData, sData, (Reference)optionalReferenceList.get(j), (Reference)signedReferenceList.get(i))) continue;
                optionalDataList.remove(j);
                optionalReferenceList.remove(j);
                found = true;
                break;
            }
            if (found) continue;
            Reference st = (Reference)signedReferenceList.get(i);
            throw new XWSSecurityException("SingatureTarget in the message with URI " + st.getURI() + " has not met receiver requirements");
        }
        if (logger.getLevel() == Level.FINEST) {
            logger.log(Level.FINEST, "All receiver requirements are met");
        }
    }

    private static boolean isEqual(DataWrapper data1, DataWrapper data2, Reference ref1, Reference ref2) throws XWSSecurityException {
        if (data1.isNodesetData() && data2.isNodesetData()) {
            NodeSetData ns1 = (NodeSetData)data1.getData();
            NodeSetData ns2 = (NodeSetData)data2.getData();
            Iterator itr1 = ns1.iterator();
            Iterator itr2 = ns2.iterator();
            while (itr1.hasNext() && itr2.hasNext()) {
                Node node2;
                Node node1 = (Node)itr1.next();
                if (node1.isSameNode(node2 = (Node)itr2.next()) || node1.isEqualNode(node2)) continue;
                return false;
            }
            return !itr1.hasNext() && !itr2.hasNext();
        }
        if (data1.isOctectData() && data2.isOctectData()) {
            OctetStreamData osd1 = (OctetStreamData)data1.getData();
            OctetStreamData osd2 = (OctetStreamData)data2.getData();
            InputStream stream1 = osd1.getOctetStream();
            InputStream stream2 = osd2.getOctetStream();
            byte[] b1 = new byte[128];
            byte[] b2 = new byte[128];
            block3: while (true) {
                int len1 = 0;
                int len2 = 0;
                try {
                    len1 = stream1.read(b1);
                    len2 = stream2.read(b2);
                }
                catch (IOException ioEx) {
                    if (logger.getLevel() == Level.FINEST) {
                        logger.log(Level.FINEST, "Error occurred whilecomparing OctetStreamData objects " + ioEx.getMessage());
                    }
                    return false;
                }
                if (len1 == -1 && len2 == -1) break;
                if (len1 != len2) {
                    return false;
                }
                int i = 0;
                while (true) {
                    if (i >= len1) continue block3;
                    if (b1[i] != b2[i]) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            return true;
        }
        if (data1.isAttachmentData() && data2.isAttachmentData()) {
            AttachmentData ad1 = (AttachmentData)data1.getData();
            AttachmentData ad2 = (AttachmentData)data2.getData();
            String uriOne = ad1.getAttachmentPart().getContentId();
            String uriTwo = ad2.getAttachmentPart().getContentId();
            if (uriOne != null && uriOne.equals(uriTwo)) {
                return SignatureProcessor.isTransformsEqual(ref1, ref2);
            }
            return false;
        }
        return false;
    }

    private static boolean isTransformsEqual(Reference ref1, Reference ref2) throws XWSSecurityException {
        List<Transform> tList1 = ref1.getTransforms();
        List<Transform> tList2 = ref2.getTransforms();
        if (tList1.size() != tList2.size()) {
            throw new XWSSecurityException("Receiver Requirements for the transforms are not met");
        }
        for (int i = 0; i < tList1.size(); ++i) {
            Transform tr1 = tList1.get(i);
            Transform tr2 = tList2.get(i);
            String alg1 = tr1.getAlgorithm();
            String alg2 = tr2.getAlgorithm();
            if (alg1 == alg2 || alg1 != null && alg1.equals(alg2)) continue;
            throw new XWSSecurityException("Receiver Requirements for the transforms are not met");
        }
        return true;
    }

    private static Data getData(Reference reference, DOMValidateContext context) throws Exception {
        final String uri = reference.getURI();
        URIReference uriRef = new URIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }
        };
        Data inputData = DSigResolver.getInstance().dereference(uriRef, context);
        if (inputData instanceof AttachmentData) {
            return inputData;
        }
        List<Transform> transformList = reference.getTransforms();
        Iterator<Transform> itr = transformList.iterator();
        while (itr.hasNext()) {
            Transform transform = itr.next();
            inputData = SignatureProcessor.getData(transform, inputData, context);
        }
        return inputData;
    }

    private static Data getData(Transform transform, Data inputData, DOMValidateContext context) throws Exception {
        String transformAlgo = transform.getAlgorithm();
        if (transformAlgo == "http://www.w3.org/TR/1999/REC-xpath-19991116" || transformAlgo == "http://www.w3.org/2002/06/xmldsig-filter2" || transformAlgo == "http://www.w3.org/TR/1999/REC-xslt-19991116") {
            TransformService transformImpl = TransformService.getInstance(transformAlgo, "DOM");
            TransformParameterSpec transformParams = null;
            transformParams = (TransformParameterSpec)transform.getParameterSpec();
            transformImpl.init(transformParams);
            return transformImpl.transform(inputData, context);
        }
        return inputData;
    }

    public static boolean verifySignature(Element signElement, FilterProcessingContext context) throws XWSSecurityException {
        try {
            DOMValidateContext validationContext = new DOMValidateContext(KeySelectorImpl.getInstance(), (Node)signElement);
            XMLSignatureFactory signatureFactory = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            XMLSignature signature = signatureFactory.unmarshalXMLSignature(validationContext);
            validationContext.setURIDereferencer(DSigResolver.getInstance());
            validationContext.put("http://wss.sun.com#processingContext", context);
            boolean coreValidity = signature.validate(validationContext);
            if (!coreValidity && logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "Signature failed core validation");
                boolean sv = signature.getSignatureValue().validate(validationContext);
                logger.log(Level.FINEST, "Signature validation status: " + sv);
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference ref = i.next();
                    logger.log(Level.FINEST, "Reference ID " + ref.getId());
                    logger.log(Level.FINEST, "Reference URI " + ref.getURI());
                    boolean refValid = ref.validate(validationContext);
                    logger.log(Level.FINEST, "Reference[" + j + "] validity status: " + refValid);
                    ++j;
                }
            }
            return coreValidity;
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Exception occurred during signature verification" + e.getMessage());
            throw new XWSSecurityException(e);
        }
    }
}

