/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.xml.jaxws.JAXWSMessage;
import com.sun.xml.messaging.saaj.soap.ExpressMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.impl.dsig.NamespaceContextImpl;
import com.sun.xml.wss.impl.misc.UnsyncByteArrayOutputStream;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.Parameter;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSPolicyConsumerImpl {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig.LogStrings", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    public static final String defaultJSR105Provider = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
    private String pMT = System.getProperty("jsr105MechanismType", "DOM");
    private static WSSPolicyConsumerImpl wpcInstance = null;
    private NamespaceContextImpl nsContext = null;
    private URIDereferencer externalURIResolver = null;
    private Provider provider = null;

    private WSSPolicyConsumerImpl() {
        try {
            this.provider = (Provider)Class.forName(this.providerName).newInstance();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS1324.dsig.factory", ex);
        }
        if (logger.getLevel() == Level.FINEST) {
            logger.log(Level.FINEST, "JSR 105 provider is : " + this.providerName);
            logger.log(Level.FINEST, "JSR 105 provider mechanism is : " + this.pMT);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.addProvider(new WSSProvider());
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSSPolicyConsumerImpl getInstance() {
        if (wpcInstance == null) {
            Class clazz = WSSPolicyConsumerImpl.class;
            synchronized (clazz) {
                if (wpcInstance == null) {
                    wpcInstance = new WSSPolicyConsumerImpl();
                }
            }
        }
        return wpcInstance;
    }

    public SignedInfo constructSignedInfo(FilterProcessingContext fpContext) throws PolicyGenerationException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        if (PolicyTypeUtil.signaturePolicy(fpContext.getSecurityPolicy())) {
            SignedInfo signInfo = this.generateSignedInfo(fpContext);
            return signInfo;
        }
        return null;
    }

    public XMLSignature constructSignature(SignedInfo signInfo, KeyInfo keyInfo) {
        return this.getSignatureFactory().newXMLSignature(signInfo, keyInfo);
    }

    public KeyInfo constructKeyInfo(MLSPolicy signaturePolicy, SecurityTokenReference reference) throws PolicyGenerationException, SOAPException, XWSSecurityException {
        if (PolicyTypeUtil.signaturePolicy(signaturePolicy)) {
            SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
            WSSPolicy keyBinding = (WSSPolicy)signaturePolicy.getKeyBinding();
            KeyInfoFactory keyFactory = this.getKeyInfoFactory();
            DOMStructure domKeyInfo = new DOMStructure((Node)reference.getAsSoapElement());
            KeyInfo keyInfo = keyFactory.newKeyInfo(Collections.singletonList(domKeyInfo));
            return keyInfo;
        }
        return null;
    }

    public XMLSignatureFactory getSignatureFactory() {
        try {
            return XMLSignatureFactory.getInstance("DOM", this.provider);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS1324.dsig.factory", ex);
            throw new RuntimeException(ex);
        }
    }

    public KeyInfoFactory getKeyInfoFactory() {
        try {
            return this.getSignatureFactory().getKeyInfoFactory();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS1323.dsig.keyinfo.factory", ex);
            throw new RuntimeException(ex);
        }
    }

    public SignaturePolicy constructSignaturePolicy(SignedInfo signedInfo, boolean isBSP) {
        SignaturePolicy policy = new SignaturePolicy();
        this.constructSignaturePolicy(signedInfo, isBSP, policy);
        return policy;
    }

    public void constructSignaturePolicy(SignedInfo signedInfo, boolean isBSP, SignaturePolicy policy) {
        List<Reference> referencesList = signedInfo.getReferences();
        SignatureMethod sm = signedInfo.getSignatureMethod();
        CanonicalizationMethod cm = signedInfo.getCanonicalizationMethod();
        policy.isBSP(isBSP);
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        featureBinding.setCanonicalizationAlgorithm(cm.getAlgorithm());
        Iterator<Reference> itr = referencesList.iterator();
        while (itr.hasNext()) {
            Reference ref = itr.next();
            SignatureTarget.Transform transform = this.getSignatureTransform(ref);
            SignatureTarget target = new SignatureTarget();
            target.isBSP(isBSP);
            if (transform != null) {
                target.addTransform(transform);
            }
            target.setDigestAlgorithm(ref.getDigestMethod().getAlgorithm());
            if (ref.getURI().length() > 0) {
                target.setValue(SecurableSoapMessage.getIdFromFragmentRef(ref.getURI()));
            } else {
                target.setValue(ref.getURI());
            }
            target.setType("uri");
            featureBinding.addTargetBinding(target);
        }
    }

    public SignatureTarget.Transform getSignatureTransform(Reference reference) {
        List<Transform> transformList = reference.getTransforms();
        Iterator<Transform> transformItr = transformList.iterator();
        SignatureTarget.Transform transform = null;
        while (transformItr.hasNext()) {
            Transform trObj = transformItr.next();
            String algorithm = trObj.getAlgorithm();
            transform = new SignatureTarget.Transform();
            transform.setTransform(algorithm);
            AlgorithmParameterSpec paramSpec = trObj.getParameterSpec();
            transform.setAlgorithmParameters(paramSpec);
        }
        return transform;
    }

    public void addCanonicalizationParams(AlgorithmParameterSpec algoSpec, HashMap paramList) {
        if (algoSpec instanceof XPathFilterParameterSpec) {
            XPathFilterParameterSpec spec = (XPathFilterParameterSpec)algoSpec;
            paramList.put("XPATH", spec.getXPath());
        } else if (algoSpec instanceof XPathFilter2ParameterSpec) {
            XPathFilter2ParameterSpec spec = (XPathFilter2ParameterSpec)algoSpec;
            paramList.put("XPATH2", spec.getXPathList());
        }
    }

    private SignedInfo generateSignedInfo(FilterProcessingContext fpContext) throws PolicyGenerationException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        SignaturePolicy signaturePolicy = (SignaturePolicy)fpContext.getSecurityPolicy();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
        MLSPolicy keyBinding = signaturePolicy.getKeyBinding();
        XMLSignatureFactory signatureFactory = this.getSignatureFactory();
        SecurableSoapMessage secureMessage = fpContext.getSecurableSoapMessage();
        String canonicalAlgo = featureBinding.getCanonicalizationAlgorithm();
        ArrayList targetList = featureBinding.getTargetBindings();
        String keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
            if (!"".equals(certificateBinding.getKeyAlgorithm())) {
                keyAlgo = certificateBinding.getKeyAlgorithm();
            }
        } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
            if (!"".equals(samlBinding.getKeyAlgorithm())) {
                keyAlgo = samlBinding.getKeyAlgorithm();
            }
        } else {
            throw new XWSSecurityException("Unsupported KeyBinding for SignaturePolicy");
        }
        ExcC14NParameterSpec spec = null;
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(canonicalAlgo)) {
            List inc = WSSPolicyConsumerImpl.getInclusiveNamespacePrefixes((Element)((Object)secureMessage.findSecurityHeader()), false);
            spec = new ExcC14NParameterSpec(inc);
        }
        CanonicalizationMethod canonicalMethod = signatureFactory.newCanonicalizationMethod(canonicalAlgo, spec);
        SignatureMethod signatureMethod = signatureFactory.newSignatureMethod(keyAlgo, null);
        SignedInfo signedInfo = signatureFactory.newSignedInfo(canonicalMethod, signatureMethod, this.generateReferenceList(targetList, signatureFactory, secureMessage, fpContext, false), null);
        return signedInfo;
    }

    public static List getInclusiveNamespacePrefixes(Element target, boolean excludeVisiblePrefixes) {
        ArrayList<String> result = new ArrayList<String>();
        Node parent = target;
        while (!(parent instanceof Document)) {
            NamedNodeMap attributes = parent.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                result.add(attribute.getLocalName());
            }
            parent = parent.getParentNode();
        }
        return result;
    }

    public static List getReferenceNamespacePrefixes(Node target) {
        ArrayList result = new ArrayList();
        WSSPolicyConsumerImpl.traverseSubtree(target, result);
        return result;
    }

    private static void traverseSubtree(Node node, List result) {
        SOAPElement element = (SOAPElement)node;
        Iterator visible = element.getVisibleNamespacePrefixes();
        while (visible.hasNext()) {
            String prefix = (String)visible.next();
            if (result.contains(prefix)) continue;
            result.add(prefix);
        }
        Iterator children = element.getChildElements();
        while (children.hasNext()) {
            Node child = (Node)children.next();
            if (child instanceof Text) continue;
            WSSPolicyConsumerImpl.traverseSubtree(child, result);
        }
    }

    public List generateReferenceList(List targetList, SecurableSoapMessage secureMessage, FilterProcessingContext fpContext, boolean verify) throws PolicyGenerationException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        XMLSignatureFactory factory = this.getSignatureFactory();
        return this.generateReferenceList(targetList, factory, secureMessage, fpContext, verify);
    }

    private List generateReferenceList(List targetList, XMLSignatureFactory signatureFactory, SecurableSoapMessage secureMessage, FilterProcessingContext fpContext, boolean verify) throws PolicyGenerationException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        ListIterator iterator = targetList.listIterator();
        ArrayList<Reference> references = new ArrayList<Reference>();
        while (iterator.hasNext()) {
            SignatureTarget signatureTarget = (SignatureTarget)iterator.next();
            String digestAlgo = signatureTarget.getDigestAlgorithm();
            DigestMethod digestMethod = null;
            try {
                digestMethod = signatureFactory.newDigestMethod(digestAlgo, null);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WSS1301.invalid.digest.algo", digestAlgo);
                throw new XWSSecurityException(ex.getMessage());
            }
            boolean exclTransformToBeAdded = false;
            ArrayList transforms = signatureTarget.getTransforms();
            ListIterator transformIterator = transforms.listIterator();
            ArrayList<Transform> transformList = new ArrayList<Transform>(2);
            while (transformIterator.hasNext()) {
                TransformParameterSpec transformParams;
                SignatureTarget.Transform transformInfo = (SignatureTarget.Transform)transformIterator.next();
                String transformAlgo = transformInfo.getTransform();
                Transform transform = null;
                if (transformAlgo == "http://www.w3.org/TR/1999/REC-xpath-19991116" || transformAlgo.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                    TransformParameterSpec spec = (TransformParameterSpec)transformInfo.getAlgorithmParameters();
                    if (spec == null) {
                        throw new XWSSecurityException("XPATH parameters cannot be null");
                    }
                    transform = signatureFactory.newTransform(transformAlgo, spec);
                } else if (transformAlgo == "http://www.w3.org/2002/06/xmldsig-filter2" || transformAlgo.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                    transformParams = (TransformParameterSpec)transformInfo.getAlgorithmParameters();
                    transform = signatureFactory.newTransform(transformAlgo, transformParams);
                } else if (transformAlgo == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform" || transformAlgo.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
                    transformParams = (Parameter)transformInfo.getAlgorithmParameters();
                    String algo = null;
                    if (((Parameter)transformParams).getParamName().equals("CanonicalizationMethod")) {
                        algo = ((Parameter)transformParams).getParamValue();
                    }
                    if (algo == null) {
                        throw new XWSSecurityException("STR Transform must have acanonicalization method specified");
                    }
                    Object cm = null;
                    Object spec = null;
                    try {
                        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                        Element tp = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
                        Element cem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
                        tp.appendChild(cem);
                        cem.setAttribute("Algorithm", algo);
                        doc.appendChild(tp);
                        DOMStructure transformSpec = new DOMStructure(tp);
                        transform = signatureFactory.newTransform(transformAlgo, transformSpec);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "WSS1300.dsig.transform_param.error", ex);
                        throw new XWSSecurityException(ex.getMessage());
                    }
                } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(transformAlgo)) {
                    exclTransformToBeAdded = true;
                } else {
                    transform = signatureFactory.newTransform(transformAlgo, (TransformParameterSpec)null);
                }
                if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(transformAlgo)) continue;
                transformList.add(transform);
            }
            String targetURI = "";
            String signatureType = signatureTarget.getType();
            SOAPMessage msg = secureMessage.getSOAPMessage();
            if (signatureType.equals("qname") || signatureType.equals("xpath")) {
                String expr = null;
                NodeList nodes = null;
                if (signatureType == "qname") {
                    String targetValue = signatureTarget.getValue();
                    boolean optimized = false;
                    if (fpContext.getConfigType() == MessageConstants.SIGN_BODY || fpContext.getConfigType() == MessageConstants.SIGN_ENCRYPT_BODY) {
                        optimized = true;
                    }
                    if (targetValue.equals("{http://schemas.xmlsoap.org/soap/envelope/}Body") && optimized) {
                        Reference ref = new JAXWSDigestProcessor(fpContext, signatureTarget, digestMethod, signatureFactory).handleJAXWSSOAPBody();
                        references.add(ref);
                        continue;
                    }
                    if (targetValue.equals("{http://schemas.xmlsoap.org/soap/envelope/}Body")) {
                        try {
                            SOAPBody se = msg.getSOAPBody();
                            nodes = new NodeList((SOAPElement)se){
                                Node node;
                                private final /* synthetic */ SOAPElement val$se;
                                {
                                    this.val$se = sOAPElement;
                                    this.node = this.val$se;
                                }

                                public int getLength() {
                                    if (this.node == null) {
                                        return 0;
                                    }
                                    return 1;
                                }

                                public Node item(int num) {
                                    if (num == 0) {
                                        return this.node;
                                    }
                                    return null;
                                }
                            };
                        }
                        catch (SOAPException se) {
                            throw new XWSSecurityException("SignatureTarget with URI " + targetValue + " is not in the message");
                        }
                    } else {
                        QName name = QName.valueOf(targetValue);
                        nodes = "".equals(name.getNamespaceURI()) ? msg.getSOAPPart().getElementsByTagName(name.getLocalPart()) : msg.getSOAPPart().getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
                    }
                } else {
                    expr = signatureTarget.getValue();
                    try {
                        XPathFactory xpathFactory = XPathFactory.newInstance();
                        XPath xpath = xpathFactory.newXPath();
                        xpath.setNamespaceContext(secureMessage.getNamespaceContext());
                        XPathExpression xpathExpr = xpath.compile(expr);
                        nodes = (NodeList)xpathExpr.evaluate(secureMessage.getSOAPPart(), XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException xpe) {
                        logger.log(Level.FINEST, "Error occurred whileresolving XPATH expression" + expr, xpe);
                        throw new XWSSecurityException(xpe);
                    }
                }
                int i = 0;
                if (nodes == null || nodes.getLength() <= 0) {
                    throw new XWSSecurityException("SignatureTarget with URI " + signatureTarget.getValue() + " is not in the message");
                }
                HashMap elementCache = null;
                if (fpContext != null) {
                    elementCache = fpContext.getElementCache();
                }
                while (i < nodes.getLength()) {
                    Node nodeRef;
                    if ((nodeRef = nodes.item(i++)).getNodeType() != 1) {
                        throw new XWSSecurityException("XPath does not correspond to a DOM Element");
                    }
                    if (exclTransformToBeAdded) {
                        String transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                        ExcC14NParameterSpec spec = new ExcC14NParameterSpec(WSSPolicyConsumerImpl.getReferenceNamespacePrefixes(nodeRef));
                        Transform transform = signatureFactory.newTransform(transformAlgo, spec);
                        transformList.add(transform);
                    }
                    boolean w3cElem = false;
                    String id = ((Element)nodeRef).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (!(id != null && !id.equals("") || nodeRef.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#" && nodeRef.getNamespaceURI() != "http://www.w3.org/2001/04/xmlenc#")) {
                        w3cElem = true;
                        id = ((Element)nodeRef).getAttribute("Id");
                    }
                    if (id == null || id.equals("")) {
                        id = secureMessage.generateId();
                        if (!verify) {
                            if (w3cElem) {
                                XMLUtil.setIdAttr((Element)nodeRef, id);
                            } else {
                                XMLUtil.setWsuIdAttr((Element)nodeRef, id);
                            }
                        } else {
                            elementCache.put(id, nodeRef);
                        }
                    }
                    targetURI = "#" + id;
                }
            } else if (signatureType == "uri") {
                targetURI = signatureTarget.getValue();
                if (targetURI == null) {
                    targetURI = "";
                }
                if (targetURI == "cid:*") {
                    Iterator itr = secureMessage.getAttachments();
                    if (!itr.hasNext()) {
                        throw new XWSSecurityException("No attachment present in the message");
                    }
                    while (itr.hasNext()) {
                        int sindex;
                        AttachmentPart ap = (AttachmentPart)itr.next();
                        String _cid = ap.getContentId();
                        int lindex = _cid.lastIndexOf(62);
                        if (lindex < (sindex = _cid.indexOf(60)) || lindex == sindex) {
                            logger.log(Level.SEVERE, "WSS1303.cid_error");
                        }
                        String cid = "cid:" + _cid.substring(sindex + 1, lindex);
                        Reference reference = signatureFactory.newReference(cid, digestMethod, transformList, null, null);
                        references.add(reference);
                    }
                    continue;
                }
                if (exclTransformToBeAdded) {
                    SOAPElement dataElement = null;
                    try {
                        String _uri = targetURI;
                        if (targetURI.length() > 0 && targetURI.charAt(0) == '#') {
                            _uri = targetURI.substring(1);
                        }
                        dataElement = (SOAPElement)XMLUtil.getElementById((Document)secureMessage.getSOAPPart(), _uri);
                    }
                    catch (TransformerException te) {
                        throw new XWSSecurityException(te.getMessage(), te);
                    }
                    String transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                    ExcC14NParameterSpec spec = null;
                    if (dataElement != null) {
                        spec = new ExcC14NParameterSpec(WSSPolicyConsumerImpl.getReferenceNamespacePrefixes((Node)dataElement));
                    }
                    Transform transform = signatureFactory.newTransform(transformAlgo, spec);
                    transformList.add(transform);
                }
            }
            byte[] digestValue = fpContext.getDigestValue();
            Reference reference = null;
            reference = !verify && digestValue != null ? signatureFactory.newReference(targetURI, digestMethod, transformList, null, null, digestValue) : signatureFactory.newReference(targetURI, digestMethod, transformList, null, null);
            references.add(reference);
        }
        return references;
    }

    public URIDereferencer getDefaultResolver() {
        if (this.externalURIResolver == null) {
            this.externalURIResolver = this.getSignatureFactory().getURIDereferencer();
        }
        return this.externalURIResolver;
    }

    public static void printDocument(Node node) {
        try {
            logger.log(Level.FINEST, "\n");
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(node), new StreamResult(baos));
            byte[] bytes = baos.toByteArray();
            logger.log(Level.FINEST, new String(bytes));
            logger.log(Level.FINEST, "\n");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public class JAXWSDigestProcessor {
        FilterProcessingContext fpContext = null;
        SignatureTarget target = null;
        DigestMethod dm = null;
        XMLSignatureFactory signatureFactory = null;
        String targetURI = "";
        SOAPMessage msg = null;

        JAXWSDigestProcessor(FilterProcessingContext fc, SignatureTarget st, DigestMethod dm, XMLSignatureFactory sf) {
            this.fpContext = fc;
            this.target = st;
            this.dm = dm;
            this.signatureFactory = sf;
            this.msg = this.fpContext.getSOAPMessage();
        }

        public Reference handleJAXWSSOAPBody() throws XWSSecurityException {
            try {
                SOAPBody body = ((ExpressMessage)this.msg).getEMBody();
                int optCase = this.fpContext.getConfigType();
                switch (optCase) {
                    case 1: {
                        this.signBody(body);
                        break;
                    }
                    case 2: {
                        this.signEncryptBody(body);
                        break;
                    }
                    default: {
                        throw new XWSSecurityException("Invalid configuration option");
                    }
                }
                ArrayList transforms = this.target.getTransforms();
                ListIterator transformIterator = transforms.listIterator();
                ArrayList<Transform> transformList = new ArrayList<Transform>(1);
                String transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                String algo = this.dm.getAlgorithm();
                MessageDigest digester = null;
                if (algo == "http://www.w3.org/2000/09/xmldsig#sha1") {
                    digester = MessageDigest.getInstance("SHA");
                }
                JAXWSMessage jxm = ((ExpressMessage)this.msg).getJAXWSMessage();
                byte[] canonData = jxm.getCanonicalizedBody();
                int len = jxm.getCBLength();
                if (MessageConstants.SIGN_ENCRYPT_BODY == optCase) {
                    byte[] data = null;
                    jxm.setCanonicalizedBody(data, 0);
                }
                digester.update(canonData, 0, len);
                byte[] digestValue = digester.digest();
                TransformParameterSpec spec = null;
                Transform transform = this.signatureFactory.newTransform(transformAlgo, spec);
                transformList.add(transform);
                Reference reference = this.signatureFactory.newReference(this.targetURI, this.dm, transformList, null, null, digestValue);
                return reference;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void signBody(SOAPBody body) throws IOException, XMLStreamException, XWSSecurityException, SOAPException {
            StAXEXC14nCanonicalizerImpl canonicalizer = new StAXEXC14nCanonicalizerImpl();
            UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
            canonicalizer.setStream(baos);
            JAXWSMessage jxm = ((ExpressMessage)this.msg).getJAXWSMessage();
            this.cBodyTag(canonicalizer, body);
            if (!jxm.isBodyUsed()) {
                jxm.writeJAXWSBody((XMLStreamWriter)canonicalizer);
            }
            canonicalizer.writeEndDocument();
            byte[] data = baos.getBytes();
            jxm.setCanonicalizedBody(data, baos.getLength());
        }

        private void signEncryptBody(SOAPBody body) throws IOException, XMLStreamException, XWSSecurityException, SOAPException {
            StAXEXC14nCanonicalizerImpl canonicalizer = new StAXEXC14nCanonicalizerImpl();
            UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
            canonicalizer.setStream(baos);
            JAXWSMessage jxm = ((ExpressMessage)this.msg).getJAXWSMessage();
            this.cBodyTag(canonicalizer, body);
            canonicalizer.writeCharacters("");
            byte[] bodyTag = baos.toByteArray();
            baos.reset();
            if (!jxm.isBodyUsed()) {
                jxm.writeJAXWSBody((XMLStreamWriter)canonicalizer);
            }
            byte[] bodyContent = baos.toByteArray();
            baos.reset();
            canonicalizer.writeEndDocument();
            byte[] endTag = baos.getBytes();
            byte[] canonicalizedData = new byte[bodyTag.length + bodyContent.length + baos.getLength()];
            System.arraycopy(bodyTag, 0, canonicalizedData, 0, bodyTag.length);
            System.arraycopy(bodyContent, 0, canonicalizedData, bodyTag.length, bodyContent.length);
            System.arraycopy(endTag, 0, canonicalizedData, bodyTag.length + bodyContent.length, baos.getLength());
            jxm.setCanonicalizedBody(canonicalizedData, canonicalizedData.length);
            this.fpContext.setCanonicalizedData(bodyContent);
        }

        private void cBodyTag(XMLStreamWriter canonicalizer, SOAPBody body) throws IOException, XMLStreamException, XWSSecurityException, SOAPException {
            Attr attr;
            String id = body.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (!(id != null && id.length() != 0 || body.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#" && body.getNamespaceURI() != "http://www.w3.org/2001/04/xmlenc#")) {
                id = body.getAttribute("Id");
            }
            if (id == null || id.equals("")) {
                id = this.fpContext.getSecurableSoapMessage().generateId();
                XMLUtil.setWsuIdAttr((Element)body, id);
            }
            this.targetURI = "#" + id;
            NamedNodeMap nodes = body.getAttributes();
            Vector<Attr> attrs = new Vector<Attr>();
            Vector<Attr> attrsNS = new Vector<Attr>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Attr attr2 = (Attr)nodes.item(i);
                if (attr2.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    attrsNS.add(attr2);
                    continue;
                }
                attrs.add(attr2);
            }
            SOAPEnvelope env = this.msg.getSOAPPart().getEnvelope();
            NamedNodeMap parentAttrs = env.getAttributes();
            for (int i = 0; i < parentAttrs.getLength(); ++i) {
                attr = (Attr)parentAttrs.item(i);
                if (!attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                canonicalizer.writeNamespace(attr.getLocalName(), attr.getValue());
            }
            canonicalizer.writeStartDocument();
            canonicalizer.writeStartElement(body.getPrefix(), body.getLocalName(), body.getNamespaceURI());
            Iterator nsItr = attrsNS.iterator();
            while (nsItr.hasNext()) {
                attr = (Attr)nsItr.next();
                canonicalizer.writeNamespace(attr.getLocalName(), attr.getValue());
            }
            Iterator attrItr = attrs.iterator();
            while (attrItr.hasNext()) {
                Attr attr3 = (Attr)attrItr.next();
                canonicalizer.writeAttribute(attr3.getPrefix(), attr3.getNamespaceURI(), attr3.getLocalName(), attr3.getValue());
            }
        }
    }

    public final class WSSProvider
    extends Provider {
        private static final String INFO = "WSS_TRANSFORM (DOM WSS_TRANSFORM_PROVIDER)";

        public WSSProvider() {
            super("WSS_TRANSFORM", 1.0, INFO);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete-Transform", "com.sun.xml.wss.impl.transform.ACTransform");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete-Transform MechanismType", "DOM");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "com.sun.xml.wss.impl.transform.DOMSTRTransform");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform MechanismType", "DOM");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform", "com.sun.xml.wss.impl.transform.ACOTransform");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform MechanismType", "DOM");
            this.putAll((Map<?, ?>)map);
        }
    }
}

