/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionUtil;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportSamlAssertionFilter {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        Assertion samlAssertion = null;
        SOAPElement samlElement = null;
        if (context.getMode() == 0) {
            NodeList nl = wsseSecurity.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
            int nodeListLength = nl.getLength();
            if (nodeListLength == 0) {
                throw new XWSSecurityException("No SAML Assertion found, Reciever requirement not met");
            }
            if (nodeListLength > 1) {
                throw new XWSSecurityException("More than one SAML Assertion found, Reciever requirement not met");
            }
            samlElement = (SOAPElement)nl.item(0);
            try {
                samlAssertion = AssertionUtil.fromElement((Element)samlElement);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0418.saml.import.exception");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception while importing SAML Token", e);
            }
            AuthenticationTokenPolicy policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
            AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.getFeatureBinding();
            if (!"".equals(samlPolicy.getAuthorityIdentifier()) && !samlPolicy.getAuthorityIdentifier().equals(samlAssertion.getIssuer())) {
                XWSSecurityException xwse = new XWSSecurityException("Invalid Assertion Issuer, expected " + samlPolicy.getAuthorityIdentifier() + ", found " + samlAssertion.getIssuer());
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Received SAML Assertion has invalid Issuer", xwse);
            }
        } else {
            if (context.getMode() == 1) {
                throw new XWSSecurityException("Internal Error: Called ImportSAMLAssertionFilter in POSTHOC Mode");
            }
            try {
                samlAssertion = AssertionUtil.fromElement((Element)wsseSecurity.getCurrentHeaderElement());
            }
            catch (Exception ex) {
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Exception while importing SAML Assertion", ex);
            }
        }
        HashMap tokenCache = context.getTokenCache();
        tokenCache.put(samlAssertion.getAssertionID(), samlAssertion);
        String confirmationMethod = AssertionUtil.getConfirmationMethod((Element)samlElement);
        if (!"urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(confirmationMethod)) {
            XWSSecurityException xwse = new XWSSecurityException("Invalid ConfirmationMethod " + confirmationMethod);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Invalid ConfirmationMethod", xwse);
        }
        context.getSecurityEnvironment().validateSAMLAssertion(context.getExtraneousProperties(), (Element)samlElement);
        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), samlAssertion);
    }
}

