/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSFeatureBindingExtension;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.security.cert.CertPath;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.w3c.dom.Element;

public class AuthenticationTokenPolicy
extends WSSFeatureBindingExtension {
    public AuthenticationTokenPolicy() {
        this.setPolicyIdentifier("AuthenticationTokenPolicy");
    }

    public boolean equals(WSSPolicy policy) {
        boolean _assert = false;
        try {
            if (!PolicyTypeUtil.authenticationTokenPolicy(policy)) {
                return false;
            }
            AuthenticationTokenPolicy aPolicy = (AuthenticationTokenPolicy)policy;
            _assert = ((WSSPolicy)this.getFeatureBinding()).equals((WSSPolicy)aPolicy.getFeatureBinding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _assert;
    }

    public boolean equalsIgnoreTargets(WSSPolicy policy) {
        return this.equals(policy);
    }

    public Object clone() {
        AuthenticationTokenPolicy atPolicy = new AuthenticationTokenPolicy();
        try {
            WSSPolicy fBinding = (WSSPolicy)this.getFeatureBinding();
            WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
            if (fBinding != null) {
                atPolicy.setFeatureBinding((MLSPolicy)fBinding.clone());
            }
            if (kBinding != null) {
                atPolicy.setKeyBinding((MLSPolicy)kBinding.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return atPolicy;
    }

    public String getType() {
        return "AuthenticationTokenPolicy";
    }

    public static class SAMLAssertionBinding
    extends WSSPolicy {
        String _type = "";
        String _keyAlgorithm = "";
        String _keyIdentifier = "";
        String _referenceType = "";
        String _authorityIdentifier = "";
        String strId = null;
        String assertionId = null;
        public static final String SV_ASSERTION = "SV";
        public static final String HOK_ASSERTION = "HOK";
        Element _assertion = null;
        Element _authorityBinding = null;

        public SAMLAssertionBinding() {
            this.setPolicyIdentifier("SAMLAssertionBinding");
        }

        public SAMLAssertionBinding(String type, String keyIdentifier, String authorityIdentifier, String referenceType) {
            this();
            this._type = type;
            this._keyIdentifier = keyIdentifier;
            this._authorityIdentifier = authorityIdentifier;
            this._referenceType = referenceType;
        }

        public void setAssertionType(String type) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAMLAssertionType : Policy is ReadOnly");
            }
            if (SV_ASSERTION.equals(type)) {
                this._type = SV_ASSERTION;
            } else if (HOK_ASSERTION.equals(type)) {
                this._type = HOK_ASSERTION;
            }
        }

        public MLSPolicy newPrivateKeyBinding() {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create PrivateKeyBinding : Policy is Readonly");
            }
            this._keyBinding = new PrivateKeyBinding();
            return this._keyBinding;
        }

        public void setKeyIdentifier(String ki) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML KeyIdentifier : Policy is ReadOnly");
            }
            this._keyIdentifier = ki;
        }

        public void setAuthorityIdentifier(String uri) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML AuthorityIdentifier : Policy is ReadOnly");
            }
            this._authorityIdentifier = uri;
        }

        public void setReferenceType(String rtype) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML ReferenceType : Policy is ReadOnly");
            }
            this._referenceType = rtype;
        }

        public void setAuthorityBinding(Element authorityBinding) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML AuthorityBinding : Policy is ReadOnly");
            }
            this._authorityBinding = authorityBinding;
        }

        public void setAssertion(Element assertion) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML Assertion : Policy is ReadOnly");
            }
            this._assertion = assertion;
        }

        public void setKeyAlgorithm(String algorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set KeyAlgorithm : Policy is ReadOnly");
            }
            this._keyAlgorithm = algorithm;
        }

        public String getKeyAlgorithm() {
            return this._keyAlgorithm;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public String getAssertionType() {
            return this._type;
        }

        public String getKeyIdentifier() {
            return this._keyIdentifier;
        }

        public String getAuthorityIdentifier() {
            return this._authorityIdentifier;
        }

        public Element getAuthorityBinding() {
            return this._authorityBinding;
        }

        public Element getAssertion() {
            return this._assertion;
        }

        public boolean equals(WSSPolicy policy) {
            try {
                boolean b8;
                boolean b7;
                boolean b6;
                boolean b3;
                boolean b2;
                boolean b1;
                if (!PolicyTypeUtil.samlTokenPolicy(policy)) {
                    return false;
                }
                SAMLAssertionBinding sBinding = (SAMLAssertionBinding)policy;
                boolean bl = b1 = this._type.equals("") ? true : this._type.equals(sBinding.getAssertionType());
                if (!b1) {
                    return false;
                }
                boolean bl2 = b2 = this._authorityIdentifier.equals("") ? true : this._authorityIdentifier.equals(sBinding.getAuthorityIdentifier());
                if (!b2) {
                    return false;
                }
                boolean bl3 = b3 = this._referenceType.equals("") ? true : this._referenceType.equals(sBinding.getReferenceType());
                if (!b3) {
                    return false;
                }
                boolean bl4 = b6 = this._keyAlgorithm.equals("") ? true : this._keyAlgorithm.equals(sBinding.getKeyAlgorithm());
                if (!b6) {
                    return false;
                }
                boolean bl5 = b7 = this.strId == null ? true : this.strId.equals(sBinding.getSTRID());
                if (!b7) {
                    return false;
                }
                boolean bl6 = b8 = this.assertionId == null ? true : this.assertionId.equals(sBinding.getAssertionId());
                if (!b8) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public boolean equalsIgnoreTargets(WSSPolicy binding) {
            return this.equals(binding);
        }

        public Object clone() {
            SAMLAssertionBinding samlBinding = new SAMLAssertionBinding();
            try {
                samlBinding.setAssertionType(this._type);
                samlBinding.setKeyAlgorithm(this._keyAlgorithm);
                samlBinding.setKeyIdentifier(this._keyIdentifier);
                samlBinding.setReferenceType(this._referenceType);
                samlBinding.setAuthorityIdentifier(this._authorityIdentifier);
                samlBinding.setAssertion(this._assertion);
                samlBinding.setAuthorityBinding(this._authorityBinding);
                samlBinding.setSTRID(this.strId);
                samlBinding.setAssertionId(this.assertionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return samlBinding;
        }

        public String getType() {
            return "SAMLAssertionBinding";
        }

        public void setSTRID(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML STRID : Policy is ReadOnly");
            }
            this.strId = id;
        }

        public String getSTRID() {
            return this.strId;
        }

        public void setAssertionId(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML AssertionID : Policy is ReadOnly");
            }
            this.assertionId = id;
        }

        public String getAssertionId() {
            return this.assertionId;
        }

        public String toString() {
            return "SAMLAssertionBinding::" + this.getReferenceType() + "::" + this._type;
        }
    }

    public static class UsernameTokenBinding
    extends WSSPolicy {
        String nonce = MessageConstants._EMPTY;
        String username = MessageConstants._EMPTY;
        String password = MessageConstants._EMPTY;
        boolean useNonce = true;
        boolean doDigest = true;
        long maxNonceAge = 0L;

        public UsernameTokenBinding() {
            this.setPolicyIdentifier("UsernameTokenBinding");
        }

        public UsernameTokenBinding(String username, String password, String nonce, boolean doDigest, String creationTime) {
            this();
            this.username = username;
            this.password = password;
            this.nonce = nonce;
            this.doDigest = doDigest;
        }

        public MLSPolicy newTimestampFeatureBinding() throws PolicyGenerationException {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create a feature binding of Timestamp type for ReadOnly " + this._policyIdentifier);
            }
            if (this._policyIdentifier != "UsernameTokenBinding" && this._policyIdentifier != "SignaturePolicy.FeatureBinding") {
                throw new PolicyGenerationException("Can not create a feature binding of Timestamp type for " + this._policyIdentifier);
            }
            this._featureBinding = new TimestampPolicy();
            return this._featureBinding;
        }

        public void setUsername(String username) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set Username : Policy is ReadOnly");
            }
            this.username = username;
        }

        public void setPassword(String password) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set Password : Policy is ReadOnly");
            }
            this.password = password;
        }

        public void setNonce(String nonce) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set Nonce : Policy is ReadOnly");
            }
            this.nonce = nonce;
        }

        public void setUseNonce(boolean useNonce) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set useNonce flag : Policy is ReadOnly");
            }
            this.useNonce = useNonce;
        }

        public void setDigestOn(boolean doDigest) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set digest flag : Policy is ReadOnly");
            }
            this.doDigest = doDigest;
        }

        public void setMaxNonceAge(long nonceAge) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set maxNonceAge flag : Policy is ReadOnly");
            }
            this.maxNonceAge = nonceAge;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getNonce() {
            return this.nonce;
        }

        public boolean getUseNonce() {
            return this.useNonce;
        }

        public boolean getDigestOn() {
            return this.doDigest;
        }

        public long getMaxNonceAge() {
            return this.maxNonceAge;
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                if (!PolicyTypeUtil.usernameTokenPolicy(policy)) {
                    return false;
                }
                UsernameTokenBinding utBinding = (UsernameTokenBinding)policy;
                assrt = this.useNonce == utBinding.getUseNonce() && this.doDigest == utBinding.getDigestOn();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return assrt;
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return this.equals(policy);
        }

        public Object clone() {
            UsernameTokenBinding utBinding = new UsernameTokenBinding();
            utBinding.setUsername(this.username);
            utBinding.setPassword(this.password);
            utBinding.setNonce(this.nonce);
            utBinding.setUseNonce(this.useNonce);
            utBinding.setDigestOn(this.doDigest);
            utBinding.setUUID(this.UUID);
            return utBinding;
        }

        public String getType() {
            return "UsernameTokenBinding";
        }

        public String toString() {
            return "UsernameTokenBinding::" + this.getUsername();
        }
    }

    public static class X509CertificateBinding
    extends WSSPolicy {
        String _valueType = MessageConstants._EMPTY;
        String _encodingType = MessageConstants._EMPTY;
        String _referenceType = MessageConstants._EMPTY;
        X509CRL _crl = null;
        CertPath _certPath = null;
        X509Certificate _certificate = null;
        String _keyAlgorithm = MessageConstants._EMPTY;
        String _certificateIdentifier = "";
        String strId = null;

        public X509CertificateBinding() {
            this.setPolicyIdentifier("X509CertificateBinding");
        }

        public X509CertificateBinding(String certificateIdentifier, String keyAlgorithm) {
            this();
            this._certificateIdentifier = certificateIdentifier;
            this._keyAlgorithm = keyAlgorithm;
        }

        public MLSPolicy newPrivateKeyBinding() {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create PrivateKeyBinding : Policy is Readonly");
            }
            this._keyBinding = new PrivateKeyBinding();
            return this._keyBinding;
        }

        public void setValueType(String valueType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ValueType of X509Certificate : Policy is ReadOnly");
            }
            this._valueType = valueType;
        }

        public void setEncodingType(String encodingType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set EncodingType of X509Certificate : Policy is ReadOnly");
            }
            this._encodingType = encodingType;
        }

        public void setReferenceType(String referenceType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ReferenceType of X509Certificate : Policy is ReadOnly");
            }
            this._referenceType = referenceType;
        }

        public void setCertificateIdentifier(String certificateIdentifier) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set X509Certificate Identifier : Policy is ReadOnly");
            }
            this._certificateIdentifier = certificateIdentifier;
        }

        public void setX509Certificate(X509Certificate certificate) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set X509Certificate : Policy is ReadOnly");
            }
            this._certificate = certificate;
        }

        public String getValueType() {
            return this._valueType;
        }

        public String getEncodingType() {
            return this._encodingType;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public String getCertificateIdentifier() {
            return this._certificateIdentifier;
        }

        public X509Certificate getX509Certificate() {
            return this._certificate;
        }

        public void setKeyAlgorithm(String keyAlgorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set KeyAlgorithm : Policy is ReadOnly");
            }
            this._keyAlgorithm = keyAlgorithm;
        }

        public String getKeyAlgorithm() {
            return this._keyAlgorithm;
        }

        public void setSTRID(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set STRID attribute : Policy is ReadOnly");
            }
            this.strId = id;
        }

        public String getSTRID() {
            return this.strId;
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                boolean b4;
                boolean b3;
                boolean b2;
                boolean b1;
                if (!PolicyTypeUtil.x509CertificateBinding(policy)) {
                    return false;
                }
                X509CertificateBinding ctBinding = (X509CertificateBinding)policy;
                boolean bl = b1 = this._valueType.equals("") ? true : this._valueType.equals(ctBinding.getValueType());
                if (!b1) {
                    return false;
                }
                boolean bl2 = b2 = this._encodingType.equals("") ? true : this._encodingType.equals(ctBinding.getEncodingType());
                if (!b2) {
                    return false;
                }
                boolean bl3 = b3 = this._referenceType.equals("") ? true : this._referenceType.equals(ctBinding.getReferenceType());
                if (!b3) {
                    return false;
                }
                boolean bl4 = b4 = this._keyAlgorithm.equals("") ? true : this._keyAlgorithm.equals(ctBinding.getKeyAlgorithm());
                if (!b4) {
                    return false;
                }
                if (this.strId == null && ctBinding.getSTRID() == null) {
                    return true;
                }
                if (this.strId != null && this.strId.equals(ctBinding.getSTRID())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return this.equals(policy);
        }

        public Object clone() {
            X509CertificateBinding x509Binding = new X509CertificateBinding();
            try {
                x509Binding.setValueType(this._valueType);
                x509Binding.setEncodingType(this._encodingType);
                x509Binding.setReferenceType(this._referenceType);
                x509Binding.setKeyAlgorithm(this._keyAlgorithm);
                x509Binding.setCertificateIdentifier(this._certificateIdentifier);
                x509Binding.setX509Certificate(this._certificate);
                x509Binding.setUUID(this.UUID);
                x509Binding.setSTRID(this.strId);
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                if (kBinding != null) {
                    x509Binding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return x509Binding;
        }

        public String getType() {
            return "X509CertificateBinding";
        }

        public String toString() {
            return "X509CertificateBinding::" + this.getCertificateIdentifier() + "::" + this.strId + "::" + this._referenceType;
        }
    }
}

