/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.processor.config.WSDLModelInfo;
import com.sun.tools.ws.spi.TooltimeModule;
import com.sun.tools.ws.util.xml.NullEntityResolver;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wsdl.document.Binding;
import com.sun.tools.ws.wsdl.document.BindingFault;
import com.sun.tools.ws.wsdl.document.BindingInput;
import com.sun.tools.ws.wsdl.document.BindingOperation;
import com.sun.tools.ws.wsdl.document.BindingOutput;
import com.sun.tools.ws.wsdl.document.Definitions;
import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.Fault;
import com.sun.tools.ws.wsdl.document.Import;
import com.sun.tools.ws.wsdl.document.Input;
import com.sun.tools.ws.wsdl.document.Message;
import com.sun.tools.ws.wsdl.document.MessagePart;
import com.sun.tools.ws.wsdl.document.Operation;
import com.sun.tools.ws.wsdl.document.OperationStyle;
import com.sun.tools.ws.wsdl.document.Output;
import com.sun.tools.ws.wsdl.document.Port;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.tools.ws.wsdl.document.Service;
import com.sun.tools.ws.wsdl.document.Types;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.WSDLDocument;
import com.sun.tools.ws.wsdl.document.schema.SchemaConstants;
import com.sun.tools.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.Extensible;
import com.sun.tools.ws.wsdl.framework.ParseException;
import com.sun.tools.ws.wsdl.framework.ParserContext;
import com.sun.tools.ws.wsdl.framework.ParserListener;
import com.sun.tools.ws.wsdl.parser.ExtensionHandler;
import com.sun.tools.ws.wsdl.parser.HTTPExtensionHandler;
import com.sun.tools.ws.wsdl.parser.Internalizer;
import com.sun.tools.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import com.sun.tools.ws.wsdl.parser.MIMEExtensionHandler;
import com.sun.tools.ws.wsdl.parser.SOAP12ExtensionHandler;
import com.sun.tools.ws.wsdl.parser.SOAPExtensionHandler;
import com.sun.tools.ws.wsdl.parser.SchemaExtensionHandler;
import com.sun.tools.ws.wsdl.parser.Util;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.ModuleFinder;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLParser {
    private WSDLModelInfo modelInfo;
    private EntityResolver entityResolver;
    private final Set<String> imports = new HashSet<String>();
    private final Map<String, Document> wsdlDocuments = new HashMap<String, Document>();
    private List _elements = new ArrayList();
    private boolean _followImports;
    private String _targetNamespaceURI;
    private Map _extensionHandlers;
    private ArrayList _listeners;
    private boolean _useWSIBasicProfile = true;
    private LocalizableMessageFactory _messageFactory = new LocalizableMessageFactory("com.sun.tools.ws.resources.wsdl");
    private Localizer _localizer = new Localizer();
    private HashSet hSet = null;

    private WSDLParser() {
        this._extensionHandlers = new HashMap();
        this.hSet = new HashSet();
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
        this.register(new JAXWSBindingExtensionHandler());
        this.register(new SOAP12ExtensionHandler());
        List<Object> modules = ModuleFinder.findTooltimeModules();
        for (Object obj : modules) {
            if (!(obj instanceof TooltimeModule)) {
                this.warn("tooltime.module.ignore", new Object[]{obj.getClass().getName()});
                continue;
            }
            this.register(((TooltimeModule)obj).getExtensionHandler());
        }
    }

    public WSDLParser(WSDLModelInfo modelInfo) {
        this();
        assert (modelInfo != null);
        this.modelInfo = modelInfo;
        this.entityResolver = modelInfo.getEntityResolver();
    }

    public void register(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), h);
        h.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), null);
        h.setExtensionHandlers(null);
    }

    public void unregister(String uri) {
        this._extensionHandlers.put(uri, null);
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean b) {
        this._followImports = b;
    }

    public void addParserListener(ParserListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(l);
    }

    public void removeParserListener(ParserListener l) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(l);
    }

    public WSDLDocument parse() {
        String location = this.modelInfo.getLocation();
        assert (location != null);
        this._messageFactory = new LocalizableMessageFactory("com.sun.tools.ws.resources.wsdl");
        this._localizer = new Localizer();
        WSDLDocument document = new WSDLDocument();
        InputSource source = null;
        String wsdlLoc = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(location));
        if (this.entityResolver != null) {
            try {
                source = this.entityResolver.resolveEntity(null, wsdlLoc);
            }
            catch (SAXException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.saxException", e);
            }
            catch (IOException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.ioException", e);
            }
        }
        if (source == null) {
            source = new InputSource(wsdlLoc);
        }
        document.setSystemId(wsdlLoc);
        ParserContext context = new ParserContext(document, this._listeners);
        context.setFollowImports(this._followImports);
        document.setDefinitions(this.parseDefinitions(context, source, null));
        return document;
    }

    protected Definitions parseDefinitions(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
        context.pushWSDLLocation();
        context.setWSDLLocation(context.getDocument().getSystemId());
        String sysId = context.getDocument().getSystemId();
        this.buildDocumentFromWSDL(sysId, source, expectedTargetNamespaceURI);
        Document root = this.wsdlDocuments.get(sysId);
        new Internalizer().transform(this.modelInfo.getJAXWSBindings(), this.wsdlDocuments, this.modelInfo.getParent().getEnvironment());
        Definitions definitions = this.parseDefinitionsNoImport(context, root, expectedTargetNamespaceURI);
        this.processImports(context, source, definitions);
        context.popWSDLLocation();
        return definitions;
    }

    private void buildDocumentFromWSDL(String systemId, InputSource source, String expectedTargetNamespaceURI) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                }
            });
            if (this.entityResolver != null) {
                builder.setEntityResolver(this.entityResolver);
            } else {
                builder.setEntityResolver(new NullEntityResolver());
            }
            try {
                Element e2;
                Document document = builder.parse(source);
                this.wsdlDocuments.put(systemId, document);
                Element e = document.getDocumentElement();
                Util.verifyTagNSRootElement(e, WSDLConstants.QNAME_DEFINITIONS);
                String name = XmlUtil.getAttributeOrNull(e, "name");
                String _targetNamespaceURI = XmlUtil.getAttributeOrNull(e, "targetNamespace");
                if (expectedTargetNamespaceURI == null || !expectedTargetNamespaceURI.equals(_targetNamespaceURI)) {
                    // empty if block
                }
                Iterator iter = XmlUtil.getAllChildren(e);
                while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                    if (!XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_IMPORT)) continue;
                    String namespace = Util.getRequiredAttribute(e2, "namespace");
                    String location = Util.getRequiredAttribute(e2, "location");
                    if ((location = this.getAdjustedLocation(source, location)) == null || location.equals("") || this.imports.contains(location)) continue;
                    this.imports.add(location);
                    InputSource impSource = null;
                    if (this.entityResolver != null) {
                        impSource = this.entityResolver.resolveEntity(null, location);
                    }
                    if (impSource == null) {
                        impSource = new InputSource(location);
                    }
                    this.buildDocumentFromWSDL(location, impSource, namespace);
                }
            }
            catch (IOException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.ioException", e);
            }
            catch (SAXException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.saxException", e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("parsing.parserConfigException", e);
        }
        catch (FactoryConfigurationError e) {
            throw new ParseException("parsing.factoryConfigException", e);
        }
    }

    private String getAdjustedLocation(InputSource source, String location) {
        return source.getSystemId() == null ? location : Util.processSystemIdWithBase(source.getSystemId(), location);
    }

    public void dump(OutputStream out) throws IOException {
        try {
            Transformer it = XmlUtil.newTransformer();
            for (Map.Entry<String, Document> e : this.wsdlDocuments.entrySet()) {
                out.write(("---<< " + e.getKey() + "\n").getBytes());
                it.transform(new DOMSource(e.getValue()), new StreamResult(out));
                out.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    protected void processImports(ParserContext context, InputSource source, Definitions definitions) {
        for (String location : this.imports) {
            Definitions importedDefinitions;
            if (context.getDocument().isImportedDocument(location) || (importedDefinitions = this.parseDefinitionsNoImport(context, this.wsdlDocuments.get(location), location)) == null) continue;
            context.getDocument().addImportedEntity(importedDefinitions);
            context.getDocument().addImportedDocument(location);
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                }
            });
            builder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = builder.parse(source);
                return this.parseDefinitionsNoImport(context, document, expectedTargetNamespaceURI);
            }
            catch (IOException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.ioException", e);
            }
            catch (SAXException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.saxException", e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("parsing.parserConfigException", e);
        }
        catch (FactoryConfigurationError e) {
            throw new ParseException("parsing.factoryConfigException", e);
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext context, Document doc, String expectedTargetNamespaceURI) {
        this._targetNamespaceURI = null;
        Element root = doc.getDocumentElement();
        Util.verifyTagNSRootElement(root, WSDLConstants.QNAME_DEFINITIONS);
        return this.parseDefinitionsNoImport(context, root, expectedTargetNamespaceURI);
    }

    protected Definitions parseDefinitionsNoImport(ParserContext context, Element e, String expectedTargetNamespaceURI) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Definitions definitions = new Definitions(context.getDocument());
        String name = XmlUtil.getAttributeOrNull(e, "name");
        definitions.setName(name);
        this._targetNamespaceURI = XmlUtil.getAttributeOrNull(e, "targetNamespace");
        definitions.setTargetNamespaceURI(this._targetNamespaceURI);
        boolean gotDocumentation = false;
        boolean gotTypes = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (definitions.getDocumentation() != null) continue;
                definitions.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_TYPES)) {
                if (gotTypes) {
                    Util.fail("parsing.onlyOneTypesAllowed", "definitions");
                }
                this.addSchemaElements(e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_MESSAGE)) {
                Message message = this.parseMessage(context, definitions, e2);
                definitions.add(message);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT_TYPE)) {
                PortType portType = this.parsePortType(context, definitions, e2);
                definitions.add(portType);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_BINDING)) {
                Binding binding = this.parseBinding(context, definitions, e2);
                definitions.add(binding);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_SERVICE)) {
                Service service = this.parseService(context, definitions, e2);
                definitions.add(service);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(context, definitions, e2));
                continue;
            }
            if (this._useWSIBasicProfile && XmlUtil.matchesTagNS(e2, SchemaConstants.QNAME_IMPORT)) {
                this.warn("warning.wsi.r2003");
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, definitions, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    protected Message parseMessage(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Message message = new Message(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        message.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                message.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PART)) {
                MessagePart part = this.parseMessagePart(context, e2);
                message.add(part);
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    protected MessagePart parseMessagePart(ParserContext context, Element e) {
        context.push();
        context.registerNamespaces(e);
        MessagePart part = new MessagePart();
        String partName = Util.getRequiredAttribute(e, "name");
        part.setName(partName);
        String elementAttr = XmlUtil.getAttributeOrNull(e, "element");
        String typeAttr = XmlUtil.getAttributeOrNull(e, "type");
        if (elementAttr != null) {
            if (typeAttr != null) {
                Util.fail("parsing.onlyOneOfElementOrTypeRequired", partName);
            }
            part.setDescriptor(context.translateQualifiedName(elementAttr));
            part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (typeAttr != null) {
            part.setDescriptor(context.translateQualifiedName(typeAttr));
            part.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            Util.fail("parsing.elementOrTypeRequired", partName);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PART, part);
        return part;
    }

    protected PortType parsePortType(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        PortType portType = new PortType(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        portType.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (portType.getDocumentation() != null) continue;
                portType.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                Operation op = this.parsePortTypeOperation(context, e2);
                portType.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, portType, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    protected Operation parsePortTypeOperation(ParserContext context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Operation operation = new Operation();
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        String parameterOrderAttr = XmlUtil.getAttributeOrNull(e, "parameterOrder");
        operation.setParameterOrder(parameterOrderAttr);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Element e3;
            Iterator iter2;
            boolean gotDocumentation2;
            Attr e32;
            String nameAttr;
            String messageAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (operation.getDocumentation() != null) continue;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                if (gotInput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                Input input = new Input();
                messageAttr = Util.getRequiredAttribute(e2, "message");
                input.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                input.setName(nameAttr);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                Iterator iter22 = XmlUtil.getAllAttributes(e2);
                while (iter22.hasNext()) {
                    e32 = (Attr)iter22.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, input, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                if (gotOutput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                Output output = new Output();
                messageAttr = Util.getRequiredAttribute(e2, "message");
                output.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                Iterator iter23 = XmlUtil.getAllAttributes(e2);
                while (iter23.hasNext()) {
                    e32 = (Attr)iter23.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, output, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                context.push();
                context.registerNamespaces(e2);
                Fault fault = new Fault();
                messageAttr = Util.getRequiredAttribute(e2, "message");
                fault.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                Iterator iter24 = XmlUtil.getAllAttributes(e2);
                while (iter24.hasNext()) {
                    e32 = (Attr)iter24.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, fault, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        if (fault.getDocumentation() != null) continue;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", name);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Binding parseBinding(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Binding binding = new Binding(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        binding.setName(name);
        String typeAttr = Util.getRequiredAttribute(e, "type");
        binding.setPortType(context.translateQualifiedName(typeAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                binding.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation op = this.parseBindingOperation(context, e2);
                binding.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, binding, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    protected BindingOperation parseBindingOperation(ParserContext context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        BindingOperation operation = new BindingOperation();
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Iterator iter2;
            String nameAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                Element e3;
                if (gotInput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", name});
                }
                Iterator itere2 = XmlUtil.getAllChildren(e2);
                Element ee = Util.nextElement(itere2);
                if (this.hSet.isEmpty()) {
                    this.hSet.add(ee.getAttribute("use"));
                } else if (!this.hSet.contains(ee.getAttribute("use")) && ee.getAttribute("use") != "") {
                    this.hSet.add(ee.getAttribute("use"));
                }
                context.push();
                context.registerNamespaces(e2);
                BindingInput input = new BindingInput();
                String nameAttr2 = XmlUtil.getAttributeOrNull(e2, "name");
                input.setName(nameAttr2);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                boolean gotDocumentation2 = false;
                Iterator iter22 = XmlUtil.getAllChildren(e2);
                while (iter22.hasNext() && (e3 = Util.nextElement(iter22)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, input, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                Element e3;
                if (gotOutput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                BindingOutput output = new BindingOutput();
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                boolean gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, output, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                Element e3;
                context.push();
                context.registerNamespaces(e2);
                BindingFault fault = new BindingFault();
                nameAttr = Util.getRequiredAttribute(e2, "name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                boolean gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        if (fault.getDocumentation() != null) continue;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", name);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Import parseImport(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Import anImport = new Import();
        String namespace = Util.getRequiredAttribute(e, "namespace");
        anImport.setNamespace(namespace);
        String location = Util.getRequiredAttribute(e, "location");
        anImport.setLocation(location);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                anImport.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, anImport);
        return anImport;
    }

    protected Service parseService(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Service service = new Service(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        service.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (service.getDocumentation() != null) continue;
                service.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(context, definitions, e2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, service, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    protected Port parsePort(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Port port = new Port(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        port.setName(name);
        String bindingAttr = Util.getRequiredAttribute(e, "binding");
        port.setBinding(context.translateQualifiedName(bindingAttr));
        boolean gotDocumentation = false;
        Iterator iter = definitions.bindings();
        while (iter.hasNext()) {
            Binding b = (Binding)iter.next();
            if (!b.getName().equals(port.getBinding().getLocalPart())) continue;
            port.setAddressing(b.isAddressing());
            break;
        }
        iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (port.getDocumentation() != null) continue;
                port.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, port, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    protected Types parseTypes(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Types types = new Types();
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                types.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (this._useWSIBasicProfile && XmlUtil.matchesTagNS(e2, SchemaConstants.QNAME_IMPORT)) {
                this.warn("warning.wsi.r2003");
                continue;
            }
            this.checkNotWsdlElement(e2);
            try {
                if (this.handleExtension(context, types, e2)) continue;
                this.checkNotWsdlRequired(e2);
            }
            catch (ParseException pe) {
                if (!pe.getKey().equals("parsing.incorrectRootElement")) continue;
                if (this._useWSIBasicProfile) {
                    this.warn("warning.wsi.r2004");
                }
                throw pe;
            }
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_TYPES, types);
        return types;
    }

    public void addSchemaElements(Element typesElement) {
        Element e;
        Iterator iter = XmlUtil.getAllChildren(typesElement);
        while (iter.hasNext() && (e = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e, SchemaConstants.QNAME_SCHEMA)) {
                this._elements.add(e);
                continue;
            }
            this.checkNotWsdlElement(e);
        }
    }

    public List getSchemaElements() {
        return this._elements;
    }

    protected boolean handleExtension(ParserContext context, Extensible entity, Element n) {
        ExtensionHandler h = (ExtensionHandler)this._extensionHandlers.get(n.getNamespaceURI());
        if (h == null) {
            context.fireIgnoringExtension(new QName(n.getNamespaceURI(), n.getLocalName()), ((Entity)((Object)entity)).getElementName());
            return false;
        }
        return h.doHandleExtension(context, entity, n);
    }

    protected boolean handleExtension(ParserContext context, Extensible entity, Node n, Element e) {
        ExtensionHandler h = (ExtensionHandler)this._extensionHandlers.get(n.getNamespaceURI());
        if (h == null) {
            context.fireIgnoringExtension(new QName(n.getNamespaceURI(), n.getLocalName()), ((Entity)((Object)entity)).getElementName());
            return false;
        }
        return h.doHandleExtension(context, entity, e);
    }

    protected void checkNotWsdlElement(Element e) {
        if (e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", e.getTagName());
        }
    }

    protected void checkNotWsdlAttribute(Attr a) {
        if (a.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", a.getLocalName());
        }
    }

    protected void checkNotWsdlRequired(Element e) {
        String required = XmlUtil.getAttributeNSOrNull(e, "required", "http://schemas.xmlsoap.org/wsdl/");
        if (required != null && required.equals("true")) {
            Util.fail("parsing.requiredExtensibilityElement", e.getTagName(), e.getNamespaceURI());
        }
    }

    protected Documentation getDocumentationFor(Element e) {
        String s = XmlUtil.getTextForNode(e);
        if (s == null) {
            return null;
        }
        return new Documentation(s);
    }

    protected void error(String key) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key, new Object[0])));
    }

    public HashSet getUse() {
        return this.hSet;
    }

    protected void warn(String key) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key, new Object[0])));
    }

    protected void warn(String key, String arg) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key, arg)));
    }

    protected void warn(String key, Object[] args) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key, args)));
    }
}

