/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;

import es.dgpe.place.client.beans.codice.Code;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.utils.ComboBoxUtils;

public class ComboListener implements ItemListener{

	JComboBox padre;
	JComboBox hijo;
	
	public ComboListener (JComboBox padre, JComboBox hijo){
		this.padre=padre;
		this.hijo=hijo;
	}
	
	public JComboBox getPadre() {
		return padre;
	}


	public void setPadre(JComboBox padre) {
		this.padre = padre;
	}


	public JComboBox getHijo() {
		return hijo;
	}


	public void setHijo(JComboBox hijo) {
		this.hijo = hijo;
	}


	public void itemStateChanged(ItemEvent e) {
		if (e.getItem()!=null && !((String)e.getItem()).equalsIgnoreCase("")){ 
			
			String tipoContratoSeleccionado=(String)e.getItem();
			String subTipoContrato="";
			if (tipoContratoSeleccionado.equalsIgnoreCase("Suministros")){
				hijo.removeAllItems();
				ComboBoxUtils.loadComboBoxFromConstant(hijo, ConstantsGC.GOODS_CONTRACT);
			}else if (tipoContratoSeleccionado.equalsIgnoreCase("Servicios")){
				hijo.removeAllItems();
				ComboBoxUtils.loadComboBoxFromConstant(hijo, ConstantsGC.TENDERING_SERVICE_CONTRACT);
			}else if (tipoContratoSeleccionado.equalsIgnoreCase("Obras")){
				hijo.removeAllItems();
				ComboBoxUtils.loadComboBoxFromConstant(hijo, ConstantsGC.WORKS_CONTRACT);
			}else if (tipoContratoSeleccionado.equalsIgnoreCase("Colaboracin entre el sector pblico y sector privado")){
				hijo.removeAllItems();
				ComboBoxUtils.loadComboBoxFromConstant(hijo, ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION);
			}else{
				hijo.removeAllItems();
			}
		}
	}
	
	

}
