/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;

public class ThemeJFrame extends JFrame implements ActionListener {

	JPanel panelMain = null;

	int width = 900;
	int height = 700;

	int posX = 200;
	int posY = 200;

	boolean hasButtonNext = false;
	boolean hasButtonPrev = false; 

	String versionId = "Versin: 1.18";

	private JButton jButtonSiguiente = null;
	private JButton jButtonAnterior=null;
	
	
	private ImageIcon imgLogo = null;
	private ImageIcon imgPlataforma = null;
	
	private static Font serifFont = new Font("Serif", Font.BOLD, 15);

	public ThemeJFrame() throws ModelException {
		this.setSize(929, 777);
		this.setLocation(new Point(150, 150));
		this.setResizable(false);
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setBackground(Color.WHITE);
		this.getContentPane().add(getPanel());		
	}
 


	public JPanel getPanel() {
		if (panelMain == null) {
			imgLogo = new ImageIcon("img/MinisterioLogo.jpg");
			imgPlataforma = new ImageIcon("img/PlataformaLogo.png");
			panelMain = new JPanel(null, true) {
				public void paintComponent(Graphics g) {

					Image imagenLogo = imgLogo.getImage();
					Image imagenPlataforma = imgPlataforma.getImage();

					g.drawImage(imagenLogo, 0, 0, null);
					int resto = this.getWidth() - imagenLogo.getWidth(null);
					g.drawImage(imagenPlataforma, resto / 2, 20, null);
					g.setFont(serifFont);
					g.drawString(versionId, this.getWidth() - 100, this
							.getHeight() - 10);
					panelMain.getGraphics().setColor(Color.WHITE);
				}

			};
			 
			this.setBackground(Color.WHITE);
			this.repaint();

		}
		return panelMain;
	}

	public boolean isHasButtonNext() {
		return hasButtonNext;
	}

	public void setHasButtonNext(boolean hasButtonNext) {
		this.hasButtonNext = hasButtonNext;
	}

	public boolean isHasButtonPrev() {
		return hasButtonPrev;
	}

	public void setHasButtonPrev(boolean hasButtonPrev) {
		this.hasButtonPrev = hasButtonPrev;
	}

	public JButton getJButtonSiguiente() {
		if (jButtonSiguiente == null) {
			jButtonSiguiente = new JButton();
			jButtonSiguiente.setLocation(new Point(this.getWidth() - 200, this
					.getHeight() - 100));
			jButtonSiguiente.setText(Acciones.NEXT);
			jButtonSiguiente.setSize(new Dimension(150, 30));
		}
		return jButtonSiguiente;
	}
	
	public JButton getJButtonAnterior() {
		if (jButtonAnterior == null) {
			jButtonAnterior = new JButton();
			jButtonAnterior.setLocation(new Point(50, this.getHeight() - 100));
			jButtonAnterior.setText("Volver");
			jButtonAnterior.setActionCommand(Acciones.PREV);
			jButtonAnterior.setSize(new Dimension(150, 30));
		}
		return jButtonAnterior;
	}

	public void actionPerformed(ActionEvent e) {

	}

}
