/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.constants;

public class ConstantsGC {

	public final static String LANGUAGE_ID="es";
	
	/**
	 * Alias for the activity code for the Contracting Parties involved in eProcurement
	 */
	public final static String CONTRACTING_AUTHORITY_ACTIVITY = "http://contrataciondelestado.es/codice/cl/1.04/ContractingAuthorityActivityCode-1.04.gc";
	public final static String CONTRACTING_AUTHORITY_ACTIVITY_VER="2006";
	
	/**
	 * Alias for the type code (AGE, CCAA, Local)for contracting Parties
	 */
	public final static String CONTRACTING_AUTHORITY_TYPE = "http://contrataciondelestado.es/codice/cl/1.04/ContractingAuthorityCode-1.04.gc";
	public final static String CONTRACTING_AUTHORITY_TYPE_VER = "2006";
	/**
	 * Alias for the subcontract type code for goods (Bienes)
	 */
	public final static String GOODS_CONTRACT = "http://contrataciondelestado.es/codice/cl/1.04/GoodsContractCode-1.04.gc";
	public final static String GOODS_CONTRACT_VER="2006";
	/**
	 * Alias for the subcontract type code for works (Obras)
	 */
	public final static String WORKS_CONTRACT = "http://contrataciondelestado.es/codice/cl/1.04/WorksContractCode-1.04.gc";
	public final static String WORKS_CONTRACT_VER = "2006";
	/**
	 * Alias for the subcontract type code for public private collaboration (colaboracin pblica privada)
	 */
	public final static String WORKS_PUBLIC_PRIVATE_COLLABORATION = "http://contrataciondelestado.es/codice/cl/2.05/PublicPrivateCollaborationContractTypeCode-2.05.gc";
	public final static String WORKS_PUBLIC_PRIVATE_COLLABORATION_VER = "2.05";
	/**
	 * Alias for the type of tendering process (abierto, cerrado, etc.)
	 */
	public final static String TENDERING_PROCESS = "http://contrataciondelestado.es/codice/cl/2.05/TenderingProcessCode-2.05.gc";
	public final static String TENDERING_PROCESS_VER ="2.05";
	/**
	 * Alias for the subcontract type code type notice (Servicios)
	 */
	public final static String TENDERING_NOTICE_TYPE = "http://contrataciondelestado.es/codice/cl/2.04/TenderingNoticeTypeCode-2.04.gc";
	public final static String TENDERING_NOTICE_TYPE_VER="2.04";

	/**
	 * Alias for the type of diligence (tipo de tramitacin)
	 */
	public final static String DILIGENCE = "http://contrataciondelestado.es/codice/cl/1.04/DiligenceTypeCode-1.04.gc";
	public final static String DILIGENCE_VER ="2006";
	/**
	 * Alias for the type of Expense (tramitacin del gasto)
	 */
	public final static String EXPENSE = "http://contrataciondelestado.es/codice/cl/1.04/ExpenseTypeCode-1.04.gc";
	public final static String EXPENSE_VER ="2006";
	/**
	 * Alias for the type of Tender delivery (condiciones de presentacin de oferta: Electronica, Manual, etc.)
	 */
	public final static String TENDER_DELIVERY = "http://contrataciondelestado.es/codice/cl/1.04/TenderDeliveryCode-1.04.gc";
	public final static String TENDER_DELIVERY_VER ="2006"; 
	/**
	 * Alias for the type of Tender presentation (Ofertar a un lote, varios lotes, etc.)
	 */
	public final static String TENDER_PRESENTATION = "http://contrataciondelestado.es/codice/cl/1.04/TenderPresentationCode-1.04.gc";
	public final static String TENDER_PRESENTATION_VER = "2006";

		
	/**
	 * Alias for the type of declaration (PCAP - Declaraciones)
	 */
	public final static String DECLARATION = "http://contrataciondelestado.es/codice/cl/2.0/DeclarationTypeCode-2.0.gc";
	public final static String DECLARATION_VER = "2.0";

	/**
	 * Alias for the type of Capability (PCAP - Solvencia Tcnica)
	 */
	public final static String CAPABILITY = "http://contrataciondelestado.es/codice/cl/1.04/CapabilityTypeCode-1.04.gc";

	/**
	 * Alias for the type of Valoration (PCAP - Valoracin)
	 */
	public final static String VALORATION = "http://contrataciondelestado.es/codice/cl/1.04/ValorationTypeCode-1.04.gc";

	/**
	 * Alias for the type of NUTS (Localizacion geogrfica)
	 */
	public final static String NUTS_URI = "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc";

	/**
	 * Alias for the type of Resolution (PCAP - Resolucin)
	 */
	public final static String TENDER_RESULT = "http://contrataciondelestado.es/codice/cl/2.02/TenderResultCode-2.02.gc";
	public final static String TENDER_RESULT_VER="2.02";
	/**
	 * Alias for the type of languages of portal users 
	 */
	public final static String CA_LANGUAGE = "http://contrataciondelestado.es/codice/cl/1.04/LanguagePresentationCode-1.04.gc";

	/**
	 * Alias for the country code
	 */
	public final static String COUNTRY_CODE = "http://docs.oasis-open.org/ubl/os-ubl-2.0/cl/gc/default/CountryIdentificationCode-2.0.gc";
	public final static String COUNTRY_CODE_VER = "0.3";

	/**
	 * Alias for the measure codes list
	 */
	public final static String MEASURE_CODE = "http://contrataciondelestado.es/codice/cl/1.04/UnitOfMeasureCode-1.04.gc";

	/************* SYSTEMIC LISTCODES ********************************/

	/**
	 * Alias for the restricted languages for PLACE
	 */
	public final static String PLACE_LANGUAGE = "http://contrataciondelestado.es/codice/cl/1.04/LanguagePresentationCode-1.04.gc";

	/**
	 * Alias for Comunidades Autonomas for PLACE
	 */
	public final static String PLACE_COMUNIDADES = "http://contrataciondelestado.es/codice/cl/1.04/Autonomias-1.04.gc";

	/**
	 * Alias for Provincias for PLACE
	 */
	public final static String PLACE_PROVINCIAS = "http://contrataciondelestado.es/codice/cl/1.04/Provincias-1.04.gc";

	//CODICE20 
	/**
	 * Alias for the type of Awarding (PCAP - adjudicacin - FALTA EL COMBO)
	 */

	public final static String AWARDINGTYPE = "http://contrataciondelestado.es/codice/cl/2.0/AwardingCriteriaCode-2.0.gc";
	public final static String AWARDINGTYPE_VER = "2.0";
	
	
	public final static String AWARDINGSUBTYPE = "http://contrataciondelestado.es/codice/cl/2.05/AwardingCriteriaSubTypeCode-2.05.gc";
	public final static String AWARDINGSUBTYPE_VER = "2.05";

	/**
	 * Alias for the Contract type code (Obras, Bienes, Servicios)
	 */

	public final static String TENDERING_CONTRACT = "http://contrataciondelestado.es/codice/cl/1.04/ContractCode-1.04.gc";
	public final static String TENDERING_CONTRACT_VER ="2006";
	
	public final static String CONTRACTING_SYSTEM_TYPE_CODE = "http://contrataciondelestado.es/codice/cl/2.0/ContractingSystemTypeCode-2.0.gc";
	public final static String CONTRACTING_SYSTEM_TYPE_CODE_VER = "2.0";

	public final static String GUARANTEE_TYPE_CODE = "http://contrataciondelestado.es/codice/cl/1.04/GuaranteeTypeCode-1.04.gc";

	/**
	 * Alias for the role code for contracting Parties
	 */

	public final static String CONTRACTING_AUTHORITY_ROLE = "http://contrataciondelestado.es/codice/cl/2.0/PLACE_ContractingPartyRoleCode-2.0.gc";

	/**
	 * Alias for the subcontract type code for services (Servicios)
	 */

	public final static String TENDERING_SERVICE_CONTRACT = "http://contrataciondelestado.es/codice/cl/1.04/ServiceContractCode-1.04.gc";
	public final static String TENDERING_SERVICE_CONTRACT_VER="2006";
	
	
	
	
	/**
	 * Alias for the type current ship for PLACE
	 */
	public final static String PLACE_CURRENCY = "http://contrataciondelestado.es/codice/cl/1.04/CODICE_CurrencyCode-1.04.gc";

	/**
	 * Alias for the place rol for reasignate rol users
	 */

	public final static String PLACE_ROLE = "http://contrataciondelestado.es/codice/cl/2.0/PLACE_UserRoleCode-2.0.gc";

	/************* SYSTEMIC LISTCODES ********************************/
	/**
	 * Alias for the document code (CIF, NIF, NIE) for several types of ID documents
	 */

	public final static String DOCUMENT_TYPE = "http://contrataciondelestado.es/codice/cl/2.0/PartyIdentificationSchemeID-2.0.gc";

	/**
	 * Alias for the owner type of identificators
	 */

	public final static String IDENTIFICATOR_TYPE = "http://contrataciondelestado.es/codice/cl/1.04/PLACE_IDBuyerProfileCode-1.04.gc";

	/**
	 * Alias for the Ministry Code (SYSTEMIC)
	 */

	public final static String MINISTRY = "http://contrataciondelestado.es/codice/cl/1.04/PLACE_MinistryCode-1.04.gc";

	/**
	 * Alias for the type of period Measure (capada para plazos: aos, meses, das)
	 */

	public final static String PERIOD_UNIT = "http://contrataciondelestado.es/codice/cl/1.04/PeriodUnitCode-1.04.gc";

	public final static String ADDRESS_FORMAT_CODE = "http://contrataciondelestado.es/codice/cl/1.04/AddressFormatCode-1.0.gc";
	public final static String ADDRESS_FORMAT_CODE_VER="2007";
	public final static String ADDRESS_FORMAT_CODE_VALUE="1";
	public final static String ADDRESS_FORMAT_CODE_NAME="Spanish Format";
	/**
	 * Alias for Document Reference Type Code
	 */

	public final static String DOCREF_TYPE_CODE = "http://contrataciondelestado.es/codice/cl/2.05/TenderingDocumentTypeCode-2.05.gc";
	public final static String DOCREF_TYPE_CODE_VER ="2.05";
	
	//Nuevas para CODICE20
	public final static String ADMISSION_CODE = "http://contrataciondelestado.es/codice/cl/2.0/AdmissionCode-2.0.gc";

	public final static String CALCULATIONEXPRESSIONCODE = "http://contrataciondelestado.es/codice/cl/2.0/CalculationExpressionCode-2.0.gc";

	public final static String EVIDENCETYPECODE = "http://contrataciondelestado.es/codice/cl/2.0/EvidenceTypeCode-2.0.gc";

	public final static String EXPRESSIONCODE = "http://contrataciondelestado.es/codice/cl/2.0/ExpressionCode-2.0.gc";

	public final static String FUNDINGPROGRAMCODE = "http://contrataciondelestado.es/codice/cl/2.0/FundingProgramCode-2.0.gc";

	public final static String TENDERTYPECODE = "http://contrataciondelestado.es/codice/cl/2.0/TenderTypeCode-2.0.gc";

	public final static String WEIGHTINGALGORITHMCODE = "http://contrataciondelestado.es/codice/cl/2.0/WeightingAlgorithmCode-2.0.gc";

	public final static String EVENTTYPECODE = "http://contrataciondelestado.es/codice/cl/2.01/EventTypeCode-2.01.gc";
	public final static String EVENTTYPECODE_VER = "2.01";
	
	public final static String ATTENDANCERESTRICTIONCODE = "http://contrataciondelestado.es/codice/cl/2.05/AttendanceRestrictionCode-2.05.gc";
	public final static String ATTENDANCERESTRICTIONCODE_VER = "2.05";

	public final static String PRICEEVALUATIONTYPECODE = "http://contrataciondelestado.es/codice/cl/2.0/PriceEvaluationTypeCode-2.0.gc";

	public final static String FINANCIALCAPABILITYTYPECODE = "http://contrataciondelestado.es/codice/cl/2.0/FinancialCapabilityTypeCode-2.0.gc";
	public final static String FINANCIALCAPABILITYTYPECODE_VER = "2.0";
	
	

	public final static String TECHNICALCAPABILITYTYPECODE = "http://contrataciondelestado.es/codice/cl/2.0/TechnicalCapabilityTypeCode-2.0.gc";
	public final static String TECHNICALCAPABILITYTYPECODE_VER = "2.0";

	public final static String PROCESSJUSTIFICATIONREASONCODE = "http://contrataciondelestado.es/codice/cl/2.0/ProcessJustificationReasonCode-2.0.gc";
	public final static String PROCESSJUSTIFICATIONREASONCODE_VER = "2.0";

	public final static String TENDERENVELOPETYPECODE = "http://contrataciondelestado.es/codice/cl/2.0/TenderEnvelopeTypeCode-2.0.gc";

	public final static String EXECUTIONREQUIREMENTCODE = "http://contrataciondelestado.es/codice/cl/2.0/ExecutionRequirementCode-2.0.gc";
	public final static String EXECUTIONREQUIREMENTCODE_VER = "2.0";

	public final static String STARTINGEVENTDESCRIPTIONCODE = "http://contrataciondelestado.es/codice/cl/2.0/StartingEventDescriptionCode-2.0.gc";

	public final static String QUALITYCONTROLCODE = "http://contrataciondelestado.es/codice/cl/2.0/QualityControlCode-2.0.gc";

	public final static String PACKLEVELCODE = "http://contrataciondelestado.es/codice/cl/2.0/PackLevelCode-2.0.gc";

	public final static String VALIDATIONRESULTCODE = "http://contrataciondelestado.es/codice/cl/2.0/ValidationResultCode-2.0.gc";

	public final static String GENERALCONTRACTDOCCODE = "http://contrataciondelestado.es/codice/cl/2.02/GeneralContractDocuments-2.02.gc";
	public final static String GENERALCONTRACTDOCCODE_VER="2.02"; 

	public final static String CONTRACTINGAUTHORITYEPIGRAPHCODE = "http://contrataciondelestado.es/codice/cl/2.01/PLACE_ContractingAuthorityEpigraph-2.01.gc";

	public final static String BOEEPIGRAPHCODE = "http://contrataciondelestado.es/codice/cl/2.01/PLACE_EpigrafesBOE-2.01.gc";
	
	public final static String CPV = "http://contrataciondelestado.es/codice/cl/2.04/CPV2008-2.04.gc";
	public final static String CPV_VER ="2.04";
	
	public final static String NUTS = "https://contrataciondelestado.es/codice/cl/2.06/NUTS-2016.gc";
	public final static String NUTS_VER ="2009";
	
	
	public final static String BUSINESS_PROFILE = "RequiredBusinessProfileCode";
	public final static String BUSINESS_PROFILE_URI = "http://contrataciondelestado.es/codice/cl/2.05/RequiredBusinessProfileCode-2.05.gc";
	public final static String BUSINESS_PROFILE_CODE="urn:dgpe:names:specification:codice:codelist:gc:RequiredBusinessProfileCode-2.05";
	public final static String BUSINESS_PROFILE_CODE_VER="2.05";
	
	/*****
	 *  Alias for Cancellation Reason Code
	 */
	public final static String CANCELLATION_REASON_CODE = "http://contrataciondelestado.es/codice/cl/2.02/CancellationReasonCode-2.02.gc";
	public final static String CANCELLATION_REASON_VER = "2.02";
	
	/*****
	 *  Alias for Directiva de Aplicacion
	 */
	public final static String DIRECTIVA = "http://contrataciondelestado.es/codice/cl/2.05/ProcurementLegislationDocumentReferenceID-2.05.gc";
	public final static String DIRECTIVA_VER = "2.05";
	public final static String NO_SARA ="No sujeto a regulacion armonizada";
	
	public final static String SI_NO = "/Si_No.gc";

	
	/*****
	 *  Alias for Modification Reason Code
	 */
	public final static String MODIFICATION_REASON_CODE = "http://contrataciondelestado.es/codice/cl/2.05/ContractModificationReasonCode-2.05.gc";
}
